# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SaveSqlTuningSetAsDetails(object):
    """
    Save current list of Sql statements into another Sql tuning set.
    It takes either credentialDetails or databaseCredential. It's recommended to provide databaseCredential
    """

    #: A constant which can be used with the plan_filter property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "LAST_GENERATED"
    PLAN_FILTER_LAST_GENERATED = "LAST_GENERATED"

    #: A constant which can be used with the plan_filter property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "FIRST_GENERATED"
    PLAN_FILTER_FIRST_GENERATED = "FIRST_GENERATED"

    #: A constant which can be used with the plan_filter property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "LAST_LOADED"
    PLAN_FILTER_LAST_LOADED = "LAST_LOADED"

    #: A constant which can be used with the plan_filter property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "FIRST_LOADED"
    PLAN_FILTER_FIRST_LOADED = "FIRST_LOADED"

    #: A constant which can be used with the plan_filter property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "MAX_ELAPSED_TIME"
    PLAN_FILTER_MAX_ELAPSED_TIME = "MAX_ELAPSED_TIME"

    #: A constant which can be used with the plan_filter property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "MAX_BUFFER_GETS"
    PLAN_FILTER_MAX_BUFFER_GETS = "MAX_BUFFER_GETS"

    #: A constant which can be used with the plan_filter property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "MAX_DISK_READS"
    PLAN_FILTER_MAX_DISK_READS = "MAX_DISK_READS"

    #: A constant which can be used with the plan_filter property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "MAX_DIRECT_WRITES"
    PLAN_FILTER_MAX_DIRECT_WRITES = "MAX_DIRECT_WRITES"

    #: A constant which can be used with the plan_filter property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "MAX_OPTIMIZER_COST"
    PLAN_FILTER_MAX_OPTIMIZER_COST = "MAX_OPTIMIZER_COST"

    #: A constant which can be used with the recursive_sql property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "HAS_RECURSIVE_SQL"
    RECURSIVE_SQL_HAS_RECURSIVE_SQL = "HAS_RECURSIVE_SQL"

    #: A constant which can be used with the recursive_sql property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "NO_RECURSIVE_SQL"
    RECURSIVE_SQL_NO_RECURSIVE_SQL = "NO_RECURSIVE_SQL"

    #: A constant which can be used with the ranking_measure1 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "ELAPSED_TIME"
    RANKING_MEASURE1_ELAPSED_TIME = "ELAPSED_TIME"

    #: A constant which can be used with the ranking_measure1 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "CPU_TIME"
    RANKING_MEASURE1_CPU_TIME = "CPU_TIME"

    #: A constant which can be used with the ranking_measure1 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "OPTIMIZER_COST"
    RANKING_MEASURE1_OPTIMIZER_COST = "OPTIMIZER_COST"

    #: A constant which can be used with the ranking_measure1 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "BUFFER_GETS"
    RANKING_MEASURE1_BUFFER_GETS = "BUFFER_GETS"

    #: A constant which can be used with the ranking_measure1 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "DISK_READS"
    RANKING_MEASURE1_DISK_READS = "DISK_READS"

    #: A constant which can be used with the ranking_measure1 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "DIRECT_WRITES"
    RANKING_MEASURE1_DIRECT_WRITES = "DIRECT_WRITES"

    #: A constant which can be used with the ranking_measure2 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "ELAPSED_TIME"
    RANKING_MEASURE2_ELAPSED_TIME = "ELAPSED_TIME"

    #: A constant which can be used with the ranking_measure2 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "CPU_TIME"
    RANKING_MEASURE2_CPU_TIME = "CPU_TIME"

    #: A constant which can be used with the ranking_measure2 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "OPTIMIZER_COST"
    RANKING_MEASURE2_OPTIMIZER_COST = "OPTIMIZER_COST"

    #: A constant which can be used with the ranking_measure2 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "BUFFER_GETS"
    RANKING_MEASURE2_BUFFER_GETS = "BUFFER_GETS"

    #: A constant which can be used with the ranking_measure2 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "DISK_READS"
    RANKING_MEASURE2_DISK_READS = "DISK_READS"

    #: A constant which can be used with the ranking_measure2 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "DIRECT_WRITES"
    RANKING_MEASURE2_DIRECT_WRITES = "DIRECT_WRITES"

    #: A constant which can be used with the ranking_measure3 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "ELAPSED_TIME"
    RANKING_MEASURE3_ELAPSED_TIME = "ELAPSED_TIME"

    #: A constant which can be used with the ranking_measure3 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "CPU_TIME"
    RANKING_MEASURE3_CPU_TIME = "CPU_TIME"

    #: A constant which can be used with the ranking_measure3 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "OPTIMIZER_COST"
    RANKING_MEASURE3_OPTIMIZER_COST = "OPTIMIZER_COST"

    #: A constant which can be used with the ranking_measure3 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "BUFFER_GETS"
    RANKING_MEASURE3_BUFFER_GETS = "BUFFER_GETS"

    #: A constant which can be used with the ranking_measure3 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "DISK_READS"
    RANKING_MEASURE3_DISK_READS = "DISK_READS"

    #: A constant which can be used with the ranking_measure3 property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "DIRECT_WRITES"
    RANKING_MEASURE3_DIRECT_WRITES = "DIRECT_WRITES"

    #: A constant which can be used with the load_option property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "INSERT"
    LOAD_OPTION_INSERT = "INSERT"

    #: A constant which can be used with the load_option property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "UPDATE"
    LOAD_OPTION_UPDATE = "UPDATE"

    #: A constant which can be used with the load_option property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "MERGE"
    LOAD_OPTION_MERGE = "MERGE"

    #: A constant which can be used with the update_option property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "REPLACE"
    UPDATE_OPTION_REPLACE = "REPLACE"

    #: A constant which can be used with the update_option property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "ACCUMULATE"
    UPDATE_OPTION_ACCUMULATE = "ACCUMULATE"

    #: A constant which can be used with the update_condition property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "OLD"
    UPDATE_CONDITION_OLD = "OLD"

    #: A constant which can be used with the update_condition property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "NEW"
    UPDATE_CONDITION_NEW = "NEW"

    #: A constant which can be used with the update_condition property of a SaveSqlTuningSetAsDetails.
    #: This constant has a value of "NULL"
    UPDATE_CONDITION_NULL = "NULL"

    def __init__(self, **kwargs):
        """
        Initializes a new SaveSqlTuningSetAsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param credential_details:
            The value to assign to the credential_details property of this SaveSqlTuningSetAsDetails.
        :type credential_details: oci.database_management.models.SqlTuningSetAdminCredentialDetails

        :param database_credential:
            The value to assign to the database_credential property of this SaveSqlTuningSetAsDetails.
        :type database_credential: oci.database_management.models.DatabaseCredentialDetails

        :param show_sql_only:
            The value to assign to the show_sql_only property of this SaveSqlTuningSetAsDetails.
        :type show_sql_only: int

        :param owner:
            The value to assign to the owner property of this SaveSqlTuningSetAsDetails.
        :type owner: str

        :param name:
            The value to assign to the name property of this SaveSqlTuningSetAsDetails.
        :type name: str

        :param destination_sql_tuning_set_name:
            The value to assign to the destination_sql_tuning_set_name property of this SaveSqlTuningSetAsDetails.
        :type destination_sql_tuning_set_name: str

        :param destination_sql_tuning_set_description:
            The value to assign to the destination_sql_tuning_set_description property of this SaveSqlTuningSetAsDetails.
        :type destination_sql_tuning_set_description: str

        :param destination_sql_tuning_set_owner:
            The value to assign to the destination_sql_tuning_set_owner property of this SaveSqlTuningSetAsDetails.
        :type destination_sql_tuning_set_owner: str

        :param create_new:
            The value to assign to the create_new property of this SaveSqlTuningSetAsDetails.
        :type create_new: int

        :param basic_filter:
            The value to assign to the basic_filter property of this SaveSqlTuningSetAsDetails.
        :type basic_filter: str

        :param plan_filter:
            The value to assign to the plan_filter property of this SaveSqlTuningSetAsDetails.
            Allowed values for this property are: "LAST_GENERATED", "FIRST_GENERATED", "LAST_LOADED", "FIRST_LOADED", "MAX_ELAPSED_TIME", "MAX_BUFFER_GETS", "MAX_DISK_READS", "MAX_DIRECT_WRITES", "MAX_OPTIMIZER_COST"
        :type plan_filter: str

        :param recursive_sql:
            The value to assign to the recursive_sql property of this SaveSqlTuningSetAsDetails.
            Allowed values for this property are: "HAS_RECURSIVE_SQL", "NO_RECURSIVE_SQL"
        :type recursive_sql: str

        :param result_percentage:
            The value to assign to the result_percentage property of this SaveSqlTuningSetAsDetails.
        :type result_percentage: float

        :param result_limit:
            The value to assign to the result_limit property of this SaveSqlTuningSetAsDetails.
        :type result_limit: int

        :param ranking_measure1:
            The value to assign to the ranking_measure1 property of this SaveSqlTuningSetAsDetails.
            Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"
        :type ranking_measure1: str

        :param ranking_measure2:
            The value to assign to the ranking_measure2 property of this SaveSqlTuningSetAsDetails.
            Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"
        :type ranking_measure2: str

        :param ranking_measure3:
            The value to assign to the ranking_measure3 property of this SaveSqlTuningSetAsDetails.
            Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"
        :type ranking_measure3: str

        :param attribute_list:
            The value to assign to the attribute_list property of this SaveSqlTuningSetAsDetails.
        :type attribute_list: str

        :param load_option:
            The value to assign to the load_option property of this SaveSqlTuningSetAsDetails.
            Allowed values for this property are: "INSERT", "UPDATE", "MERGE"
        :type load_option: str

        :param update_option:
            The value to assign to the update_option property of this SaveSqlTuningSetAsDetails.
            Allowed values for this property are: "REPLACE", "ACCUMULATE"
        :type update_option: str

        :param update_condition:
            The value to assign to the update_condition property of this SaveSqlTuningSetAsDetails.
            Allowed values for this property are: "OLD", "NEW", "NULL"
        :type update_condition: str

        :param update_attributes:
            The value to assign to the update_attributes property of this SaveSqlTuningSetAsDetails.
        :type update_attributes: str

        :param is_ignore_null:
            The value to assign to the is_ignore_null property of this SaveSqlTuningSetAsDetails.
        :type is_ignore_null: bool

        :param commit_rows:
            The value to assign to the commit_rows property of this SaveSqlTuningSetAsDetails.
        :type commit_rows: int

        """
        self.swagger_types = {
            'credential_details': 'SqlTuningSetAdminCredentialDetails',
            'database_credential': 'DatabaseCredentialDetails',
            'show_sql_only': 'int',
            'owner': 'str',
            'name': 'str',
            'destination_sql_tuning_set_name': 'str',
            'destination_sql_tuning_set_description': 'str',
            'destination_sql_tuning_set_owner': 'str',
            'create_new': 'int',
            'basic_filter': 'str',
            'plan_filter': 'str',
            'recursive_sql': 'str',
            'result_percentage': 'float',
            'result_limit': 'int',
            'ranking_measure1': 'str',
            'ranking_measure2': 'str',
            'ranking_measure3': 'str',
            'attribute_list': 'str',
            'load_option': 'str',
            'update_option': 'str',
            'update_condition': 'str',
            'update_attributes': 'str',
            'is_ignore_null': 'bool',
            'commit_rows': 'int'
        }

        self.attribute_map = {
            'credential_details': 'credentialDetails',
            'database_credential': 'databaseCredential',
            'show_sql_only': 'showSqlOnly',
            'owner': 'owner',
            'name': 'name',
            'destination_sql_tuning_set_name': 'destinationSqlTuningSetName',
            'destination_sql_tuning_set_description': 'destinationSqlTuningSetDescription',
            'destination_sql_tuning_set_owner': 'destinationSqlTuningSetOwner',
            'create_new': 'createNew',
            'basic_filter': 'basicFilter',
            'plan_filter': 'planFilter',
            'recursive_sql': 'recursiveSql',
            'result_percentage': 'resultPercentage',
            'result_limit': 'resultLimit',
            'ranking_measure1': 'rankingMeasure1',
            'ranking_measure2': 'rankingMeasure2',
            'ranking_measure3': 'rankingMeasure3',
            'attribute_list': 'attributeList',
            'load_option': 'loadOption',
            'update_option': 'updateOption',
            'update_condition': 'updateCondition',
            'update_attributes': 'updateAttributes',
            'is_ignore_null': 'isIgnoreNull',
            'commit_rows': 'commitRows'
        }

        self._credential_details = None
        self._database_credential = None
        self._show_sql_only = None
        self._owner = None
        self._name = None
        self._destination_sql_tuning_set_name = None
        self._destination_sql_tuning_set_description = None
        self._destination_sql_tuning_set_owner = None
        self._create_new = None
        self._basic_filter = None
        self._plan_filter = None
        self._recursive_sql = None
        self._result_percentage = None
        self._result_limit = None
        self._ranking_measure1 = None
        self._ranking_measure2 = None
        self._ranking_measure3 = None
        self._attribute_list = None
        self._load_option = None
        self._update_option = None
        self._update_condition = None
        self._update_attributes = None
        self._is_ignore_null = None
        self._commit_rows = None

    @property
    def credential_details(self):
        """
        Gets the credential_details of this SaveSqlTuningSetAsDetails.

        :return: The credential_details of this SaveSqlTuningSetAsDetails.
        :rtype: oci.database_management.models.SqlTuningSetAdminCredentialDetails
        """
        return self._credential_details

    @credential_details.setter
    def credential_details(self, credential_details):
        """
        Sets the credential_details of this SaveSqlTuningSetAsDetails.

        :param credential_details: The credential_details of this SaveSqlTuningSetAsDetails.
        :type: oci.database_management.models.SqlTuningSetAdminCredentialDetails
        """
        self._credential_details = credential_details

    @property
    def database_credential(self):
        """
        Gets the database_credential of this SaveSqlTuningSetAsDetails.

        :return: The database_credential of this SaveSqlTuningSetAsDetails.
        :rtype: oci.database_management.models.DatabaseCredentialDetails
        """
        return self._database_credential

    @database_credential.setter
    def database_credential(self, database_credential):
        """
        Sets the database_credential of this SaveSqlTuningSetAsDetails.

        :param database_credential: The database_credential of this SaveSqlTuningSetAsDetails.
        :type: oci.database_management.models.DatabaseCredentialDetails
        """
        self._database_credential = database_credential

    @property
    def show_sql_only(self):
        """
        Gets the show_sql_only of this SaveSqlTuningSetAsDetails.
        Flag to indicate whether to save the Sql tuning set or just display the plsql used to save Sql tuning set.


        :return: The show_sql_only of this SaveSqlTuningSetAsDetails.
        :rtype: int
        """
        return self._show_sql_only

    @show_sql_only.setter
    def show_sql_only(self, show_sql_only):
        """
        Sets the show_sql_only of this SaveSqlTuningSetAsDetails.
        Flag to indicate whether to save the Sql tuning set or just display the plsql used to save Sql tuning set.


        :param show_sql_only: The show_sql_only of this SaveSqlTuningSetAsDetails.
        :type: int
        """
        self._show_sql_only = show_sql_only

    @property
    def owner(self):
        """
        Gets the owner of this SaveSqlTuningSetAsDetails.
        The owner of the Sql tuning set.


        :return: The owner of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this SaveSqlTuningSetAsDetails.
        The owner of the Sql tuning set.


        :param owner: The owner of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        self._owner = owner

    @property
    def name(self):
        """
        **[Required]** Gets the name of this SaveSqlTuningSetAsDetails.
        The name of the Sql tuning set.


        :return: The name of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SaveSqlTuningSetAsDetails.
        The name of the Sql tuning set.


        :param name: The name of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        self._name = name

    @property
    def destination_sql_tuning_set_name(self):
        """
        **[Required]** Gets the destination_sql_tuning_set_name of this SaveSqlTuningSetAsDetails.
        The name of the destination Sql tuning set.


        :return: The destination_sql_tuning_set_name of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._destination_sql_tuning_set_name

    @destination_sql_tuning_set_name.setter
    def destination_sql_tuning_set_name(self, destination_sql_tuning_set_name):
        """
        Sets the destination_sql_tuning_set_name of this SaveSqlTuningSetAsDetails.
        The name of the destination Sql tuning set.


        :param destination_sql_tuning_set_name: The destination_sql_tuning_set_name of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        self._destination_sql_tuning_set_name = destination_sql_tuning_set_name

    @property
    def destination_sql_tuning_set_description(self):
        """
        Gets the destination_sql_tuning_set_description of this SaveSqlTuningSetAsDetails.
        The description for the destination Sql tuning set.


        :return: The destination_sql_tuning_set_description of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._destination_sql_tuning_set_description

    @destination_sql_tuning_set_description.setter
    def destination_sql_tuning_set_description(self, destination_sql_tuning_set_description):
        """
        Sets the destination_sql_tuning_set_description of this SaveSqlTuningSetAsDetails.
        The description for the destination Sql tuning set.


        :param destination_sql_tuning_set_description: The destination_sql_tuning_set_description of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        self._destination_sql_tuning_set_description = destination_sql_tuning_set_description

    @property
    def destination_sql_tuning_set_owner(self):
        """
        Gets the destination_sql_tuning_set_owner of this SaveSqlTuningSetAsDetails.
        Owner of the destination Sql tuning set.


        :return: The destination_sql_tuning_set_owner of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._destination_sql_tuning_set_owner

    @destination_sql_tuning_set_owner.setter
    def destination_sql_tuning_set_owner(self, destination_sql_tuning_set_owner):
        """
        Sets the destination_sql_tuning_set_owner of this SaveSqlTuningSetAsDetails.
        Owner of the destination Sql tuning set.


        :param destination_sql_tuning_set_owner: The destination_sql_tuning_set_owner of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        self._destination_sql_tuning_set_owner = destination_sql_tuning_set_owner

    @property
    def create_new(self):
        """
        **[Required]** Gets the create_new of this SaveSqlTuningSetAsDetails.
        Specifies whether to create a new Sql tuning set or not.
        Possible values
        1 - Create a new Sql tuning set
        0 - Do not create a new Sql tuning set


        :return: The create_new of this SaveSqlTuningSetAsDetails.
        :rtype: int
        """
        return self._create_new

    @create_new.setter
    def create_new(self, create_new):
        """
        Sets the create_new of this SaveSqlTuningSetAsDetails.
        Specifies whether to create a new Sql tuning set or not.
        Possible values
        1 - Create a new Sql tuning set
        0 - Do not create a new Sql tuning set


        :param create_new: The create_new of this SaveSqlTuningSetAsDetails.
        :type: int
        """
        self._create_new = create_new

    @property
    def basic_filter(self):
        """
        Gets the basic_filter of this SaveSqlTuningSetAsDetails.
        Specifies the Sql predicate to filter the Sql from the Sql tuning set defined on attributes of the SQLSET_ROW.
        User could use any combination of the following columns with appropriate values as Sql predicate
        Refer to the documentation https://docs.oracle.com/en/database/oracle/oracle-database/18/arpls/DBMS_SQLTUNE.html#GUID-1F4AFB03-7B29-46FC-B3F2-CB01EC36326C


        :return: The basic_filter of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._basic_filter

    @basic_filter.setter
    def basic_filter(self, basic_filter):
        """
        Sets the basic_filter of this SaveSqlTuningSetAsDetails.
        Specifies the Sql predicate to filter the Sql from the Sql tuning set defined on attributes of the SQLSET_ROW.
        User could use any combination of the following columns with appropriate values as Sql predicate
        Refer to the documentation https://docs.oracle.com/en/database/oracle/oracle-database/18/arpls/DBMS_SQLTUNE.html#GUID-1F4AFB03-7B29-46FC-B3F2-CB01EC36326C


        :param basic_filter: The basic_filter of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        self._basic_filter = basic_filter

    @property
    def plan_filter(self):
        """
        Gets the plan_filter of this SaveSqlTuningSetAsDetails.
        Specifies the plan filter.
        This parameter enables you to select a single plan when a statement has multiple plans.
        Refer to the documentation https://docs.oracle.com/en/database/oracle/oracle-database/19/arpls/DBMS_SQLSET.html#GUID-9D995019-91AB-4B1E-9EAF-031050789B21

        Allowed values for this property are: "LAST_GENERATED", "FIRST_GENERATED", "LAST_LOADED", "FIRST_LOADED", "MAX_ELAPSED_TIME", "MAX_BUFFER_GETS", "MAX_DISK_READS", "MAX_DIRECT_WRITES", "MAX_OPTIMIZER_COST"


        :return: The plan_filter of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._plan_filter

    @plan_filter.setter
    def plan_filter(self, plan_filter):
        """
        Sets the plan_filter of this SaveSqlTuningSetAsDetails.
        Specifies the plan filter.
        This parameter enables you to select a single plan when a statement has multiple plans.
        Refer to the documentation https://docs.oracle.com/en/database/oracle/oracle-database/19/arpls/DBMS_SQLSET.html#GUID-9D995019-91AB-4B1E-9EAF-031050789B21


        :param plan_filter: The plan_filter of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        allowed_values = ["LAST_GENERATED", "FIRST_GENERATED", "LAST_LOADED", "FIRST_LOADED", "MAX_ELAPSED_TIME", "MAX_BUFFER_GETS", "MAX_DISK_READS", "MAX_DIRECT_WRITES", "MAX_OPTIMIZER_COST"]
        if not value_allowed_none_or_none_sentinel(plan_filter, allowed_values):
            raise ValueError(
                f"Invalid value for `plan_filter`, must be None or one of {allowed_values}"
            )
        self._plan_filter = plan_filter

    @property
    def recursive_sql(self):
        """
        Gets the recursive_sql of this SaveSqlTuningSetAsDetails.
        Specifies that the filter must include recursive Sql in the Sql tuning set.

        Allowed values for this property are: "HAS_RECURSIVE_SQL", "NO_RECURSIVE_SQL"


        :return: The recursive_sql of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._recursive_sql

    @recursive_sql.setter
    def recursive_sql(self, recursive_sql):
        """
        Sets the recursive_sql of this SaveSqlTuningSetAsDetails.
        Specifies that the filter must include recursive Sql in the Sql tuning set.


        :param recursive_sql: The recursive_sql of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        allowed_values = ["HAS_RECURSIVE_SQL", "NO_RECURSIVE_SQL"]
        if not value_allowed_none_or_none_sentinel(recursive_sql, allowed_values):
            raise ValueError(
                f"Invalid value for `recursive_sql`, must be None or one of {allowed_values}"
            )
        self._recursive_sql = recursive_sql

    @property
    def result_percentage(self):
        """
        Gets the result_percentage of this SaveSqlTuningSetAsDetails.
        Specifies a filter that picks the top n% according to the supplied ranking measure.
        Note that this parameter applies only if one ranking measure is supplied.


        :return: The result_percentage of this SaveSqlTuningSetAsDetails.
        :rtype: float
        """
        return self._result_percentage

    @result_percentage.setter
    def result_percentage(self, result_percentage):
        """
        Sets the result_percentage of this SaveSqlTuningSetAsDetails.
        Specifies a filter that picks the top n% according to the supplied ranking measure.
        Note that this parameter applies only if one ranking measure is supplied.


        :param result_percentage: The result_percentage of this SaveSqlTuningSetAsDetails.
        :type: float
        """
        self._result_percentage = result_percentage

    @property
    def result_limit(self):
        """
        Gets the result_limit of this SaveSqlTuningSetAsDetails.
        The top limit Sql from the filtered source, ranked by the ranking measure.


        :return: The result_limit of this SaveSqlTuningSetAsDetails.
        :rtype: int
        """
        return self._result_limit

    @result_limit.setter
    def result_limit(self, result_limit):
        """
        Sets the result_limit of this SaveSqlTuningSetAsDetails.
        The top limit Sql from the filtered source, ranked by the ranking measure.


        :param result_limit: The result_limit of this SaveSqlTuningSetAsDetails.
        :type: int
        """
        self._result_limit = result_limit

    @property
    def ranking_measure1(self):
        """
        Gets the ranking_measure1 of this SaveSqlTuningSetAsDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.

        Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"


        :return: The ranking_measure1 of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._ranking_measure1

    @ranking_measure1.setter
    def ranking_measure1(self, ranking_measure1):
        """
        Sets the ranking_measure1 of this SaveSqlTuningSetAsDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.


        :param ranking_measure1: The ranking_measure1 of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        allowed_values = ["ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"]
        if not value_allowed_none_or_none_sentinel(ranking_measure1, allowed_values):
            raise ValueError(
                f"Invalid value for `ranking_measure1`, must be None or one of {allowed_values}"
            )
        self._ranking_measure1 = ranking_measure1

    @property
    def ranking_measure2(self):
        """
        Gets the ranking_measure2 of this SaveSqlTuningSetAsDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.

        Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"


        :return: The ranking_measure2 of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._ranking_measure2

    @ranking_measure2.setter
    def ranking_measure2(self, ranking_measure2):
        """
        Sets the ranking_measure2 of this SaveSqlTuningSetAsDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.


        :param ranking_measure2: The ranking_measure2 of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        allowed_values = ["ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"]
        if not value_allowed_none_or_none_sentinel(ranking_measure2, allowed_values):
            raise ValueError(
                f"Invalid value for `ranking_measure2`, must be None or one of {allowed_values}"
            )
        self._ranking_measure2 = ranking_measure2

    @property
    def ranking_measure3(self):
        """
        Gets the ranking_measure3 of this SaveSqlTuningSetAsDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.

        Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"


        :return: The ranking_measure3 of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._ranking_measure3

    @ranking_measure3.setter
    def ranking_measure3(self, ranking_measure3):
        """
        Sets the ranking_measure3 of this SaveSqlTuningSetAsDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.


        :param ranking_measure3: The ranking_measure3 of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        allowed_values = ["ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"]
        if not value_allowed_none_or_none_sentinel(ranking_measure3, allowed_values):
            raise ValueError(
                f"Invalid value for `ranking_measure3`, must be None or one of {allowed_values}"
            )
        self._ranking_measure3 = ranking_measure3

    @property
    def attribute_list(self):
        """
        Gets the attribute_list of this SaveSqlTuningSetAsDetails.
        Specifies the list of Sql statement attributes to return in the result.
        Note that this parameter cannot be made an enum since custom value can take a list of comma separated attribute names.
        Attribute list can take one of the following values.
         TYPICAL - Specifies BASIC plus Sql plan (without row source statistics) and without object reference list (default).
         BASIC - Specifies all attributes (such as execution statistics and binds) except the plans. The execution context is always part of the result.
         ALL - Specifies all attributes.
         CUSTOM - Comma-separated list of the following attribute names.
                  - EXECUTION_STATISTICS
                  - BIND_LIST
                  - OBJECT_LIST
                  - SQL_PLAN
                  - SQL_PLAN_STATISTICS
        Usage examples:
          1. \"attributeList\": \"TYPICAL\"
          2. \"attributeList\": \"ALL\"
          3. \"attributeList\": \"EXECUTION_STATISTICS,OBJECT_LIST,SQL_PLAN\"


        :return: The attribute_list of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._attribute_list

    @attribute_list.setter
    def attribute_list(self, attribute_list):
        """
        Sets the attribute_list of this SaveSqlTuningSetAsDetails.
        Specifies the list of Sql statement attributes to return in the result.
        Note that this parameter cannot be made an enum since custom value can take a list of comma separated attribute names.
        Attribute list can take one of the following values.
         TYPICAL - Specifies BASIC plus Sql plan (without row source statistics) and without object reference list (default).
         BASIC - Specifies all attributes (such as execution statistics and binds) except the plans. The execution context is always part of the result.
         ALL - Specifies all attributes.
         CUSTOM - Comma-separated list of the following attribute names.
                  - EXECUTION_STATISTICS
                  - BIND_LIST
                  - OBJECT_LIST
                  - SQL_PLAN
                  - SQL_PLAN_STATISTICS
        Usage examples:
          1. \"attributeList\": \"TYPICAL\"
          2. \"attributeList\": \"ALL\"
          3. \"attributeList\": \"EXECUTION_STATISTICS,OBJECT_LIST,SQL_PLAN\"


        :param attribute_list: The attribute_list of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        self._attribute_list = attribute_list

    @property
    def load_option(self):
        """
        Gets the load_option of this SaveSqlTuningSetAsDetails.
        Specifies which statements are loaded into the Sql tuning set.
        The possible values are.
          - INSERT (default)
            Adds only new statements.
          - UPDATE
            Updates existing the Sql statements and ignores any new statements.
          - MERGE
            Inserts new statements and updates the information of the existing ones.

        Allowed values for this property are: "INSERT", "UPDATE", "MERGE"


        :return: The load_option of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._load_option

    @load_option.setter
    def load_option(self, load_option):
        """
        Sets the load_option of this SaveSqlTuningSetAsDetails.
        Specifies which statements are loaded into the Sql tuning set.
        The possible values are.
          - INSERT (default)
            Adds only new statements.
          - UPDATE
            Updates existing the Sql statements and ignores any new statements.
          - MERGE
            Inserts new statements and updates the information of the existing ones.


        :param load_option: The load_option of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        allowed_values = ["INSERT", "UPDATE", "MERGE"]
        if not value_allowed_none_or_none_sentinel(load_option, allowed_values):
            raise ValueError(
                f"Invalid value for `load_option`, must be None or one of {allowed_values}"
            )
        self._load_option = load_option

    @property
    def update_option(self):
        """
        Gets the update_option of this SaveSqlTuningSetAsDetails.
        Specifies how existing Sql statements are updated.
        This parameter is applicable only if load_option is specified with UPDATE or MERGE as an option.
        Update option can take one of the following values.
           REPLACE (default) - Updates the statement using the new statistics, bind list, object list, and so on.
           ACCUMULATE - Combines attributes when possible (for example, statistics such as elapsed_time), otherwise replaces the existing values (for example, module and action) with the provided values.
           Following Sql statement attributes can be accumulated.
               elapsed_time
               buffer_gets
               direct_writes
               disk_reads
               row_processed
               fetches
               executions
               end_of_fetch_count
               stat_period
               active_stat_period

        Allowed values for this property are: "REPLACE", "ACCUMULATE"


        :return: The update_option of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._update_option

    @update_option.setter
    def update_option(self, update_option):
        """
        Sets the update_option of this SaveSqlTuningSetAsDetails.
        Specifies how existing Sql statements are updated.
        This parameter is applicable only if load_option is specified with UPDATE or MERGE as an option.
        Update option can take one of the following values.
           REPLACE (default) - Updates the statement using the new statistics, bind list, object list, and so on.
           ACCUMULATE - Combines attributes when possible (for example, statistics such as elapsed_time), otherwise replaces the existing values (for example, module and action) with the provided values.
           Following Sql statement attributes can be accumulated.
               elapsed_time
               buffer_gets
               direct_writes
               disk_reads
               row_processed
               fetches
               executions
               end_of_fetch_count
               stat_period
               active_stat_period


        :param update_option: The update_option of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        allowed_values = ["REPLACE", "ACCUMULATE"]
        if not value_allowed_none_or_none_sentinel(update_option, allowed_values):
            raise ValueError(
                f"Invalid value for `update_option`, must be None or one of {allowed_values}"
            )
        self._update_option = update_option

    @property
    def update_condition(self):
        """
        Gets the update_condition of this SaveSqlTuningSetAsDetails.
        Specifies when to perform the update.
        The procedure only performs the update when the specified condition is satisfied.
        The condition can refer to either the data source or destination.
        The condition must use the following prefixes to refer to attributes from the source or the destination:
          OLD  \u2014 Refers to statement attributes from the SQL tuning set (destination).
          NEW  \u2014 Refers to statement attributes from the input statements (source).
          NULL \u2014 No updates are performed.

        Allowed values for this property are: "OLD", "NEW", "NULL"


        :return: The update_condition of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._update_condition

    @update_condition.setter
    def update_condition(self, update_condition):
        """
        Sets the update_condition of this SaveSqlTuningSetAsDetails.
        Specifies when to perform the update.
        The procedure only performs the update when the specified condition is satisfied.
        The condition can refer to either the data source or destination.
        The condition must use the following prefixes to refer to attributes from the source or the destination:
          OLD  \u2014 Refers to statement attributes from the SQL tuning set (destination).
          NEW  \u2014 Refers to statement attributes from the input statements (source).
          NULL \u2014 No updates are performed.


        :param update_condition: The update_condition of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        allowed_values = ["OLD", "NEW", "NULL"]
        if not value_allowed_none_or_none_sentinel(update_condition, allowed_values):
            raise ValueError(
                f"Invalid value for `update_condition`, must be None or one of {allowed_values}"
            )
        self._update_condition = update_condition

    @property
    def update_attributes(self):
        """
        Gets the update_attributes of this SaveSqlTuningSetAsDetails.
        Specifies the list of Sql statement attributes to update during a merge or update.
        Note that this parameter cannot be made an enum since custom value can take a list of comma separated attribute names.
        Update attributes can take one of the following values.
           NULL (default) - Specifies the content of the input cursor except the execution context. On other terms, it is equivalent to ALL without execution contexts such as module and action.
           BASIC - Specifies statistics and binds only.
           TYPICAL - Specifies BASIC with Sql plans (without row source statistics) and without an object reference list.
           ALL - Specifies all attributes, including the execution context attributes such as module and action.
           CUSTOM - List of comma separated attribute names to update
               EXECUTION_CONTEXT
               EXECUTION_STATISTICS
               SQL_BINDS
               SQL_PLAN
               SQL_PLAN_STATISTICS (similar to SQL_PLAN with added row source statistics)
        Usage examples:
          1. \"updateAttributes\": \"TYPICAL\"
          2. \"updateAttributes\": \"BASIC\"
          3. \"updateAttributes\": \"EXECUTION_STATISTICS,SQL_PLAN_STATISTICS,SQL_PLAN\"
          4. \"updateAttributes\": \"EXECUTION_STATISTICS,SQL_PLAN\"


        :return: The update_attributes of this SaveSqlTuningSetAsDetails.
        :rtype: str
        """
        return self._update_attributes

    @update_attributes.setter
    def update_attributes(self, update_attributes):
        """
        Sets the update_attributes of this SaveSqlTuningSetAsDetails.
        Specifies the list of Sql statement attributes to update during a merge or update.
        Note that this parameter cannot be made an enum since custom value can take a list of comma separated attribute names.
        Update attributes can take one of the following values.
           NULL (default) - Specifies the content of the input cursor except the execution context. On other terms, it is equivalent to ALL without execution contexts such as module and action.
           BASIC - Specifies statistics and binds only.
           TYPICAL - Specifies BASIC with Sql plans (without row source statistics) and without an object reference list.
           ALL - Specifies all attributes, including the execution context attributes such as module and action.
           CUSTOM - List of comma separated attribute names to update
               EXECUTION_CONTEXT
               EXECUTION_STATISTICS
               SQL_BINDS
               SQL_PLAN
               SQL_PLAN_STATISTICS (similar to SQL_PLAN with added row source statistics)
        Usage examples:
          1. \"updateAttributes\": \"TYPICAL\"
          2. \"updateAttributes\": \"BASIC\"
          3. \"updateAttributes\": \"EXECUTION_STATISTICS,SQL_PLAN_STATISTICS,SQL_PLAN\"
          4. \"updateAttributes\": \"EXECUTION_STATISTICS,SQL_PLAN\"


        :param update_attributes: The update_attributes of this SaveSqlTuningSetAsDetails.
        :type: str
        """
        self._update_attributes = update_attributes

    @property
    def is_ignore_null(self):
        """
        Gets the is_ignore_null of this SaveSqlTuningSetAsDetails.
        Specifies whether to update attributes when the new value is NULL.
        If TRUE, then the procedure does not update an attribute when the new value is NULL.
        That is, do not override with NULL values unless intentional.
        Possible values - true or false


        :return: The is_ignore_null of this SaveSqlTuningSetAsDetails.
        :rtype: bool
        """
        return self._is_ignore_null

    @is_ignore_null.setter
    def is_ignore_null(self, is_ignore_null):
        """
        Sets the is_ignore_null of this SaveSqlTuningSetAsDetails.
        Specifies whether to update attributes when the new value is NULL.
        If TRUE, then the procedure does not update an attribute when the new value is NULL.
        That is, do not override with NULL values unless intentional.
        Possible values - true or false


        :param is_ignore_null: The is_ignore_null of this SaveSqlTuningSetAsDetails.
        :type: bool
        """
        self._is_ignore_null = is_ignore_null

    @property
    def commit_rows(self):
        """
        Gets the commit_rows of this SaveSqlTuningSetAsDetails.
        Specifies whether to commit statements after DML.
        If a value is provided, then the load commits after each specified number of statements is inserted.
        If NULL is provided, then the load commits only once, at the end of the operation.


        :return: The commit_rows of this SaveSqlTuningSetAsDetails.
        :rtype: int
        """
        return self._commit_rows

    @commit_rows.setter
    def commit_rows(self, commit_rows):
        """
        Sets the commit_rows of this SaveSqlTuningSetAsDetails.
        Specifies whether to commit statements after DML.
        If a value is provided, then the load commits after each specified number of statements is inserted.
        If NULL is provided, then the load commits only once, at the end of the operation.


        :param commit_rows: The commit_rows of this SaveSqlTuningSetAsDetails.
        :type: int
        """
        self._commit_rows = commit_rows

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
