# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudAutonomousVmClusterResourceUsage(object):
    """
    Cloud Autonomous VM Cluster usage details, including the Autonomous Container Databases usage.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloudAutonomousVmClusterResourceUsage object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CloudAutonomousVmClusterResourceUsage.
        :type display_name: str

        :param id:
            The value to assign to the id property of this CloudAutonomousVmClusterResourceUsage.
        :type id: str

        :param autonomous_data_storage_size_in_tbs:
            The value to assign to the autonomous_data_storage_size_in_tbs property of this CloudAutonomousVmClusterResourceUsage.
        :type autonomous_data_storage_size_in_tbs: float

        :param db_node_storage_size_in_gbs:
            The value to assign to the db_node_storage_size_in_gbs property of this CloudAutonomousVmClusterResourceUsage.
        :type db_node_storage_size_in_gbs: int

        :param memory_size_in_gbs:
            The value to assign to the memory_size_in_gbs property of this CloudAutonomousVmClusterResourceUsage.
        :type memory_size_in_gbs: int

        :param total_container_databases:
            The value to assign to the total_container_databases property of this CloudAutonomousVmClusterResourceUsage.
        :type total_container_databases: int

        :param available_autonomous_data_storage_size_in_tbs:
            The value to assign to the available_autonomous_data_storage_size_in_tbs property of this CloudAutonomousVmClusterResourceUsage.
        :type available_autonomous_data_storage_size_in_tbs: float

        :param used_autonomous_data_storage_size_in_tbs:
            The value to assign to the used_autonomous_data_storage_size_in_tbs property of this CloudAutonomousVmClusterResourceUsage.
        :type used_autonomous_data_storage_size_in_tbs: float

        :param memory_per_oracle_compute_unit_in_gbs:
            The value to assign to the memory_per_oracle_compute_unit_in_gbs property of this CloudAutonomousVmClusterResourceUsage.
        :type memory_per_oracle_compute_unit_in_gbs: int

        :param exadata_storage_in_tbs:
            The value to assign to the exadata_storage_in_tbs property of this CloudAutonomousVmClusterResourceUsage.
        :type exadata_storage_in_tbs: float

        :param total_cpus:
            The value to assign to the total_cpus property of this CloudAutonomousVmClusterResourceUsage.
        :type total_cpus: float

        :param used_cpus:
            The value to assign to the used_cpus property of this CloudAutonomousVmClusterResourceUsage.
        :type used_cpus: float

        :param available_cpus:
            The value to assign to the available_cpus property of this CloudAutonomousVmClusterResourceUsage.
        :type available_cpus: float

        :param reclaimable_cpus:
            The value to assign to the reclaimable_cpus property of this CloudAutonomousVmClusterResourceUsage.
        :type reclaimable_cpus: float

        :param provisioned_cpus:
            The value to assign to the provisioned_cpus property of this CloudAutonomousVmClusterResourceUsage.
        :type provisioned_cpus: float

        :param reserved_cpus:
            The value to assign to the reserved_cpus property of this CloudAutonomousVmClusterResourceUsage.
        :type reserved_cpus: float

        :param provisionable_autonomous_container_databases:
            The value to assign to the provisionable_autonomous_container_databases property of this CloudAutonomousVmClusterResourceUsage.
        :type provisionable_autonomous_container_databases: int

        :param provisioned_autonomous_container_databases:
            The value to assign to the provisioned_autonomous_container_databases property of this CloudAutonomousVmClusterResourceUsage.
        :type provisioned_autonomous_container_databases: int

        :param non_provisionable_autonomous_container_databases:
            The value to assign to the non_provisionable_autonomous_container_databases property of this CloudAutonomousVmClusterResourceUsage.
        :type non_provisionable_autonomous_container_databases: int

        :param autonomous_vm_resource_usage:
            The value to assign to the autonomous_vm_resource_usage property of this CloudAutonomousVmClusterResourceUsage.
        :type autonomous_vm_resource_usage: list[oci.database.models.AutonomousVmResourceUsage]

        """
        self.swagger_types = {
            'display_name': 'str',
            'id': 'str',
            'autonomous_data_storage_size_in_tbs': 'float',
            'db_node_storage_size_in_gbs': 'int',
            'memory_size_in_gbs': 'int',
            'total_container_databases': 'int',
            'available_autonomous_data_storage_size_in_tbs': 'float',
            'used_autonomous_data_storage_size_in_tbs': 'float',
            'memory_per_oracle_compute_unit_in_gbs': 'int',
            'exadata_storage_in_tbs': 'float',
            'total_cpus': 'float',
            'used_cpus': 'float',
            'available_cpus': 'float',
            'reclaimable_cpus': 'float',
            'provisioned_cpus': 'float',
            'reserved_cpus': 'float',
            'provisionable_autonomous_container_databases': 'int',
            'provisioned_autonomous_container_databases': 'int',
            'non_provisionable_autonomous_container_databases': 'int',
            'autonomous_vm_resource_usage': 'list[AutonomousVmResourceUsage]'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'id': 'id',
            'autonomous_data_storage_size_in_tbs': 'autonomousDataStorageSizeInTBs',
            'db_node_storage_size_in_gbs': 'dbNodeStorageSizeInGBs',
            'memory_size_in_gbs': 'memorySizeInGBs',
            'total_container_databases': 'totalContainerDatabases',
            'available_autonomous_data_storage_size_in_tbs': 'availableAutonomousDataStorageSizeInTBs',
            'used_autonomous_data_storage_size_in_tbs': 'usedAutonomousDataStorageSizeInTBs',
            'memory_per_oracle_compute_unit_in_gbs': 'memoryPerOracleComputeUnitInGBs',
            'exadata_storage_in_tbs': 'exadataStorageInTBs',
            'total_cpus': 'totalCpus',
            'used_cpus': 'usedCpus',
            'available_cpus': 'availableCpus',
            'reclaimable_cpus': 'reclaimableCpus',
            'provisioned_cpus': 'provisionedCpus',
            'reserved_cpus': 'reservedCpus',
            'provisionable_autonomous_container_databases': 'provisionableAutonomousContainerDatabases',
            'provisioned_autonomous_container_databases': 'provisionedAutonomousContainerDatabases',
            'non_provisionable_autonomous_container_databases': 'nonProvisionableAutonomousContainerDatabases',
            'autonomous_vm_resource_usage': 'autonomousVmResourceUsage'
        }

        self._display_name = None
        self._id = None
        self._autonomous_data_storage_size_in_tbs = None
        self._db_node_storage_size_in_gbs = None
        self._memory_size_in_gbs = None
        self._total_container_databases = None
        self._available_autonomous_data_storage_size_in_tbs = None
        self._used_autonomous_data_storage_size_in_tbs = None
        self._memory_per_oracle_compute_unit_in_gbs = None
        self._exadata_storage_in_tbs = None
        self._total_cpus = None
        self._used_cpus = None
        self._available_cpus = None
        self._reclaimable_cpus = None
        self._provisioned_cpus = None
        self._reserved_cpus = None
        self._provisionable_autonomous_container_databases = None
        self._provisioned_autonomous_container_databases = None
        self._non_provisionable_autonomous_container_databases = None
        self._autonomous_vm_resource_usage = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CloudAutonomousVmClusterResourceUsage.
        The user-friendly name for the Autonomous VM cluster. The name does not need to be unique.


        :return: The display_name of this CloudAutonomousVmClusterResourceUsage.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CloudAutonomousVmClusterResourceUsage.
        The user-friendly name for the Autonomous VM cluster. The name does not need to be unique.


        :param display_name: The display_name of this CloudAutonomousVmClusterResourceUsage.
        :type: str
        """
        self._display_name = display_name

    @property
    def id(self):
        """
        Gets the id of this CloudAutonomousVmClusterResourceUsage.
        The `OCID`__ of the Cloud Autonomous VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this CloudAutonomousVmClusterResourceUsage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CloudAutonomousVmClusterResourceUsage.
        The `OCID`__ of the Cloud Autonomous VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this CloudAutonomousVmClusterResourceUsage.
        :type: str
        """
        self._id = id

    @property
    def autonomous_data_storage_size_in_tbs(self):
        """
        Gets the autonomous_data_storage_size_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        The data disk group size allocated for Autonomous Databases, in TBs.


        :return: The autonomous_data_storage_size_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        :rtype: float
        """
        return self._autonomous_data_storage_size_in_tbs

    @autonomous_data_storage_size_in_tbs.setter
    def autonomous_data_storage_size_in_tbs(self, autonomous_data_storage_size_in_tbs):
        """
        Sets the autonomous_data_storage_size_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        The data disk group size allocated for Autonomous Databases, in TBs.


        :param autonomous_data_storage_size_in_tbs: The autonomous_data_storage_size_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        :type: float
        """
        self._autonomous_data_storage_size_in_tbs = autonomous_data_storage_size_in_tbs

    @property
    def db_node_storage_size_in_gbs(self):
        """
        Gets the db_node_storage_size_in_gbs of this CloudAutonomousVmClusterResourceUsage.
        The local node storage allocated in GBs.


        :return: The db_node_storage_size_in_gbs of this CloudAutonomousVmClusterResourceUsage.
        :rtype: int
        """
        return self._db_node_storage_size_in_gbs

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, db_node_storage_size_in_gbs):
        """
        Sets the db_node_storage_size_in_gbs of this CloudAutonomousVmClusterResourceUsage.
        The local node storage allocated in GBs.


        :param db_node_storage_size_in_gbs: The db_node_storage_size_in_gbs of this CloudAutonomousVmClusterResourceUsage.
        :type: int
        """
        self._db_node_storage_size_in_gbs = db_node_storage_size_in_gbs

    @property
    def memory_size_in_gbs(self):
        """
        Gets the memory_size_in_gbs of this CloudAutonomousVmClusterResourceUsage.
        The memory allocated in GBs.


        :return: The memory_size_in_gbs of this CloudAutonomousVmClusterResourceUsage.
        :rtype: int
        """
        return self._memory_size_in_gbs

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, memory_size_in_gbs):
        """
        Sets the memory_size_in_gbs of this CloudAutonomousVmClusterResourceUsage.
        The memory allocated in GBs.


        :param memory_size_in_gbs: The memory_size_in_gbs of this CloudAutonomousVmClusterResourceUsage.
        :type: int
        """
        self._memory_size_in_gbs = memory_size_in_gbs

    @property
    def total_container_databases(self):
        """
        Gets the total_container_databases of this CloudAutonomousVmClusterResourceUsage.
        The total number of Autonomous Container Databases that can be created.


        :return: The total_container_databases of this CloudAutonomousVmClusterResourceUsage.
        :rtype: int
        """
        return self._total_container_databases

    @total_container_databases.setter
    def total_container_databases(self, total_container_databases):
        """
        Sets the total_container_databases of this CloudAutonomousVmClusterResourceUsage.
        The total number of Autonomous Container Databases that can be created.


        :param total_container_databases: The total_container_databases of this CloudAutonomousVmClusterResourceUsage.
        :type: int
        """
        self._total_container_databases = total_container_databases

    @property
    def available_autonomous_data_storage_size_in_tbs(self):
        """
        Gets the available_autonomous_data_storage_size_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        The data disk group size available for Autonomous Databases, in TBs.


        :return: The available_autonomous_data_storage_size_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        :rtype: float
        """
        return self._available_autonomous_data_storage_size_in_tbs

    @available_autonomous_data_storage_size_in_tbs.setter
    def available_autonomous_data_storage_size_in_tbs(self, available_autonomous_data_storage_size_in_tbs):
        """
        Sets the available_autonomous_data_storage_size_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        The data disk group size available for Autonomous Databases, in TBs.


        :param available_autonomous_data_storage_size_in_tbs: The available_autonomous_data_storage_size_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        :type: float
        """
        self._available_autonomous_data_storage_size_in_tbs = available_autonomous_data_storage_size_in_tbs

    @property
    def used_autonomous_data_storage_size_in_tbs(self):
        """
        Gets the used_autonomous_data_storage_size_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        The data disk group size used for Autonomous Databases, in TBs.


        :return: The used_autonomous_data_storage_size_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        :rtype: float
        """
        return self._used_autonomous_data_storage_size_in_tbs

    @used_autonomous_data_storage_size_in_tbs.setter
    def used_autonomous_data_storage_size_in_tbs(self, used_autonomous_data_storage_size_in_tbs):
        """
        Sets the used_autonomous_data_storage_size_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        The data disk group size used for Autonomous Databases, in TBs.


        :param used_autonomous_data_storage_size_in_tbs: The used_autonomous_data_storage_size_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        :type: float
        """
        self._used_autonomous_data_storage_size_in_tbs = used_autonomous_data_storage_size_in_tbs

    @property
    def memory_per_oracle_compute_unit_in_gbs(self):
        """
        Gets the memory_per_oracle_compute_unit_in_gbs of this CloudAutonomousVmClusterResourceUsage.
        The amount of memory (in GBs) to be enabled per each CPU core.


        :return: The memory_per_oracle_compute_unit_in_gbs of this CloudAutonomousVmClusterResourceUsage.
        :rtype: int
        """
        return self._memory_per_oracle_compute_unit_in_gbs

    @memory_per_oracle_compute_unit_in_gbs.setter
    def memory_per_oracle_compute_unit_in_gbs(self, memory_per_oracle_compute_unit_in_gbs):
        """
        Sets the memory_per_oracle_compute_unit_in_gbs of this CloudAutonomousVmClusterResourceUsage.
        The amount of memory (in GBs) to be enabled per each CPU core.


        :param memory_per_oracle_compute_unit_in_gbs: The memory_per_oracle_compute_unit_in_gbs of this CloudAutonomousVmClusterResourceUsage.
        :type: int
        """
        self._memory_per_oracle_compute_unit_in_gbs = memory_per_oracle_compute_unit_in_gbs

    @property
    def exadata_storage_in_tbs(self):
        """
        Gets the exadata_storage_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        Total exadata storage allocated for the Autonomous VM Cluster. DATA + RECOVERY + SPARSE + any overhead in TBs.


        :return: The exadata_storage_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        :rtype: float
        """
        return self._exadata_storage_in_tbs

    @exadata_storage_in_tbs.setter
    def exadata_storage_in_tbs(self, exadata_storage_in_tbs):
        """
        Sets the exadata_storage_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        Total exadata storage allocated for the Autonomous VM Cluster. DATA + RECOVERY + SPARSE + any overhead in TBs.


        :param exadata_storage_in_tbs: The exadata_storage_in_tbs of this CloudAutonomousVmClusterResourceUsage.
        :type: float
        """
        self._exadata_storage_in_tbs = exadata_storage_in_tbs

    @property
    def total_cpus(self):
        """
        Gets the total_cpus of this CloudAutonomousVmClusterResourceUsage.
        The number of CPU cores enabled on the Cloud Autonomous VM cluster.


        :return: The total_cpus of this CloudAutonomousVmClusterResourceUsage.
        :rtype: float
        """
        return self._total_cpus

    @total_cpus.setter
    def total_cpus(self, total_cpus):
        """
        Sets the total_cpus of this CloudAutonomousVmClusterResourceUsage.
        The number of CPU cores enabled on the Cloud Autonomous VM cluster.


        :param total_cpus: The total_cpus of this CloudAutonomousVmClusterResourceUsage.
        :type: float
        """
        self._total_cpus = total_cpus

    @property
    def used_cpus(self):
        """
        Gets the used_cpus of this CloudAutonomousVmClusterResourceUsage.
        The number of CPU cores alloted to the Autonomous Container Databases
        in an Cloud Autonomous VM cluster.


        :return: The used_cpus of this CloudAutonomousVmClusterResourceUsage.
        :rtype: float
        """
        return self._used_cpus

    @used_cpus.setter
    def used_cpus(self, used_cpus):
        """
        Sets the used_cpus of this CloudAutonomousVmClusterResourceUsage.
        The number of CPU cores alloted to the Autonomous Container Databases
        in an Cloud Autonomous VM cluster.


        :param used_cpus: The used_cpus of this CloudAutonomousVmClusterResourceUsage.
        :type: float
        """
        self._used_cpus = used_cpus

    @property
    def available_cpus(self):
        """
        Gets the available_cpus of this CloudAutonomousVmClusterResourceUsage.
        The number of CPU cores available.


        :return: The available_cpus of this CloudAutonomousVmClusterResourceUsage.
        :rtype: float
        """
        return self._available_cpus

    @available_cpus.setter
    def available_cpus(self, available_cpus):
        """
        Sets the available_cpus of this CloudAutonomousVmClusterResourceUsage.
        The number of CPU cores available.


        :param available_cpus: The available_cpus of this CloudAutonomousVmClusterResourceUsage.
        :type: float
        """
        self._available_cpus = available_cpus

    @property
    def reclaimable_cpus(self):
        """
        Gets the reclaimable_cpus of this CloudAutonomousVmClusterResourceUsage.
        CPU cores that continue to be included in the count of OCPUs available
        to the Autonomous Container Database even after one of its Autonomous Database is
        terminated or scaled down. You can release them to the available OCPUs at its parent
        AVMC level by restarting the Autonomous Container Database.


        :return: The reclaimable_cpus of this CloudAutonomousVmClusterResourceUsage.
        :rtype: float
        """
        return self._reclaimable_cpus

    @reclaimable_cpus.setter
    def reclaimable_cpus(self, reclaimable_cpus):
        """
        Sets the reclaimable_cpus of this CloudAutonomousVmClusterResourceUsage.
        CPU cores that continue to be included in the count of OCPUs available
        to the Autonomous Container Database even after one of its Autonomous Database is
        terminated or scaled down. You can release them to the available OCPUs at its parent
        AVMC level by restarting the Autonomous Container Database.


        :param reclaimable_cpus: The reclaimable_cpus of this CloudAutonomousVmClusterResourceUsage.
        :type: float
        """
        self._reclaimable_cpus = reclaimable_cpus

    @property
    def provisioned_cpus(self):
        """
        Gets the provisioned_cpus of this CloudAutonomousVmClusterResourceUsage.
        The number of CPUs provisioned in an Autonomous VM Cluster.


        :return: The provisioned_cpus of this CloudAutonomousVmClusterResourceUsage.
        :rtype: float
        """
        return self._provisioned_cpus

    @provisioned_cpus.setter
    def provisioned_cpus(self, provisioned_cpus):
        """
        Sets the provisioned_cpus of this CloudAutonomousVmClusterResourceUsage.
        The number of CPUs provisioned in an Autonomous VM Cluster.


        :param provisioned_cpus: The provisioned_cpus of this CloudAutonomousVmClusterResourceUsage.
        :type: float
        """
        self._provisioned_cpus = provisioned_cpus

    @property
    def reserved_cpus(self):
        """
        Gets the reserved_cpus of this CloudAutonomousVmClusterResourceUsage.
        The number of CPUs reserved in an Autonomous VM Cluster.


        :return: The reserved_cpus of this CloudAutonomousVmClusterResourceUsage.
        :rtype: float
        """
        return self._reserved_cpus

    @reserved_cpus.setter
    def reserved_cpus(self, reserved_cpus):
        """
        Sets the reserved_cpus of this CloudAutonomousVmClusterResourceUsage.
        The number of CPUs reserved in an Autonomous VM Cluster.


        :param reserved_cpus: The reserved_cpus of this CloudAutonomousVmClusterResourceUsage.
        :type: float
        """
        self._reserved_cpus = reserved_cpus

    @property
    def provisionable_autonomous_container_databases(self):
        """
        Gets the provisionable_autonomous_container_databases of this CloudAutonomousVmClusterResourceUsage.
        The number of provisionable Autonomous Container Databases in an Autonomous VM Cluster.


        :return: The provisionable_autonomous_container_databases of this CloudAutonomousVmClusterResourceUsage.
        :rtype: int
        """
        return self._provisionable_autonomous_container_databases

    @provisionable_autonomous_container_databases.setter
    def provisionable_autonomous_container_databases(self, provisionable_autonomous_container_databases):
        """
        Sets the provisionable_autonomous_container_databases of this CloudAutonomousVmClusterResourceUsage.
        The number of provisionable Autonomous Container Databases in an Autonomous VM Cluster.


        :param provisionable_autonomous_container_databases: The provisionable_autonomous_container_databases of this CloudAutonomousVmClusterResourceUsage.
        :type: int
        """
        self._provisionable_autonomous_container_databases = provisionable_autonomous_container_databases

    @property
    def provisioned_autonomous_container_databases(self):
        """
        Gets the provisioned_autonomous_container_databases of this CloudAutonomousVmClusterResourceUsage.
        The number of provisioned Autonomous Container Databases in an Autonomous VM Cluster.


        :return: The provisioned_autonomous_container_databases of this CloudAutonomousVmClusterResourceUsage.
        :rtype: int
        """
        return self._provisioned_autonomous_container_databases

    @provisioned_autonomous_container_databases.setter
    def provisioned_autonomous_container_databases(self, provisioned_autonomous_container_databases):
        """
        Sets the provisioned_autonomous_container_databases of this CloudAutonomousVmClusterResourceUsage.
        The number of provisioned Autonomous Container Databases in an Autonomous VM Cluster.


        :param provisioned_autonomous_container_databases: The provisioned_autonomous_container_databases of this CloudAutonomousVmClusterResourceUsage.
        :type: int
        """
        self._provisioned_autonomous_container_databases = provisioned_autonomous_container_databases

    @property
    def non_provisionable_autonomous_container_databases(self):
        """
        Gets the non_provisionable_autonomous_container_databases of this CloudAutonomousVmClusterResourceUsage.
        The number of non-provisionable Autonomous Container Databases in an Autonomous VM Cluster.


        :return: The non_provisionable_autonomous_container_databases of this CloudAutonomousVmClusterResourceUsage.
        :rtype: int
        """
        return self._non_provisionable_autonomous_container_databases

    @non_provisionable_autonomous_container_databases.setter
    def non_provisionable_autonomous_container_databases(self, non_provisionable_autonomous_container_databases):
        """
        Sets the non_provisionable_autonomous_container_databases of this CloudAutonomousVmClusterResourceUsage.
        The number of non-provisionable Autonomous Container Databases in an Autonomous VM Cluster.


        :param non_provisionable_autonomous_container_databases: The non_provisionable_autonomous_container_databases of this CloudAutonomousVmClusterResourceUsage.
        :type: int
        """
        self._non_provisionable_autonomous_container_databases = non_provisionable_autonomous_container_databases

    @property
    def autonomous_vm_resource_usage(self):
        """
        Gets the autonomous_vm_resource_usage of this CloudAutonomousVmClusterResourceUsage.
        List of Autonomous VM resource usages.


        :return: The autonomous_vm_resource_usage of this CloudAutonomousVmClusterResourceUsage.
        :rtype: list[oci.database.models.AutonomousVmResourceUsage]
        """
        return self._autonomous_vm_resource_usage

    @autonomous_vm_resource_usage.setter
    def autonomous_vm_resource_usage(self, autonomous_vm_resource_usage):
        """
        Sets the autonomous_vm_resource_usage of this CloudAutonomousVmClusterResourceUsage.
        List of Autonomous VM resource usages.


        :param autonomous_vm_resource_usage: The autonomous_vm_resource_usage of this CloudAutonomousVmClusterResourceUsage.
        :type: list[oci.database.models.AutonomousVmResourceUsage]
        """
        self._autonomous_vm_resource_usage = autonomous_vm_resource_usage

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
