# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AutonomousVmClusterSummary(object):
    """
    Details of the Autonomous VM cluster.
    """

    #: A constant which can be used with the lifecycle_state property of a AutonomousVmClusterSummary.
    #: This constant has a value of "PROVISIONING"
    LIFECYCLE_STATE_PROVISIONING = "PROVISIONING"

    #: A constant which can be used with the lifecycle_state property of a AutonomousVmClusterSummary.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a AutonomousVmClusterSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a AutonomousVmClusterSummary.
    #: This constant has a value of "TERMINATING"
    LIFECYCLE_STATE_TERMINATING = "TERMINATING"

    #: A constant which can be used with the lifecycle_state property of a AutonomousVmClusterSummary.
    #: This constant has a value of "TERMINATED"
    LIFECYCLE_STATE_TERMINATED = "TERMINATED"

    #: A constant which can be used with the lifecycle_state property of a AutonomousVmClusterSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a AutonomousVmClusterSummary.
    #: This constant has a value of "MAINTENANCE_IN_PROGRESS"
    LIFECYCLE_STATE_MAINTENANCE_IN_PROGRESS = "MAINTENANCE_IN_PROGRESS"

    #: A constant which can be used with the compute_model property of a AutonomousVmClusterSummary.
    #: This constant has a value of "ECPU"
    COMPUTE_MODEL_ECPU = "ECPU"

    #: A constant which can be used with the compute_model property of a AutonomousVmClusterSummary.
    #: This constant has a value of "OCPU"
    COMPUTE_MODEL_OCPU = "OCPU"

    #: A constant which can be used with the license_model property of a AutonomousVmClusterSummary.
    #: This constant has a value of "LICENSE_INCLUDED"
    LICENSE_MODEL_LICENSE_INCLUDED = "LICENSE_INCLUDED"

    #: A constant which can be used with the license_model property of a AutonomousVmClusterSummary.
    #: This constant has a value of "BRING_YOUR_OWN_LICENSE"
    LICENSE_MODEL_BRING_YOUR_OWN_LICENSE = "BRING_YOUR_OWN_LICENSE"

    def __init__(self, **kwargs):
        """
        Initializes a new AutonomousVmClusterSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AutonomousVmClusterSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AutonomousVmClusterSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this AutonomousVmClusterSummary.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this AutonomousVmClusterSummary.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this AutonomousVmClusterSummary.
            Allowed values for this property are: "PROVISIONING", "AVAILABLE", "UPDATING", "TERMINATING", "TERMINATED", "FAILED", "MAINTENANCE_IN_PROGRESS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this AutonomousVmClusterSummary.
        :type lifecycle_details: str

        :param time_zone:
            The value to assign to the time_zone property of this AutonomousVmClusterSummary.
        :type time_zone: str

        :param exadata_infrastructure_id:
            The value to assign to the exadata_infrastructure_id property of this AutonomousVmClusterSummary.
        :type exadata_infrastructure_id: str

        :param vm_cluster_network_id:
            The value to assign to the vm_cluster_network_id property of this AutonomousVmClusterSummary.
        :type vm_cluster_network_id: str

        :param is_local_backup_enabled:
            The value to assign to the is_local_backup_enabled property of this AutonomousVmClusterSummary.
        :type is_local_backup_enabled: bool

        :param cpus_enabled:
            The value to assign to the cpus_enabled property of this AutonomousVmClusterSummary.
        :type cpus_enabled: int

        :param compute_model:
            The value to assign to the compute_model property of this AutonomousVmClusterSummary.
            Allowed values for this property are: "ECPU", "OCPU", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type compute_model: str

        :param ocpus_enabled:
            The value to assign to the ocpus_enabled property of this AutonomousVmClusterSummary.
        :type ocpus_enabled: float

        :param available_cpus:
            The value to assign to the available_cpus property of this AutonomousVmClusterSummary.
        :type available_cpus: int

        :param total_container_databases:
            The value to assign to the total_container_databases property of this AutonomousVmClusterSummary.
        :type total_container_databases: int

        :param memory_per_oracle_compute_unit_in_gbs:
            The value to assign to the memory_per_oracle_compute_unit_in_gbs property of this AutonomousVmClusterSummary.
        :type memory_per_oracle_compute_unit_in_gbs: int

        :param cpu_core_count_per_node:
            The value to assign to the cpu_core_count_per_node property of this AutonomousVmClusterSummary.
        :type cpu_core_count_per_node: int

        :param autonomous_data_storage_size_in_tbs:
            The value to assign to the autonomous_data_storage_size_in_tbs property of this AutonomousVmClusterSummary.
        :type autonomous_data_storage_size_in_tbs: float

        :param maintenance_window:
            The value to assign to the maintenance_window property of this AutonomousVmClusterSummary.
        :type maintenance_window: oci.database.models.MaintenanceWindow

        :param last_maintenance_run_id:
            The value to assign to the last_maintenance_run_id property of this AutonomousVmClusterSummary.
        :type last_maintenance_run_id: str

        :param next_maintenance_run_id:
            The value to assign to the next_maintenance_run_id property of this AutonomousVmClusterSummary.
        :type next_maintenance_run_id: str

        :param cpu_percentage:
            The value to assign to the cpu_percentage property of this AutonomousVmClusterSummary.
        :type cpu_percentage: float

        :param autonomous_data_storage_percentage:
            The value to assign to the autonomous_data_storage_percentage property of this AutonomousVmClusterSummary.
        :type autonomous_data_storage_percentage: float

        :param provisioned_cpus:
            The value to assign to the provisioned_cpus property of this AutonomousVmClusterSummary.
        :type provisioned_cpus: float

        :param total_autonomous_data_storage_in_tbs:
            The value to assign to the total_autonomous_data_storage_in_tbs property of this AutonomousVmClusterSummary.
        :type total_autonomous_data_storage_in_tbs: float

        :param reserved_cpus:
            The value to assign to the reserved_cpus property of this AutonomousVmClusterSummary.
        :type reserved_cpus: float

        :param provisionable_autonomous_container_databases:
            The value to assign to the provisionable_autonomous_container_databases property of this AutonomousVmClusterSummary.
        :type provisionable_autonomous_container_databases: int

        :param provisioned_autonomous_container_databases:
            The value to assign to the provisioned_autonomous_container_databases property of this AutonomousVmClusterSummary.
        :type provisioned_autonomous_container_databases: int

        :param non_provisionable_autonomous_container_databases:
            The value to assign to the non_provisionable_autonomous_container_databases property of this AutonomousVmClusterSummary.
        :type non_provisionable_autonomous_container_databases: int

        :param memory_size_in_gbs:
            The value to assign to the memory_size_in_gbs property of this AutonomousVmClusterSummary.
        :type memory_size_in_gbs: int

        :param db_node_storage_size_in_gbs:
            The value to assign to the db_node_storage_size_in_gbs property of this AutonomousVmClusterSummary.
        :type db_node_storage_size_in_gbs: int

        :param data_storage_size_in_tbs:
            The value to assign to the data_storage_size_in_tbs property of this AutonomousVmClusterSummary.
        :type data_storage_size_in_tbs: float

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this AutonomousVmClusterSummary.
        :type data_storage_size_in_gbs: float

        :param available_data_storage_size_in_tbs:
            The value to assign to the available_data_storage_size_in_tbs property of this AutonomousVmClusterSummary.
        :type available_data_storage_size_in_tbs: float

        :param node_count:
            The value to assign to the node_count property of this AutonomousVmClusterSummary.
        :type node_count: int

        :param license_model:
            The value to assign to the license_model property of this AutonomousVmClusterSummary.
            Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type license_model: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AutonomousVmClusterSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AutonomousVmClusterSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param db_servers:
            The value to assign to the db_servers property of this AutonomousVmClusterSummary.
        :type db_servers: list[str]

        :param reclaimable_cpus:
            The value to assign to the reclaimable_cpus property of this AutonomousVmClusterSummary.
        :type reclaimable_cpus: int

        :param available_container_databases:
            The value to assign to the available_container_databases property of this AutonomousVmClusterSummary.
        :type available_container_databases: int

        :param available_autonomous_data_storage_size_in_tbs:
            The value to assign to the available_autonomous_data_storage_size_in_tbs property of this AutonomousVmClusterSummary.
        :type available_autonomous_data_storage_size_in_tbs: float

        :param scan_listener_port_tls:
            The value to assign to the scan_listener_port_tls property of this AutonomousVmClusterSummary.
        :type scan_listener_port_tls: int

        :param scan_listener_port_non_tls:
            The value to assign to the scan_listener_port_non_tls property of this AutonomousVmClusterSummary.
        :type scan_listener_port_non_tls: int

        :param is_mtls_enabled:
            The value to assign to the is_mtls_enabled property of this AutonomousVmClusterSummary.
        :type is_mtls_enabled: bool

        :param time_database_ssl_certificate_expires:
            The value to assign to the time_database_ssl_certificate_expires property of this AutonomousVmClusterSummary.
        :type time_database_ssl_certificate_expires: datetime

        :param time_ords_certificate_expires:
            The value to assign to the time_ords_certificate_expires property of this AutonomousVmClusterSummary.
        :type time_ords_certificate_expires: datetime

        :param exadata_storage_in_tbs_lowest_scaled_value:
            The value to assign to the exadata_storage_in_tbs_lowest_scaled_value property of this AutonomousVmClusterSummary.
        :type exadata_storage_in_tbs_lowest_scaled_value: float

        :param cpus_lowest_scaled_value:
            The value to assign to the cpus_lowest_scaled_value property of this AutonomousVmClusterSummary.
        :type cpus_lowest_scaled_value: int

        :param max_acds_lowest_scaled_value:
            The value to assign to the max_acds_lowest_scaled_value property of this AutonomousVmClusterSummary.
        :type max_acds_lowest_scaled_value: int

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_zone': 'str',
            'exadata_infrastructure_id': 'str',
            'vm_cluster_network_id': 'str',
            'is_local_backup_enabled': 'bool',
            'cpus_enabled': 'int',
            'compute_model': 'str',
            'ocpus_enabled': 'float',
            'available_cpus': 'int',
            'total_container_databases': 'int',
            'memory_per_oracle_compute_unit_in_gbs': 'int',
            'cpu_core_count_per_node': 'int',
            'autonomous_data_storage_size_in_tbs': 'float',
            'maintenance_window': 'MaintenanceWindow',
            'last_maintenance_run_id': 'str',
            'next_maintenance_run_id': 'str',
            'cpu_percentage': 'float',
            'autonomous_data_storage_percentage': 'float',
            'provisioned_cpus': 'float',
            'total_autonomous_data_storage_in_tbs': 'float',
            'reserved_cpus': 'float',
            'provisionable_autonomous_container_databases': 'int',
            'provisioned_autonomous_container_databases': 'int',
            'non_provisionable_autonomous_container_databases': 'int',
            'memory_size_in_gbs': 'int',
            'db_node_storage_size_in_gbs': 'int',
            'data_storage_size_in_tbs': 'float',
            'data_storage_size_in_gbs': 'float',
            'available_data_storage_size_in_tbs': 'float',
            'node_count': 'int',
            'license_model': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'db_servers': 'list[str]',
            'reclaimable_cpus': 'int',
            'available_container_databases': 'int',
            'available_autonomous_data_storage_size_in_tbs': 'float',
            'scan_listener_port_tls': 'int',
            'scan_listener_port_non_tls': 'int',
            'is_mtls_enabled': 'bool',
            'time_database_ssl_certificate_expires': 'datetime',
            'time_ords_certificate_expires': 'datetime',
            'exadata_storage_in_tbs_lowest_scaled_value': 'float',
            'cpus_lowest_scaled_value': 'int',
            'max_acds_lowest_scaled_value': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_zone': 'timeZone',
            'exadata_infrastructure_id': 'exadataInfrastructureId',
            'vm_cluster_network_id': 'vmClusterNetworkId',
            'is_local_backup_enabled': 'isLocalBackupEnabled',
            'cpus_enabled': 'cpusEnabled',
            'compute_model': 'computeModel',
            'ocpus_enabled': 'ocpusEnabled',
            'available_cpus': 'availableCpus',
            'total_container_databases': 'totalContainerDatabases',
            'memory_per_oracle_compute_unit_in_gbs': 'memoryPerOracleComputeUnitInGBs',
            'cpu_core_count_per_node': 'cpuCoreCountPerNode',
            'autonomous_data_storage_size_in_tbs': 'autonomousDataStorageSizeInTBs',
            'maintenance_window': 'maintenanceWindow',
            'last_maintenance_run_id': 'lastMaintenanceRunId',
            'next_maintenance_run_id': 'nextMaintenanceRunId',
            'cpu_percentage': 'cpuPercentage',
            'autonomous_data_storage_percentage': 'autonomousDataStoragePercentage',
            'provisioned_cpus': 'provisionedCpus',
            'total_autonomous_data_storage_in_tbs': 'totalAutonomousDataStorageInTBs',
            'reserved_cpus': 'reservedCpus',
            'provisionable_autonomous_container_databases': 'provisionableAutonomousContainerDatabases',
            'provisioned_autonomous_container_databases': 'provisionedAutonomousContainerDatabases',
            'non_provisionable_autonomous_container_databases': 'nonProvisionableAutonomousContainerDatabases',
            'memory_size_in_gbs': 'memorySizeInGBs',
            'db_node_storage_size_in_gbs': 'dbNodeStorageSizeInGBs',
            'data_storage_size_in_tbs': 'dataStorageSizeInTBs',
            'data_storage_size_in_gbs': 'dataStorageSizeInGBs',
            'available_data_storage_size_in_tbs': 'availableDataStorageSizeInTBs',
            'node_count': 'nodeCount',
            'license_model': 'licenseModel',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'db_servers': 'dbServers',
            'reclaimable_cpus': 'reclaimableCpus',
            'available_container_databases': 'availableContainerDatabases',
            'available_autonomous_data_storage_size_in_tbs': 'availableAutonomousDataStorageSizeInTBs',
            'scan_listener_port_tls': 'scanListenerPortTls',
            'scan_listener_port_non_tls': 'scanListenerPortNonTls',
            'is_mtls_enabled': 'isMtlsEnabled',
            'time_database_ssl_certificate_expires': 'timeDatabaseSslCertificateExpires',
            'time_ords_certificate_expires': 'timeOrdsCertificateExpires',
            'exadata_storage_in_tbs_lowest_scaled_value': 'exadataStorageInTBsLowestScaledValue',
            'cpus_lowest_scaled_value': 'cpusLowestScaledValue',
            'max_acds_lowest_scaled_value': 'maxAcdsLowestScaledValue'
        }

        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._time_created = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_zone = None
        self._exadata_infrastructure_id = None
        self._vm_cluster_network_id = None
        self._is_local_backup_enabled = None
        self._cpus_enabled = None
        self._compute_model = None
        self._ocpus_enabled = None
        self._available_cpus = None
        self._total_container_databases = None
        self._memory_per_oracle_compute_unit_in_gbs = None
        self._cpu_core_count_per_node = None
        self._autonomous_data_storage_size_in_tbs = None
        self._maintenance_window = None
        self._last_maintenance_run_id = None
        self._next_maintenance_run_id = None
        self._cpu_percentage = None
        self._autonomous_data_storage_percentage = None
        self._provisioned_cpus = None
        self._total_autonomous_data_storage_in_tbs = None
        self._reserved_cpus = None
        self._provisionable_autonomous_container_databases = None
        self._provisioned_autonomous_container_databases = None
        self._non_provisionable_autonomous_container_databases = None
        self._memory_size_in_gbs = None
        self._db_node_storage_size_in_gbs = None
        self._data_storage_size_in_tbs = None
        self._data_storage_size_in_gbs = None
        self._available_data_storage_size_in_tbs = None
        self._node_count = None
        self._license_model = None
        self._freeform_tags = None
        self._defined_tags = None
        self._db_servers = None
        self._reclaimable_cpus = None
        self._available_container_databases = None
        self._available_autonomous_data_storage_size_in_tbs = None
        self._scan_listener_port_tls = None
        self._scan_listener_port_non_tls = None
        self._is_mtls_enabled = None
        self._time_database_ssl_certificate_expires = None
        self._time_ords_certificate_expires = None
        self._exadata_storage_in_tbs_lowest_scaled_value = None
        self._cpus_lowest_scaled_value = None
        self._max_acds_lowest_scaled_value = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this AutonomousVmClusterSummary.
        The `OCID`__ of the Autonomous VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this AutonomousVmClusterSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AutonomousVmClusterSummary.
        The `OCID`__ of the Autonomous VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this AutonomousVmClusterSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AutonomousVmClusterSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this AutonomousVmClusterSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AutonomousVmClusterSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this AutonomousVmClusterSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AutonomousVmClusterSummary.
        The user-friendly name for the Autonomous VM cluster. The name does not need to be unique.


        :return: The display_name of this AutonomousVmClusterSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AutonomousVmClusterSummary.
        The user-friendly name for the Autonomous VM cluster. The name does not need to be unique.


        :param display_name: The display_name of this AutonomousVmClusterSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def time_created(self):
        """
        Gets the time_created of this AutonomousVmClusterSummary.
        The date and time that the Autonomous VM cluster was created.


        :return: The time_created of this AutonomousVmClusterSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this AutonomousVmClusterSummary.
        The date and time that the Autonomous VM cluster was created.


        :param time_created: The time_created of this AutonomousVmClusterSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this AutonomousVmClusterSummary.
        The current state of the Autonomous VM cluster.

        Allowed values for this property are: "PROVISIONING", "AVAILABLE", "UPDATING", "TERMINATING", "TERMINATED", "FAILED", "MAINTENANCE_IN_PROGRESS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this AutonomousVmClusterSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this AutonomousVmClusterSummary.
        The current state of the Autonomous VM cluster.


        :param lifecycle_state: The lifecycle_state of this AutonomousVmClusterSummary.
        :type: str
        """
        allowed_values = ["PROVISIONING", "AVAILABLE", "UPDATING", "TERMINATING", "TERMINATED", "FAILED", "MAINTENANCE_IN_PROGRESS"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this AutonomousVmClusterSummary.
        Additional information about the current lifecycle state.


        :return: The lifecycle_details of this AutonomousVmClusterSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this AutonomousVmClusterSummary.
        Additional information about the current lifecycle state.


        :param lifecycle_details: The lifecycle_details of this AutonomousVmClusterSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_zone(self):
        """
        Gets the time_zone of this AutonomousVmClusterSummary.
        The time zone to use for the Autonomous VM cluster. For details, see `DB System Time Zones`__.

        __ https://docs.cloud.oracle.com/Content/Database/References/timezones.htm


        :return: The time_zone of this AutonomousVmClusterSummary.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """
        Sets the time_zone of this AutonomousVmClusterSummary.
        The time zone to use for the Autonomous VM cluster. For details, see `DB System Time Zones`__.

        __ https://docs.cloud.oracle.com/Content/Database/References/timezones.htm


        :param time_zone: The time_zone of this AutonomousVmClusterSummary.
        :type: str
        """
        self._time_zone = time_zone

    @property
    def exadata_infrastructure_id(self):
        """
        **[Required]** Gets the exadata_infrastructure_id of this AutonomousVmClusterSummary.
        The `OCID`__ of the Exadata infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The exadata_infrastructure_id of this AutonomousVmClusterSummary.
        :rtype: str
        """
        return self._exadata_infrastructure_id

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, exadata_infrastructure_id):
        """
        Sets the exadata_infrastructure_id of this AutonomousVmClusterSummary.
        The `OCID`__ of the Exadata infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param exadata_infrastructure_id: The exadata_infrastructure_id of this AutonomousVmClusterSummary.
        :type: str
        """
        self._exadata_infrastructure_id = exadata_infrastructure_id

    @property
    def vm_cluster_network_id(self):
        """
        **[Required]** Gets the vm_cluster_network_id of this AutonomousVmClusterSummary.
        The `OCID`__ of the VM cluster network.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vm_cluster_network_id of this AutonomousVmClusterSummary.
        :rtype: str
        """
        return self._vm_cluster_network_id

    @vm_cluster_network_id.setter
    def vm_cluster_network_id(self, vm_cluster_network_id):
        """
        Sets the vm_cluster_network_id of this AutonomousVmClusterSummary.
        The `OCID`__ of the VM cluster network.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vm_cluster_network_id: The vm_cluster_network_id of this AutonomousVmClusterSummary.
        :type: str
        """
        self._vm_cluster_network_id = vm_cluster_network_id

    @property
    def is_local_backup_enabled(self):
        """
        Gets the is_local_backup_enabled of this AutonomousVmClusterSummary.
        If true, database backup on local Exadata storage is configured for the Autonomous VM cluster. If false, database backup on local Exadata storage is not available in the Autonomous VM cluster.


        :return: The is_local_backup_enabled of this AutonomousVmClusterSummary.
        :rtype: bool
        """
        return self._is_local_backup_enabled

    @is_local_backup_enabled.setter
    def is_local_backup_enabled(self, is_local_backup_enabled):
        """
        Sets the is_local_backup_enabled of this AutonomousVmClusterSummary.
        If true, database backup on local Exadata storage is configured for the Autonomous VM cluster. If false, database backup on local Exadata storage is not available in the Autonomous VM cluster.


        :param is_local_backup_enabled: The is_local_backup_enabled of this AutonomousVmClusterSummary.
        :type: bool
        """
        self._is_local_backup_enabled = is_local_backup_enabled

    @property
    def cpus_enabled(self):
        """
        Gets the cpus_enabled of this AutonomousVmClusterSummary.
        The number of enabled CPU cores.


        :return: The cpus_enabled of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._cpus_enabled

    @cpus_enabled.setter
    def cpus_enabled(self, cpus_enabled):
        """
        Sets the cpus_enabled of this AutonomousVmClusterSummary.
        The number of enabled CPU cores.


        :param cpus_enabled: The cpus_enabled of this AutonomousVmClusterSummary.
        :type: int
        """
        self._cpus_enabled = cpus_enabled

    @property
    def compute_model(self):
        """
        Gets the compute_model of this AutonomousVmClusterSummary.
        The compute model of the Autonomous VM Cluster. ECPU compute model is the recommended model and OCPU compute model is legacy. See `Compute Models in Autonomous Database on Dedicated Exadata #Infrastructure`__ for more details.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbak

        Allowed values for this property are: "ECPU", "OCPU", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The compute_model of this AutonomousVmClusterSummary.
        :rtype: str
        """
        return self._compute_model

    @compute_model.setter
    def compute_model(self, compute_model):
        """
        Sets the compute_model of this AutonomousVmClusterSummary.
        The compute model of the Autonomous VM Cluster. ECPU compute model is the recommended model and OCPU compute model is legacy. See `Compute Models in Autonomous Database on Dedicated Exadata #Infrastructure`__ for more details.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbak


        :param compute_model: The compute_model of this AutonomousVmClusterSummary.
        :type: str
        """
        allowed_values = ["ECPU", "OCPU"]
        if not value_allowed_none_or_none_sentinel(compute_model, allowed_values):
            compute_model = 'UNKNOWN_ENUM_VALUE'
        self._compute_model = compute_model

    @property
    def ocpus_enabled(self):
        """
        Gets the ocpus_enabled of this AutonomousVmClusterSummary.
        The number of enabled OCPU cores.


        :return: The ocpus_enabled of this AutonomousVmClusterSummary.
        :rtype: float
        """
        return self._ocpus_enabled

    @ocpus_enabled.setter
    def ocpus_enabled(self, ocpus_enabled):
        """
        Sets the ocpus_enabled of this AutonomousVmClusterSummary.
        The number of enabled OCPU cores.


        :param ocpus_enabled: The ocpus_enabled of this AutonomousVmClusterSummary.
        :type: float
        """
        self._ocpus_enabled = ocpus_enabled

    @property
    def available_cpus(self):
        """
        Gets the available_cpus of this AutonomousVmClusterSummary.
        The numnber of CPU cores available.


        :return: The available_cpus of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._available_cpus

    @available_cpus.setter
    def available_cpus(self, available_cpus):
        """
        Sets the available_cpus of this AutonomousVmClusterSummary.
        The numnber of CPU cores available.


        :param available_cpus: The available_cpus of this AutonomousVmClusterSummary.
        :type: int
        """
        self._available_cpus = available_cpus

    @property
    def total_container_databases(self):
        """
        Gets the total_container_databases of this AutonomousVmClusterSummary.
        The total number of Autonomous Container Databases that can be created.


        :return: The total_container_databases of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._total_container_databases

    @total_container_databases.setter
    def total_container_databases(self, total_container_databases):
        """
        Sets the total_container_databases of this AutonomousVmClusterSummary.
        The total number of Autonomous Container Databases that can be created.


        :param total_container_databases: The total_container_databases of this AutonomousVmClusterSummary.
        :type: int
        """
        self._total_container_databases = total_container_databases

    @property
    def memory_per_oracle_compute_unit_in_gbs(self):
        """
        Gets the memory_per_oracle_compute_unit_in_gbs of this AutonomousVmClusterSummary.
        The amount of memory (in GBs) to be enabled per OCPU or ECPU.


        :return: The memory_per_oracle_compute_unit_in_gbs of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._memory_per_oracle_compute_unit_in_gbs

    @memory_per_oracle_compute_unit_in_gbs.setter
    def memory_per_oracle_compute_unit_in_gbs(self, memory_per_oracle_compute_unit_in_gbs):
        """
        Sets the memory_per_oracle_compute_unit_in_gbs of this AutonomousVmClusterSummary.
        The amount of memory (in GBs) to be enabled per OCPU or ECPU.


        :param memory_per_oracle_compute_unit_in_gbs: The memory_per_oracle_compute_unit_in_gbs of this AutonomousVmClusterSummary.
        :type: int
        """
        self._memory_per_oracle_compute_unit_in_gbs = memory_per_oracle_compute_unit_in_gbs

    @property
    def cpu_core_count_per_node(self):
        """
        Gets the cpu_core_count_per_node of this AutonomousVmClusterSummary.
        The number of CPU cores enabled per VM cluster node.


        :return: The cpu_core_count_per_node of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._cpu_core_count_per_node

    @cpu_core_count_per_node.setter
    def cpu_core_count_per_node(self, cpu_core_count_per_node):
        """
        Sets the cpu_core_count_per_node of this AutonomousVmClusterSummary.
        The number of CPU cores enabled per VM cluster node.


        :param cpu_core_count_per_node: The cpu_core_count_per_node of this AutonomousVmClusterSummary.
        :type: int
        """
        self._cpu_core_count_per_node = cpu_core_count_per_node

    @property
    def autonomous_data_storage_size_in_tbs(self):
        """
        Gets the autonomous_data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        The data disk group size allocated for Autonomous Databases, in TBs.


        :return: The autonomous_data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        :rtype: float
        """
        return self._autonomous_data_storage_size_in_tbs

    @autonomous_data_storage_size_in_tbs.setter
    def autonomous_data_storage_size_in_tbs(self, autonomous_data_storage_size_in_tbs):
        """
        Sets the autonomous_data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        The data disk group size allocated for Autonomous Databases, in TBs.


        :param autonomous_data_storage_size_in_tbs: The autonomous_data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        :type: float
        """
        self._autonomous_data_storage_size_in_tbs = autonomous_data_storage_size_in_tbs

    @property
    def maintenance_window(self):
        """
        Gets the maintenance_window of this AutonomousVmClusterSummary.

        :return: The maintenance_window of this AutonomousVmClusterSummary.
        :rtype: oci.database.models.MaintenanceWindow
        """
        return self._maintenance_window

    @maintenance_window.setter
    def maintenance_window(self, maintenance_window):
        """
        Sets the maintenance_window of this AutonomousVmClusterSummary.

        :param maintenance_window: The maintenance_window of this AutonomousVmClusterSummary.
        :type: oci.database.models.MaintenanceWindow
        """
        self._maintenance_window = maintenance_window

    @property
    def last_maintenance_run_id(self):
        """
        Gets the last_maintenance_run_id of this AutonomousVmClusterSummary.
        The `OCID`__ of the last maintenance run.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The last_maintenance_run_id of this AutonomousVmClusterSummary.
        :rtype: str
        """
        return self._last_maintenance_run_id

    @last_maintenance_run_id.setter
    def last_maintenance_run_id(self, last_maintenance_run_id):
        """
        Sets the last_maintenance_run_id of this AutonomousVmClusterSummary.
        The `OCID`__ of the last maintenance run.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param last_maintenance_run_id: The last_maintenance_run_id of this AutonomousVmClusterSummary.
        :type: str
        """
        self._last_maintenance_run_id = last_maintenance_run_id

    @property
    def next_maintenance_run_id(self):
        """
        Gets the next_maintenance_run_id of this AutonomousVmClusterSummary.
        The `OCID`__ of the next maintenance run.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The next_maintenance_run_id of this AutonomousVmClusterSummary.
        :rtype: str
        """
        return self._next_maintenance_run_id

    @next_maintenance_run_id.setter
    def next_maintenance_run_id(self, next_maintenance_run_id):
        """
        Sets the next_maintenance_run_id of this AutonomousVmClusterSummary.
        The `OCID`__ of the next maintenance run.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param next_maintenance_run_id: The next_maintenance_run_id of this AutonomousVmClusterSummary.
        :type: str
        """
        self._next_maintenance_run_id = next_maintenance_run_id

    @property
    def cpu_percentage(self):
        """
        Gets the cpu_percentage of this AutonomousVmClusterSummary.
        The percentage of total number of CPUs used in an Autonomous VM Cluster.


        :return: The cpu_percentage of this AutonomousVmClusterSummary.
        :rtype: float
        """
        return self._cpu_percentage

    @cpu_percentage.setter
    def cpu_percentage(self, cpu_percentage):
        """
        Sets the cpu_percentage of this AutonomousVmClusterSummary.
        The percentage of total number of CPUs used in an Autonomous VM Cluster.


        :param cpu_percentage: The cpu_percentage of this AutonomousVmClusterSummary.
        :type: float
        """
        self._cpu_percentage = cpu_percentage

    @property
    def autonomous_data_storage_percentage(self):
        """
        Gets the autonomous_data_storage_percentage of this AutonomousVmClusterSummary.
        The percentage of the data storage used for the Autonomous Databases in an Autonomous VM Cluster.


        :return: The autonomous_data_storage_percentage of this AutonomousVmClusterSummary.
        :rtype: float
        """
        return self._autonomous_data_storage_percentage

    @autonomous_data_storage_percentage.setter
    def autonomous_data_storage_percentage(self, autonomous_data_storage_percentage):
        """
        Sets the autonomous_data_storage_percentage of this AutonomousVmClusterSummary.
        The percentage of the data storage used for the Autonomous Databases in an Autonomous VM Cluster.


        :param autonomous_data_storage_percentage: The autonomous_data_storage_percentage of this AutonomousVmClusterSummary.
        :type: float
        """
        self._autonomous_data_storage_percentage = autonomous_data_storage_percentage

    @property
    def provisioned_cpus(self):
        """
        Gets the provisioned_cpus of this AutonomousVmClusterSummary.
        The number of CPUs provisioned in an Autonomous VM Cluster.


        :return: The provisioned_cpus of this AutonomousVmClusterSummary.
        :rtype: float
        """
        return self._provisioned_cpus

    @provisioned_cpus.setter
    def provisioned_cpus(self, provisioned_cpus):
        """
        Sets the provisioned_cpus of this AutonomousVmClusterSummary.
        The number of CPUs provisioned in an Autonomous VM Cluster.


        :param provisioned_cpus: The provisioned_cpus of this AutonomousVmClusterSummary.
        :type: float
        """
        self._provisioned_cpus = provisioned_cpus

    @property
    def total_autonomous_data_storage_in_tbs(self):
        """
        Gets the total_autonomous_data_storage_in_tbs of this AutonomousVmClusterSummary.
        The total data disk group size for Autonomous Databases, in TBs.


        :return: The total_autonomous_data_storage_in_tbs of this AutonomousVmClusterSummary.
        :rtype: float
        """
        return self._total_autonomous_data_storage_in_tbs

    @total_autonomous_data_storage_in_tbs.setter
    def total_autonomous_data_storage_in_tbs(self, total_autonomous_data_storage_in_tbs):
        """
        Sets the total_autonomous_data_storage_in_tbs of this AutonomousVmClusterSummary.
        The total data disk group size for Autonomous Databases, in TBs.


        :param total_autonomous_data_storage_in_tbs: The total_autonomous_data_storage_in_tbs of this AutonomousVmClusterSummary.
        :type: float
        """
        self._total_autonomous_data_storage_in_tbs = total_autonomous_data_storage_in_tbs

    @property
    def reserved_cpus(self):
        """
        Gets the reserved_cpus of this AutonomousVmClusterSummary.
        The number of CPUs reserved in an Autonomous VM Cluster.


        :return: The reserved_cpus of this AutonomousVmClusterSummary.
        :rtype: float
        """
        return self._reserved_cpus

    @reserved_cpus.setter
    def reserved_cpus(self, reserved_cpus):
        """
        Sets the reserved_cpus of this AutonomousVmClusterSummary.
        The number of CPUs reserved in an Autonomous VM Cluster.


        :param reserved_cpus: The reserved_cpus of this AutonomousVmClusterSummary.
        :type: float
        """
        self._reserved_cpus = reserved_cpus

    @property
    def provisionable_autonomous_container_databases(self):
        """
        Gets the provisionable_autonomous_container_databases of this AutonomousVmClusterSummary.
        **Deprecated.** Use field totalContainerDatabases.


        :return: The provisionable_autonomous_container_databases of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._provisionable_autonomous_container_databases

    @provisionable_autonomous_container_databases.setter
    def provisionable_autonomous_container_databases(self, provisionable_autonomous_container_databases):
        """
        Sets the provisionable_autonomous_container_databases of this AutonomousVmClusterSummary.
        **Deprecated.** Use field totalContainerDatabases.


        :param provisionable_autonomous_container_databases: The provisionable_autonomous_container_databases of this AutonomousVmClusterSummary.
        :type: int
        """
        self._provisionable_autonomous_container_databases = provisionable_autonomous_container_databases

    @property
    def provisioned_autonomous_container_databases(self):
        """
        Gets the provisioned_autonomous_container_databases of this AutonomousVmClusterSummary.
        The number of provisioned Autonomous Container Databases in an Autonomous VM Cluster.


        :return: The provisioned_autonomous_container_databases of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._provisioned_autonomous_container_databases

    @provisioned_autonomous_container_databases.setter
    def provisioned_autonomous_container_databases(self, provisioned_autonomous_container_databases):
        """
        Sets the provisioned_autonomous_container_databases of this AutonomousVmClusterSummary.
        The number of provisioned Autonomous Container Databases in an Autonomous VM Cluster.


        :param provisioned_autonomous_container_databases: The provisioned_autonomous_container_databases of this AutonomousVmClusterSummary.
        :type: int
        """
        self._provisioned_autonomous_container_databases = provisioned_autonomous_container_databases

    @property
    def non_provisionable_autonomous_container_databases(self):
        """
        Gets the non_provisionable_autonomous_container_databases of this AutonomousVmClusterSummary.
        The number of non-provisionable Autonomous Container Databases in an Autonomous VM Cluster.


        :return: The non_provisionable_autonomous_container_databases of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._non_provisionable_autonomous_container_databases

    @non_provisionable_autonomous_container_databases.setter
    def non_provisionable_autonomous_container_databases(self, non_provisionable_autonomous_container_databases):
        """
        Sets the non_provisionable_autonomous_container_databases of this AutonomousVmClusterSummary.
        The number of non-provisionable Autonomous Container Databases in an Autonomous VM Cluster.


        :param non_provisionable_autonomous_container_databases: The non_provisionable_autonomous_container_databases of this AutonomousVmClusterSummary.
        :type: int
        """
        self._non_provisionable_autonomous_container_databases = non_provisionable_autonomous_container_databases

    @property
    def memory_size_in_gbs(self):
        """
        Gets the memory_size_in_gbs of this AutonomousVmClusterSummary.
        The memory allocated in GBs.


        :return: The memory_size_in_gbs of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._memory_size_in_gbs

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, memory_size_in_gbs):
        """
        Sets the memory_size_in_gbs of this AutonomousVmClusterSummary.
        The memory allocated in GBs.


        :param memory_size_in_gbs: The memory_size_in_gbs of this AutonomousVmClusterSummary.
        :type: int
        """
        self._memory_size_in_gbs = memory_size_in_gbs

    @property
    def db_node_storage_size_in_gbs(self):
        """
        Gets the db_node_storage_size_in_gbs of this AutonomousVmClusterSummary.
        The local node storage allocated in GBs.


        :return: The db_node_storage_size_in_gbs of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._db_node_storage_size_in_gbs

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, db_node_storage_size_in_gbs):
        """
        Sets the db_node_storage_size_in_gbs of this AutonomousVmClusterSummary.
        The local node storage allocated in GBs.


        :param db_node_storage_size_in_gbs: The db_node_storage_size_in_gbs of this AutonomousVmClusterSummary.
        :type: int
        """
        self._db_node_storage_size_in_gbs = db_node_storage_size_in_gbs

    @property
    def data_storage_size_in_tbs(self):
        """
        Gets the data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        The total data storage allocated in TBs


        :return: The data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        :rtype: float
        """
        return self._data_storage_size_in_tbs

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, data_storage_size_in_tbs):
        """
        Sets the data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        The total data storage allocated in TBs


        :param data_storage_size_in_tbs: The data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        :type: float
        """
        self._data_storage_size_in_tbs = data_storage_size_in_tbs

    @property
    def data_storage_size_in_gbs(self):
        """
        Gets the data_storage_size_in_gbs of this AutonomousVmClusterSummary.
        The total data storage allocated in GBs.


        :return: The data_storage_size_in_gbs of this AutonomousVmClusterSummary.
        :rtype: float
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this AutonomousVmClusterSummary.
        The total data storage allocated in GBs.


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this AutonomousVmClusterSummary.
        :type: float
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def available_data_storage_size_in_tbs(self):
        """
        Gets the available_data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        **Deprecated.** Use `availableAutonomousDataStorageSizeInTBs` for Autonomous Databases' data storage availability in TBs.


        :return: The available_data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        :rtype: float
        """
        return self._available_data_storage_size_in_tbs

    @available_data_storage_size_in_tbs.setter
    def available_data_storage_size_in_tbs(self, available_data_storage_size_in_tbs):
        """
        Sets the available_data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        **Deprecated.** Use `availableAutonomousDataStorageSizeInTBs` for Autonomous Databases' data storage availability in TBs.


        :param available_data_storage_size_in_tbs: The available_data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        :type: float
        """
        self._available_data_storage_size_in_tbs = available_data_storage_size_in_tbs

    @property
    def node_count(self):
        """
        Gets the node_count of this AutonomousVmClusterSummary.
        The number of nodes in the Autonomous VM Cluster.


        :return: The node_count of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._node_count

    @node_count.setter
    def node_count(self, node_count):
        """
        Sets the node_count of this AutonomousVmClusterSummary.
        The number of nodes in the Autonomous VM Cluster.


        :param node_count: The node_count of this AutonomousVmClusterSummary.
        :type: int
        """
        self._node_count = node_count

    @property
    def license_model(self):
        """
        Gets the license_model of this AutonomousVmClusterSummary.
        The Oracle license model that applies to the Autonomous VM cluster. The default is LICENSE_INCLUDED.

        Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The license_model of this AutonomousVmClusterSummary.
        :rtype: str
        """
        return self._license_model

    @license_model.setter
    def license_model(self, license_model):
        """
        Sets the license_model of this AutonomousVmClusterSummary.
        The Oracle license model that applies to the Autonomous VM cluster. The default is LICENSE_INCLUDED.


        :param license_model: The license_model of this AutonomousVmClusterSummary.
        :type: str
        """
        allowed_values = ["LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"]
        if not value_allowed_none_or_none_sentinel(license_model, allowed_values):
            license_model = 'UNKNOWN_ENUM_VALUE'
        self._license_model = license_model

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this AutonomousVmClusterSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this AutonomousVmClusterSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AutonomousVmClusterSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this AutonomousVmClusterSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this AutonomousVmClusterSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this AutonomousVmClusterSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AutonomousVmClusterSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this AutonomousVmClusterSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def db_servers(self):
        """
        Gets the db_servers of this AutonomousVmClusterSummary.
        The list of `OCIDs`__ of the Db servers.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The db_servers of this AutonomousVmClusterSummary.
        :rtype: list[str]
        """
        return self._db_servers

    @db_servers.setter
    def db_servers(self, db_servers):
        """
        Sets the db_servers of this AutonomousVmClusterSummary.
        The list of `OCIDs`__ of the Db servers.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param db_servers: The db_servers of this AutonomousVmClusterSummary.
        :type: list[str]
        """
        self._db_servers = db_servers

    @property
    def reclaimable_cpus(self):
        """
        Gets the reclaimable_cpus of this AutonomousVmClusterSummary.
        CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.


        :return: The reclaimable_cpus of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._reclaimable_cpus

    @reclaimable_cpus.setter
    def reclaimable_cpus(self, reclaimable_cpus):
        """
        Sets the reclaimable_cpus of this AutonomousVmClusterSummary.
        CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.


        :param reclaimable_cpus: The reclaimable_cpus of this AutonomousVmClusterSummary.
        :type: int
        """
        self._reclaimable_cpus = reclaimable_cpus

    @property
    def available_container_databases(self):
        """
        Gets the available_container_databases of this AutonomousVmClusterSummary.
        The number of Autonomous Container Databases that can be created with the currently available local storage.


        :return: The available_container_databases of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._available_container_databases

    @available_container_databases.setter
    def available_container_databases(self, available_container_databases):
        """
        Sets the available_container_databases of this AutonomousVmClusterSummary.
        The number of Autonomous Container Databases that can be created with the currently available local storage.


        :param available_container_databases: The available_container_databases of this AutonomousVmClusterSummary.
        :type: int
        """
        self._available_container_databases = available_container_databases

    @property
    def available_autonomous_data_storage_size_in_tbs(self):
        """
        Gets the available_autonomous_data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        The data disk group size available for Autonomous Databases, in TBs.


        :return: The available_autonomous_data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        :rtype: float
        """
        return self._available_autonomous_data_storage_size_in_tbs

    @available_autonomous_data_storage_size_in_tbs.setter
    def available_autonomous_data_storage_size_in_tbs(self, available_autonomous_data_storage_size_in_tbs):
        """
        Sets the available_autonomous_data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        The data disk group size available for Autonomous Databases, in TBs.


        :param available_autonomous_data_storage_size_in_tbs: The available_autonomous_data_storage_size_in_tbs of this AutonomousVmClusterSummary.
        :type: float
        """
        self._available_autonomous_data_storage_size_in_tbs = available_autonomous_data_storage_size_in_tbs

    @property
    def scan_listener_port_tls(self):
        """
        Gets the scan_listener_port_tls of this AutonomousVmClusterSummary.
        The SCAN Listener TLS port number. Default value is 2484.


        :return: The scan_listener_port_tls of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._scan_listener_port_tls

    @scan_listener_port_tls.setter
    def scan_listener_port_tls(self, scan_listener_port_tls):
        """
        Sets the scan_listener_port_tls of this AutonomousVmClusterSummary.
        The SCAN Listener TLS port number. Default value is 2484.


        :param scan_listener_port_tls: The scan_listener_port_tls of this AutonomousVmClusterSummary.
        :type: int
        """
        self._scan_listener_port_tls = scan_listener_port_tls

    @property
    def scan_listener_port_non_tls(self):
        """
        Gets the scan_listener_port_non_tls of this AutonomousVmClusterSummary.
        The SCAN Listener Non TLS port number. Default value is 1521.


        :return: The scan_listener_port_non_tls of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._scan_listener_port_non_tls

    @scan_listener_port_non_tls.setter
    def scan_listener_port_non_tls(self, scan_listener_port_non_tls):
        """
        Sets the scan_listener_port_non_tls of this AutonomousVmClusterSummary.
        The SCAN Listener Non TLS port number. Default value is 1521.


        :param scan_listener_port_non_tls: The scan_listener_port_non_tls of this AutonomousVmClusterSummary.
        :type: int
        """
        self._scan_listener_port_non_tls = scan_listener_port_non_tls

    @property
    def is_mtls_enabled(self):
        """
        Gets the is_mtls_enabled of this AutonomousVmClusterSummary.
        Enable mutual TLS(mTLS) authentication for database while provisioning a VMCluster. Default is TLS.


        :return: The is_mtls_enabled of this AutonomousVmClusterSummary.
        :rtype: bool
        """
        return self._is_mtls_enabled

    @is_mtls_enabled.setter
    def is_mtls_enabled(self, is_mtls_enabled):
        """
        Sets the is_mtls_enabled of this AutonomousVmClusterSummary.
        Enable mutual TLS(mTLS) authentication for database while provisioning a VMCluster. Default is TLS.


        :param is_mtls_enabled: The is_mtls_enabled of this AutonomousVmClusterSummary.
        :type: bool
        """
        self._is_mtls_enabled = is_mtls_enabled

    @property
    def time_database_ssl_certificate_expires(self):
        """
        Gets the time_database_ssl_certificate_expires of this AutonomousVmClusterSummary.
        The date and time of the Database SSL certificate expiration.


        :return: The time_database_ssl_certificate_expires of this AutonomousVmClusterSummary.
        :rtype: datetime
        """
        return self._time_database_ssl_certificate_expires

    @time_database_ssl_certificate_expires.setter
    def time_database_ssl_certificate_expires(self, time_database_ssl_certificate_expires):
        """
        Sets the time_database_ssl_certificate_expires of this AutonomousVmClusterSummary.
        The date and time of the Database SSL certificate expiration.


        :param time_database_ssl_certificate_expires: The time_database_ssl_certificate_expires of this AutonomousVmClusterSummary.
        :type: datetime
        """
        self._time_database_ssl_certificate_expires = time_database_ssl_certificate_expires

    @property
    def time_ords_certificate_expires(self):
        """
        Gets the time_ords_certificate_expires of this AutonomousVmClusterSummary.
        The date and time of the ORDS certificate expiration.


        :return: The time_ords_certificate_expires of this AutonomousVmClusterSummary.
        :rtype: datetime
        """
        return self._time_ords_certificate_expires

    @time_ords_certificate_expires.setter
    def time_ords_certificate_expires(self, time_ords_certificate_expires):
        """
        Sets the time_ords_certificate_expires of this AutonomousVmClusterSummary.
        The date and time of the ORDS certificate expiration.


        :param time_ords_certificate_expires: The time_ords_certificate_expires of this AutonomousVmClusterSummary.
        :type: datetime
        """
        self._time_ords_certificate_expires = time_ords_certificate_expires

    @property
    def exadata_storage_in_tbs_lowest_scaled_value(self):
        """
        Gets the exadata_storage_in_tbs_lowest_scaled_value of this AutonomousVmClusterSummary.
        The lowest value to which exadataStorage(in TBs) can be scaled down.


        :return: The exadata_storage_in_tbs_lowest_scaled_value of this AutonomousVmClusterSummary.
        :rtype: float
        """
        return self._exadata_storage_in_tbs_lowest_scaled_value

    @exadata_storage_in_tbs_lowest_scaled_value.setter
    def exadata_storage_in_tbs_lowest_scaled_value(self, exadata_storage_in_tbs_lowest_scaled_value):
        """
        Sets the exadata_storage_in_tbs_lowest_scaled_value of this AutonomousVmClusterSummary.
        The lowest value to which exadataStorage(in TBs) can be scaled down.


        :param exadata_storage_in_tbs_lowest_scaled_value: The exadata_storage_in_tbs_lowest_scaled_value of this AutonomousVmClusterSummary.
        :type: float
        """
        self._exadata_storage_in_tbs_lowest_scaled_value = exadata_storage_in_tbs_lowest_scaled_value

    @property
    def cpus_lowest_scaled_value(self):
        """
        Gets the cpus_lowest_scaled_value of this AutonomousVmClusterSummary.
        The lowest value to which cpus can be scaled down.


        :return: The cpus_lowest_scaled_value of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._cpus_lowest_scaled_value

    @cpus_lowest_scaled_value.setter
    def cpus_lowest_scaled_value(self, cpus_lowest_scaled_value):
        """
        Sets the cpus_lowest_scaled_value of this AutonomousVmClusterSummary.
        The lowest value to which cpus can be scaled down.


        :param cpus_lowest_scaled_value: The cpus_lowest_scaled_value of this AutonomousVmClusterSummary.
        :type: int
        """
        self._cpus_lowest_scaled_value = cpus_lowest_scaled_value

    @property
    def max_acds_lowest_scaled_value(self):
        """
        Gets the max_acds_lowest_scaled_value of this AutonomousVmClusterSummary.
        The lowest value to which maximum number of ACDs can be scaled down.


        :return: The max_acds_lowest_scaled_value of this AutonomousVmClusterSummary.
        :rtype: int
        """
        return self._max_acds_lowest_scaled_value

    @max_acds_lowest_scaled_value.setter
    def max_acds_lowest_scaled_value(self, max_acds_lowest_scaled_value):
        """
        Sets the max_acds_lowest_scaled_value of this AutonomousVmClusterSummary.
        The lowest value to which maximum number of ACDs can be scaled down.


        :param max_acds_lowest_scaled_value: The max_acds_lowest_scaled_value of this AutonomousVmClusterSummary.
        :type: int
        """
        self._max_acds_lowest_scaled_value = max_acds_lowest_scaled_value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
