# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelDeploymentInstanceShapeConfigDetails(object):
    """
    Details for the model-deployment instance shape configuration.
    """

    #: A constant which can be used with the cpu_baseline property of a ModelDeploymentInstanceShapeConfigDetails.
    #: This constant has a value of "BASELINE_1_8"
    CPU_BASELINE_BASELINE_1_8 = "BASELINE_1_8"

    #: A constant which can be used with the cpu_baseline property of a ModelDeploymentInstanceShapeConfigDetails.
    #: This constant has a value of "BASELINE_1_2"
    CPU_BASELINE_BASELINE_1_2 = "BASELINE_1_2"

    #: A constant which can be used with the cpu_baseline property of a ModelDeploymentInstanceShapeConfigDetails.
    #: This constant has a value of "BASELINE_1_1"
    CPU_BASELINE_BASELINE_1_1 = "BASELINE_1_1"

    def __init__(self, **kwargs):
        """
        Initializes a new ModelDeploymentInstanceShapeConfigDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ocpus:
            The value to assign to the ocpus property of this ModelDeploymentInstanceShapeConfigDetails.
        :type ocpus: float

        :param memory_in_gbs:
            The value to assign to the memory_in_gbs property of this ModelDeploymentInstanceShapeConfigDetails.
        :type memory_in_gbs: float

        :param cpu_baseline:
            The value to assign to the cpu_baseline property of this ModelDeploymentInstanceShapeConfigDetails.
            Allowed values for this property are: "BASELINE_1_8", "BASELINE_1_2", "BASELINE_1_1", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cpu_baseline: str

        """
        self.swagger_types = {
            'ocpus': 'float',
            'memory_in_gbs': 'float',
            'cpu_baseline': 'str'
        }

        self.attribute_map = {
            'ocpus': 'ocpus',
            'memory_in_gbs': 'memoryInGBs',
            'cpu_baseline': 'cpuBaseline'
        }

        self._ocpus = None
        self._memory_in_gbs = None
        self._cpu_baseline = None

    @property
    def ocpus(self):
        """
        Gets the ocpus of this ModelDeploymentInstanceShapeConfigDetails.
        A model-deployment instance of type VM.Standard.E3.Flex or VM.Standard.E4.Flex allows the ocpu count to be specified with in the range of 1 to 64 ocpu. VM.Standard3.Flex OCPU range is between 1 to 32 ocpu and for VM.Optimized3.Flex OCPU range is 1 to 18 ocpu.


        :return: The ocpus of this ModelDeploymentInstanceShapeConfigDetails.
        :rtype: float
        """
        return self._ocpus

    @ocpus.setter
    def ocpus(self, ocpus):
        """
        Sets the ocpus of this ModelDeploymentInstanceShapeConfigDetails.
        A model-deployment instance of type VM.Standard.E3.Flex or VM.Standard.E4.Flex allows the ocpu count to be specified with in the range of 1 to 64 ocpu. VM.Standard3.Flex OCPU range is between 1 to 32 ocpu and for VM.Optimized3.Flex OCPU range is 1 to 18 ocpu.


        :param ocpus: The ocpus of this ModelDeploymentInstanceShapeConfigDetails.
        :type: float
        """
        self._ocpus = ocpus

    @property
    def memory_in_gbs(self):
        """
        Gets the memory_in_gbs of this ModelDeploymentInstanceShapeConfigDetails.
        A model-deployment instance of type VM.Standard.E3.Flex or VM.Standard.E4.Flex allows the memory to be specified with in the range of 6 to 1024 GB. VM.Standard3.Flex memory range is between 6 to 512 GB and VM.Optimized3.Flex memory range is between 6 to 256 GB.


        :return: The memory_in_gbs of this ModelDeploymentInstanceShapeConfigDetails.
        :rtype: float
        """
        return self._memory_in_gbs

    @memory_in_gbs.setter
    def memory_in_gbs(self, memory_in_gbs):
        """
        Sets the memory_in_gbs of this ModelDeploymentInstanceShapeConfigDetails.
        A model-deployment instance of type VM.Standard.E3.Flex or VM.Standard.E4.Flex allows the memory to be specified with in the range of 6 to 1024 GB. VM.Standard3.Flex memory range is between 6 to 512 GB and VM.Optimized3.Flex memory range is between 6 to 256 GB.


        :param memory_in_gbs: The memory_in_gbs of this ModelDeploymentInstanceShapeConfigDetails.
        :type: float
        """
        self._memory_in_gbs = memory_in_gbs

    @property
    def cpu_baseline(self):
        """
        Gets the cpu_baseline of this ModelDeploymentInstanceShapeConfigDetails.
        The baseline OCPU utilization for a subcore burstable VM instance. If this attribute is left blank, it will default to `BASELINE_1_1`.
        The following values are supported:
          BASELINE_1_8 - baseline usage is 1/8 of an OCPU.
          BASELINE_1_2 - baseline usage is 1/2 of an OCPU.
          BASELINE_1_1 - baseline usage is an entire OCPU. This represents a non-burstable instance.

        Allowed values for this property are: "BASELINE_1_8", "BASELINE_1_2", "BASELINE_1_1", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cpu_baseline of this ModelDeploymentInstanceShapeConfigDetails.
        :rtype: str
        """
        return self._cpu_baseline

    @cpu_baseline.setter
    def cpu_baseline(self, cpu_baseline):
        """
        Sets the cpu_baseline of this ModelDeploymentInstanceShapeConfigDetails.
        The baseline OCPU utilization for a subcore burstable VM instance. If this attribute is left blank, it will default to `BASELINE_1_1`.
        The following values are supported:
          BASELINE_1_8 - baseline usage is 1/8 of an OCPU.
          BASELINE_1_2 - baseline usage is 1/2 of an OCPU.
          BASELINE_1_1 - baseline usage is an entire OCPU. This represents a non-burstable instance.


        :param cpu_baseline: The cpu_baseline of this ModelDeploymentInstanceShapeConfigDetails.
        :type: str
        """
        allowed_values = ["BASELINE_1_8", "BASELINE_1_2", "BASELINE_1_1"]
        if not value_allowed_none_or_none_sentinel(cpu_baseline, allowed_values):
            cpu_baseline = 'UNKNOWN_ENUM_VALUE'
        self._cpu_baseline = cpu_baseline

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
