# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SqlFirewallAllowedSqlDimensions(object):
    """
    The dimensions available for SQL Firewall allow SQL analytics.
    """

    #: A constant which can be used with the sql_level property of a SqlFirewallAllowedSqlDimensions.
    #: This constant has a value of "USER_ISSUED_SQL"
    SQL_LEVEL_USER_ISSUED_SQL = "USER_ISSUED_SQL"

    #: A constant which can be used with the sql_level property of a SqlFirewallAllowedSqlDimensions.
    #: This constant has a value of "ALL_SQL"
    SQL_LEVEL_ALL_SQL = "ALL_SQL"

    #: A constant which can be used with the lifecycle_state property of a SqlFirewallAllowedSqlDimensions.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a SqlFirewallAllowedSqlDimensions.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new SqlFirewallAllowedSqlDimensions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param sql_firewall_policy_id:
            The value to assign to the sql_firewall_policy_id property of this SqlFirewallAllowedSqlDimensions.
        :type sql_firewall_policy_id: str

        :param sql_level:
            The value to assign to the sql_level property of this SqlFirewallAllowedSqlDimensions.
            Allowed values for this property are: "USER_ISSUED_SQL", "ALL_SQL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type sql_level: str

        :param db_user_name:
            The value to assign to the db_user_name property of this SqlFirewallAllowedSqlDimensions.
        :type db_user_name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SqlFirewallAllowedSqlDimensions.
            Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'sql_firewall_policy_id': 'str',
            'sql_level': 'str',
            'db_user_name': 'str',
            'lifecycle_state': 'str'
        }

        self.attribute_map = {
            'sql_firewall_policy_id': 'sqlFirewallPolicyId',
            'sql_level': 'sqlLevel',
            'db_user_name': 'dbUserName',
            'lifecycle_state': 'lifecycleState'
        }

        self._sql_firewall_policy_id = None
        self._sql_level = None
        self._db_user_name = None
        self._lifecycle_state = None

    @property
    def sql_firewall_policy_id(self):
        """
        Gets the sql_firewall_policy_id of this SqlFirewallAllowedSqlDimensions.
        The OCID of the SQL Firewall policy corresponding to the SQL Firewall allowed SQL.


        :return: The sql_firewall_policy_id of this SqlFirewallAllowedSqlDimensions.
        :rtype: str
        """
        return self._sql_firewall_policy_id

    @sql_firewall_policy_id.setter
    def sql_firewall_policy_id(self, sql_firewall_policy_id):
        """
        Sets the sql_firewall_policy_id of this SqlFirewallAllowedSqlDimensions.
        The OCID of the SQL Firewall policy corresponding to the SQL Firewall allowed SQL.


        :param sql_firewall_policy_id: The sql_firewall_policy_id of this SqlFirewallAllowedSqlDimensions.
        :type: str
        """
        self._sql_firewall_policy_id = sql_firewall_policy_id

    @property
    def sql_level(self):
        """
        Gets the sql_level of this SqlFirewallAllowedSqlDimensions.
        Specifies the level of SQL included for this SQL Firewall policy.
        USER_ISSUED_SQL - User issued SQL statements only.
        ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.

        Allowed values for this property are: "USER_ISSUED_SQL", "ALL_SQL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The sql_level of this SqlFirewallAllowedSqlDimensions.
        :rtype: str
        """
        return self._sql_level

    @sql_level.setter
    def sql_level(self, sql_level):
        """
        Sets the sql_level of this SqlFirewallAllowedSqlDimensions.
        Specifies the level of SQL included for this SQL Firewall policy.
        USER_ISSUED_SQL - User issued SQL statements only.
        ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.


        :param sql_level: The sql_level of this SqlFirewallAllowedSqlDimensions.
        :type: str
        """
        allowed_values = ["USER_ISSUED_SQL", "ALL_SQL"]
        if not value_allowed_none_or_none_sentinel(sql_level, allowed_values):
            sql_level = 'UNKNOWN_ENUM_VALUE'
        self._sql_level = sql_level

    @property
    def db_user_name(self):
        """
        Gets the db_user_name of this SqlFirewallAllowedSqlDimensions.
        The database user name.


        :return: The db_user_name of this SqlFirewallAllowedSqlDimensions.
        :rtype: str
        """
        return self._db_user_name

    @db_user_name.setter
    def db_user_name(self, db_user_name):
        """
        Sets the db_user_name of this SqlFirewallAllowedSqlDimensions.
        The database user name.


        :param db_user_name: The db_user_name of this SqlFirewallAllowedSqlDimensions.
        :type: str
        """
        self._db_user_name = db_user_name

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this SqlFirewallAllowedSqlDimensions.
        The current state of the SQL Firewall allowed SQL.

        Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this SqlFirewallAllowedSqlDimensions.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SqlFirewallAllowedSqlDimensions.
        The current state of the SQL Firewall allowed SQL.


        :param lifecycle_state: The lifecycle_state of this SqlFirewallAllowedSqlDimensions.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
