# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221208


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CccInfrastructure(object):
    """
    The Oracle Cloud Infrastructure resource representing the connection to the hardware and
    software located in a customer's data center running the Compute Cloud@Customer IaaS services.
    """

    #: A constant which can be used with the connection_state property of a CccInfrastructure.
    #: This constant has a value of "REJECT"
    CONNECTION_STATE_REJECT = "REJECT"

    #: A constant which can be used with the connection_state property of a CccInfrastructure.
    #: This constant has a value of "REQUEST"
    CONNECTION_STATE_REQUEST = "REQUEST"

    #: A constant which can be used with the connection_state property of a CccInfrastructure.
    #: This constant has a value of "READY"
    CONNECTION_STATE_READY = "READY"

    #: A constant which can be used with the connection_state property of a CccInfrastructure.
    #: This constant has a value of "CONNECTED"
    CONNECTION_STATE_CONNECTED = "CONNECTED"

    #: A constant which can be used with the connection_state property of a CccInfrastructure.
    #: This constant has a value of "DISCONNECTED"
    CONNECTION_STATE_DISCONNECTED = "DISCONNECTED"

    #: A constant which can be used with the lifecycle_state property of a CccInfrastructure.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a CccInfrastructure.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a CccInfrastructure.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a CccInfrastructure.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new CccInfrastructure object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CccInfrastructure.
        :type id: str

        :param short_name:
            The value to assign to the short_name property of this CccInfrastructure.
        :type short_name: str

        :param display_name:
            The value to assign to the display_name property of this CccInfrastructure.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CccInfrastructure.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CccInfrastructure.
        :type compartment_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CccInfrastructure.
        :type subnet_id: str

        :param connection_state:
            The value to assign to the connection_state property of this CccInfrastructure.
            Allowed values for this property are: "REJECT", "REQUEST", "READY", "CONNECTED", "DISCONNECTED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type connection_state: str

        :param connection_details:
            The value to assign to the connection_details property of this CccInfrastructure.
        :type connection_details: str

        :param ccc_upgrade_schedule_id:
            The value to assign to the ccc_upgrade_schedule_id property of this CccInfrastructure.
        :type ccc_upgrade_schedule_id: str

        :param provisioning_fingerprint:
            The value to assign to the provisioning_fingerprint property of this CccInfrastructure.
        :type provisioning_fingerprint: str

        :param provisioning_pin:
            The value to assign to the provisioning_pin property of this CccInfrastructure.
        :type provisioning_pin: str

        :param time_created:
            The value to assign to the time_created property of this CccInfrastructure.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CccInfrastructure.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CccInfrastructure.
            Allowed values for this property are: "ACTIVE", "NEEDS_ATTENTION", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this CccInfrastructure.
        :type lifecycle_details: str

        :param infrastructure_inventory:
            The value to assign to the infrastructure_inventory property of this CccInfrastructure.
        :type infrastructure_inventory: oci.compute_cloud_at_customer.models.CccInfrastructureInventory

        :param infrastructure_network_configuration:
            The value to assign to the infrastructure_network_configuration property of this CccInfrastructure.
        :type infrastructure_network_configuration: oci.compute_cloud_at_customer.models.CccInfrastructureNetworkConfiguration

        :param upgrade_information:
            The value to assign to the upgrade_information property of this CccInfrastructure.
        :type upgrade_information: oci.compute_cloud_at_customer.models.CccUpgradeInformation

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CccInfrastructure.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CccInfrastructure.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this CccInfrastructure.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'short_name': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'subnet_id': 'str',
            'connection_state': 'str',
            'connection_details': 'str',
            'ccc_upgrade_schedule_id': 'str',
            'provisioning_fingerprint': 'str',
            'provisioning_pin': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'infrastructure_inventory': 'CccInfrastructureInventory',
            'infrastructure_network_configuration': 'CccInfrastructureNetworkConfiguration',
            'upgrade_information': 'CccUpgradeInformation',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'short_name': 'shortName',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'subnet_id': 'subnetId',
            'connection_state': 'connectionState',
            'connection_details': 'connectionDetails',
            'ccc_upgrade_schedule_id': 'cccUpgradeScheduleId',
            'provisioning_fingerprint': 'provisioningFingerprint',
            'provisioning_pin': 'provisioningPin',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'infrastructure_inventory': 'infrastructureInventory',
            'infrastructure_network_configuration': 'infrastructureNetworkConfiguration',
            'upgrade_information': 'upgradeInformation',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._short_name = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._subnet_id = None
        self._connection_state = None
        self._connection_details = None
        self._ccc_upgrade_schedule_id = None
        self._provisioning_fingerprint = None
        self._provisioning_pin = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._infrastructure_inventory = None
        self._infrastructure_network_configuration = None
        self._upgrade_information = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CccInfrastructure.
        The Compute Cloud@Customer infrastructure `OCID`__.
        This cannot be changed once created.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this CccInfrastructure.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CccInfrastructure.
        The Compute Cloud@Customer infrastructure `OCID`__.
        This cannot be changed once created.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this CccInfrastructure.
        :type: str
        """
        self._id = id

    @property
    def short_name(self):
        """
        Gets the short_name of this CccInfrastructure.
        The Compute Cloud@Customer infrastructure short name.
        This cannot be changed once created. The
        short name is used to refer to the infrastructure in several contexts and is unique.


        :return: The short_name of this CccInfrastructure.
        :rtype: str
        """
        return self._short_name

    @short_name.setter
    def short_name(self, short_name):
        """
        Sets the short_name of this CccInfrastructure.
        The Compute Cloud@Customer infrastructure short name.
        This cannot be changed once created. The
        short name is used to refer to the infrastructure in several contexts and is unique.


        :param short_name: The short_name of this CccInfrastructure.
        :type: str
        """
        self._short_name = short_name

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CccInfrastructure.
        The name that will be used to display the Compute Cloud@Customer infrastructure
        in the Oracle Cloud Infrastructure console. Does not have to be unique and can be changed.
        Avoid entering confidential information.


        :return: The display_name of this CccInfrastructure.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CccInfrastructure.
        The name that will be used to display the Compute Cloud@Customer infrastructure
        in the Oracle Cloud Infrastructure console. Does not have to be unique and can be changed.
        Avoid entering confidential information.


        :param display_name: The display_name of this CccInfrastructure.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CccInfrastructure.
        A mutable client-meaningful text description of the Compute Cloud@Customer infrastructure.
        Avoid entering confidential information.


        :return: The description of this CccInfrastructure.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CccInfrastructure.
        A mutable client-meaningful text description of the Compute Cloud@Customer infrastructure.
        Avoid entering confidential information.


        :param description: The description of this CccInfrastructure.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CccInfrastructure.
        The infrastructure compartment `OCID`__.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CccInfrastructure.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CccInfrastructure.
        The infrastructure compartment `OCID`__.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CccInfrastructure.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CccInfrastructure.
        `OCID`__ for the network subnet that is
        used to communicate with Compute Cloud@Customer infrastructure.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this CccInfrastructure.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CccInfrastructure.
        `OCID`__ for the network subnet that is
        used to communicate with Compute Cloud@Customer infrastructure.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this CccInfrastructure.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def connection_state(self):
        """
        Gets the connection_state of this CccInfrastructure.
        The current connection state of the infrastructure. A user can only update
        it from REQUEST to READY or from any state back to REJECT. The system automatically
        handles the REJECT to REQUEST, READY to CONNECTED, or CONNECTED to DISCONNECTED transitions.

        Allowed values for this property are: "REJECT", "REQUEST", "READY", "CONNECTED", "DISCONNECTED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The connection_state of this CccInfrastructure.
        :rtype: str
        """
        return self._connection_state

    @connection_state.setter
    def connection_state(self, connection_state):
        """
        Sets the connection_state of this CccInfrastructure.
        The current connection state of the infrastructure. A user can only update
        it from REQUEST to READY or from any state back to REJECT. The system automatically
        handles the REJECT to REQUEST, READY to CONNECTED, or CONNECTED to DISCONNECTED transitions.


        :param connection_state: The connection_state of this CccInfrastructure.
        :type: str
        """
        allowed_values = ["REJECT", "REQUEST", "READY", "CONNECTED", "DISCONNECTED"]
        if not value_allowed_none_or_none_sentinel(connection_state, allowed_values):
            connection_state = 'UNKNOWN_ENUM_VALUE'
        self._connection_state = connection_state

    @property
    def connection_details(self):
        """
        Gets the connection_details of this CccInfrastructure.
        A message describing the current connection state in more detail.


        :return: The connection_details of this CccInfrastructure.
        :rtype: str
        """
        return self._connection_details

    @connection_details.setter
    def connection_details(self, connection_details):
        """
        Sets the connection_details of this CccInfrastructure.
        A message describing the current connection state in more detail.


        :param connection_details: The connection_details of this CccInfrastructure.
        :type: str
        """
        self._connection_details = connection_details

    @property
    def ccc_upgrade_schedule_id(self):
        """
        Gets the ccc_upgrade_schedule_id of this CccInfrastructure.
        Schedule used for upgrades. If no schedule is associated with the infrastructure,
        it can be updated at any time.


        :return: The ccc_upgrade_schedule_id of this CccInfrastructure.
        :rtype: str
        """
        return self._ccc_upgrade_schedule_id

    @ccc_upgrade_schedule_id.setter
    def ccc_upgrade_schedule_id(self, ccc_upgrade_schedule_id):
        """
        Sets the ccc_upgrade_schedule_id of this CccInfrastructure.
        Schedule used for upgrades. If no schedule is associated with the infrastructure,
        it can be updated at any time.


        :param ccc_upgrade_schedule_id: The ccc_upgrade_schedule_id of this CccInfrastructure.
        :type: str
        """
        self._ccc_upgrade_schedule_id = ccc_upgrade_schedule_id

    @property
    def provisioning_fingerprint(self):
        """
        Gets the provisioning_fingerprint of this CccInfrastructure.
        Fingerprint of a Compute Cloud@Customer infrastructure in a data center generated
        during the initial connection to this resource. The fingerprint should be verified
        by the administrator when changing the connectionState from REQUEST to READY.


        :return: The provisioning_fingerprint of this CccInfrastructure.
        :rtype: str
        """
        return self._provisioning_fingerprint

    @provisioning_fingerprint.setter
    def provisioning_fingerprint(self, provisioning_fingerprint):
        """
        Sets the provisioning_fingerprint of this CccInfrastructure.
        Fingerprint of a Compute Cloud@Customer infrastructure in a data center generated
        during the initial connection to this resource. The fingerprint should be verified
        by the administrator when changing the connectionState from REQUEST to READY.


        :param provisioning_fingerprint: The provisioning_fingerprint of this CccInfrastructure.
        :type: str
        """
        self._provisioning_fingerprint = provisioning_fingerprint

    @property
    def provisioning_pin(self):
        """
        Gets the provisioning_pin of this CccInfrastructure.
        Code that is required for service personnel to connect a
        Compute Cloud@Customer infrastructure in a data center to this resource.
        This code will only be available when the connectionState is REJECT (usually
        at create time of the Compute Cloud@Customer infrastructure).


        :return: The provisioning_pin of this CccInfrastructure.
        :rtype: str
        """
        return self._provisioning_pin

    @provisioning_pin.setter
    def provisioning_pin(self, provisioning_pin):
        """
        Sets the provisioning_pin of this CccInfrastructure.
        Code that is required for service personnel to connect a
        Compute Cloud@Customer infrastructure in a data center to this resource.
        This code will only be available when the connectionState is REJECT (usually
        at create time of the Compute Cloud@Customer infrastructure).


        :param provisioning_pin: The provisioning_pin of this CccInfrastructure.
        :type: str
        """
        self._provisioning_pin = provisioning_pin

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CccInfrastructure.
        Compute Cloud@Customer infrastructure creation date and time, using an RFC3339 formatted
        datetime string.


        :return: The time_created of this CccInfrastructure.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CccInfrastructure.
        Compute Cloud@Customer infrastructure creation date and time, using an RFC3339 formatted
        datetime string.


        :param time_created: The time_created of this CccInfrastructure.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this CccInfrastructure.
        Compute Cloud@Customer infrastructure updated date and time, using an RFC3339 formatted
        datetime string.


        :return: The time_updated of this CccInfrastructure.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this CccInfrastructure.
        Compute Cloud@Customer infrastructure updated date and time, using an RFC3339 formatted
        datetime string.


        :param time_updated: The time_updated of this CccInfrastructure.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this CccInfrastructure.
        The current state of the Compute Cloud@Customer infrastructure.

        Allowed values for this property are: "ACTIVE", "NEEDS_ATTENTION", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this CccInfrastructure.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this CccInfrastructure.
        The current state of the Compute Cloud@Customer infrastructure.


        :param lifecycle_state: The lifecycle_state of this CccInfrastructure.
        :type: str
        """
        allowed_values = ["ACTIVE", "NEEDS_ATTENTION", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this CccInfrastructure.
        A message describing the current lifecycle state in more detail.
        For example, this can be used to provide actionable information for a resource that is in
        a Failed state.


        :return: The lifecycle_details of this CccInfrastructure.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this CccInfrastructure.
        A message describing the current lifecycle state in more detail.
        For example, this can be used to provide actionable information for a resource that is in
        a Failed state.


        :param lifecycle_details: The lifecycle_details of this CccInfrastructure.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def infrastructure_inventory(self):
        """
        Gets the infrastructure_inventory of this CccInfrastructure.

        :return: The infrastructure_inventory of this CccInfrastructure.
        :rtype: oci.compute_cloud_at_customer.models.CccInfrastructureInventory
        """
        return self._infrastructure_inventory

    @infrastructure_inventory.setter
    def infrastructure_inventory(self, infrastructure_inventory):
        """
        Sets the infrastructure_inventory of this CccInfrastructure.

        :param infrastructure_inventory: The infrastructure_inventory of this CccInfrastructure.
        :type: oci.compute_cloud_at_customer.models.CccInfrastructureInventory
        """
        self._infrastructure_inventory = infrastructure_inventory

    @property
    def infrastructure_network_configuration(self):
        """
        Gets the infrastructure_network_configuration of this CccInfrastructure.

        :return: The infrastructure_network_configuration of this CccInfrastructure.
        :rtype: oci.compute_cloud_at_customer.models.CccInfrastructureNetworkConfiguration
        """
        return self._infrastructure_network_configuration

    @infrastructure_network_configuration.setter
    def infrastructure_network_configuration(self, infrastructure_network_configuration):
        """
        Sets the infrastructure_network_configuration of this CccInfrastructure.

        :param infrastructure_network_configuration: The infrastructure_network_configuration of this CccInfrastructure.
        :type: oci.compute_cloud_at_customer.models.CccInfrastructureNetworkConfiguration
        """
        self._infrastructure_network_configuration = infrastructure_network_configuration

    @property
    def upgrade_information(self):
        """
        Gets the upgrade_information of this CccInfrastructure.

        :return: The upgrade_information of this CccInfrastructure.
        :rtype: oci.compute_cloud_at_customer.models.CccUpgradeInformation
        """
        return self._upgrade_information

    @upgrade_information.setter
    def upgrade_information(self, upgrade_information):
        """
        Sets the upgrade_information of this CccInfrastructure.

        :param upgrade_information: The upgrade_information of this CccInfrastructure.
        :type: oci.compute_cloud_at_customer.models.CccUpgradeInformation
        """
        self._upgrade_information = upgrade_information

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CccInfrastructure.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CccInfrastructure.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CccInfrastructure.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CccInfrastructure.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CccInfrastructure.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CccInfrastructure.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CccInfrastructure.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CccInfrastructure.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CccInfrastructure.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this CccInfrastructure.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CccInfrastructure.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this CccInfrastructure.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
