# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WorkerSummary(object):
    """
    Information about On-premise VP worker.
    """

    #: A constant which can be used with the worker_type property of a WorkerSummary.
    #: This constant has a value of "DOCKER"
    WORKER_TYPE_DOCKER = "DOCKER"

    #: A constant which can be used with the status property of a WorkerSummary.
    #: This constant has a value of "ENABLED"
    STATUS_ENABLED = "ENABLED"

    #: A constant which can be used with the status property of a WorkerSummary.
    #: This constant has a value of "DISABLED"
    STATUS_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new WorkerSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this WorkerSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this WorkerSummary.
        :type display_name: str

        :param name:
            The value to assign to the name property of this WorkerSummary.
        :type name: str

        :param version_details:
            The value to assign to the version_details property of this WorkerSummary.
        :type version_details: oci.apm_synthetics.models.OnPremiseVpWorkerVersionDetails

        :param configuration_details:
            The value to assign to the configuration_details property of this WorkerSummary.
        :type configuration_details: object

        :param worker_type:
            The value to assign to the worker_type property of this WorkerSummary.
            Allowed values for this property are: "DOCKER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type worker_type: str

        :param status:
            The value to assign to the status property of this WorkerSummary.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param priority:
            The value to assign to the priority property of this WorkerSummary.
        :type priority: int

        :param geo_info:
            The value to assign to the geo_info property of this WorkerSummary.
        :type geo_info: str

        :param monitor_list:
            The value to assign to the monitor_list property of this WorkerSummary.
        :type monitor_list: list[oci.apm_synthetics.models.WorkerMonitorList]

        :param time_last_syncup:
            The value to assign to the time_last_syncup property of this WorkerSummary.
        :type time_last_syncup: datetime

        :param time_created:
            The value to assign to the time_created property of this WorkerSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this WorkerSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this WorkerSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this WorkerSummary.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'name': 'str',
            'version_details': 'OnPremiseVpWorkerVersionDetails',
            'configuration_details': 'object',
            'worker_type': 'str',
            'status': 'str',
            'priority': 'int',
            'geo_info': 'str',
            'monitor_list': 'list[WorkerMonitorList]',
            'time_last_syncup': 'datetime',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'name': 'name',
            'version_details': 'versionDetails',
            'configuration_details': 'configurationDetails',
            'worker_type': 'workerType',
            'status': 'status',
            'priority': 'priority',
            'geo_info': 'geoInfo',
            'monitor_list': 'monitorList',
            'time_last_syncup': 'timeLastSyncup',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._display_name = None
        self._name = None
        self._version_details = None
        self._configuration_details = None
        self._worker_type = None
        self._status = None
        self._priority = None
        self._geo_info = None
        self._monitor_list = None
        self._time_last_syncup = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this WorkerSummary.
        The `OCID`__ of the On-premise VP worker.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this WorkerSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WorkerSummary.
        The `OCID`__ of the On-premise VP worker.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this WorkerSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this WorkerSummary.
        Unique On-premise VP worker name that cannot be edited. The name should not contain any confidential information.


        :return: The display_name of this WorkerSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this WorkerSummary.
        Unique On-premise VP worker name that cannot be edited. The name should not contain any confidential information.


        :param display_name: The display_name of this WorkerSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def name(self):
        """
        **[Required]** Gets the name of this WorkerSummary.
        Unique permanent name of the On-premise VP worker. This is the same as the displayName.


        :return: The name of this WorkerSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this WorkerSummary.
        Unique permanent name of the On-premise VP worker. This is the same as the displayName.


        :param name: The name of this WorkerSummary.
        :type: str
        """
        self._name = name

    @property
    def version_details(self):
        """
        **[Required]** Gets the version_details of this WorkerSummary.

        :return: The version_details of this WorkerSummary.
        :rtype: oci.apm_synthetics.models.OnPremiseVpWorkerVersionDetails
        """
        return self._version_details

    @version_details.setter
    def version_details(self, version_details):
        """
        Sets the version_details of this WorkerSummary.

        :param version_details: The version_details of this WorkerSummary.
        :type: oci.apm_synthetics.models.OnPremiseVpWorkerVersionDetails
        """
        self._version_details = version_details

    @property
    def configuration_details(self):
        """
        Gets the configuration_details of this WorkerSummary.
        Configuration details of the On-premise VP worker.


        :return: The configuration_details of this WorkerSummary.
        :rtype: object
        """
        return self._configuration_details

    @configuration_details.setter
    def configuration_details(self, configuration_details):
        """
        Sets the configuration_details of this WorkerSummary.
        Configuration details of the On-premise VP worker.


        :param configuration_details: The configuration_details of this WorkerSummary.
        :type: object
        """
        self._configuration_details = configuration_details

    @property
    def worker_type(self):
        """
        **[Required]** Gets the worker_type of this WorkerSummary.
        Type of the On-premise VP worker.

        Allowed values for this property are: "DOCKER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The worker_type of this WorkerSummary.
        :rtype: str
        """
        return self._worker_type

    @worker_type.setter
    def worker_type(self, worker_type):
        """
        Sets the worker_type of this WorkerSummary.
        Type of the On-premise VP worker.


        :param worker_type: The worker_type of this WorkerSummary.
        :type: str
        """
        allowed_values = ["DOCKER"]
        if not value_allowed_none_or_none_sentinel(worker_type, allowed_values):
            worker_type = 'UNKNOWN_ENUM_VALUE'
        self._worker_type = worker_type

    @property
    def status(self):
        """
        **[Required]** Gets the status of this WorkerSummary.
        Enables or disables the On-premise VP worker.

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this WorkerSummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this WorkerSummary.
        Enables or disables the On-premise VP worker.


        :param status: The status of this WorkerSummary.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def priority(self):
        """
        **[Required]** Gets the priority of this WorkerSummary.
        Priority of the On-premise VP worker to schedule monitors.


        :return: The priority of this WorkerSummary.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """
        Sets the priority of this WorkerSummary.
        Priority of the On-premise VP worker to schedule monitors.


        :param priority: The priority of this WorkerSummary.
        :type: int
        """
        self._priority = priority

    @property
    def geo_info(self):
        """
        Gets the geo_info of this WorkerSummary.
        Geographical information of the On-premise VP worker.


        :return: The geo_info of this WorkerSummary.
        :rtype: str
        """
        return self._geo_info

    @geo_info.setter
    def geo_info(self, geo_info):
        """
        Sets the geo_info of this WorkerSummary.
        Geographical information of the On-premise VP worker.


        :param geo_info: The geo_info of this WorkerSummary.
        :type: str
        """
        self._geo_info = geo_info

    @property
    def monitor_list(self):
        """
        Gets the monitor_list of this WorkerSummary.
        Monitors list assigned to the On-premise VP worker.


        :return: The monitor_list of this WorkerSummary.
        :rtype: list[oci.apm_synthetics.models.WorkerMonitorList]
        """
        return self._monitor_list

    @monitor_list.setter
    def monitor_list(self, monitor_list):
        """
        Sets the monitor_list of this WorkerSummary.
        Monitors list assigned to the On-premise VP worker.


        :param monitor_list: The monitor_list of this WorkerSummary.
        :type: list[oci.apm_synthetics.models.WorkerMonitorList]
        """
        self._monitor_list = monitor_list

    @property
    def time_last_syncup(self):
        """
        Gets the time_last_syncup of this WorkerSummary.
        The time the resource was last synced, expressed in `RFC 3339`__
        timestamp format.
        Example: `2020-02-12T22:47:12.613Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_last_syncup of this WorkerSummary.
        :rtype: datetime
        """
        return self._time_last_syncup

    @time_last_syncup.setter
    def time_last_syncup(self, time_last_syncup):
        """
        Sets the time_last_syncup of this WorkerSummary.
        The time the resource was last synced, expressed in `RFC 3339`__
        timestamp format.
        Example: `2020-02-12T22:47:12.613Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_last_syncup: The time_last_syncup of this WorkerSummary.
        :type: datetime
        """
        self._time_last_syncup = time_last_syncup

    @property
    def time_created(self):
        """
        Gets the time_created of this WorkerSummary.
        The time the resource was created, expressed in `RFC 3339`__
        timestamp format.
        Example: `2020-02-12T22:47:12.613Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this WorkerSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this WorkerSummary.
        The time the resource was created, expressed in `RFC 3339`__
        timestamp format.
        Example: `2020-02-12T22:47:12.613Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this WorkerSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this WorkerSummary.
        The time the resource was updated, expressed in `RFC 3339`__
        timestamp format.
        Example: `2020-02-13T22:47:12.613Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this WorkerSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this WorkerSummary.
        The time the resource was updated, expressed in `RFC 3339`__
        timestamp format.
        Example: `2020-02-13T22:47:12.613Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this WorkerSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this WorkerSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this WorkerSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this WorkerSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this WorkerSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this WorkerSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this WorkerSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this WorkerSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this WorkerSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
