# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201

from .test_output import TestOutput
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TestSpanEnrichmentOutput(TestOutput):
    """
    Output of running a set of span enrichment rules against a span.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TestSpanEnrichmentOutput object with values from keyword arguments. The default value of the :py:attr:`~oci.apm_config.models.TestSpanEnrichmentOutput.test_type` attribute
        of this class is ``SPAN_ENRICHMENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param test_type:
            The value to assign to the test_type property of this TestSpanEnrichmentOutput.
            Allowed values for this property are: "SPAN_ENRICHMENT"
        :type test_type: str

        :param span:
            The value to assign to the span property of this TestSpanEnrichmentOutput.
        :type span: object

        :param filters:
            The value to assign to the filters property of this TestSpanEnrichmentOutput.
        :type filters: list[bool]

        """
        self.swagger_types = {
            'test_type': 'str',
            'span': 'object',
            'filters': 'list[bool]'
        }

        self.attribute_map = {
            'test_type': 'testType',
            'span': 'span',
            'filters': 'filters'
        }

        self._test_type = None
        self._span = None
        self._filters = None
        self._test_type = 'SPAN_ENRICHMENT'

    @property
    def span(self):
        """
        Gets the span of this TestSpanEnrichmentOutput.
        The span after applying enrichment rules.


        :return: The span of this TestSpanEnrichmentOutput.
        :rtype: object
        """
        return self._span

    @span.setter
    def span(self, span):
        """
        Sets the span of this TestSpanEnrichmentOutput.
        The span after applying enrichment rules.


        :param span: The span of this TestSpanEnrichmentOutput.
        :type: object
        """
        self._span = span

    @property
    def filters(self):
        """
        Gets the filters of this TestSpanEnrichmentOutput.
        A list of booleans indicating whether the corresponding filter in the input matched the input span.


        :return: The filters of this TestSpanEnrichmentOutput.
        :rtype: list[bool]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """
        Sets the filters of this TestSpanEnrichmentOutput.
        A list of booleans indicating whether the corresponding filter in the input matched the input span.


        :param filters: The filters of this TestSpanEnrichmentOutput.
        :type: list[bool]
        """
        self._filters = filters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
