# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221109


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AnalyzeDocumentDetails(object):
    """
    The details of how to analyze a document.
    """

    #: A constant which can be used with the document_type property of a AnalyzeDocumentDetails.
    #: This constant has a value of "INVOICE"
    DOCUMENT_TYPE_INVOICE = "INVOICE"

    #: A constant which can be used with the document_type property of a AnalyzeDocumentDetails.
    #: This constant has a value of "RECEIPT"
    DOCUMENT_TYPE_RECEIPT = "RECEIPT"

    #: A constant which can be used with the document_type property of a AnalyzeDocumentDetails.
    #: This constant has a value of "RESUME"
    DOCUMENT_TYPE_RESUME = "RESUME"

    #: A constant which can be used with the document_type property of a AnalyzeDocumentDetails.
    #: This constant has a value of "TAX_FORM"
    DOCUMENT_TYPE_TAX_FORM = "TAX_FORM"

    #: A constant which can be used with the document_type property of a AnalyzeDocumentDetails.
    #: This constant has a value of "DRIVER_LICENSE"
    DOCUMENT_TYPE_DRIVER_LICENSE = "DRIVER_LICENSE"

    #: A constant which can be used with the document_type property of a AnalyzeDocumentDetails.
    #: This constant has a value of "PASSPORT"
    DOCUMENT_TYPE_PASSPORT = "PASSPORT"

    #: A constant which can be used with the document_type property of a AnalyzeDocumentDetails.
    #: This constant has a value of "BANK_STATEMENT"
    DOCUMENT_TYPE_BANK_STATEMENT = "BANK_STATEMENT"

    #: A constant which can be used with the document_type property of a AnalyzeDocumentDetails.
    #: This constant has a value of "CHECK"
    DOCUMENT_TYPE_CHECK = "CHECK"

    #: A constant which can be used with the document_type property of a AnalyzeDocumentDetails.
    #: This constant has a value of "PAYSLIP"
    DOCUMENT_TYPE_PAYSLIP = "PAYSLIP"

    #: A constant which can be used with the document_type property of a AnalyzeDocumentDetails.
    #: This constant has a value of "OTHERS"
    DOCUMENT_TYPE_OTHERS = "OTHERS"

    #: A constant which can be used with the document_type property of a AnalyzeDocumentDetails.
    #: This constant has a value of "INSURANCE_CLAIM"
    DOCUMENT_TYPE_INSURANCE_CLAIM = "INSURANCE_CLAIM"

    def __init__(self, **kwargs):
        """
        Initializes a new AnalyzeDocumentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param features:
            The value to assign to the features property of this AnalyzeDocumentDetails.
        :type features: list[oci.ai_document.models.DocumentFeature]

        :param document:
            The value to assign to the document property of this AnalyzeDocumentDetails.
        :type document: oci.ai_document.models.DocumentDetails

        :param compartment_id:
            The value to assign to the compartment_id property of this AnalyzeDocumentDetails.
        :type compartment_id: str

        :param output_location:
            The value to assign to the output_location property of this AnalyzeDocumentDetails.
        :type output_location: oci.ai_document.models.OutputLocation

        :param language:
            The value to assign to the language property of this AnalyzeDocumentDetails.
        :type language: str

        :param document_type:
            The value to assign to the document_type property of this AnalyzeDocumentDetails.
            Allowed values for this property are: "INVOICE", "RECEIPT", "RESUME", "TAX_FORM", "DRIVER_LICENSE", "PASSPORT", "BANK_STATEMENT", "CHECK", "PAYSLIP", "OTHERS", "INSURANCE_CLAIM"
        :type document_type: str

        :param ocr_data:
            The value to assign to the ocr_data property of this AnalyzeDocumentDetails.
        :type ocr_data: oci.ai_document.models.AnalyzeDocumentResult

        """
        self.swagger_types = {
            'features': 'list[DocumentFeature]',
            'document': 'DocumentDetails',
            'compartment_id': 'str',
            'output_location': 'OutputLocation',
            'language': 'str',
            'document_type': 'str',
            'ocr_data': 'AnalyzeDocumentResult'
        }

        self.attribute_map = {
            'features': 'features',
            'document': 'document',
            'compartment_id': 'compartmentId',
            'output_location': 'outputLocation',
            'language': 'language',
            'document_type': 'documentType',
            'ocr_data': 'ocrData'
        }

        self._features = None
        self._document = None
        self._compartment_id = None
        self._output_location = None
        self._language = None
        self._document_type = None
        self._ocr_data = None

    @property
    def features(self):
        """
        **[Required]** Gets the features of this AnalyzeDocumentDetails.
        The types of document analysis requested.


        :return: The features of this AnalyzeDocumentDetails.
        :rtype: list[oci.ai_document.models.DocumentFeature]
        """
        return self._features

    @features.setter
    def features(self, features):
        """
        Sets the features of this AnalyzeDocumentDetails.
        The types of document analysis requested.


        :param features: The features of this AnalyzeDocumentDetails.
        :type: list[oci.ai_document.models.DocumentFeature]
        """
        self._features = features

    @property
    def document(self):
        """
        **[Required]** Gets the document of this AnalyzeDocumentDetails.

        :return: The document of this AnalyzeDocumentDetails.
        :rtype: oci.ai_document.models.DocumentDetails
        """
        return self._document

    @document.setter
    def document(self, document):
        """
        Sets the document of this AnalyzeDocumentDetails.

        :param document: The document of this AnalyzeDocumentDetails.
        :type: oci.ai_document.models.DocumentDetails
        """
        self._document = document

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this AnalyzeDocumentDetails.
        The compartment identifier.


        :return: The compartment_id of this AnalyzeDocumentDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AnalyzeDocumentDetails.
        The compartment identifier.


        :param compartment_id: The compartment_id of this AnalyzeDocumentDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def output_location(self):
        """
        Gets the output_location of this AnalyzeDocumentDetails.

        :return: The output_location of this AnalyzeDocumentDetails.
        :rtype: oci.ai_document.models.OutputLocation
        """
        return self._output_location

    @output_location.setter
    def output_location(self, output_location):
        """
        Sets the output_location of this AnalyzeDocumentDetails.

        :param output_location: The output_location of this AnalyzeDocumentDetails.
        :type: oci.ai_document.models.OutputLocation
        """
        self._output_location = output_location

    @property
    def language(self):
        """
        Gets the language of this AnalyzeDocumentDetails.
        The document language, abbreviated according to the BCP 47 syntax.


        :return: The language of this AnalyzeDocumentDetails.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """
        Sets the language of this AnalyzeDocumentDetails.
        The document language, abbreviated according to the BCP 47 syntax.


        :param language: The language of this AnalyzeDocumentDetails.
        :type: str
        """
        self._language = language

    @property
    def document_type(self):
        """
        Gets the document_type of this AnalyzeDocumentDetails.
        The document type.

        Allowed values for this property are: "INVOICE", "RECEIPT", "RESUME", "TAX_FORM", "DRIVER_LICENSE", "PASSPORT", "BANK_STATEMENT", "CHECK", "PAYSLIP", "OTHERS", "INSURANCE_CLAIM"


        :return: The document_type of this AnalyzeDocumentDetails.
        :rtype: str
        """
        return self._document_type

    @document_type.setter
    def document_type(self, document_type):
        """
        Sets the document_type of this AnalyzeDocumentDetails.
        The document type.


        :param document_type: The document_type of this AnalyzeDocumentDetails.
        :type: str
        """
        allowed_values = ["INVOICE", "RECEIPT", "RESUME", "TAX_FORM", "DRIVER_LICENSE", "PASSPORT", "BANK_STATEMENT", "CHECK", "PAYSLIP", "OTHERS", "INSURANCE_CLAIM"]
        if not value_allowed_none_or_none_sentinel(document_type, allowed_values):
            raise ValueError(
                f"Invalid value for `document_type`, must be None or one of {allowed_values}"
            )
        self._document_type = document_type

    @property
    def ocr_data(self):
        """
        Gets the ocr_data of this AnalyzeDocumentDetails.

        :return: The ocr_data of this AnalyzeDocumentDetails.
        :rtype: oci.ai_document.models.AnalyzeDocumentResult
        """
        return self._ocr_data

    @ocr_data.setter
    def ocr_data(self, ocr_data):
        """
        Sets the ocr_data of this AnalyzeDocumentDetails.

        :param ocr_data: The ocr_data of this AnalyzeDocumentDetails.
        :type: oci.ai_document.models.AnalyzeDocumentResult
        """
        self._ocr_data = ocr_data

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
