# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Vulnerability(object):
    """
    A vulnerability is a weakness or error in an artifact.
    A vulnerability is a generalization of a CVE (every CVE is a vulnerability, but not every vulnerability has a CVE).
    """

    #: A constant which can be used with the severity property of a Vulnerability.
    #: This constant has a value of "NONE"
    SEVERITY_NONE = "NONE"

    #: A constant which can be used with the severity property of a Vulnerability.
    #: This constant has a value of "LOW"
    SEVERITY_LOW = "LOW"

    #: A constant which can be used with the severity property of a Vulnerability.
    #: This constant has a value of "MEDIUM"
    SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the severity property of a Vulnerability.
    #: This constant has a value of "HIGH"
    SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the severity property of a Vulnerability.
    #: This constant has a value of "CRITICAL"
    SEVERITY_CRITICAL = "CRITICAL"

    def __init__(self, **kwargs):
        """
        Initializes a new Vulnerability object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Vulnerability.
        :type id: str

        :param source:
            The value to assign to the source property of this Vulnerability.
        :type source: str

        :param cvss_v2_score:
            The value to assign to the cvss_v2_score property of this Vulnerability.
        :type cvss_v2_score: float

        :param cvss_v3_score:
            The value to assign to the cvss_v3_score property of this Vulnerability.
        :type cvss_v3_score: float

        :param severity:
            The value to assign to the severity property of this Vulnerability.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        :param is_ignored:
            The value to assign to the is_ignored property of this Vulnerability.
        :type is_ignored: bool

        :param is_false_positive:
            The value to assign to the is_false_positive property of this Vulnerability.
        :type is_false_positive: bool

        """
        self.swagger_types = {
            'id': 'str',
            'source': 'str',
            'cvss_v2_score': 'float',
            'cvss_v3_score': 'float',
            'severity': 'str',
            'is_ignored': 'bool',
            'is_false_positive': 'bool'
        }

        self.attribute_map = {
            'id': 'id',
            'source': 'source',
            'cvss_v2_score': 'cvssV2Score',
            'cvss_v3_score': 'cvssV3Score',
            'severity': 'severity',
            'is_ignored': 'isIgnored',
            'is_false_positive': 'isFalsePositive'
        }

        self._id = None
        self._source = None
        self._cvss_v2_score = None
        self._cvss_v3_score = None
        self._severity = None
        self._is_ignored = None
        self._is_false_positive = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Vulnerability.
        Unique vulnerability identifier, e.g. CVE-1999-0067.


        :return: The id of this Vulnerability.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Vulnerability.
        Unique vulnerability identifier, e.g. CVE-1999-0067.


        :param id: The id of this Vulnerability.
        :type: str
        """
        self._id = id

    @property
    def source(self):
        """
        Gets the source of this Vulnerability.
        Source that published the vulnerability


        :return: The source of this Vulnerability.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this Vulnerability.
        Source that published the vulnerability


        :param source: The source of this Vulnerability.
        :type: str
        """
        self._source = source

    @property
    def cvss_v2_score(self):
        """
        Gets the cvss_v2_score of this Vulnerability.
        Common Vulnerability Scoring System (CVSS) Version 2.


        :return: The cvss_v2_score of this Vulnerability.
        :rtype: float
        """
        return self._cvss_v2_score

    @cvss_v2_score.setter
    def cvss_v2_score(self, cvss_v2_score):
        """
        Sets the cvss_v2_score of this Vulnerability.
        Common Vulnerability Scoring System (CVSS) Version 2.


        :param cvss_v2_score: The cvss_v2_score of this Vulnerability.
        :type: float
        """
        self._cvss_v2_score = cvss_v2_score

    @property
    def cvss_v3_score(self):
        """
        Gets the cvss_v3_score of this Vulnerability.
        Common Vulnerability Scoring System (CVSS) Version 3.


        :return: The cvss_v3_score of this Vulnerability.
        :rtype: float
        """
        return self._cvss_v3_score

    @cvss_v3_score.setter
    def cvss_v3_score(self, cvss_v3_score):
        """
        Sets the cvss_v3_score of this Vulnerability.
        Common Vulnerability Scoring System (CVSS) Version 3.


        :param cvss_v3_score: The cvss_v3_score of this Vulnerability.
        :type: float
        """
        self._cvss_v3_score = cvss_v3_score

    @property
    def severity(self):
        """
        Gets the severity of this Vulnerability.
        ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this Vulnerability.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this Vulnerability.
        ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.


        :param severity: The severity of this Vulnerability.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    @property
    def is_ignored(self):
        """
        **[Required]** Gets the is_ignored of this Vulnerability.
        Indicates if the vulnerability was ignored according to the audit configuration.


        :return: The is_ignored of this Vulnerability.
        :rtype: bool
        """
        return self._is_ignored

    @is_ignored.setter
    def is_ignored(self, is_ignored):
        """
        Sets the is_ignored of this Vulnerability.
        Indicates if the vulnerability was ignored according to the audit configuration.


        :param is_ignored: The is_ignored of this Vulnerability.
        :type: bool
        """
        self._is_ignored = is_ignored

    @property
    def is_false_positive(self):
        """
        Gets the is_false_positive of this Vulnerability.
        Indicates if the vulnerability is a false positive according to the usage data. If no usage data was provided or the service cannot infer usage of the vulnerable code then this property is `null`.


        :return: The is_false_positive of this Vulnerability.
        :rtype: bool
        """
        return self._is_false_positive

    @is_false_positive.setter
    def is_false_positive(self, is_false_positive):
        """
        Sets the is_false_positive of this Vulnerability.
        Indicates if the vulnerability is a false positive according to the usage data. If no usage data was provided or the service cannot infer usage of the vulnerable code then this property is `null`.


        :param is_false_positive: The is_false_positive of this Vulnerability.
        :type: bool
        """
        self._is_false_positive = is_false_positive

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
