# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Metric(object):
    """
    Details of a metric which is part of this metric extension
    """

    #: A constant which can be used with the data_type property of a Metric.
    #: This constant has a value of "STRING"
    DATA_TYPE_STRING = "STRING"

    #: A constant which can be used with the data_type property of a Metric.
    #: This constant has a value of "NUMBER"
    DATA_TYPE_NUMBER = "NUMBER"

    #: A constant which can be used with the metric_category property of a Metric.
    #: This constant has a value of "LOAD"
    METRIC_CATEGORY_LOAD = "LOAD"

    #: A constant which can be used with the metric_category property of a Metric.
    #: This constant has a value of "UTILIZATION"
    METRIC_CATEGORY_UTILIZATION = "UTILIZATION"

    #: A constant which can be used with the metric_category property of a Metric.
    #: This constant has a value of "CAPACITY"
    METRIC_CATEGORY_CAPACITY = "CAPACITY"

    #: A constant which can be used with the metric_category property of a Metric.
    #: This constant has a value of "AVAILABILITY"
    METRIC_CATEGORY_AVAILABILITY = "AVAILABILITY"

    def __init__(self, **kwargs):
        """
        Initializes a new Metric object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this Metric.
        :type name: str

        :param display_name:
            The value to assign to the display_name property of this Metric.
        :type display_name: str

        :param is_dimension:
            The value to assign to the is_dimension property of this Metric.
        :type is_dimension: bool

        :param compute_expression:
            The value to assign to the compute_expression property of this Metric.
        :type compute_expression: str

        :param data_type:
            The value to assign to the data_type property of this Metric.
            Allowed values for this property are: "STRING", "NUMBER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type data_type: str

        :param is_hidden:
            The value to assign to the is_hidden property of this Metric.
        :type is_hidden: bool

        :param metric_category:
            The value to assign to the metric_category property of this Metric.
            Allowed values for this property are: "LOAD", "UTILIZATION", "CAPACITY", "AVAILABILITY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type metric_category: str

        :param unit:
            The value to assign to the unit property of this Metric.
        :type unit: str

        """
        self.swagger_types = {
            'name': 'str',
            'display_name': 'str',
            'is_dimension': 'bool',
            'compute_expression': 'str',
            'data_type': 'str',
            'is_hidden': 'bool',
            'metric_category': 'str',
            'unit': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'display_name': 'displayName',
            'is_dimension': 'isDimension',
            'compute_expression': 'computeExpression',
            'data_type': 'dataType',
            'is_hidden': 'isHidden',
            'metric_category': 'metricCategory',
            'unit': 'unit'
        }

        self._name = None
        self._display_name = None
        self._is_dimension = None
        self._compute_expression = None
        self._data_type = None
        self._is_hidden = None
        self._metric_category = None
        self._unit = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this Metric.
        Name of the metric.


        :return: The name of this Metric.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Metric.
        Name of the metric.


        :param name: The name of this Metric.
        :type: str
        """
        self._name = name

    @property
    def display_name(self):
        """
        Gets the display_name of this Metric.
        Display name of the metric.


        :return: The display_name of this Metric.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Metric.
        Display name of the metric.


        :param display_name: The display_name of this Metric.
        :type: str
        """
        self._display_name = display_name

    @property
    def is_dimension(self):
        """
        Gets the is_dimension of this Metric.
        Current metric need to be included as dimension or not


        :return: The is_dimension of this Metric.
        :rtype: bool
        """
        return self._is_dimension

    @is_dimension.setter
    def is_dimension(self, is_dimension):
        """
        Sets the is_dimension of this Metric.
        Current metric need to be included as dimension or not


        :param is_dimension: The is_dimension of this Metric.
        :type: bool
        """
        self._is_dimension = is_dimension

    @property
    def compute_expression(self):
        """
        Gets the compute_expression of this Metric.
        Compute Expression to calculate the value of this metric


        :return: The compute_expression of this Metric.
        :rtype: str
        """
        return self._compute_expression

    @compute_expression.setter
    def compute_expression(self, compute_expression):
        """
        Sets the compute_expression of this Metric.
        Compute Expression to calculate the value of this metric


        :param compute_expression: The compute_expression of this Metric.
        :type: str
        """
        self._compute_expression = compute_expression

    @property
    def data_type(self):
        """
        **[Required]** Gets the data_type of this Metric.
        Data type of value of this metric

        Allowed values for this property are: "STRING", "NUMBER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The data_type of this Metric.
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """
        Sets the data_type of this Metric.
        Data type of value of this metric


        :param data_type: The data_type of this Metric.
        :type: str
        """
        allowed_values = ["STRING", "NUMBER"]
        if not value_allowed_none_or_none_sentinel(data_type, allowed_values):
            data_type = 'UNKNOWN_ENUM_VALUE'
        self._data_type = data_type

    @property
    def is_hidden(self):
        """
        Gets the is_hidden of this Metric.
        Flag to marks whether a metric has to be uploaded or not. When isHidden = false -> Metric is uploaded, isHidden = true -> Metric is NOT uploaded


        :return: The is_hidden of this Metric.
        :rtype: bool
        """
        return self._is_hidden

    @is_hidden.setter
    def is_hidden(self, is_hidden):
        """
        Sets the is_hidden of this Metric.
        Flag to marks whether a metric has to be uploaded or not. When isHidden = false -> Metric is uploaded, isHidden = true -> Metric is NOT uploaded


        :param is_hidden: The is_hidden of this Metric.
        :type: bool
        """
        self._is_hidden = is_hidden

    @property
    def metric_category(self):
        """
        Gets the metric_category of this Metric.
        Metric category

        Allowed values for this property are: "LOAD", "UTILIZATION", "CAPACITY", "AVAILABILITY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The metric_category of this Metric.
        :rtype: str
        """
        return self._metric_category

    @metric_category.setter
    def metric_category(self, metric_category):
        """
        Sets the metric_category of this Metric.
        Metric category


        :param metric_category: The metric_category of this Metric.
        :type: str
        """
        allowed_values = ["LOAD", "UTILIZATION", "CAPACITY", "AVAILABILITY"]
        if not value_allowed_none_or_none_sentinel(metric_category, allowed_values):
            metric_category = 'UNKNOWN_ENUM_VALUE'
        self._metric_category = metric_category

    @property
    def unit(self):
        """
        Gets the unit of this Metric.
        Unit of metric value


        :return: The unit of this Metric.
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """
        Sets the unit of this Metric.
        Unit of metric value


        :param unit: The unit of this Metric.
        :type: str
        """
        self._unit = unit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
