# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330

from .monitored_resource_task_details import MonitoredResourceTaskDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImportOciTelemetryResourcesTaskDetails(MonitoredResourceTaskDetails):
    """
    Request details for importing resources from Telemetry like resources from OCI Native Services and prometheus.
    """

    #: A constant which can be used with the source property of a ImportOciTelemetryResourcesTaskDetails.
    #: This constant has a value of "OCI_TELEMETRY_NATIVE"
    SOURCE_OCI_TELEMETRY_NATIVE = "OCI_TELEMETRY_NATIVE"

    #: A constant which can be used with the source property of a ImportOciTelemetryResourcesTaskDetails.
    #: This constant has a value of "OCI_TELEMETRY_PROMETHEUS"
    SOURCE_OCI_TELEMETRY_PROMETHEUS = "OCI_TELEMETRY_PROMETHEUS"

    def __init__(self, **kwargs):
        """
        Initializes a new ImportOciTelemetryResourcesTaskDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.stack_monitoring.models.ImportOciTelemetryResourcesTaskDetails.type` attribute
        of this class is ``IMPORT_OCI_TELEMETRY_RESOURCES`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ImportOciTelemetryResourcesTaskDetails.
            Allowed values for this property are: "IMPORT_OCI_TELEMETRY_RESOURCES", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param source:
            The value to assign to the source property of this ImportOciTelemetryResourcesTaskDetails.
            Allowed values for this property are: "OCI_TELEMETRY_NATIVE", "OCI_TELEMETRY_PROMETHEUS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type source: str

        :param namespace:
            The value to assign to the namespace property of this ImportOciTelemetryResourcesTaskDetails.
        :type namespace: str

        :param resource_group:
            The value to assign to the resource_group property of this ImportOciTelemetryResourcesTaskDetails.
        :type resource_group: str

        :param availability_proxy_metrics:
            The value to assign to the availability_proxy_metrics property of this ImportOciTelemetryResourcesTaskDetails.
        :type availability_proxy_metrics: list[str]

        :param availability_proxy_metric_collection_interval:
            The value to assign to the availability_proxy_metric_collection_interval property of this ImportOciTelemetryResourcesTaskDetails.
        :type availability_proxy_metric_collection_interval: int

        """
        self.swagger_types = {
            'type': 'str',
            'source': 'str',
            'namespace': 'str',
            'resource_group': 'str',
            'availability_proxy_metrics': 'list[str]',
            'availability_proxy_metric_collection_interval': 'int'
        }

        self.attribute_map = {
            'type': 'type',
            'source': 'source',
            'namespace': 'namespace',
            'resource_group': 'resourceGroup',
            'availability_proxy_metrics': 'availabilityProxyMetrics',
            'availability_proxy_metric_collection_interval': 'availabilityProxyMetricCollectionInterval'
        }

        self._type = None
        self._source = None
        self._namespace = None
        self._resource_group = None
        self._availability_proxy_metrics = None
        self._availability_proxy_metric_collection_interval = None
        self._type = 'IMPORT_OCI_TELEMETRY_RESOURCES'

    @property
    def source(self):
        """
        **[Required]** Gets the source of this ImportOciTelemetryResourcesTaskDetails.
        Source from where the metrics pushed to telemetry.
        Possible values:
          * OCI_TELEMETRY_NATIVE      - The metrics are pushed to telemetry from OCI Native Services.
          * OCI_TELEMETRY_PROMETHEUS  - The metrics are pushed to telemetry from Prometheus.

        Allowed values for this property are: "OCI_TELEMETRY_NATIVE", "OCI_TELEMETRY_PROMETHEUS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The source of this ImportOciTelemetryResourcesTaskDetails.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this ImportOciTelemetryResourcesTaskDetails.
        Source from where the metrics pushed to telemetry.
        Possible values:
          * OCI_TELEMETRY_NATIVE      - The metrics are pushed to telemetry from OCI Native Services.
          * OCI_TELEMETRY_PROMETHEUS  - The metrics are pushed to telemetry from Prometheus.


        :param source: The source of this ImportOciTelemetryResourcesTaskDetails.
        :type: str
        """
        allowed_values = ["OCI_TELEMETRY_NATIVE", "OCI_TELEMETRY_PROMETHEUS"]
        if not value_allowed_none_or_none_sentinel(source, allowed_values):
            source = 'UNKNOWN_ENUM_VALUE'
        self._source = source

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this ImportOciTelemetryResourcesTaskDetails.
        Name space to be used for OCI Native service resources discovery.


        :return: The namespace of this ImportOciTelemetryResourcesTaskDetails.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this ImportOciTelemetryResourcesTaskDetails.
        Name space to be used for OCI Native service resources discovery.


        :param namespace: The namespace of this ImportOciTelemetryResourcesTaskDetails.
        :type: str
        """
        self._namespace = namespace

    @property
    def resource_group(self):
        """
        Gets the resource_group of this ImportOciTelemetryResourcesTaskDetails.
        The resource group to use while fetching metrics from telemetry.
        If not specified, resource group will be skipped in the list metrics request.


        :return: The resource_group of this ImportOciTelemetryResourcesTaskDetails.
        :rtype: str
        """
        return self._resource_group

    @resource_group.setter
    def resource_group(self, resource_group):
        """
        Sets the resource_group of this ImportOciTelemetryResourcesTaskDetails.
        The resource group to use while fetching metrics from telemetry.
        If not specified, resource group will be skipped in the list metrics request.


        :param resource_group: The resource_group of this ImportOciTelemetryResourcesTaskDetails.
        :type: str
        """
        self._resource_group = resource_group

    @property
    def availability_proxy_metrics(self):
        """
        Gets the availability_proxy_metrics of this ImportOciTelemetryResourcesTaskDetails.
        List of metrics to be used to calculate the availability of the resource.
        Resource is considered to be up if at least one of the specified metrics is available for
        the resource during the specified interval using the property
        'availabilityProxyMetricCollectionIntervalInSeconds'.
        If no metrics are specified, availability will not be calculated for the resource.


        :return: The availability_proxy_metrics of this ImportOciTelemetryResourcesTaskDetails.
        :rtype: list[str]
        """
        return self._availability_proxy_metrics

    @availability_proxy_metrics.setter
    def availability_proxy_metrics(self, availability_proxy_metrics):
        """
        Sets the availability_proxy_metrics of this ImportOciTelemetryResourcesTaskDetails.
        List of metrics to be used to calculate the availability of the resource.
        Resource is considered to be up if at least one of the specified metrics is available for
        the resource during the specified interval using the property
        'availabilityProxyMetricCollectionIntervalInSeconds'.
        If no metrics are specified, availability will not be calculated for the resource.


        :param availability_proxy_metrics: The availability_proxy_metrics of this ImportOciTelemetryResourcesTaskDetails.
        :type: list[str]
        """
        self._availability_proxy_metrics = availability_proxy_metrics

    @property
    def availability_proxy_metric_collection_interval(self):
        """
        Gets the availability_proxy_metric_collection_interval of this ImportOciTelemetryResourcesTaskDetails.
        Metrics collection interval in seconds used when calculating the availability of the
        resource based on metrics specified using the property 'availabilityProxyMetrics'.


        :return: The availability_proxy_metric_collection_interval of this ImportOciTelemetryResourcesTaskDetails.
        :rtype: int
        """
        return self._availability_proxy_metric_collection_interval

    @availability_proxy_metric_collection_interval.setter
    def availability_proxy_metric_collection_interval(self, availability_proxy_metric_collection_interval):
        """
        Sets the availability_proxy_metric_collection_interval of this ImportOciTelemetryResourcesTaskDetails.
        Metrics collection interval in seconds used when calculating the availability of the
        resource based on metrics specified using the property 'availabilityProxyMetrics'.


        :param availability_proxy_metric_collection_interval: The availability_proxy_metric_collection_interval of this ImportOciTelemetryResourcesTaskDetails.
        :type: int
        """
        self._availability_proxy_metric_collection_interval = availability_proxy_metric_collection_interval

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
