# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ShapeSummary(object):
    """
    Summary of the database system shape.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ShapeSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ShapeSummary.
        :type id: str

        :param shape:
            The value to assign to the shape property of this ShapeSummary.
        :type shape: str

        :param ocpu_count:
            The value to assign to the ocpu_count property of this ShapeSummary.
        :type ocpu_count: int

        :param memory_size_in_gbs:
            The value to assign to the memory_size_in_gbs property of this ShapeSummary.
        :type memory_size_in_gbs: int

        """
        self.swagger_types = {
            'id': 'str',
            'shape': 'str',
            'ocpu_count': 'int',
            'memory_size_in_gbs': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'shape': 'shape',
            'ocpu_count': 'ocpuCount',
            'memory_size_in_gbs': 'memorySizeInGBs'
        }

        self._id = None
        self._shape = None
        self._ocpu_count = None
        self._memory_size_in_gbs = None

    @property
    def id(self):
        """
        Gets the id of this ShapeSummary.
        A unique identifier for the shape.


        :return: The id of this ShapeSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ShapeSummary.
        A unique identifier for the shape.


        :param id: The id of this ShapeSummary.
        :type: str
        """
        self._id = id

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this ShapeSummary.
        The name of the Compute VM shape.
        Example: `VM.Standard.E4.Flex`


        :return: The shape of this ShapeSummary.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this ShapeSummary.
        The name of the Compute VM shape.
        Example: `VM.Standard.E4.Flex`


        :param shape: The shape of this ShapeSummary.
        :type: str
        """
        self._shape = shape

    @property
    def ocpu_count(self):
        """
        **[Required]** Gets the ocpu_count of this ShapeSummary.
        The number of OCPUs.


        :return: The ocpu_count of this ShapeSummary.
        :rtype: int
        """
        return self._ocpu_count

    @ocpu_count.setter
    def ocpu_count(self, ocpu_count):
        """
        Sets the ocpu_count of this ShapeSummary.
        The number of OCPUs.


        :param ocpu_count: The ocpu_count of this ShapeSummary.
        :type: int
        """
        self._ocpu_count = ocpu_count

    @property
    def memory_size_in_gbs(self):
        """
        **[Required]** Gets the memory_size_in_gbs of this ShapeSummary.
        The amount of memory in gigabytes.


        :return: The memory_size_in_gbs of this ShapeSummary.
        :rtype: int
        """
        return self._memory_size_in_gbs

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, memory_size_in_gbs):
        """
        Sets the memory_size_in_gbs of this ShapeSummary.
        The amount of memory in gigabytes.


        :param memory_size_in_gbs: The memory_size_in_gbs of this ShapeSummary.
        :type: int
        """
        self._memory_size_in_gbs = memory_size_in_gbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
