# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915

from .patch_instruction import PatchInstruction
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchMoveInstruction(PatchInstruction):
    """
    An operation that \"puts\" values from elsewhere in the target, functionally equivalent to a single add and then a remove.
    The first item of the selection is replaced, or created if the selection is empty.
    NOT_FOUND exceptions in the selection are handled by creating the implied containing structure.
    This operation fails if the `from` selection yields any exceptions, or if an item is moved to any of its descendants.
    """

    #: A constant which can be used with the position property of a PatchMoveInstruction.
    #: This constant has a value of "AT"
    POSITION_AT = "AT"

    #: A constant which can be used with the position property of a PatchMoveInstruction.
    #: This constant has a value of "BEFORE"
    POSITION_BEFORE = "BEFORE"

    #: A constant which can be used with the position property of a PatchMoveInstruction.
    #: This constant has a value of "AFTER"
    POSITION_AFTER = "AFTER"

    def __init__(self, **kwargs):
        """
        Initializes a new PatchMoveInstruction object with values from keyword arguments. The default value of the :py:attr:`~oci.psql.models.PatchMoveInstruction.operation` attribute
        of this class is ``MOVE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operation:
            The value to assign to the operation property of this PatchMoveInstruction.
            Allowed values for this property are: "REQUIRE", "PROHIBIT", "REPLACE", "INSERT", "REMOVE", "MOVE", "MERGE"
        :type operation: str

        :param selection:
            The value to assign to the selection property of this PatchMoveInstruction.
        :type selection: str

        :param _from:
            The value to assign to the _from property of this PatchMoveInstruction.
        :type _from: str

        :param position:
            The value to assign to the position property of this PatchMoveInstruction.
            Allowed values for this property are: "AT", "BEFORE", "AFTER"
        :type position: str

        """
        self.swagger_types = {
            'operation': 'str',
            'selection': 'str',
            '_from': 'str',
            'position': 'str'
        }

        self.attribute_map = {
            'operation': 'operation',
            'selection': 'selection',
            '_from': 'from',
            'position': 'position'
        }

        self._operation = None
        self._selection = None
        self.__from = None
        self._position = None
        self._operation = 'MOVE'

    @property
    def _from(self):
        """
        **[Required]** Gets the _from of this PatchMoveInstruction.
        The selection that is to be moved, with the same format and semantics as `selection`.


        :return: The _from of this PatchMoveInstruction.
        :rtype: str
        """
        return self.__from

    @_from.setter
    def _from(self, _from):
        """
        Sets the _from of this PatchMoveInstruction.
        The selection that is to be moved, with the same format and semantics as `selection`.


        :param _from: The _from of this PatchMoveInstruction.
        :type: str
        """
        self.__from = _from

    @property
    def position(self):
        """
        Gets the position of this PatchMoveInstruction.
        Where to insert the value in an array, relative to the first item in the selection.
        If there is no such item, then \"BEFORE\" specifies insertion at the first position in an array and \"AFTER\" specifies insertion at the last position.
        If the first item in the selection is not the child of an array, then this field has no effect.

        Allowed values for this property are: "AT", "BEFORE", "AFTER"


        :return: The position of this PatchMoveInstruction.
        :rtype: str
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this PatchMoveInstruction.
        Where to insert the value in an array, relative to the first item in the selection.
        If there is no such item, then \"BEFORE\" specifies insertion at the first position in an array and \"AFTER\" specifies insertion at the last position.
        If the first item in the selection is not the child of an array, then this field has no effect.


        :param position: The position of this PatchMoveInstruction.
        :type: str
        """
        allowed_values = ["AT", "BEFORE", "AFTER"]
        if not value_allowed_none_or_none_sentinel(position, allowed_values):
            raise ValueError(
                f"Invalid value for `position`, must be None or one of {allowed_values}"
            )
        self._position = position

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
