# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915

from .backup_policy import BackupPolicy
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MonthlyBackupPolicy(BackupPolicy):
    """
    Monthly backup policy.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MonthlyBackupPolicy object with values from keyword arguments. The default value of the :py:attr:`~oci.psql.models.MonthlyBackupPolicy.kind` attribute
        of this class is ``MONTHLY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this MonthlyBackupPolicy.
            Allowed values for this property are: "DAILY", "WEEKLY", "MONTHLY", "NONE"
        :type kind: str

        :param retention_days:
            The value to assign to the retention_days property of this MonthlyBackupPolicy.
        :type retention_days: int

        :param backup_start:
            The value to assign to the backup_start property of this MonthlyBackupPolicy.
        :type backup_start: str

        :param days_of_the_month:
            The value to assign to the days_of_the_month property of this MonthlyBackupPolicy.
        :type days_of_the_month: list[int]

        """
        self.swagger_types = {
            'kind': 'str',
            'retention_days': 'int',
            'backup_start': 'str',
            'days_of_the_month': 'list[int]'
        }

        self.attribute_map = {
            'kind': 'kind',
            'retention_days': 'retentionDays',
            'backup_start': 'backupStart',
            'days_of_the_month': 'daysOfTheMonth'
        }

        self._kind = None
        self._retention_days = None
        self._backup_start = None
        self._days_of_the_month = None
        self._kind = 'MONTHLY'

    @property
    def backup_start(self):
        """
        **[Required]** Gets the backup_start of this MonthlyBackupPolicy.
        Hour of the day when backup starts.


        :return: The backup_start of this MonthlyBackupPolicy.
        :rtype: str
        """
        return self._backup_start

    @backup_start.setter
    def backup_start(self, backup_start):
        """
        Sets the backup_start of this MonthlyBackupPolicy.
        Hour of the day when backup starts.


        :param backup_start: The backup_start of this MonthlyBackupPolicy.
        :type: str
        """
        self._backup_start = backup_start

    @property
    def days_of_the_month(self):
        """
        **[Required]** Gets the days_of_the_month of this MonthlyBackupPolicy.
        Day of the month when the backup should start.
        To ensure that the backup runs monthly, the latest day of the month that you can use to schedule a backup is the the 28th day.


        :return: The days_of_the_month of this MonthlyBackupPolicy.
        :rtype: list[int]
        """
        return self._days_of_the_month

    @days_of_the_month.setter
    def days_of_the_month(self, days_of_the_month):
        """
        Sets the days_of_the_month of this MonthlyBackupPolicy.
        Day of the month when the backup should start.
        To ensure that the backup runs monthly, the latest day of the month that you can use to schedule a backup is the the 28th day.


        :param days_of_the_month: The days_of_the_month of this MonthlyBackupPolicy.
        :type: list[int]
        """
        self._days_of_the_month = days_of_the_month

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
