# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WarehouseDataObjectDetails(object):
    """
    Warehouse data object details.
    """

    #: A constant which can be used with the data_object_type property of a WarehouseDataObjectDetails.
    #: This constant has a value of "VIEW"
    DATA_OBJECT_TYPE_VIEW = "VIEW"

    #: A constant which can be used with the data_object_type property of a WarehouseDataObjectDetails.
    #: This constant has a value of "TABLE"
    DATA_OBJECT_TYPE_TABLE = "TABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new WarehouseDataObjectDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.opsi.models.WarehouseViewDataObjectDetails`
        * :class:`~oci.opsi.models.WarehouseTableDataObjectDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param data_object_type:
            The value to assign to the data_object_type property of this WarehouseDataObjectDetails.
            Allowed values for this property are: "VIEW", "TABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type data_object_type: str

        """
        self.swagger_types = {
            'data_object_type': 'str'
        }

        self.attribute_map = {
            'data_object_type': 'dataObjectType'
        }

        self._data_object_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['dataObjectType']

        if type == 'VIEW':
            return 'WarehouseViewDataObjectDetails'

        if type == 'TABLE':
            return 'WarehouseTableDataObjectDetails'
        else:
            return 'WarehouseDataObjectDetails'

    @property
    def data_object_type(self):
        """
        **[Required]** Gets the data_object_type of this WarehouseDataObjectDetails.
        Type of the data object.

        Allowed values for this property are: "VIEW", "TABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The data_object_type of this WarehouseDataObjectDetails.
        :rtype: str
        """
        return self._data_object_type

    @data_object_type.setter
    def data_object_type(self, data_object_type):
        """
        Sets the data_object_type of this WarehouseDataObjectDetails.
        Type of the data object.


        :param data_object_type: The data_object_type of this WarehouseDataObjectDetails.
        :type: str
        """
        allowed_values = ["VIEW", "TABLE"]
        if not value_allowed_none_or_none_sentinel(data_object_type, allowed_values):
            data_object_type = 'UNKNOWN_ENUM_VALUE'
        self._data_object_type = data_object_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
