# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAwrHubSourceDetails(object):
    """
    Awr hub source update object information
    """

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "ADW_S"
    TYPE_ADW_S = "ADW_S"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "ATP_S"
    TYPE_ATP_S = "ATP_S"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "ADW_D"
    TYPE_ADW_D = "ADW_D"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "ATP_D"
    TYPE_ATP_D = "ATP_D"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "EXTERNAL_PDB"
    TYPE_EXTERNAL_PDB = "EXTERNAL_PDB"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "EXTERNAL_NONCDB"
    TYPE_EXTERNAL_NONCDB = "EXTERNAL_NONCDB"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_VM_CDB"
    TYPE_COMANAGED_VM_CDB = "COMANAGED_VM_CDB"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_VM_PDB"
    TYPE_COMANAGED_VM_PDB = "COMANAGED_VM_PDB"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_VM_NONCDB"
    TYPE_COMANAGED_VM_NONCDB = "COMANAGED_VM_NONCDB"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_BM_CDB"
    TYPE_COMANAGED_BM_CDB = "COMANAGED_BM_CDB"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_BM_PDB"
    TYPE_COMANAGED_BM_PDB = "COMANAGED_BM_PDB"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_BM_NONCDB"
    TYPE_COMANAGED_BM_NONCDB = "COMANAGED_BM_NONCDB"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_EXACS_CDB"
    TYPE_COMANAGED_EXACS_CDB = "COMANAGED_EXACS_CDB"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_EXACS_PDB"
    TYPE_COMANAGED_EXACS_PDB = "COMANAGED_EXACS_PDB"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "COMANAGED_EXACS_NONCDB"
    TYPE_COMANAGED_EXACS_NONCDB = "COMANAGED_EXACS_NONCDB"

    #: A constant which can be used with the type property of a UpdateAwrHubSourceDetails.
    #: This constant has a value of "UNDEFINED"
    TYPE_UNDEFINED = "UNDEFINED"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAwrHubSourceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this UpdateAwrHubSourceDetails.
            Allowed values for this property are: "ADW_S", "ATP_S", "ADW_D", "ATP_D", "EXTERNAL_PDB", "EXTERNAL_NONCDB", "COMANAGED_VM_CDB", "COMANAGED_VM_PDB", "COMANAGED_VM_NONCDB", "COMANAGED_BM_CDB", "COMANAGED_BM_PDB", "COMANAGED_BM_NONCDB", "COMANAGED_EXACS_CDB", "COMANAGED_EXACS_PDB", "COMANAGED_EXACS_NONCDB", "UNDEFINED"
        :type type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateAwrHubSourceDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateAwrHubSourceDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'type': 'type',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._type = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def type(self):
        """
        Gets the type of this UpdateAwrHubSourceDetails.
        source type of the database

        Allowed values for this property are: "ADW_S", "ATP_S", "ADW_D", "ATP_D", "EXTERNAL_PDB", "EXTERNAL_NONCDB", "COMANAGED_VM_CDB", "COMANAGED_VM_PDB", "COMANAGED_VM_NONCDB", "COMANAGED_BM_CDB", "COMANAGED_BM_PDB", "COMANAGED_BM_NONCDB", "COMANAGED_EXACS_CDB", "COMANAGED_EXACS_PDB", "COMANAGED_EXACS_NONCDB", "UNDEFINED"


        :return: The type of this UpdateAwrHubSourceDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this UpdateAwrHubSourceDetails.
        source type of the database


        :param type: The type of this UpdateAwrHubSourceDetails.
        :type: str
        """
        allowed_values = ["ADW_S", "ATP_S", "ADW_D", "ATP_D", "EXTERNAL_PDB", "EXTERNAL_NONCDB", "COMANAGED_VM_CDB", "COMANAGED_VM_PDB", "COMANAGED_VM_NONCDB", "COMANAGED_BM_CDB", "COMANAGED_BM_PDB", "COMANAGED_BM_NONCDB", "COMANAGED_EXACS_CDB", "COMANAGED_EXACS_PDB", "COMANAGED_EXACS_NONCDB", "UNDEFINED"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateAwrHubSourceDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateAwrHubSourceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateAwrHubSourceDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateAwrHubSourceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateAwrHubSourceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateAwrHubSourceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateAwrHubSourceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateAwrHubSourceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
