# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ServiceList(object):
    """
    A group of services.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ServiceList object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this ServiceList.
        :type name: str

        :param services:
            The value to assign to the services property of this ServiceList.
        :type services: list[str]

        :param total_services:
            The value to assign to the total_services property of this ServiceList.
        :type total_services: int

        :param parent_resource_id:
            The value to assign to the parent_resource_id property of this ServiceList.
        :type parent_resource_id: str

        """
        self.swagger_types = {
            'name': 'str',
            'services': 'list[str]',
            'total_services': 'int',
            'parent_resource_id': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'services': 'services',
            'total_services': 'totalServices',
            'parent_resource_id': 'parentResourceId'
        }

        self._name = None
        self._services = None
        self._total_services = None
        self._parent_resource_id = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ServiceList.
        Name of the service Group.


        :return: The name of this ServiceList.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ServiceList.
        Name of the service Group.


        :param name: The name of this ServiceList.
        :type: str
        """
        self._name = name

    @property
    def services(self):
        """
        **[Required]** Gets the services of this ServiceList.
        List of services in the group.


        :return: The services of this ServiceList.
        :rtype: list[str]
        """
        return self._services

    @services.setter
    def services(self, services):
        """
        Sets the services of this ServiceList.
        List of services in the group.


        :param services: The services of this ServiceList.
        :type: list[str]
        """
        self._services = services

    @property
    def total_services(self):
        """
        **[Required]** Gets the total_services of this ServiceList.
        Count of total services in the given service List.


        :return: The total_services of this ServiceList.
        :rtype: int
        """
        return self._total_services

    @total_services.setter
    def total_services(self, total_services):
        """
        Sets the total_services of this ServiceList.
        Count of total services in the given service List.


        :param total_services: The total_services of this ServiceList.
        :type: int
        """
        self._total_services = total_services

    @property
    def parent_resource_id(self):
        """
        **[Required]** Gets the parent_resource_id of this ServiceList.
        OCID of the Network Firewall Policy this serviceList belongs to.


        :return: The parent_resource_id of this ServiceList.
        :rtype: str
        """
        return self._parent_resource_id

    @parent_resource_id.setter
    def parent_resource_id(self, parent_resource_id):
        """
        Sets the parent_resource_id of this ServiceList.
        OCID of the Network Firewall Policy this serviceList belongs to.


        :param parent_resource_id: The parent_resource_id of this ServiceList.
        :type: str
        """
        self._parent_resource_id = parent_resource_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
