# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ListingRevisionPackageSummary(object):
    """
    The model for a summary of a package.
    """

    #: A constant which can be used with the package_type property of a ListingRevisionPackageSummary.
    #: This constant has a value of "CONTAINER_IMAGE"
    PACKAGE_TYPE_CONTAINER_IMAGE = "CONTAINER_IMAGE"

    #: A constant which can be used with the package_type property of a ListingRevisionPackageSummary.
    #: This constant has a value of "HELM_CHART"
    PACKAGE_TYPE_HELM_CHART = "HELM_CHART"

    def __init__(self, **kwargs):
        """
        Initializes a new ListingRevisionPackageSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ListingRevisionPackageSummary.
        :type id: str

        :param listing_revision_id:
            The value to assign to the listing_revision_id property of this ListingRevisionPackageSummary.
        :type listing_revision_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ListingRevisionPackageSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this ListingRevisionPackageSummary.
        :type display_name: str

        :param package_version:
            The value to assign to the package_version property of this ListingRevisionPackageSummary.
        :type package_version: str

        :param package_type:
            The value to assign to the package_type property of this ListingRevisionPackageSummary.
            Allowed values for this property are: "CONTAINER_IMAGE", "HELM_CHART", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type package_type: str

        :param are_security_upgrades_provided:
            The value to assign to the are_security_upgrades_provided property of this ListingRevisionPackageSummary.
        :type are_security_upgrades_provided: bool

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ListingRevisionPackageSummary.
        :type lifecycle_state: str

        :param status:
            The value to assign to the status property of this ListingRevisionPackageSummary.
        :type status: str

        :param time_created:
            The value to assign to the time_created property of this ListingRevisionPackageSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ListingRevisionPackageSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ListingRevisionPackageSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ListingRevisionPackageSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ListingRevisionPackageSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'listing_revision_id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'package_version': 'str',
            'package_type': 'str',
            'are_security_upgrades_provided': 'bool',
            'lifecycle_state': 'str',
            'status': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'listing_revision_id': 'listingRevisionId',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'package_version': 'packageVersion',
            'package_type': 'packageType',
            'are_security_upgrades_provided': 'areSecurityUpgradesProvided',
            'lifecycle_state': 'lifecycleState',
            'status': 'status',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._id = None
        self._listing_revision_id = None
        self._compartment_id = None
        self._display_name = None
        self._package_version = None
        self._package_type = None
        self._are_security_upgrades_provided = None
        self._lifecycle_state = None
        self._status = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ListingRevisionPackageSummary.
        The ID of the listing revision package.


        :return: The id of this ListingRevisionPackageSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ListingRevisionPackageSummary.
        The ID of the listing revision package.


        :param id: The id of this ListingRevisionPackageSummary.
        :type: str
        """
        self._id = id

    @property
    def listing_revision_id(self):
        """
        **[Required]** Gets the listing_revision_id of this ListingRevisionPackageSummary.
        The ID of the listing revision.


        :return: The listing_revision_id of this ListingRevisionPackageSummary.
        :rtype: str
        """
        return self._listing_revision_id

    @listing_revision_id.setter
    def listing_revision_id(self, listing_revision_id):
        """
        Sets the listing_revision_id of this ListingRevisionPackageSummary.
        The ID of the listing revision.


        :param listing_revision_id: The listing_revision_id of this ListingRevisionPackageSummary.
        :type: str
        """
        self._listing_revision_id = listing_revision_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ListingRevisionPackageSummary.
        The unique identifier for the compartment.


        :return: The compartment_id of this ListingRevisionPackageSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ListingRevisionPackageSummary.
        The unique identifier for the compartment.


        :param compartment_id: The compartment_id of this ListingRevisionPackageSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ListingRevisionPackageSummary.
        The name of the listing revision package.


        :return: The display_name of this ListingRevisionPackageSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ListingRevisionPackageSummary.
        The name of the listing revision package.


        :param display_name: The display_name of this ListingRevisionPackageSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def package_version(self):
        """
        **[Required]** Gets the package_version of this ListingRevisionPackageSummary.
        The version of the specified package.


        :return: The package_version of this ListingRevisionPackageSummary.
        :rtype: str
        """
        return self._package_version

    @package_version.setter
    def package_version(self, package_version):
        """
        Sets the package_version of this ListingRevisionPackageSummary.
        The version of the specified package.


        :param package_version: The package_version of this ListingRevisionPackageSummary.
        :type: str
        """
        self._package_version = package_version

    @property
    def package_type(self):
        """
        **[Required]** Gets the package_type of this ListingRevisionPackageSummary.
        The specified package's type.

        Allowed values for this property are: "CONTAINER_IMAGE", "HELM_CHART", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The package_type of this ListingRevisionPackageSummary.
        :rtype: str
        """
        return self._package_type

    @package_type.setter
    def package_type(self, package_type):
        """
        Sets the package_type of this ListingRevisionPackageSummary.
        The specified package's type.


        :param package_type: The package_type of this ListingRevisionPackageSummary.
        :type: str
        """
        allowed_values = ["CONTAINER_IMAGE", "HELM_CHART"]
        if not value_allowed_none_or_none_sentinel(package_type, allowed_values):
            package_type = 'UNKNOWN_ENUM_VALUE'
        self._package_type = package_type

    @property
    def are_security_upgrades_provided(self):
        """
        **[Required]** Gets the are_security_upgrades_provided of this ListingRevisionPackageSummary.
        Identifies whether security upgrades will be provided for this package.


        :return: The are_security_upgrades_provided of this ListingRevisionPackageSummary.
        :rtype: bool
        """
        return self._are_security_upgrades_provided

    @are_security_upgrades_provided.setter
    def are_security_upgrades_provided(self, are_security_upgrades_provided):
        """
        Sets the are_security_upgrades_provided of this ListingRevisionPackageSummary.
        Identifies whether security upgrades will be provided for this package.


        :param are_security_upgrades_provided: The are_security_upgrades_provided of this ListingRevisionPackageSummary.
        :type: bool
        """
        self._are_security_upgrades_provided = are_security_upgrades_provided

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ListingRevisionPackageSummary.
        The current state of the Package.


        :return: The lifecycle_state of this ListingRevisionPackageSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ListingRevisionPackageSummary.
        The current state of the Package.


        :param lifecycle_state: The lifecycle_state of this ListingRevisionPackageSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def status(self):
        """
        **[Required]** Gets the status of this ListingRevisionPackageSummary.
        The current status of the package.


        :return: The status of this ListingRevisionPackageSummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ListingRevisionPackageSummary.
        The current status of the package.


        :param status: The status of this ListingRevisionPackageSummary.
        :type: str
        """
        self._status = status

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ListingRevisionPackageSummary.
        The date and time the publication package was created, expressed in `RFC 3339`__
        timestamp format.

        Example: `2022-09-24T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ListingRevisionPackageSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ListingRevisionPackageSummary.
        The date and time the publication package was created, expressed in `RFC 3339`__
        timestamp format.

        Example: `2022-09-24T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ListingRevisionPackageSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ListingRevisionPackageSummary.
        The date and time the publication package was updated, expressed in `RFC 3339`__
        timestamp format.

        Example: `2022-09-24T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ListingRevisionPackageSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ListingRevisionPackageSummary.
        The date and time the publication package was updated, expressed in `RFC 3339`__
        timestamp format.

        Example: `2022-09-24T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ListingRevisionPackageSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ListingRevisionPackageSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this ListingRevisionPackageSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ListingRevisionPackageSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this ListingRevisionPackageSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ListingRevisionPackageSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this ListingRevisionPackageSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ListingRevisionPackageSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this ListingRevisionPackageSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ListingRevisionPackageSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ListingRevisionPackageSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ListingRevisionPackageSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ListingRevisionPackageSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
