# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RecallCount(object):
    """
    This is the recall count statistics for a given tenant
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RecallCount object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param recall_count:
            The value to assign to the recall_count property of this RecallCount.
        :type recall_count: int

        :param recall_succeeded:
            The value to assign to the recall_succeeded property of this RecallCount.
        :type recall_succeeded: int

        :param recall_failed:
            The value to assign to the recall_failed property of this RecallCount.
        :type recall_failed: int

        :param recall_pending:
            The value to assign to the recall_pending property of this RecallCount.
        :type recall_pending: int

        :param recall_limit:
            The value to assign to the recall_limit property of this RecallCount.
        :type recall_limit: int

        """
        self.swagger_types = {
            'recall_count': 'int',
            'recall_succeeded': 'int',
            'recall_failed': 'int',
            'recall_pending': 'int',
            'recall_limit': 'int'
        }

        self.attribute_map = {
            'recall_count': 'recallCount',
            'recall_succeeded': 'recallSucceeded',
            'recall_failed': 'recallFailed',
            'recall_pending': 'recallPending',
            'recall_limit': 'recallLimit'
        }

        self._recall_count = None
        self._recall_succeeded = None
        self._recall_failed = None
        self._recall_pending = None
        self._recall_limit = None

    @property
    def recall_count(self):
        """
        **[Required]** Gets the recall_count of this RecallCount.
        This is the total number of recalls made so far


        :return: The recall_count of this RecallCount.
        :rtype: int
        """
        return self._recall_count

    @recall_count.setter
    def recall_count(self, recall_count):
        """
        Sets the recall_count of this RecallCount.
        This is the total number of recalls made so far


        :param recall_count: The recall_count of this RecallCount.
        :type: int
        """
        self._recall_count = recall_count

    @property
    def recall_succeeded(self):
        """
        **[Required]** Gets the recall_succeeded of this RecallCount.
        This is the number of recalls that succeeded


        :return: The recall_succeeded of this RecallCount.
        :rtype: int
        """
        return self._recall_succeeded

    @recall_succeeded.setter
    def recall_succeeded(self, recall_succeeded):
        """
        Sets the recall_succeeded of this RecallCount.
        This is the number of recalls that succeeded


        :param recall_succeeded: The recall_succeeded of this RecallCount.
        :type: int
        """
        self._recall_succeeded = recall_succeeded

    @property
    def recall_failed(self):
        """
        **[Required]** Gets the recall_failed of this RecallCount.
        This is the number of recalls that failed


        :return: The recall_failed of this RecallCount.
        :rtype: int
        """
        return self._recall_failed

    @recall_failed.setter
    def recall_failed(self, recall_failed):
        """
        Sets the recall_failed of this RecallCount.
        This is the number of recalls that failed


        :param recall_failed: The recall_failed of this RecallCount.
        :type: int
        """
        self._recall_failed = recall_failed

    @property
    def recall_pending(self):
        """
        **[Required]** Gets the recall_pending of this RecallCount.
        This is the number of recalls in pending state


        :return: The recall_pending of this RecallCount.
        :rtype: int
        """
        return self._recall_pending

    @recall_pending.setter
    def recall_pending(self, recall_pending):
        """
        Sets the recall_pending of this RecallCount.
        This is the number of recalls in pending state


        :param recall_pending: The recall_pending of this RecallCount.
        :type: int
        """
        self._recall_pending = recall_pending

    @property
    def recall_limit(self):
        """
        **[Required]** Gets the recall_limit of this RecallCount.
        This is the maximum number of recalls (including successful and pending recalls) allowed


        :return: The recall_limit of this RecallCount.
        :rtype: int
        """
        return self._recall_limit

    @recall_limit.setter
    def recall_limit(self, recall_limit):
        """
        Sets the recall_limit of this RecallCount.
        This is the maximum number of recalls (including successful and pending recalls) allowed


        :param recall_limit: The recall_limit of this RecallCount.
        :type: int
        """
        self._recall_limit = recall_limit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
