# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LogAnalyticsEndpoint(object):
    """
    Endpoint configuration for REST API based log collection.
    """

    #: A constant which can be used with the endpoint_type property of a LogAnalyticsEndpoint.
    #: This constant has a value of "LOG_LIST"
    ENDPOINT_TYPE_LOG_LIST = "LOG_LIST"

    #: A constant which can be used with the endpoint_type property of a LogAnalyticsEndpoint.
    #: This constant has a value of "LOG"
    ENDPOINT_TYPE_LOG = "LOG"

    def __init__(self, **kwargs):
        """
        Initializes a new LogAnalyticsEndpoint object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.log_analytics.models.LogListTypeEndpoint`
        * :class:`~oci.log_analytics.models.LogTypeEndpoint`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param endpoint_type:
            The value to assign to the endpoint_type property of this LogAnalyticsEndpoint.
            Allowed values for this property are: "LOG_LIST", "LOG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type endpoint_type: str

        """
        self.swagger_types = {
            'endpoint_type': 'str'
        }

        self.attribute_map = {
            'endpoint_type': 'endpointType'
        }

        self._endpoint_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['endpointType']

        if type == 'LOG_LIST':
            return 'LogListTypeEndpoint'

        if type == 'LOG':
            return 'LogTypeEndpoint'
        else:
            return 'LogAnalyticsEndpoint'

    @property
    def endpoint_type(self):
        """
        **[Required]** Gets the endpoint_type of this LogAnalyticsEndpoint.
        Discriminator.

        Allowed values for this property are: "LOG_LIST", "LOG", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The endpoint_type of this LogAnalyticsEndpoint.
        :rtype: str
        """
        return self._endpoint_type

    @endpoint_type.setter
    def endpoint_type(self, endpoint_type):
        """
        Sets the endpoint_type of this LogAnalyticsEndpoint.
        Discriminator.


        :param endpoint_type: The endpoint_type of this LogAnalyticsEndpoint.
        :type: str
        """
        allowed_values = ["LOG_LIST", "LOG"]
        if not value_allowed_none_or_none_sentinel(endpoint_type, allowed_values):
            endpoint_type = 'UNKNOWN_ENUM_VALUE'
        self._endpoint_type = endpoint_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
