# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SchemaSubAttributes(object):
    """
    A list specifying the contained attributes
    """

    #: A constant which can be used with the type property of a SchemaSubAttributes.
    #: This constant has a value of "string"
    TYPE_STRING = "string"

    #: A constant which can be used with the type property of a SchemaSubAttributes.
    #: This constant has a value of "complex"
    TYPE_COMPLEX = "complex"

    #: A constant which can be used with the type property of a SchemaSubAttributes.
    #: This constant has a value of "boolean"
    TYPE_BOOLEAN = "boolean"

    #: A constant which can be used with the type property of a SchemaSubAttributes.
    #: This constant has a value of "decimal"
    TYPE_DECIMAL = "decimal"

    #: A constant which can be used with the type property of a SchemaSubAttributes.
    #: This constant has a value of "integer"
    TYPE_INTEGER = "integer"

    #: A constant which can be used with the type property of a SchemaSubAttributes.
    #: This constant has a value of "dateTime"
    TYPE_DATE_TIME = "dateTime"

    #: A constant which can be used with the type property of a SchemaSubAttributes.
    #: This constant has a value of "reference"
    TYPE_REFERENCE = "reference"

    #: A constant which can be used with the type property of a SchemaSubAttributes.
    #: This constant has a value of "binary"
    TYPE_BINARY = "binary"

    #: A constant which can be used with the mutability property of a SchemaSubAttributes.
    #: This constant has a value of "readOnly"
    MUTABILITY_READ_ONLY = "readOnly"

    #: A constant which can be used with the mutability property of a SchemaSubAttributes.
    #: This constant has a value of "readWrite"
    MUTABILITY_READ_WRITE = "readWrite"

    #: A constant which can be used with the mutability property of a SchemaSubAttributes.
    #: This constant has a value of "immutable"
    MUTABILITY_IMMUTABLE = "immutable"

    #: A constant which can be used with the mutability property of a SchemaSubAttributes.
    #: This constant has a value of "writeOnly"
    MUTABILITY_WRITE_ONLY = "writeOnly"

    #: A constant which can be used with the returned property of a SchemaSubAttributes.
    #: This constant has a value of "always"
    RETURNED_ALWAYS = "always"

    #: A constant which can be used with the returned property of a SchemaSubAttributes.
    #: This constant has a value of "never"
    RETURNED_NEVER = "never"

    #: A constant which can be used with the returned property of a SchemaSubAttributes.
    #: This constant has a value of "default"
    RETURNED_DEFAULT = "default"

    #: A constant which can be used with the returned property of a SchemaSubAttributes.
    #: This constant has a value of "request"
    RETURNED_REQUEST = "request"

    #: A constant which can be used with the uniqueness property of a SchemaSubAttributes.
    #: This constant has a value of "none"
    UNIQUENESS_NONE = "none"

    #: A constant which can be used with the uniqueness property of a SchemaSubAttributes.
    #: This constant has a value of "server"
    UNIQUENESS_SERVER = "server"

    #: A constant which can be used with the uniqueness property of a SchemaSubAttributes.
    #: This constant has a value of "global"
    UNIQUENESS_GLOBAL = "global"

    #: A constant which can be used with the idcs_sensitive property of a SchemaSubAttributes.
    #: This constant has a value of "encrypt"
    IDCS_SENSITIVE_ENCRYPT = "encrypt"

    #: A constant which can be used with the idcs_sensitive property of a SchemaSubAttributes.
    #: This constant has a value of "hash"
    IDCS_SENSITIVE_HASH = "hash"

    #: A constant which can be used with the idcs_sensitive property of a SchemaSubAttributes.
    #: This constant has a value of "hash_sc"
    IDCS_SENSITIVE_HASH_SC = "hash_sc"

    #: A constant which can be used with the idcs_sensitive property of a SchemaSubAttributes.
    #: This constant has a value of "checksum"
    IDCS_SENSITIVE_CHECKSUM = "checksum"

    #: A constant which can be used with the idcs_sensitive property of a SchemaSubAttributes.
    #: This constant has a value of "none"
    IDCS_SENSITIVE_NONE = "none"

    #: A constant which can be used with the idcsui_widget property of a SchemaSubAttributes.
    #: This constant has a value of "inputtext"
    IDCSUI_WIDGET_INPUTTEXT = "inputtext"

    #: A constant which can be used with the idcsui_widget property of a SchemaSubAttributes.
    #: This constant has a value of "checkbox"
    IDCSUI_WIDGET_CHECKBOX = "checkbox"

    #: A constant which can be used with the idcsui_widget property of a SchemaSubAttributes.
    #: This constant has a value of "textarea"
    IDCSUI_WIDGET_TEXTAREA = "textarea"

    #: A constant which can be used with the idcsui_widget property of a SchemaSubAttributes.
    #: This constant has a value of "combobox"
    IDCSUI_WIDGET_COMBOBOX = "combobox"

    def __init__(self, **kwargs):
        """
        Initializes a new SchemaSubAttributes object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this SchemaSubAttributes.
        :type name: str

        :param idcs_requires_immediate_read_after_write_for_access_flows:
            The value to assign to the idcs_requires_immediate_read_after_write_for_access_flows property of this SchemaSubAttributes.
        :type idcs_requires_immediate_read_after_write_for_access_flows: bool

        :param idcs_requires_write_for_access_flows:
            The value to assign to the idcs_requires_write_for_access_flows property of this SchemaSubAttributes.
        :type idcs_requires_write_for_access_flows: bool

        :param idcs_display_name_message_id:
            The value to assign to the idcs_display_name_message_id property of this SchemaSubAttributes.
        :type idcs_display_name_message_id: str

        :param idcs_rtsa_hide_attribute:
            The value to assign to the idcs_rtsa_hide_attribute property of this SchemaSubAttributes.
        :type idcs_rtsa_hide_attribute: bool

        :param idcs_internal:
            The value to assign to the idcs_internal property of this SchemaSubAttributes.
        :type idcs_internal: bool

        :param type:
            The value to assign to the type property of this SchemaSubAttributes.
            Allowed values for this property are: "string", "complex", "boolean", "decimal", "integer", "dateTime", "reference", "binary", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param multi_valued:
            The value to assign to the multi_valued property of this SchemaSubAttributes.
        :type multi_valued: bool

        :param description:
            The value to assign to the description property of this SchemaSubAttributes.
        :type description: str

        :param required:
            The value to assign to the required property of this SchemaSubAttributes.
        :type required: bool

        :param idcs_return_empty_when_null:
            The value to assign to the idcs_return_empty_when_null property of this SchemaSubAttributes.
        :type idcs_return_empty_when_null: bool

        :param canonical_values:
            The value to assign to the canonical_values property of this SchemaSubAttributes.
        :type canonical_values: list[str]

        :param idcs_default_value:
            The value to assign to the idcs_default_value property of this SchemaSubAttributes.
        :type idcs_default_value: str

        :param case_exact:
            The value to assign to the case_exact property of this SchemaSubAttributes.
        :type case_exact: bool

        :param mutability:
            The value to assign to the mutability property of this SchemaSubAttributes.
            Allowed values for this property are: "readOnly", "readWrite", "immutable", "writeOnly", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type mutability: str

        :param returned:
            The value to assign to the returned property of this SchemaSubAttributes.
            Allowed values for this property are: "always", "never", "default", "request", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type returned: str

        :param idcs_csv_attribute_name:
            The value to assign to the idcs_csv_attribute_name property of this SchemaSubAttributes.
        :type idcs_csv_attribute_name: str

        :param uniqueness:
            The value to assign to the uniqueness property of this SchemaSubAttributes.
            Allowed values for this property are: "none", "server", "global", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type uniqueness: str

        :param reference_types:
            The value to assign to the reference_types property of this SchemaSubAttributes.
        :type reference_types: list[str]

        :param idcs_deprecated_since_version:
            The value to assign to the idcs_deprecated_since_version property of this SchemaSubAttributes.
        :type idcs_deprecated_since_version: int

        :param idcs_added_since_version:
            The value to assign to the idcs_added_since_version property of this SchemaSubAttributes.
        :type idcs_added_since_version: int

        :param idcs_deprecated_since_release_number:
            The value to assign to the idcs_deprecated_since_release_number property of this SchemaSubAttributes.
        :type idcs_deprecated_since_release_number: str

        :param idcs_added_since_release_number:
            The value to assign to the idcs_added_since_release_number property of this SchemaSubAttributes.
        :type idcs_added_since_release_number: str

        :param idcs_min_length:
            The value to assign to the idcs_min_length property of this SchemaSubAttributes.
        :type idcs_min_length: int

        :param idcs_max_length:
            The value to assign to the idcs_max_length property of this SchemaSubAttributes.
        :type idcs_max_length: int

        :param idcs_min_value:
            The value to assign to the idcs_min_value property of this SchemaSubAttributes.
        :type idcs_min_value: int

        :param idcs_max_value:
            The value to assign to the idcs_max_value property of this SchemaSubAttributes.
        :type idcs_max_value: int

        :param idcs_only_one_value_can_be_true:
            The value to assign to the idcs_only_one_value_can_be_true property of this SchemaSubAttributes.
        :type idcs_only_one_value_can_be_true: bool

        :param idcs_max_values_returned:
            The value to assign to the idcs_max_values_returned property of this SchemaSubAttributes.
        :type idcs_max_values_returned: int

        :param idcs_one_value_must_be_true:
            The value to assign to the idcs_one_value_must_be_true property of this SchemaSubAttributes.
        :type idcs_one_value_must_be_true: bool

        :param idcs_ref_resource_attributes:
            The value to assign to the idcs_ref_resource_attributes property of this SchemaSubAttributes.
        :type idcs_ref_resource_attributes: list[str]

        :param idcs_indirect_ref_resource_attributes:
            The value to assign to the idcs_indirect_ref_resource_attributes property of this SchemaSubAttributes.
        :type idcs_indirect_ref_resource_attributes: list[str]

        :param idcs_value_persisted:
            The value to assign to the idcs_value_persisted property of this SchemaSubAttributes.
        :type idcs_value_persisted: bool

        :param idcs_sensitive:
            The value to assign to the idcs_sensitive property of this SchemaSubAttributes.
            Allowed values for this property are: "encrypt", "hash", "hash_sc", "checksum", "none", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_sensitive: str

        :param idcs_trim_string_value:
            The value to assign to the idcs_trim_string_value property of this SchemaSubAttributes.
        :type idcs_trim_string_value: bool

        :param idcs_searchable:
            The value to assign to the idcs_searchable property of this SchemaSubAttributes.
        :type idcs_searchable: bool

        :param idcs_generated:
            The value to assign to the idcs_generated property of this SchemaSubAttributes.
        :type idcs_generated: bool

        :param idcs_auditable:
            The value to assign to the idcs_auditable property of this SchemaSubAttributes.
        :type idcs_auditable: bool

        :param idcs_target_attribute_name:
            The value to assign to the idcs_target_attribute_name property of this SchemaSubAttributes.
        :type idcs_target_attribute_name: str

        :param idcs_target_norm_attribute_name:
            The value to assign to the idcs_target_norm_attribute_name property of this SchemaSubAttributes.
        :type idcs_target_norm_attribute_name: str

        :param idcs_target_attribute_name_to_migrate_from:
            The value to assign to the idcs_target_attribute_name_to_migrate_from property of this SchemaSubAttributes.
        :type idcs_target_attribute_name_to_migrate_from: str

        :param idcs_target_unique_constraint_name:
            The value to assign to the idcs_target_unique_constraint_name property of this SchemaSubAttributes.
        :type idcs_target_unique_constraint_name: str

        :param idcs_to_target_mapper:
            The value to assign to the idcs_to_target_mapper property of this SchemaSubAttributes.
        :type idcs_to_target_mapper: str

        :param idcs_from_target_mapper:
            The value to assign to the idcs_from_target_mapper property of this SchemaSubAttributes.
        :type idcs_from_target_mapper: str

        :param idcs_display_name:
            The value to assign to the idcs_display_name property of this SchemaSubAttributes.
        :type idcs_display_name: str

        :param idcs_canonical_value_source_resource_type:
            The value to assign to the idcs_canonical_value_source_resource_type property of this SchemaSubAttributes.
        :type idcs_canonical_value_source_resource_type: str

        :param idcs_canonical_value_source_filter:
            The value to assign to the idcs_canonical_value_source_filter property of this SchemaSubAttributes.
        :type idcs_canonical_value_source_filter: str

        :param idcs_canonical_value_source_resource_type_id:
            The value to assign to the idcs_canonical_value_source_resource_type_id property of this SchemaSubAttributes.
        :type idcs_canonical_value_source_resource_type_id: str

        :param idcs_canonical_value_source_display_attr_name:
            The value to assign to the idcs_canonical_value_source_display_attr_name property of this SchemaSubAttributes.
        :type idcs_canonical_value_source_display_attr_name: str

        :param idcs_canonical_value_source_key_attr_name:
            The value to assign to the idcs_canonical_value_source_key_attr_name property of this SchemaSubAttributes.
        :type idcs_canonical_value_source_key_attr_name: str

        :param idcs_validate_reference:
            The value to assign to the idcs_validate_reference property of this SchemaSubAttributes.
        :type idcs_validate_reference: bool

        :param idcs_scim_compliant:
            The value to assign to the idcs_scim_compliant property of this SchemaSubAttributes.
        :type idcs_scim_compliant: bool

        :param idcs_attribute_mappable:
            The value to assign to the idcs_attribute_mappable property of this SchemaSubAttributes.
        :type idcs_attribute_mappable: bool

        :param idcs_attribute_cacheable:
            The value to assign to the idcs_attribute_cacheable property of this SchemaSubAttributes.
        :type idcs_attribute_cacheable: bool

        :param idcsui_order:
            The value to assign to the idcsui_order property of this SchemaSubAttributes.
        :type idcsui_order: int

        :param idcsui_regexp:
            The value to assign to the idcsui_regexp property of this SchemaSubAttributes.
        :type idcsui_regexp: str

        :param idcsui_visible:
            The value to assign to the idcsui_visible property of this SchemaSubAttributes.
        :type idcsui_visible: bool

        :param idcsui_widget:
            The value to assign to the idcsui_widget property of this SchemaSubAttributes.
            Allowed values for this property are: "inputtext", "checkbox", "textarea", "combobox", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcsui_widget: str

        :param idcs_value_persisted_in_other_attribute:
            The value to assign to the idcs_value_persisted_in_other_attribute property of this SchemaSubAttributes.
        :type idcs_value_persisted_in_other_attribute: bool

        :param idcs_pii:
            The value to assign to the idcs_pii property of this SchemaSubAttributes.
        :type idcs_pii: bool

        :param idcs_sanitize:
            The value to assign to the idcs_sanitize property of this SchemaSubAttributes.
        :type idcs_sanitize: bool

        :param idcs_exclude_from_upgrade_patch:
            The value to assign to the idcs_exclude_from_upgrade_patch property of this SchemaSubAttributes.
        :type idcs_exclude_from_upgrade_patch: bool

        """
        self.swagger_types = {
            'name': 'str',
            'idcs_requires_immediate_read_after_write_for_access_flows': 'bool',
            'idcs_requires_write_for_access_flows': 'bool',
            'idcs_display_name_message_id': 'str',
            'idcs_rtsa_hide_attribute': 'bool',
            'idcs_internal': 'bool',
            'type': 'str',
            'multi_valued': 'bool',
            'description': 'str',
            'required': 'bool',
            'idcs_return_empty_when_null': 'bool',
            'canonical_values': 'list[str]',
            'idcs_default_value': 'str',
            'case_exact': 'bool',
            'mutability': 'str',
            'returned': 'str',
            'idcs_csv_attribute_name': 'str',
            'uniqueness': 'str',
            'reference_types': 'list[str]',
            'idcs_deprecated_since_version': 'int',
            'idcs_added_since_version': 'int',
            'idcs_deprecated_since_release_number': 'str',
            'idcs_added_since_release_number': 'str',
            'idcs_min_length': 'int',
            'idcs_max_length': 'int',
            'idcs_min_value': 'int',
            'idcs_max_value': 'int',
            'idcs_only_one_value_can_be_true': 'bool',
            'idcs_max_values_returned': 'int',
            'idcs_one_value_must_be_true': 'bool',
            'idcs_ref_resource_attributes': 'list[str]',
            'idcs_indirect_ref_resource_attributes': 'list[str]',
            'idcs_value_persisted': 'bool',
            'idcs_sensitive': 'str',
            'idcs_trim_string_value': 'bool',
            'idcs_searchable': 'bool',
            'idcs_generated': 'bool',
            'idcs_auditable': 'bool',
            'idcs_target_attribute_name': 'str',
            'idcs_target_norm_attribute_name': 'str',
            'idcs_target_attribute_name_to_migrate_from': 'str',
            'idcs_target_unique_constraint_name': 'str',
            'idcs_to_target_mapper': 'str',
            'idcs_from_target_mapper': 'str',
            'idcs_display_name': 'str',
            'idcs_canonical_value_source_resource_type': 'str',
            'idcs_canonical_value_source_filter': 'str',
            'idcs_canonical_value_source_resource_type_id': 'str',
            'idcs_canonical_value_source_display_attr_name': 'str',
            'idcs_canonical_value_source_key_attr_name': 'str',
            'idcs_validate_reference': 'bool',
            'idcs_scim_compliant': 'bool',
            'idcs_attribute_mappable': 'bool',
            'idcs_attribute_cacheable': 'bool',
            'idcsui_order': 'int',
            'idcsui_regexp': 'str',
            'idcsui_visible': 'bool',
            'idcsui_widget': 'str',
            'idcs_value_persisted_in_other_attribute': 'bool',
            'idcs_pii': 'bool',
            'idcs_sanitize': 'bool',
            'idcs_exclude_from_upgrade_patch': 'bool'
        }

        self.attribute_map = {
            'name': 'name',
            'idcs_requires_immediate_read_after_write_for_access_flows': 'idcsRequiresImmediateReadAfterWriteForAccessFlows',
            'idcs_requires_write_for_access_flows': 'idcsRequiresWriteForAccessFlows',
            'idcs_display_name_message_id': 'idcsDisplayNameMessageId',
            'idcs_rtsa_hide_attribute': 'idcsRtsaHideAttribute',
            'idcs_internal': 'idcsInternal',
            'type': 'type',
            'multi_valued': 'multiValued',
            'description': 'description',
            'required': 'required',
            'idcs_return_empty_when_null': 'idcsReturnEmptyWhenNull',
            'canonical_values': 'canonicalValues',
            'idcs_default_value': 'idcsDefaultValue',
            'case_exact': 'caseExact',
            'mutability': 'mutability',
            'returned': 'returned',
            'idcs_csv_attribute_name': 'idcsCsvAttributeName',
            'uniqueness': 'uniqueness',
            'reference_types': 'referenceTypes',
            'idcs_deprecated_since_version': 'idcsDeprecatedSinceVersion',
            'idcs_added_since_version': 'idcsAddedSinceVersion',
            'idcs_deprecated_since_release_number': 'idcsDeprecatedSinceReleaseNumber',
            'idcs_added_since_release_number': 'idcsAddedSinceReleaseNumber',
            'idcs_min_length': 'idcsMinLength',
            'idcs_max_length': 'idcsMaxLength',
            'idcs_min_value': 'idcsMinValue',
            'idcs_max_value': 'idcsMaxValue',
            'idcs_only_one_value_can_be_true': 'idcsOnlyOneValueCanBeTrue',
            'idcs_max_values_returned': 'idcsMaxValuesReturned',
            'idcs_one_value_must_be_true': 'idcsOneValueMustBeTrue',
            'idcs_ref_resource_attributes': 'idcsRefResourceAttributes',
            'idcs_indirect_ref_resource_attributes': 'idcsIndirectRefResourceAttributes',
            'idcs_value_persisted': 'idcsValuePersisted',
            'idcs_sensitive': 'idcsSensitive',
            'idcs_trim_string_value': 'idcsTrimStringValue',
            'idcs_searchable': 'idcsSearchable',
            'idcs_generated': 'idcsGenerated',
            'idcs_auditable': 'idcsAuditable',
            'idcs_target_attribute_name': 'idcsTargetAttributeName',
            'idcs_target_norm_attribute_name': 'idcsTargetNormAttributeName',
            'idcs_target_attribute_name_to_migrate_from': 'idcsTargetAttributeNameToMigrateFrom',
            'idcs_target_unique_constraint_name': 'idcsTargetUniqueConstraintName',
            'idcs_to_target_mapper': 'idcsToTargetMapper',
            'idcs_from_target_mapper': 'idcsFromTargetMapper',
            'idcs_display_name': 'idcsDisplayName',
            'idcs_canonical_value_source_resource_type': 'idcsCanonicalValueSourceResourceType',
            'idcs_canonical_value_source_filter': 'idcsCanonicalValueSourceFilter',
            'idcs_canonical_value_source_resource_type_id': 'idcsCanonicalValueSourceResourceTypeID',
            'idcs_canonical_value_source_display_attr_name': 'idcsCanonicalValueSourceDisplayAttrName',
            'idcs_canonical_value_source_key_attr_name': 'idcsCanonicalValueSourceKeyAttrName',
            'idcs_validate_reference': 'idcsValidateReference',
            'idcs_scim_compliant': 'idcsScimCompliant',
            'idcs_attribute_mappable': 'idcsAttributeMappable',
            'idcs_attribute_cacheable': 'idcsAttributeCacheable',
            'idcsui_order': 'idcsuiOrder',
            'idcsui_regexp': 'idcsuiRegexp',
            'idcsui_visible': 'idcsuiVisible',
            'idcsui_widget': 'idcsuiWidget',
            'idcs_value_persisted_in_other_attribute': 'idcsValuePersistedInOtherAttribute',
            'idcs_pii': 'idcsPii',
            'idcs_sanitize': 'idcsSanitize',
            'idcs_exclude_from_upgrade_patch': 'idcsExcludeFromUpgradePatch'
        }

        self._name = None
        self._idcs_requires_immediate_read_after_write_for_access_flows = None
        self._idcs_requires_write_for_access_flows = None
        self._idcs_display_name_message_id = None
        self._idcs_rtsa_hide_attribute = None
        self._idcs_internal = None
        self._type = None
        self._multi_valued = None
        self._description = None
        self._required = None
        self._idcs_return_empty_when_null = None
        self._canonical_values = None
        self._idcs_default_value = None
        self._case_exact = None
        self._mutability = None
        self._returned = None
        self._idcs_csv_attribute_name = None
        self._uniqueness = None
        self._reference_types = None
        self._idcs_deprecated_since_version = None
        self._idcs_added_since_version = None
        self._idcs_deprecated_since_release_number = None
        self._idcs_added_since_release_number = None
        self._idcs_min_length = None
        self._idcs_max_length = None
        self._idcs_min_value = None
        self._idcs_max_value = None
        self._idcs_only_one_value_can_be_true = None
        self._idcs_max_values_returned = None
        self._idcs_one_value_must_be_true = None
        self._idcs_ref_resource_attributes = None
        self._idcs_indirect_ref_resource_attributes = None
        self._idcs_value_persisted = None
        self._idcs_sensitive = None
        self._idcs_trim_string_value = None
        self._idcs_searchable = None
        self._idcs_generated = None
        self._idcs_auditable = None
        self._idcs_target_attribute_name = None
        self._idcs_target_norm_attribute_name = None
        self._idcs_target_attribute_name_to_migrate_from = None
        self._idcs_target_unique_constraint_name = None
        self._idcs_to_target_mapper = None
        self._idcs_from_target_mapper = None
        self._idcs_display_name = None
        self._idcs_canonical_value_source_resource_type = None
        self._idcs_canonical_value_source_filter = None
        self._idcs_canonical_value_source_resource_type_id = None
        self._idcs_canonical_value_source_display_attr_name = None
        self._idcs_canonical_value_source_key_attr_name = None
        self._idcs_validate_reference = None
        self._idcs_scim_compliant = None
        self._idcs_attribute_mappable = None
        self._idcs_attribute_cacheable = None
        self._idcsui_order = None
        self._idcsui_regexp = None
        self._idcsui_visible = None
        self._idcsui_widget = None
        self._idcs_value_persisted_in_other_attribute = None
        self._idcs_pii = None
        self._idcs_sanitize = None
        self._idcs_exclude_from_upgrade_patch = None

    @property
    def name(self):
        """
        Gets the name of this SchemaSubAttributes.
        Attribute's name

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The name of this SchemaSubAttributes.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SchemaSubAttributes.
        Attribute's name

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param name: The name of this SchemaSubAttributes.
        :type: str
        """
        self._name = name

    @property
    def idcs_requires_immediate_read_after_write_for_access_flows(self):
        """
        Gets the idcs_requires_immediate_read_after_write_for_access_flows of this SchemaSubAttributes.
        If true, indicates that the attribute value must be written to the home region and requires immediate read-after-write consistency for access flows initiated from a replica region.

        **Added In:** 2209220956

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: never
         - type: boolean


        :return: The idcs_requires_immediate_read_after_write_for_access_flows of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_requires_immediate_read_after_write_for_access_flows

    @idcs_requires_immediate_read_after_write_for_access_flows.setter
    def idcs_requires_immediate_read_after_write_for_access_flows(self, idcs_requires_immediate_read_after_write_for_access_flows):
        """
        Sets the idcs_requires_immediate_read_after_write_for_access_flows of this SchemaSubAttributes.
        If true, indicates that the attribute value must be written to the home region and requires immediate read-after-write consistency for access flows initiated from a replica region.

        **Added In:** 2209220956

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: never
         - type: boolean


        :param idcs_requires_immediate_read_after_write_for_access_flows: The idcs_requires_immediate_read_after_write_for_access_flows of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_requires_immediate_read_after_write_for_access_flows = idcs_requires_immediate_read_after_write_for_access_flows

    @property
    def idcs_requires_write_for_access_flows(self):
        """
        Gets the idcs_requires_write_for_access_flows of this SchemaSubAttributes.
        If true, indicates that the attribute value must be written to the home region for access flows initiated from a replica region.

        **Added In:** 2205120021

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_requires_write_for_access_flows of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_requires_write_for_access_flows

    @idcs_requires_write_for_access_flows.setter
    def idcs_requires_write_for_access_flows(self, idcs_requires_write_for_access_flows):
        """
        Sets the idcs_requires_write_for_access_flows of this SchemaSubAttributes.
        If true, indicates that the attribute value must be written to the home region for access flows initiated from a replica region.

        **Added In:** 2205120021

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_requires_write_for_access_flows: The idcs_requires_write_for_access_flows of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_requires_write_for_access_flows = idcs_requires_write_for_access_flows

    @property
    def idcs_display_name_message_id(self):
        """
        Gets the idcs_display_name_message_id of this SchemaSubAttributes.
        Localized schema attribute display name for use by UI client  for displaying attribute labels

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_display_name_message_id of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_display_name_message_id

    @idcs_display_name_message_id.setter
    def idcs_display_name_message_id(self, idcs_display_name_message_id):
        """
        Sets the idcs_display_name_message_id of this SchemaSubAttributes.
        Localized schema attribute display name for use by UI client  for displaying attribute labels

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_display_name_message_id: The idcs_display_name_message_id of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_display_name_message_id = idcs_display_name_message_id

    @property
    def idcs_rtsa_hide_attribute(self):
        """
        Gets the idcs_rtsa_hide_attribute of this SchemaSubAttributes.
        Specifies if the attributes in this schema can be displayed externally

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_rtsa_hide_attribute of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_rtsa_hide_attribute

    @idcs_rtsa_hide_attribute.setter
    def idcs_rtsa_hide_attribute(self, idcs_rtsa_hide_attribute):
        """
        Sets the idcs_rtsa_hide_attribute of this SchemaSubAttributes.
        Specifies if the attributes in this schema can be displayed externally

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_rtsa_hide_attribute: The idcs_rtsa_hide_attribute of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_rtsa_hide_attribute = idcs_rtsa_hide_attribute

    @property
    def idcs_internal(self):
        """
        Gets the idcs_internal of this SchemaSubAttributes.
        Specifies whether the schema attribute is for internal use only. Internal attributes are not exposed via REST. This attribute overrides mutability for create/update if the request is internal and the attribute internal flag is set to True. This attribute overrides the return attribute while building SCIM response attributes when both the request is internal and the schema attribute is internal.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_internal of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_internal

    @idcs_internal.setter
    def idcs_internal(self, idcs_internal):
        """
        Sets the idcs_internal of this SchemaSubAttributes.
        Specifies whether the schema attribute is for internal use only. Internal attributes are not exposed via REST. This attribute overrides mutability for create/update if the request is internal and the attribute internal flag is set to True. This attribute overrides the return attribute while building SCIM response attributes when both the request is internal and the schema attribute is internal.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_internal: The idcs_internal of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_internal = idcs_internal

    @property
    def type(self):
        """
        Gets the type of this SchemaSubAttributes.
        Attribute's data type--for example, String

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "string", "complex", "boolean", "decimal", "integer", "dateTime", "reference", "binary", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this SchemaSubAttributes.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this SchemaSubAttributes.
        Attribute's data type--for example, String

        **SCIM++ Properties:**
         - caseExact: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param type: The type of this SchemaSubAttributes.
        :type: str
        """
        allowed_values = ["string", "complex", "boolean", "decimal", "integer", "dateTime", "reference", "binary"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def multi_valued(self):
        """
        Gets the multi_valued of this SchemaSubAttributes.
        Indicates the attribute's plurality

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The multi_valued of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._multi_valued

    @multi_valued.setter
    def multi_valued(self, multi_valued):
        """
        Sets the multi_valued of this SchemaSubAttributes.
        Indicates the attribute's plurality

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param multi_valued: The multi_valued of this SchemaSubAttributes.
        :type: bool
        """
        self._multi_valued = multi_valued

    @property
    def description(self):
        """
        Gets the description of this SchemaSubAttributes.
        Attribute's human-readable description

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The description of this SchemaSubAttributes.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SchemaSubAttributes.
        Attribute's human-readable description

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param description: The description of this SchemaSubAttributes.
        :type: str
        """
        self._description = description

    @property
    def required(self):
        """
        Gets the required of this SchemaSubAttributes.
        Specifies if the attribute is required

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The required of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """
        Sets the required of this SchemaSubAttributes.
        Specifies if the attribute is required

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param required: The required of this SchemaSubAttributes.
        :type: bool
        """
        self._required = required

    @property
    def idcs_return_empty_when_null(self):
        """
        Gets the idcs_return_empty_when_null of this SchemaSubAttributes.
        Specifies if the attribute is required

        **Added In:** 2305190132

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_return_empty_when_null of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_return_empty_when_null

    @idcs_return_empty_when_null.setter
    def idcs_return_empty_when_null(self, idcs_return_empty_when_null):
        """
        Sets the idcs_return_empty_when_null of this SchemaSubAttributes.
        Specifies if the attribute is required

        **Added In:** 2305190132

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_return_empty_when_null: The idcs_return_empty_when_null of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_return_empty_when_null = idcs_return_empty_when_null

    @property
    def canonical_values(self):
        """
        Gets the canonical_values of this SchemaSubAttributes.
        A collection of canonical values. Applicable Service Providers MUST specify the canonical types specified in the core schema specification--for example, \\\"work\\\", \\\"home\\\".

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The canonical_values of this SchemaSubAttributes.
        :rtype: list[str]
        """
        return self._canonical_values

    @canonical_values.setter
    def canonical_values(self, canonical_values):
        """
        Sets the canonical_values of this SchemaSubAttributes.
        A collection of canonical values. Applicable Service Providers MUST specify the canonical types specified in the core schema specification--for example, \\\"work\\\", \\\"home\\\".

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param canonical_values: The canonical_values of this SchemaSubAttributes.
        :type: list[str]
        """
        self._canonical_values = canonical_values

    @property
    def idcs_default_value(self):
        """
        Gets the idcs_default_value of this SchemaSubAttributes.
        Specifies the default value for an attribute. The value must be one from canonicalValues if defined.

        **Added In:** 18.1.6

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_default_value of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_default_value

    @idcs_default_value.setter
    def idcs_default_value(self, idcs_default_value):
        """
        Sets the idcs_default_value of this SchemaSubAttributes.
        Specifies the default value for an attribute. The value must be one from canonicalValues if defined.

        **Added In:** 18.1.6

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_default_value: The idcs_default_value of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_default_value = idcs_default_value

    @property
    def case_exact(self):
        """
        Gets the case_exact of this SchemaSubAttributes.
        Specifies if the String attribute is case-sensitive

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The case_exact of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._case_exact

    @case_exact.setter
    def case_exact(self, case_exact):
        """
        Sets the case_exact of this SchemaSubAttributes.
        Specifies if the String attribute is case-sensitive

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param case_exact: The case_exact of this SchemaSubAttributes.
        :type: bool
        """
        self._case_exact = case_exact

    @property
    def mutability(self):
        """
        Gets the mutability of this SchemaSubAttributes.
        Specifies if the attribute is mutable

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "readOnly", "readWrite", "immutable", "writeOnly", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The mutability of this SchemaSubAttributes.
        :rtype: str
        """
        return self._mutability

    @mutability.setter
    def mutability(self, mutability):
        """
        Sets the mutability of this SchemaSubAttributes.
        Specifies if the attribute is mutable

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param mutability: The mutability of this SchemaSubAttributes.
        :type: str
        """
        allowed_values = ["readOnly", "readWrite", "immutable", "writeOnly"]
        if not value_allowed_none_or_none_sentinel(mutability, allowed_values):
            mutability = 'UNKNOWN_ENUM_VALUE'
        self._mutability = mutability

    @property
    def returned(self):
        """
        Gets the returned of this SchemaSubAttributes.
        A single keyword that indicates when an attribute and associated values are returned in response to a GET request or in response to a PUT, POST, or PATCH request

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "always", "never", "default", "request", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The returned of this SchemaSubAttributes.
        :rtype: str
        """
        return self._returned

    @returned.setter
    def returned(self, returned):
        """
        Sets the returned of this SchemaSubAttributes.
        A single keyword that indicates when an attribute and associated values are returned in response to a GET request or in response to a PUT, POST, or PATCH request

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param returned: The returned of this SchemaSubAttributes.
        :type: str
        """
        allowed_values = ["always", "never", "default", "request"]
        if not value_allowed_none_or_none_sentinel(returned, allowed_values):
            returned = 'UNKNOWN_ENUM_VALUE'
        self._returned = returned

    @property
    def idcs_csv_attribute_name(self):
        """
        Gets the idcs_csv_attribute_name of this SchemaSubAttributes.
        The attribute that defines the CSV header name for import/export

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_csv_attribute_name of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_csv_attribute_name

    @idcs_csv_attribute_name.setter
    def idcs_csv_attribute_name(self, idcs_csv_attribute_name):
        """
        Sets the idcs_csv_attribute_name of this SchemaSubAttributes.
        The attribute that defines the CSV header name for import/export

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_csv_attribute_name: The idcs_csv_attribute_name of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_csv_attribute_name = idcs_csv_attribute_name

    @property
    def uniqueness(self):
        """
        Gets the uniqueness of this SchemaSubAttributes.
        A single keyword value that specifies how the Service Provider enforces uniqueness of attribute values. A server MAY reject an invalid value based on uniqueness by returning an HTTP response code of 400 (Bad Request). A client MAY enforce uniqueness on the client side to a greater degree than the Service Provider enforces. For example, a client could make a value unique while the server has a uniqueness of \\\"none\\\".

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "none", "server", "global", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The uniqueness of this SchemaSubAttributes.
        :rtype: str
        """
        return self._uniqueness

    @uniqueness.setter
    def uniqueness(self, uniqueness):
        """
        Sets the uniqueness of this SchemaSubAttributes.
        A single keyword value that specifies how the Service Provider enforces uniqueness of attribute values. A server MAY reject an invalid value based on uniqueness by returning an HTTP response code of 400 (Bad Request). A client MAY enforce uniqueness on the client side to a greater degree than the Service Provider enforces. For example, a client could make a value unique while the server has a uniqueness of \\\"none\\\".

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param uniqueness: The uniqueness of this SchemaSubAttributes.
        :type: str
        """
        allowed_values = ["none", "server", "global"]
        if not value_allowed_none_or_none_sentinel(uniqueness, allowed_values):
            uniqueness = 'UNKNOWN_ENUM_VALUE'
        self._uniqueness = uniqueness

    @property
    def reference_types(self):
        """
        Gets the reference_types of this SchemaSubAttributes.
        The names of the Resource types that may be referenced--for example, User. This is only applicable for attributes that are of the \\\"reference\\\" data type.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The reference_types of this SchemaSubAttributes.
        :rtype: list[str]
        """
        return self._reference_types

    @reference_types.setter
    def reference_types(self, reference_types):
        """
        Sets the reference_types of this SchemaSubAttributes.
        The names of the Resource types that may be referenced--for example, User. This is only applicable for attributes that are of the \\\"reference\\\" data type.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param reference_types: The reference_types of this SchemaSubAttributes.
        :type: list[str]
        """
        self._reference_types = reference_types

    @property
    def idcs_deprecated_since_version(self):
        """
        Gets the idcs_deprecated_since_version of this SchemaSubAttributes.
        Indicates that the schema has been deprecated since version

        **Deprecated Since: 19.3.3**

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_deprecated_since_version of this SchemaSubAttributes.
        :rtype: int
        """
        return self._idcs_deprecated_since_version

    @idcs_deprecated_since_version.setter
    def idcs_deprecated_since_version(self, idcs_deprecated_since_version):
        """
        Sets the idcs_deprecated_since_version of this SchemaSubAttributes.
        Indicates that the schema has been deprecated since version

        **Deprecated Since: 19.3.3**

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :param idcs_deprecated_since_version: The idcs_deprecated_since_version of this SchemaSubAttributes.
        :type: int
        """
        self._idcs_deprecated_since_version = idcs_deprecated_since_version

    @property
    def idcs_added_since_version(self):
        """
        Gets the idcs_added_since_version of this SchemaSubAttributes.
        Indicates that the schema has been added since version

        **Deprecated Since: 19.3.3**

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_added_since_version of this SchemaSubAttributes.
        :rtype: int
        """
        return self._idcs_added_since_version

    @idcs_added_since_version.setter
    def idcs_added_since_version(self, idcs_added_since_version):
        """
        Sets the idcs_added_since_version of this SchemaSubAttributes.
        Indicates that the schema has been added since version

        **Deprecated Since: 19.3.3**

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :param idcs_added_since_version: The idcs_added_since_version of this SchemaSubAttributes.
        :type: int
        """
        self._idcs_added_since_version = idcs_added_since_version

    @property
    def idcs_deprecated_since_release_number(self):
        """
        Gets the idcs_deprecated_since_release_number of this SchemaSubAttributes.
        Indicates that the schema has been deprecated since this release number

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :return: The idcs_deprecated_since_release_number of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_deprecated_since_release_number

    @idcs_deprecated_since_release_number.setter
    def idcs_deprecated_since_release_number(self, idcs_deprecated_since_release_number):
        """
        Sets the idcs_deprecated_since_release_number of this SchemaSubAttributes.
        Indicates that the schema has been deprecated since this release number

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcs_deprecated_since_release_number: The idcs_deprecated_since_release_number of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_deprecated_since_release_number = idcs_deprecated_since_release_number

    @property
    def idcs_added_since_release_number(self):
        """
        Gets the idcs_added_since_release_number of this SchemaSubAttributes.
        Indicates that the schema has been added since this release number

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :return: The idcs_added_since_release_number of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_added_since_release_number

    @idcs_added_since_release_number.setter
    def idcs_added_since_release_number(self, idcs_added_since_release_number):
        """
        Sets the idcs_added_since_release_number of this SchemaSubAttributes.
        Indicates that the schema has been added since this release number

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcs_added_since_release_number: The idcs_added_since_release_number of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_added_since_release_number = idcs_added_since_release_number

    @property
    def idcs_min_length(self):
        """
        Gets the idcs_min_length of this SchemaSubAttributes.
        Specifies the minimum length of this attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_min_length of this SchemaSubAttributes.
        :rtype: int
        """
        return self._idcs_min_length

    @idcs_min_length.setter
    def idcs_min_length(self, idcs_min_length):
        """
        Sets the idcs_min_length of this SchemaSubAttributes.
        Specifies the minimum length of this attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :param idcs_min_length: The idcs_min_length of this SchemaSubAttributes.
        :type: int
        """
        self._idcs_min_length = idcs_min_length

    @property
    def idcs_max_length(self):
        """
        Gets the idcs_max_length of this SchemaSubAttributes.
        Specifies the maximum length of this attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_max_length of this SchemaSubAttributes.
        :rtype: int
        """
        return self._idcs_max_length

    @idcs_max_length.setter
    def idcs_max_length(self, idcs_max_length):
        """
        Sets the idcs_max_length of this SchemaSubAttributes.
        Specifies the maximum length of this attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :param idcs_max_length: The idcs_max_length of this SchemaSubAttributes.
        :type: int
        """
        self._idcs_max_length = idcs_max_length

    @property
    def idcs_min_value(self):
        """
        Gets the idcs_min_value of this SchemaSubAttributes.
        Specifies the minimum value of the integer attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_min_value of this SchemaSubAttributes.
        :rtype: int
        """
        return self._idcs_min_value

    @idcs_min_value.setter
    def idcs_min_value(self, idcs_min_value):
        """
        Sets the idcs_min_value of this SchemaSubAttributes.
        Specifies the minimum value of the integer attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: integer


        :param idcs_min_value: The idcs_min_value of this SchemaSubAttributes.
        :type: int
        """
        self._idcs_min_value = idcs_min_value

    @property
    def idcs_max_value(self):
        """
        Gets the idcs_max_value of this SchemaSubAttributes.
        Specifies the maximum value of the integer attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: integer


        :return: The idcs_max_value of this SchemaSubAttributes.
        :rtype: int
        """
        return self._idcs_max_value

    @idcs_max_value.setter
    def idcs_max_value(self, idcs_max_value):
        """
        Sets the idcs_max_value of this SchemaSubAttributes.
        Specifies the maximum value of the integer attribute

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: integer


        :param idcs_max_value: The idcs_max_value of this SchemaSubAttributes.
        :type: int
        """
        self._idcs_max_value = idcs_max_value

    @property
    def idcs_only_one_value_can_be_true(self):
        """
        Gets the idcs_only_one_value_can_be_true of this SchemaSubAttributes.
        If true, specifies that the sub attribute value can be set to true on one and only one instance of the CMVA.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_only_one_value_can_be_true of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_only_one_value_can_be_true

    @idcs_only_one_value_can_be_true.setter
    def idcs_only_one_value_can_be_true(self, idcs_only_one_value_can_be_true):
        """
        Sets the idcs_only_one_value_can_be_true of this SchemaSubAttributes.
        If true, specifies that the sub attribute value can be set to true on one and only one instance of the CMVA.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_only_one_value_can_be_true: The idcs_only_one_value_can_be_true of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_only_one_value_can_be_true = idcs_only_one_value_can_be_true

    @property
    def idcs_max_values_returned(self):
        """
        Gets the idcs_max_values_returned of this SchemaSubAttributes.
        **SCIM++ Properties:**
        - caseExact: true
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: default
        - type: integer
        - uniqueness: none
        Specify a limit on the number of attribute-values that any caller will receive when requesting a CMVA attribute. If the no of CMVA instances exceeds the limit then Oracle Identity Cloud Service will throw exception. Users can choose to refine the filter on CMVA attribute.


        :return: The idcs_max_values_returned of this SchemaSubAttributes.
        :rtype: int
        """
        return self._idcs_max_values_returned

    @idcs_max_values_returned.setter
    def idcs_max_values_returned(self, idcs_max_values_returned):
        """
        Sets the idcs_max_values_returned of this SchemaSubAttributes.
        **SCIM++ Properties:**
        - caseExact: true
        - multiValued: false
        - mutability: readOnly
        - required: false
        - returned: default
        - type: integer
        - uniqueness: none
        Specify a limit on the number of attribute-values that any caller will receive when requesting a CMVA attribute. If the no of CMVA instances exceeds the limit then Oracle Identity Cloud Service will throw exception. Users can choose to refine the filter on CMVA attribute.


        :param idcs_max_values_returned: The idcs_max_values_returned of this SchemaSubAttributes.
        :type: int
        """
        self._idcs_max_values_returned = idcs_max_values_returned

    @property
    def idcs_one_value_must_be_true(self):
        """
        Gets the idcs_one_value_must_be_true of this SchemaSubAttributes.
        If true, ARM will ensure atleast one of the instances of CMVA has the attribute value set to true.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_one_value_must_be_true of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_one_value_must_be_true

    @idcs_one_value_must_be_true.setter
    def idcs_one_value_must_be_true(self, idcs_one_value_must_be_true):
        """
        Sets the idcs_one_value_must_be_true of this SchemaSubAttributes.
        If true, ARM will ensure atleast one of the instances of CMVA has the attribute value set to true.

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_one_value_must_be_true: The idcs_one_value_must_be_true of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_one_value_must_be_true = idcs_one_value_must_be_true

    @property
    def idcs_ref_resource_attributes(self):
        """
        Gets the idcs_ref_resource_attributes of this SchemaSubAttributes.
        Specifies the directly referenced Resources

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :return: The idcs_ref_resource_attributes of this SchemaSubAttributes.
        :rtype: list[str]
        """
        return self._idcs_ref_resource_attributes

    @idcs_ref_resource_attributes.setter
    def idcs_ref_resource_attributes(self, idcs_ref_resource_attributes):
        """
        Sets the idcs_ref_resource_attributes of this SchemaSubAttributes.
        Specifies the directly referenced Resources

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcs_ref_resource_attributes: The idcs_ref_resource_attributes of this SchemaSubAttributes.
        :type: list[str]
        """
        self._idcs_ref_resource_attributes = idcs_ref_resource_attributes

    @property
    def idcs_indirect_ref_resource_attributes(self):
        """
        Gets the idcs_indirect_ref_resource_attributes of this SchemaSubAttributes.
        Specifies the indirectly referenced Resources

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :return: The idcs_indirect_ref_resource_attributes of this SchemaSubAttributes.
        :rtype: list[str]
        """
        return self._idcs_indirect_ref_resource_attributes

    @idcs_indirect_ref_resource_attributes.setter
    def idcs_indirect_ref_resource_attributes(self, idcs_indirect_ref_resource_attributes):
        """
        Sets the idcs_indirect_ref_resource_attributes of this SchemaSubAttributes.
        Specifies the indirectly referenced Resources

        **SCIM++ Properties:**
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcs_indirect_ref_resource_attributes: The idcs_indirect_ref_resource_attributes of this SchemaSubAttributes.
        :type: list[str]
        """
        self._idcs_indirect_ref_resource_attributes = idcs_indirect_ref_resource_attributes

    @property
    def idcs_value_persisted(self):
        """
        Gets the idcs_value_persisted of this SchemaSubAttributes.
        Specifies whether the sub-attribute of the Resource attribute is persisted

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_value_persisted of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_value_persisted

    @idcs_value_persisted.setter
    def idcs_value_persisted(self, idcs_value_persisted):
        """
        Sets the idcs_value_persisted of this SchemaSubAttributes.
        Specifies whether the sub-attribute of the Resource attribute is persisted

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_value_persisted: The idcs_value_persisted of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_value_persisted = idcs_value_persisted

    @property
    def idcs_sensitive(self):
        """
        Gets the idcs_sensitive of this SchemaSubAttributes.
        Specifiees if the attribute should be encrypted or hashed

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "encrypt", "hash", "hash_sc", "checksum", "none", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_sensitive of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_sensitive

    @idcs_sensitive.setter
    def idcs_sensitive(self, idcs_sensitive):
        """
        Sets the idcs_sensitive of this SchemaSubAttributes.
        Specifiees if the attribute should be encrypted or hashed

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_sensitive: The idcs_sensitive of this SchemaSubAttributes.
        :type: str
        """
        allowed_values = ["encrypt", "hash", "hash_sc", "checksum", "none"]
        if not value_allowed_none_or_none_sentinel(idcs_sensitive, allowed_values):
            idcs_sensitive = 'UNKNOWN_ENUM_VALUE'
        self._idcs_sensitive = idcs_sensitive

    @property
    def idcs_trim_string_value(self):
        """
        Gets the idcs_trim_string_value of this SchemaSubAttributes.
        Trims any leading and trailing blanks from String values. Default is True.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_trim_string_value of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_trim_string_value

    @idcs_trim_string_value.setter
    def idcs_trim_string_value(self, idcs_trim_string_value):
        """
        Sets the idcs_trim_string_value of this SchemaSubAttributes.
        Trims any leading and trailing blanks from String values. Default is True.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :param idcs_trim_string_value: The idcs_trim_string_value of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_trim_string_value = idcs_trim_string_value

    @property
    def idcs_searchable(self):
        """
        Gets the idcs_searchable of this SchemaSubAttributes.
        Specifies whether this attribute can be included in a search filter

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_searchable of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_searchable

    @idcs_searchable.setter
    def idcs_searchable(self, idcs_searchable):
        """
        Sets the idcs_searchable of this SchemaSubAttributes.
        Specifies whether this attribute can be included in a search filter

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_searchable: The idcs_searchable of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_searchable = idcs_searchable

    @property
    def idcs_generated(self):
        """
        Gets the idcs_generated of this SchemaSubAttributes.
        Specifies whether this attribute value was generated

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_generated of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_generated

    @idcs_generated.setter
    def idcs_generated(self, idcs_generated):
        """
        Sets the idcs_generated of this SchemaSubAttributes.
        Specifies whether this attribute value was generated

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_generated: The idcs_generated of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_generated = idcs_generated

    @property
    def idcs_auditable(self):
        """
        Gets the idcs_auditable of this SchemaSubAttributes.
        Specifies whether changes to this attribute value will be audited

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_auditable of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_auditable

    @idcs_auditable.setter
    def idcs_auditable(self, idcs_auditable):
        """
        Sets the idcs_auditable of this SchemaSubAttributes.
        Specifies whether changes to this attribute value will be audited

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_auditable: The idcs_auditable of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_auditable = idcs_auditable

    @property
    def idcs_target_attribute_name(self):
        """
        Gets the idcs_target_attribute_name of this SchemaSubAttributes.
        Target attribute name that this attribute gets mapped to for persistence

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_target_attribute_name of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_target_attribute_name

    @idcs_target_attribute_name.setter
    def idcs_target_attribute_name(self, idcs_target_attribute_name):
        """
        Sets the idcs_target_attribute_name of this SchemaSubAttributes.
        Target attribute name that this attribute gets mapped to for persistence

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_target_attribute_name: The idcs_target_attribute_name of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_target_attribute_name = idcs_target_attribute_name

    @property
    def idcs_target_norm_attribute_name(self):
        """
        Gets the idcs_target_norm_attribute_name of this SchemaSubAttributes.
        Target normalized attribute name that this normalized value of attribute gets mapped to for persistence. Only set for caseExact=false & searchable attributes. Do not use by default.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_target_norm_attribute_name of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_target_norm_attribute_name

    @idcs_target_norm_attribute_name.setter
    def idcs_target_norm_attribute_name(self, idcs_target_norm_attribute_name):
        """
        Sets the idcs_target_norm_attribute_name of this SchemaSubAttributes.
        Target normalized attribute name that this normalized value of attribute gets mapped to for persistence. Only set for caseExact=false & searchable attributes. Do not use by default.

        **Added In:** 19.1.4

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_target_norm_attribute_name: The idcs_target_norm_attribute_name of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_target_norm_attribute_name = idcs_target_norm_attribute_name

    @property
    def idcs_target_attribute_name_to_migrate_from(self):
        """
        Gets the idcs_target_attribute_name_to_migrate_from of this SchemaSubAttributes.
        Old Target attribute name from child table for CSVA attribute prior to migration. This maintains this attribute used to get mapped to for persistence

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_target_attribute_name_to_migrate_from of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_target_attribute_name_to_migrate_from

    @idcs_target_attribute_name_to_migrate_from.setter
    def idcs_target_attribute_name_to_migrate_from(self, idcs_target_attribute_name_to_migrate_from):
        """
        Sets the idcs_target_attribute_name_to_migrate_from of this SchemaSubAttributes.
        Old Target attribute name from child table for CSVA attribute prior to migration. This maintains this attribute used to get mapped to for persistence

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_target_attribute_name_to_migrate_from: The idcs_target_attribute_name_to_migrate_from of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_target_attribute_name_to_migrate_from = idcs_target_attribute_name_to_migrate_from

    @property
    def idcs_target_unique_constraint_name(self):
        """
        Gets the idcs_target_unique_constraint_name of this SchemaSubAttributes.
        Target index name created for this attribute for performance

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_target_unique_constraint_name of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_target_unique_constraint_name

    @idcs_target_unique_constraint_name.setter
    def idcs_target_unique_constraint_name(self, idcs_target_unique_constraint_name):
        """
        Sets the idcs_target_unique_constraint_name of this SchemaSubAttributes.
        Target index name created for this attribute for performance

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_target_unique_constraint_name: The idcs_target_unique_constraint_name of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_target_unique_constraint_name = idcs_target_unique_constraint_name

    @property
    def idcs_to_target_mapper(self):
        """
        Gets the idcs_to_target_mapper of this SchemaSubAttributes.
        Specifies the mapper to use when mapping this attribute value to DataProvider-specific semantics

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_to_target_mapper of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_to_target_mapper

    @idcs_to_target_mapper.setter
    def idcs_to_target_mapper(self, idcs_to_target_mapper):
        """
        Sets the idcs_to_target_mapper of this SchemaSubAttributes.
        Specifies the mapper to use when mapping this attribute value to DataProvider-specific semantics

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_to_target_mapper: The idcs_to_target_mapper of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_to_target_mapper = idcs_to_target_mapper

    @property
    def idcs_from_target_mapper(self):
        """
        Gets the idcs_from_target_mapper of this SchemaSubAttributes.
        Specifies the mapper to use when mapping this attribute value from DataProvider-specific semantics

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_from_target_mapper of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_from_target_mapper

    @idcs_from_target_mapper.setter
    def idcs_from_target_mapper(self, idcs_from_target_mapper):
        """
        Sets the idcs_from_target_mapper of this SchemaSubAttributes.
        Specifies the mapper to use when mapping this attribute value from DataProvider-specific semantics

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_from_target_mapper: The idcs_from_target_mapper of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_from_target_mapper = idcs_from_target_mapper

    @property
    def idcs_display_name(self):
        """
        Gets the idcs_display_name of this SchemaSubAttributes.
        Specifies the user-friendly displayable attribute name or catalog key used for localization

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_display_name of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_display_name

    @idcs_display_name.setter
    def idcs_display_name(self, idcs_display_name):
        """
        Sets the idcs_display_name of this SchemaSubAttributes.
        Specifies the user-friendly displayable attribute name or catalog key used for localization

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_display_name: The idcs_display_name of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_display_name = idcs_display_name

    @property
    def idcs_canonical_value_source_resource_type(self):
        """
        Gets the idcs_canonical_value_source_resource_type of this SchemaSubAttributes.
        Specifies the Resource type to read from for dynamic canonical values

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_canonical_value_source_resource_type of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_canonical_value_source_resource_type

    @idcs_canonical_value_source_resource_type.setter
    def idcs_canonical_value_source_resource_type(self, idcs_canonical_value_source_resource_type):
        """
        Sets the idcs_canonical_value_source_resource_type of this SchemaSubAttributes.
        Specifies the Resource type to read from for dynamic canonical values

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_source_resource_type: The idcs_canonical_value_source_resource_type of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_canonical_value_source_resource_type = idcs_canonical_value_source_resource_type

    @property
    def idcs_canonical_value_source_filter(self):
        """
        Gets the idcs_canonical_value_source_filter of this SchemaSubAttributes.
        Filter to use when getting canonical values for this schema attribute

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_canonical_value_source_filter of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_canonical_value_source_filter

    @idcs_canonical_value_source_filter.setter
    def idcs_canonical_value_source_filter(self, idcs_canonical_value_source_filter):
        """
        Sets the idcs_canonical_value_source_filter of this SchemaSubAttributes.
        Filter to use when getting canonical values for this schema attribute

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_source_filter: The idcs_canonical_value_source_filter of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_canonical_value_source_filter = idcs_canonical_value_source_filter

    @property
    def idcs_canonical_value_source_resource_type_id(self):
        """
        Gets the idcs_canonical_value_source_resource_type_id of this SchemaSubAttributes.
        Specifies the Resource type ID to read from for dynamic canonical values

        **Added In:** 17.4.4

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_canonical_value_source_resource_type_id of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_canonical_value_source_resource_type_id

    @idcs_canonical_value_source_resource_type_id.setter
    def idcs_canonical_value_source_resource_type_id(self, idcs_canonical_value_source_resource_type_id):
        """
        Sets the idcs_canonical_value_source_resource_type_id of this SchemaSubAttributes.
        Specifies the Resource type ID to read from for dynamic canonical values

        **Added In:** 17.4.4

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_source_resource_type_id: The idcs_canonical_value_source_resource_type_id of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_canonical_value_source_resource_type_id = idcs_canonical_value_source_resource_type_id

    @property
    def idcs_canonical_value_source_display_attr_name(self):
        """
        Gets the idcs_canonical_value_source_display_attr_name of this SchemaSubAttributes.
        Display name for the canonical value attribute name.

        **Added In:** 17.4.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_canonical_value_source_display_attr_name of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_canonical_value_source_display_attr_name

    @idcs_canonical_value_source_display_attr_name.setter
    def idcs_canonical_value_source_display_attr_name(self, idcs_canonical_value_source_display_attr_name):
        """
        Sets the idcs_canonical_value_source_display_attr_name of this SchemaSubAttributes.
        Display name for the canonical value attribute name.

        **Added In:** 17.4.4

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_source_display_attr_name: The idcs_canonical_value_source_display_attr_name of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_canonical_value_source_display_attr_name = idcs_canonical_value_source_display_attr_name

    @property
    def idcs_canonical_value_source_key_attr_name(self):
        """
        Gets the idcs_canonical_value_source_key_attr_name of this SchemaSubAttributes.
        Source key attribute for the canonical value.

        **Added In:** 17.4.4

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The idcs_canonical_value_source_key_attr_name of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcs_canonical_value_source_key_attr_name

    @idcs_canonical_value_source_key_attr_name.setter
    def idcs_canonical_value_source_key_attr_name(self, idcs_canonical_value_source_key_attr_name):
        """
        Sets the idcs_canonical_value_source_key_attr_name of this SchemaSubAttributes.
        Source key attribute for the canonical value.

        **Added In:** 17.4.4

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param idcs_canonical_value_source_key_attr_name: The idcs_canonical_value_source_key_attr_name of this SchemaSubAttributes.
        :type: str
        """
        self._idcs_canonical_value_source_key_attr_name = idcs_canonical_value_source_key_attr_name

    @property
    def idcs_validate_reference(self):
        """
        Gets the idcs_validate_reference of this SchemaSubAttributes.
        Validate payload reference value during create, replace, and update. Default is True.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_validate_reference of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_validate_reference

    @idcs_validate_reference.setter
    def idcs_validate_reference(self, idcs_validate_reference):
        """
        Sets the idcs_validate_reference of this SchemaSubAttributes.
        Validate payload reference value during create, replace, and update. Default is True.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_validate_reference: The idcs_validate_reference of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_validate_reference = idcs_validate_reference

    @property
    def idcs_scim_compliant(self):
        """
        Gets the idcs_scim_compliant of this SchemaSubAttributes.
        Indicates if the attribute is scim compliant, default is true

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_scim_compliant of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_scim_compliant

    @idcs_scim_compliant.setter
    def idcs_scim_compliant(self, idcs_scim_compliant):
        """
        Sets the idcs_scim_compliant of this SchemaSubAttributes.
        Indicates if the attribute is scim compliant, default is true

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :param idcs_scim_compliant: The idcs_scim_compliant of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_scim_compliant = idcs_scim_compliant

    @property
    def idcs_attribute_mappable(self):
        """
        Gets the idcs_attribute_mappable of this SchemaSubAttributes.
        Specifies if the attribute can be used for mapping with external identity sources such as AD or LDAP. If isSchemaMappable: false for the schema in which this attribute is defined, then this flag is ignored.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_attribute_mappable of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_attribute_mappable

    @idcs_attribute_mappable.setter
    def idcs_attribute_mappable(self, idcs_attribute_mappable):
        """
        Sets the idcs_attribute_mappable of this SchemaSubAttributes.
        Specifies if the attribute can be used for mapping with external identity sources such as AD or LDAP. If isSchemaMappable: false for the schema in which this attribute is defined, then this flag is ignored.

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :param idcs_attribute_mappable: The idcs_attribute_mappable of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_attribute_mappable = idcs_attribute_mappable

    @property
    def idcs_attribute_cacheable(self):
        """
        Gets the idcs_attribute_cacheable of this SchemaSubAttributes.
        Specifies whether the attribute is cacheable. True by default for all attributes. If attribute with idcsAttributeCachable = false, is present \\\"attributesToGet\\\" while executing GET/SEARCH on cacheable resource, Cache is missed and data is fetched from Data Provider.

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_attribute_cacheable of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_attribute_cacheable

    @idcs_attribute_cacheable.setter
    def idcs_attribute_cacheable(self, idcs_attribute_cacheable):
        """
        Sets the idcs_attribute_cacheable of this SchemaSubAttributes.
        Specifies whether the attribute is cacheable. True by default for all attributes. If attribute with idcsAttributeCachable = false, is present \\\"attributesToGet\\\" while executing GET/SEARCH on cacheable resource, Cache is missed and data is fetched from Data Provider.

        **Added In:** 17.3.4

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_attribute_cacheable: The idcs_attribute_cacheable of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_attribute_cacheable = idcs_attribute_cacheable

    @property
    def idcsui_order(self):
        """
        Gets the idcsui_order of this SchemaSubAttributes.
        Metadata used by Oracle Identity Cloud Service UI to sequence the attributes displayed on the Account Form.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :return: The idcsui_order of this SchemaSubAttributes.
        :rtype: int
        """
        return self._idcsui_order

    @idcsui_order.setter
    def idcsui_order(self, idcsui_order):
        """
        Sets the idcsui_order of this SchemaSubAttributes.
        Metadata used by Oracle Identity Cloud Service UI to sequence the attributes displayed on the Account Form.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer


        :param idcsui_order: The idcsui_order of this SchemaSubAttributes.
        :type: int
        """
        self._idcsui_order = idcsui_order

    @property
    def idcsui_regexp(self):
        """
        Gets the idcsui_regexp of this SchemaSubAttributes.
        Metadata used by Oracle Identity Cloud Service UI to validate the attribute values using regular expressions.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :return: The idcsui_regexp of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcsui_regexp

    @idcsui_regexp.setter
    def idcsui_regexp(self, idcsui_regexp):
        """
        Sets the idcsui_regexp of this SchemaSubAttributes.
        Metadata used by Oracle Identity Cloud Service UI to validate the attribute values using regular expressions.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcsui_regexp: The idcsui_regexp of this SchemaSubAttributes.
        :type: str
        """
        self._idcsui_regexp = idcsui_regexp

    @property
    def idcsui_visible(self):
        """
        Gets the idcsui_visible of this SchemaSubAttributes.
        Metadata used by Oracle Identity Cloud Service UI to decide whether the attribute must be displayed on the Account Form.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcsui_visible of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcsui_visible

    @idcsui_visible.setter
    def idcsui_visible(self, idcsui_visible):
        """
        Sets the idcsui_visible of this SchemaSubAttributes.
        Metadata used by Oracle Identity Cloud Service UI to decide whether the attribute must be displayed on the Account Form.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcsui_visible: The idcsui_visible of this SchemaSubAttributes.
        :type: bool
        """
        self._idcsui_visible = idcsui_visible

    @property
    def idcsui_widget(self):
        """
        Gets the idcsui_widget of this SchemaSubAttributes.
        Metadata used by Oracle Identity Cloud Service UI to render a widget for this attribute on the Account Form.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string

        Allowed values for this property are: "inputtext", "checkbox", "textarea", "combobox", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcsui_widget of this SchemaSubAttributes.
        :rtype: str
        """
        return self._idcsui_widget

    @idcsui_widget.setter
    def idcsui_widget(self, idcsui_widget):
        """
        Sets the idcsui_widget of this SchemaSubAttributes.
        Metadata used by Oracle Identity Cloud Service UI to render a widget for this attribute on the Account Form.

        **Added In:** 17.4.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string


        :param idcsui_widget: The idcsui_widget of this SchemaSubAttributes.
        :type: str
        """
        allowed_values = ["inputtext", "checkbox", "textarea", "combobox"]
        if not value_allowed_none_or_none_sentinel(idcsui_widget, allowed_values):
            idcsui_widget = 'UNKNOWN_ENUM_VALUE'
        self._idcsui_widget = idcsui_widget

    @property
    def idcs_value_persisted_in_other_attribute(self):
        """
        Gets the idcs_value_persisted_in_other_attribute of this SchemaSubAttributes.
        If true, ARM should not validate the value of the attribute since it will be converted/migrated to another attribute internally by the manager which will build valid post, put, or patch payload, depending on the client requested operation

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_value_persisted_in_other_attribute of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_value_persisted_in_other_attribute

    @idcs_value_persisted_in_other_attribute.setter
    def idcs_value_persisted_in_other_attribute(self, idcs_value_persisted_in_other_attribute):
        """
        Sets the idcs_value_persisted_in_other_attribute of this SchemaSubAttributes.
        If true, ARM should not validate the value of the attribute since it will be converted/migrated to another attribute internally by the manager which will build valid post, put, or patch payload, depending on the client requested operation

        **Added In:** 18.2.2

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean


        :param idcs_value_persisted_in_other_attribute: The idcs_value_persisted_in_other_attribute of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_value_persisted_in_other_attribute = idcs_value_persisted_in_other_attribute

    @property
    def idcs_pii(self):
        """
        Gets the idcs_pii of this SchemaSubAttributes.
        Specifies whether the attribute is PII (personal information). False by default for all attributes. If attribute with idcsPii = true, it's value must be obfuscated before it's written to the Oracle Identity Cloud Service system logs.

        **Added In:** 18.3.6

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :return: The idcs_pii of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_pii

    @idcs_pii.setter
    def idcs_pii(self, idcs_pii):
        """
        Sets the idcs_pii of this SchemaSubAttributes.
        Specifies whether the attribute is PII (personal information). False by default for all attributes. If attribute with idcsPii = true, it's value must be obfuscated before it's written to the Oracle Identity Cloud Service system logs.

        **Added In:** 18.3.6

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean


        :param idcs_pii: The idcs_pii of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_pii = idcs_pii

    @property
    def idcs_sanitize(self):
        """
        Gets the idcs_sanitize of this SchemaSubAttributes.
        Specifies if the value of the attribute should be sanitized using OWASP library for HTML content

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The idcs_sanitize of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_sanitize

    @idcs_sanitize.setter
    def idcs_sanitize(self, idcs_sanitize):
        """
        Sets the idcs_sanitize of this SchemaSubAttributes.
        Specifies if the value of the attribute should be sanitized using OWASP library for HTML content

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param idcs_sanitize: The idcs_sanitize of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_sanitize = idcs_sanitize

    @property
    def idcs_exclude_from_upgrade_patch(self):
        """
        Gets the idcs_exclude_from_upgrade_patch of this SchemaSubAttributes.
        Specifies whether the attribute should be excluded from the BulkApi patch generated by gradle task for upgrading OOTB resources.

        **Added In:** 2104150946

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: never
         - type: boolean


        :return: The idcs_exclude_from_upgrade_patch of this SchemaSubAttributes.
        :rtype: bool
        """
        return self._idcs_exclude_from_upgrade_patch

    @idcs_exclude_from_upgrade_patch.setter
    def idcs_exclude_from_upgrade_patch(self, idcs_exclude_from_upgrade_patch):
        """
        Sets the idcs_exclude_from_upgrade_patch of this SchemaSubAttributes.
        Specifies whether the attribute should be excluded from the BulkApi patch generated by gradle task for upgrading OOTB resources.

        **Added In:** 2104150946

        **SCIM++ Properties:**
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: never
         - type: boolean


        :param idcs_exclude_from_upgrade_patch: The idcs_exclude_from_upgrade_patch of this SchemaSubAttributes.
        :type: bool
        """
        self._idcs_exclude_from_upgrade_patch = idcs_exclude_from_upgrade_patch

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
