# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NotificationSettingsEventSettings(object):
    """
    Event settings
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NotificationSettingsEventSettings object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param event_id:
            The value to assign to the event_id property of this NotificationSettingsEventSettings.
        :type event_id: str

        :param enabled:
            The value to assign to the enabled property of this NotificationSettingsEventSettings.
        :type enabled: bool

        """
        self.swagger_types = {
            'event_id': 'str',
            'enabled': 'bool'
        }

        self.attribute_map = {
            'event_id': 'eventId',
            'enabled': 'enabled'
        }

        self._event_id = None
        self._enabled = None

    @property
    def event_id(self):
        """
        **[Required]** Gets the event_id of this NotificationSettingsEventSettings.
        IDCS-generated event

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The event_id of this NotificationSettingsEventSettings.
        :rtype: str
        """
        return self._event_id

    @event_id.setter
    def event_id(self, event_id):
        """
        Sets the event_id of this NotificationSettingsEventSettings.
        IDCS-generated event

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param event_id: The event_id of this NotificationSettingsEventSettings.
        :type: str
        """
        self._event_id = event_id

    @property
    def enabled(self):
        """
        Gets the enabled of this NotificationSettingsEventSettings.
        Specify if notifications are enabled for the event

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The enabled of this NotificationSettingsEventSettings.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this NotificationSettingsEventSettings.
        Specify if notifications are enabled for the event

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param enabled: The enabled of this NotificationSettingsEventSettings.
        :type: bool
        """
        self._enabled = enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
