# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IdentityPropagationTrust(object):
    """
    Schema used for Identity Propagation Trust.
    """

    #: A constant which can be used with the idcs_prevented_operations property of a IdentityPropagationTrust.
    #: This constant has a value of "replace"
    IDCS_PREVENTED_OPERATIONS_REPLACE = "replace"

    #: A constant which can be used with the idcs_prevented_operations property of a IdentityPropagationTrust.
    #: This constant has a value of "update"
    IDCS_PREVENTED_OPERATIONS_UPDATE = "update"

    #: A constant which can be used with the idcs_prevented_operations property of a IdentityPropagationTrust.
    #: This constant has a value of "delete"
    IDCS_PREVENTED_OPERATIONS_DELETE = "delete"

    #: A constant which can be used with the type property of a IdentityPropagationTrust.
    #: This constant has a value of "JWT"
    TYPE_JWT = "JWT"

    #: A constant which can be used with the type property of a IdentityPropagationTrust.
    #: This constant has a value of "SAML"
    TYPE_SAML = "SAML"

    #: A constant which can be used with the type property of a IdentityPropagationTrust.
    #: This constant has a value of "SPNEGO"
    TYPE_SPNEGO = "SPNEGO"

    #: A constant which can be used with the type property of a IdentityPropagationTrust.
    #: This constant has a value of "AWS"
    TYPE_AWS = "AWS"

    #: A constant which can be used with the subject_type property of a IdentityPropagationTrust.
    #: This constant has a value of "User"
    SUBJECT_TYPE_USER = "User"

    #: A constant which can be used with the subject_type property of a IdentityPropagationTrust.
    #: This constant has a value of "App"
    SUBJECT_TYPE_APP = "App"

    def __init__(self, **kwargs):
        """
        Initializes a new IdentityPropagationTrust object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this IdentityPropagationTrust.
        :type id: str

        :param ocid:
            The value to assign to the ocid property of this IdentityPropagationTrust.
        :type ocid: str

        :param schemas:
            The value to assign to the schemas property of this IdentityPropagationTrust.
        :type schemas: list[str]

        :param meta:
            The value to assign to the meta property of this IdentityPropagationTrust.
        :type meta: oci.identity_domains.models.Meta

        :param idcs_created_by:
            The value to assign to the idcs_created_by property of this IdentityPropagationTrust.
        :type idcs_created_by: oci.identity_domains.models.IdcsCreatedBy

        :param idcs_last_modified_by:
            The value to assign to the idcs_last_modified_by property of this IdentityPropagationTrust.
        :type idcs_last_modified_by: oci.identity_domains.models.IdcsLastModifiedBy

        :param idcs_prevented_operations:
            The value to assign to the idcs_prevented_operations property of this IdentityPropagationTrust.
            Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_prevented_operations: list[str]

        :param tags:
            The value to assign to the tags property of this IdentityPropagationTrust.
        :type tags: list[oci.identity_domains.models.Tags]

        :param delete_in_progress:
            The value to assign to the delete_in_progress property of this IdentityPropagationTrust.
        :type delete_in_progress: bool

        :param idcs_last_upgraded_in_release:
            The value to assign to the idcs_last_upgraded_in_release property of this IdentityPropagationTrust.
        :type idcs_last_upgraded_in_release: str

        :param domain_ocid:
            The value to assign to the domain_ocid property of this IdentityPropagationTrust.
        :type domain_ocid: str

        :param compartment_ocid:
            The value to assign to the compartment_ocid property of this IdentityPropagationTrust.
        :type compartment_ocid: str

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this IdentityPropagationTrust.
        :type tenancy_ocid: str

        :param name:
            The value to assign to the name property of this IdentityPropagationTrust.
        :type name: str

        :param description:
            The value to assign to the description property of this IdentityPropagationTrust.
        :type description: str

        :param type:
            The value to assign to the type property of this IdentityPropagationTrust.
            Allowed values for this property are: "JWT", "SAML", "SPNEGO", "AWS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param issuer:
            The value to assign to the issuer property of this IdentityPropagationTrust.
        :type issuer: str

        :param account_id:
            The value to assign to the account_id property of this IdentityPropagationTrust.
        :type account_id: str

        :param subject_claim_name:
            The value to assign to the subject_claim_name property of this IdentityPropagationTrust.
        :type subject_claim_name: str

        :param subject_mapping_attribute:
            The value to assign to the subject_mapping_attribute property of this IdentityPropagationTrust.
        :type subject_mapping_attribute: str

        :param subject_type:
            The value to assign to the subject_type property of this IdentityPropagationTrust.
            Allowed values for this property are: "User", "App", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type subject_type: str

        :param client_claim_name:
            The value to assign to the client_claim_name property of this IdentityPropagationTrust.
        :type client_claim_name: str

        :param client_claim_values:
            The value to assign to the client_claim_values property of this IdentityPropagationTrust.
        :type client_claim_values: list[str]

        :param active:
            The value to assign to the active property of this IdentityPropagationTrust.
        :type active: bool

        :param public_key_endpoint:
            The value to assign to the public_key_endpoint property of this IdentityPropagationTrust.
        :type public_key_endpoint: str

        :param public_certificate:
            The value to assign to the public_certificate property of this IdentityPropagationTrust.
        :type public_certificate: str

        :param oauth_clients:
            The value to assign to the oauth_clients property of this IdentityPropagationTrust.
        :type oauth_clients: list[str]

        :param service_principals:
            The value to assign to the service_principals property of this IdentityPropagationTrust.
        :type service_principals: list[str]

        :param allow_impersonation:
            The value to assign to the allow_impersonation property of this IdentityPropagationTrust.
        :type allow_impersonation: bool

        :param clock_skew_seconds:
            The value to assign to the clock_skew_seconds property of this IdentityPropagationTrust.
        :type clock_skew_seconds: int

        :param impersonation_service_users:
            The value to assign to the impersonation_service_users property of this IdentityPropagationTrust.
        :type impersonation_service_users: list[oci.identity_domains.models.IdentityPropagationTrustImpersonationServiceUsers]

        :param keytab:
            The value to assign to the keytab property of this IdentityPropagationTrust.
        :type keytab: oci.identity_domains.models.IdentityPropagationTrustKeytab

        """
        self.swagger_types = {
            'id': 'str',
            'ocid': 'str',
            'schemas': 'list[str]',
            'meta': 'Meta',
            'idcs_created_by': 'IdcsCreatedBy',
            'idcs_last_modified_by': 'IdcsLastModifiedBy',
            'idcs_prevented_operations': 'list[str]',
            'tags': 'list[Tags]',
            'delete_in_progress': 'bool',
            'idcs_last_upgraded_in_release': 'str',
            'domain_ocid': 'str',
            'compartment_ocid': 'str',
            'tenancy_ocid': 'str',
            'name': 'str',
            'description': 'str',
            'type': 'str',
            'issuer': 'str',
            'account_id': 'str',
            'subject_claim_name': 'str',
            'subject_mapping_attribute': 'str',
            'subject_type': 'str',
            'client_claim_name': 'str',
            'client_claim_values': 'list[str]',
            'active': 'bool',
            'public_key_endpoint': 'str',
            'public_certificate': 'str',
            'oauth_clients': 'list[str]',
            'service_principals': 'list[str]',
            'allow_impersonation': 'bool',
            'clock_skew_seconds': 'int',
            'impersonation_service_users': 'list[IdentityPropagationTrustImpersonationServiceUsers]',
            'keytab': 'IdentityPropagationTrustKeytab'
        }

        self.attribute_map = {
            'id': 'id',
            'ocid': 'ocid',
            'schemas': 'schemas',
            'meta': 'meta',
            'idcs_created_by': 'idcsCreatedBy',
            'idcs_last_modified_by': 'idcsLastModifiedBy',
            'idcs_prevented_operations': 'idcsPreventedOperations',
            'tags': 'tags',
            'delete_in_progress': 'deleteInProgress',
            'idcs_last_upgraded_in_release': 'idcsLastUpgradedInRelease',
            'domain_ocid': 'domainOcid',
            'compartment_ocid': 'compartmentOcid',
            'tenancy_ocid': 'tenancyOcid',
            'name': 'name',
            'description': 'description',
            'type': 'type',
            'issuer': 'issuer',
            'account_id': 'accountId',
            'subject_claim_name': 'subjectClaimName',
            'subject_mapping_attribute': 'subjectMappingAttribute',
            'subject_type': 'subjectType',
            'client_claim_name': 'clientClaimName',
            'client_claim_values': 'clientClaimValues',
            'active': 'active',
            'public_key_endpoint': 'publicKeyEndpoint',
            'public_certificate': 'publicCertificate',
            'oauth_clients': 'oauthClients',
            'service_principals': 'servicePrincipals',
            'allow_impersonation': 'allowImpersonation',
            'clock_skew_seconds': 'clockSkewSeconds',
            'impersonation_service_users': 'impersonationServiceUsers',
            'keytab': 'keytab'
        }

        self._id = None
        self._ocid = None
        self._schemas = None
        self._meta = None
        self._idcs_created_by = None
        self._idcs_last_modified_by = None
        self._idcs_prevented_operations = None
        self._tags = None
        self._delete_in_progress = None
        self._idcs_last_upgraded_in_release = None
        self._domain_ocid = None
        self._compartment_ocid = None
        self._tenancy_ocid = None
        self._name = None
        self._description = None
        self._type = None
        self._issuer = None
        self._account_id = None
        self._subject_claim_name = None
        self._subject_mapping_attribute = None
        self._subject_type = None
        self._client_claim_name = None
        self._client_claim_values = None
        self._active = None
        self._public_key_endpoint = None
        self._public_certificate = None
        self._oauth_clients = None
        self._service_principals = None
        self._allow_impersonation = None
        self._clock_skew_seconds = None
        self._impersonation_service_users = None
        self._keytab = None

    @property
    def id(self):
        """
        Gets the id of this IdentityPropagationTrust.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :return: The id of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this IdentityPropagationTrust.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :param id: The id of this IdentityPropagationTrust.
        :type: str
        """
        self._id = id

    @property
    def ocid(self):
        """
        Gets the ocid of this IdentityPropagationTrust.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :return: The ocid of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this IdentityPropagationTrust.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :param ocid: The ocid of this IdentityPropagationTrust.
        :type: str
        """
        self._ocid = ocid

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this IdentityPropagationTrust.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The schemas of this IdentityPropagationTrust.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this IdentityPropagationTrust.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param schemas: The schemas of this IdentityPropagationTrust.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def meta(self):
        """
        Gets the meta of this IdentityPropagationTrust.

        :return: The meta of this IdentityPropagationTrust.
        :rtype: oci.identity_domains.models.Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Sets the meta of this IdentityPropagationTrust.

        :param meta: The meta of this IdentityPropagationTrust.
        :type: oci.identity_domains.models.Meta
        """
        self._meta = meta

    @property
    def idcs_created_by(self):
        """
        Gets the idcs_created_by of this IdentityPropagationTrust.

        :return: The idcs_created_by of this IdentityPropagationTrust.
        :rtype: oci.identity_domains.models.IdcsCreatedBy
        """
        return self._idcs_created_by

    @idcs_created_by.setter
    def idcs_created_by(self, idcs_created_by):
        """
        Sets the idcs_created_by of this IdentityPropagationTrust.

        :param idcs_created_by: The idcs_created_by of this IdentityPropagationTrust.
        :type: oci.identity_domains.models.IdcsCreatedBy
        """
        self._idcs_created_by = idcs_created_by

    @property
    def idcs_last_modified_by(self):
        """
        Gets the idcs_last_modified_by of this IdentityPropagationTrust.

        :return: The idcs_last_modified_by of this IdentityPropagationTrust.
        :rtype: oci.identity_domains.models.IdcsLastModifiedBy
        """
        return self._idcs_last_modified_by

    @idcs_last_modified_by.setter
    def idcs_last_modified_by(self, idcs_last_modified_by):
        """
        Sets the idcs_last_modified_by of this IdentityPropagationTrust.

        :param idcs_last_modified_by: The idcs_last_modified_by of this IdentityPropagationTrust.
        :type: oci.identity_domains.models.IdcsLastModifiedBy
        """
        self._idcs_last_modified_by = idcs_last_modified_by

    @property
    def idcs_prevented_operations(self):
        """
        Gets the idcs_prevented_operations of this IdentityPropagationTrust.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_prevented_operations of this IdentityPropagationTrust.
        :rtype: list[str]
        """
        return self._idcs_prevented_operations

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, idcs_prevented_operations):
        """
        Sets the idcs_prevented_operations of this IdentityPropagationTrust.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_prevented_operations: The idcs_prevented_operations of this IdentityPropagationTrust.
        :type: list[str]
        """
        allowed_values = ["replace", "update", "delete"]
        if idcs_prevented_operations:
            idcs_prevented_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_prevented_operations]
        self._idcs_prevented_operations = idcs_prevented_operations

    @property
    def tags(self):
        """
        Gets the tags of this IdentityPropagationTrust.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The tags of this IdentityPropagationTrust.
        :rtype: list[oci.identity_domains.models.Tags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this IdentityPropagationTrust.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param tags: The tags of this IdentityPropagationTrust.
        :type: list[oci.identity_domains.models.Tags]
        """
        self._tags = tags

    @property
    def delete_in_progress(self):
        """
        Gets the delete_in_progress of this IdentityPropagationTrust.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The delete_in_progress of this IdentityPropagationTrust.
        :rtype: bool
        """
        return self._delete_in_progress

    @delete_in_progress.setter
    def delete_in_progress(self, delete_in_progress):
        """
        Sets the delete_in_progress of this IdentityPropagationTrust.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param delete_in_progress: The delete_in_progress of this IdentityPropagationTrust.
        :type: bool
        """
        self._delete_in_progress = delete_in_progress

    @property
    def idcs_last_upgraded_in_release(self):
        """
        Gets the idcs_last_upgraded_in_release of this IdentityPropagationTrust.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The idcs_last_upgraded_in_release of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._idcs_last_upgraded_in_release

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, idcs_last_upgraded_in_release):
        """
        Sets the idcs_last_upgraded_in_release of this IdentityPropagationTrust.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_last_upgraded_in_release: The idcs_last_upgraded_in_release of this IdentityPropagationTrust.
        :type: str
        """
        self._idcs_last_upgraded_in_release = idcs_last_upgraded_in_release

    @property
    def domain_ocid(self):
        """
        Gets the domain_ocid of this IdentityPropagationTrust.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The domain_ocid of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._domain_ocid

    @domain_ocid.setter
    def domain_ocid(self, domain_ocid):
        """
        Sets the domain_ocid of this IdentityPropagationTrust.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param domain_ocid: The domain_ocid of this IdentityPropagationTrust.
        :type: str
        """
        self._domain_ocid = domain_ocid

    @property
    def compartment_ocid(self):
        """
        Gets the compartment_ocid of this IdentityPropagationTrust.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The compartment_ocid of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._compartment_ocid

    @compartment_ocid.setter
    def compartment_ocid(self, compartment_ocid):
        """
        Sets the compartment_ocid of this IdentityPropagationTrust.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param compartment_ocid: The compartment_ocid of this IdentityPropagationTrust.
        :type: str
        """
        self._compartment_ocid = compartment_ocid

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this IdentityPropagationTrust.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The tenancy_ocid of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this IdentityPropagationTrust.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param tenancy_ocid: The tenancy_ocid of this IdentityPropagationTrust.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def name(self):
        """
        **[Required]** Gets the name of this IdentityPropagationTrust.
        The name of the the Identity Propagation Trust.

        **SCIM++ Properties:**
         - type: string
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - required: true
         - mutability: immutable
         - returned: default
         - uniqueness: none


        :return: The name of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this IdentityPropagationTrust.
        The name of the the Identity Propagation Trust.

        **SCIM++ Properties:**
         - type: string
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - required: true
         - mutability: immutable
         - returned: default
         - uniqueness: none


        :param name: The name of this IdentityPropagationTrust.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this IdentityPropagationTrust.
        The description of the Identity Propagation Trust.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: false
         - idcsSearchable: false


        :return: The description of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this IdentityPropagationTrust.
        The description of the Identity Propagation Trust.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: false
         - idcsSearchable: false


        :param description: The description of this IdentityPropagationTrust.
        :type: str
        """
        self._description = description

    @property
    def type(self):
        """
        **[Required]** Gets the type of this IdentityPropagationTrust.
        The type of the inbound token from the Identity cloud provider.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - required: true
         - mutability: readWrite
         - returned: default
         - type: string
         - multiValued: false
         - uniqueness: none

        Allowed values for this property are: "JWT", "SAML", "SPNEGO", "AWS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this IdentityPropagationTrust.
        The type of the inbound token from the Identity cloud provider.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - required: true
         - mutability: readWrite
         - returned: default
         - type: string
         - multiValued: false
         - uniqueness: none


        :param type: The type of this IdentityPropagationTrust.
        :type: str
        """
        allowed_values = ["JWT", "SAML", "SPNEGO", "AWS"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def issuer(self):
        """
        **[Required]** Gets the issuer of this IdentityPropagationTrust.
        The issuer claim of the Identity provider.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: true
         - mutability: readWrite
         - returned: always
         - caseExact: true
         - idcsSearchable: true
         - uniqueness: server


        :return: The issuer of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._issuer

    @issuer.setter
    def issuer(self, issuer):
        """
        Sets the issuer of this IdentityPropagationTrust.
        The issuer claim of the Identity provider.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: true
         - mutability: readWrite
         - returned: always
         - caseExact: true
         - idcsSearchable: true
         - uniqueness: server


        :param issuer: The issuer of this IdentityPropagationTrust.
        :type: str
        """
        self._issuer = issuer

    @property
    def account_id(self):
        """
        Gets the account_id of this IdentityPropagationTrust.
        The Identity cloud provider service identifier, for example, the Azure Tenancy ID, AWS Account ID, or GCP Project ID.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - caseExact: true
         - idcsSearchable: true
         - uniqueness: none


        :return: The account_id of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """
        Sets the account_id of this IdentityPropagationTrust.
        The Identity cloud provider service identifier, for example, the Azure Tenancy ID, AWS Account ID, or GCP Project ID.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - caseExact: true
         - idcsSearchable: true
         - uniqueness: none


        :param account_id: The account_id of this IdentityPropagationTrust.
        :type: str
        """
        self._account_id = account_id

    @property
    def subject_claim_name(self):
        """
        Gets the subject_claim_name of this IdentityPropagationTrust.
        Used for locating the subject claim from the incoming token.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: true
         - idcsSearchable: false


        :return: The subject_claim_name of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._subject_claim_name

    @subject_claim_name.setter
    def subject_claim_name(self, subject_claim_name):
        """
        Sets the subject_claim_name of this IdentityPropagationTrust.
        Used for locating the subject claim from the incoming token.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: true
         - idcsSearchable: false


        :param subject_claim_name: The subject_claim_name of this IdentityPropagationTrust.
        :type: str
        """
        self._subject_claim_name = subject_claim_name

    @property
    def subject_mapping_attribute(self):
        """
        Gets the subject_mapping_attribute of this IdentityPropagationTrust.
        Subject Mapping Attribute to which the value from subject claim name value would be used for identity lookup.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - idcsSearchable: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none


        :return: The subject_mapping_attribute of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._subject_mapping_attribute

    @subject_mapping_attribute.setter
    def subject_mapping_attribute(self, subject_mapping_attribute):
        """
        Sets the subject_mapping_attribute of this IdentityPropagationTrust.
        Subject Mapping Attribute to which the value from subject claim name value would be used for identity lookup.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - idcsSearchable: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none


        :param subject_mapping_attribute: The subject_mapping_attribute of this IdentityPropagationTrust.
        :type: str
        """
        self._subject_mapping_attribute = subject_mapping_attribute

    @property
    def subject_type(self):
        """
        Gets the subject_type of this IdentityPropagationTrust.
        The type of the resource against which lookup will be made in the identity domain in IAM for the incoming subject claim value.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none

        Allowed values for this property are: "User", "App", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The subject_type of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._subject_type

    @subject_type.setter
    def subject_type(self, subject_type):
        """
        Sets the subject_type of this IdentityPropagationTrust.
        The type of the resource against which lookup will be made in the identity domain in IAM for the incoming subject claim value.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param subject_type: The subject_type of this IdentityPropagationTrust.
        :type: str
        """
        allowed_values = ["User", "App"]
        if not value_allowed_none_or_none_sentinel(subject_type, allowed_values):
            subject_type = 'UNKNOWN_ENUM_VALUE'
        self._subject_type = subject_type

    @property
    def client_claim_name(self):
        """
        Gets the client_claim_name of this IdentityPropagationTrust.
        The claim name that identifies to whom the JWT/SAML token is issued. If AWS, then \\\"aud\\\" or \\\"client_id\\\". If Azure, then \\\"appid\\\". If GCP, then \\\"aud\\\".

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - idcsSearchable: false


        :return: The client_claim_name of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._client_claim_name

    @client_claim_name.setter
    def client_claim_name(self, client_claim_name):
        """
        Sets the client_claim_name of this IdentityPropagationTrust.
        The claim name that identifies to whom the JWT/SAML token is issued. If AWS, then \\\"aud\\\" or \\\"client_id\\\". If Azure, then \\\"appid\\\". If GCP, then \\\"aud\\\".

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - idcsSearchable: false


        :param client_claim_name: The client_claim_name of this IdentityPropagationTrust.
        :type: str
        """
        self._client_claim_name = client_claim_name

    @property
    def client_claim_values(self):
        """
        Gets the client_claim_values of this IdentityPropagationTrust.
        The value that corresponds to the client claim name used to identify to whom the token is issued.

        **SCIM++ Properties:**
         - type: string
         - multiValued: true
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: true
         - idcsSearchable: false


        :return: The client_claim_values of this IdentityPropagationTrust.
        :rtype: list[str]
        """
        return self._client_claim_values

    @client_claim_values.setter
    def client_claim_values(self, client_claim_values):
        """
        Sets the client_claim_values of this IdentityPropagationTrust.
        The value that corresponds to the client claim name used to identify to whom the token is issued.

        **SCIM++ Properties:**
         - type: string
         - multiValued: true
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: true
         - idcsSearchable: false


        :param client_claim_values: The client_claim_values of this IdentityPropagationTrust.
        :type: list[str]
        """
        self._client_claim_values = client_claim_values

    @property
    def active(self):
        """
        Gets the active of this IdentityPropagationTrust.
        If true, specifies that this Identity Propagation Trust is in an enabled state. The default value is false.

        **SCIM++ Properties:**
         - type: boolean
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - idcsSearchable: true


        :return: The active of this IdentityPropagationTrust.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this IdentityPropagationTrust.
        If true, specifies that this Identity Propagation Trust is in an enabled state. The default value is false.

        **SCIM++ Properties:**
         - type: boolean
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - idcsSearchable: true


        :param active: The active of this IdentityPropagationTrust.
        :type: bool
        """
        self._active = active

    @property
    def public_key_endpoint(self):
        """
        Gets the public_key_endpoint of this IdentityPropagationTrust.
        The cloud provider's public key API of SAML and OIDC providers for signature validation.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: false
         - idcsSearchable: false


        :return: The public_key_endpoint of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._public_key_endpoint

    @public_key_endpoint.setter
    def public_key_endpoint(self, public_key_endpoint):
        """
        Sets the public_key_endpoint of this IdentityPropagationTrust.
        The cloud provider's public key API of SAML and OIDC providers for signature validation.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - caseExact: false
         - idcsSearchable: false


        :param public_key_endpoint: The public_key_endpoint of this IdentityPropagationTrust.
        :type: str
        """
        self._public_key_endpoint = public_key_endpoint

    @property
    def public_certificate(self):
        """
        Gets the public_certificate of this IdentityPropagationTrust.
        Store the public key if public key cert.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - idcsSearchable: false


        :return: The public_certificate of this IdentityPropagationTrust.
        :rtype: str
        """
        return self._public_certificate

    @public_certificate.setter
    def public_certificate(self, public_certificate):
        """
        Sets the public_certificate of this IdentityPropagationTrust.
        Store the public key if public key cert.

        **SCIM++ Properties:**
         - type: string
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - idcsSearchable: false


        :param public_certificate: The public_certificate of this IdentityPropagationTrust.
        :type: str
        """
        self._public_certificate = public_certificate

    @property
    def oauth_clients(self):
        """
        Gets the oauth_clients of this IdentityPropagationTrust.
        The value of all the authorized OAuth Clients.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The oauth_clients of this IdentityPropagationTrust.
        :rtype: list[str]
        """
        return self._oauth_clients

    @oauth_clients.setter
    def oauth_clients(self, oauth_clients):
        """
        Sets the oauth_clients of this IdentityPropagationTrust.
        The value of all the authorized OAuth Clients.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param oauth_clients: The oauth_clients of this IdentityPropagationTrust.
        :type: list[str]
        """
        self._oauth_clients = oauth_clients

    @property
    def service_principals(self):
        """
        Gets the service_principals of this IdentityPropagationTrust.
        The value of all the authorized OCI Service Principals.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The service_principals of this IdentityPropagationTrust.
        :rtype: list[str]
        """
        return self._service_principals

    @service_principals.setter
    def service_principals(self, service_principals):
        """
        Sets the service_principals of this IdentityPropagationTrust.
        The value of all the authorized OCI Service Principals.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param service_principals: The service_principals of this IdentityPropagationTrust.
        :type: list[str]
        """
        self._service_principals = service_principals

    @property
    def allow_impersonation(self):
        """
        Gets the allow_impersonation of this IdentityPropagationTrust.
        Allow customers to define whether the resulting token should contain the authenticated user as the subject or whether the token should impersonate another Application Principal in IAM.

        **SCIM++ Properties:**
         - type: boolean
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - idcsSearchable: false


        :return: The allow_impersonation of this IdentityPropagationTrust.
        :rtype: bool
        """
        return self._allow_impersonation

    @allow_impersonation.setter
    def allow_impersonation(self, allow_impersonation):
        """
        Sets the allow_impersonation of this IdentityPropagationTrust.
        Allow customers to define whether the resulting token should contain the authenticated user as the subject or whether the token should impersonate another Application Principal in IAM.

        **SCIM++ Properties:**
         - type: boolean
         - multiValued: false
         - required: false
         - mutability: readWrite
         - returned: default
         - uniqueness: none
         - idcsSearchable: false


        :param allow_impersonation: The allow_impersonation of this IdentityPropagationTrust.
        :type: bool
        """
        self._allow_impersonation = allow_impersonation

    @property
    def clock_skew_seconds(self):
        """
        Gets the clock_skew_seconds of this IdentityPropagationTrust.
        The clock skew (in secs) that's allowed for the token issue and expiry time.

        **Added In:** 2308181911

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The clock_skew_seconds of this IdentityPropagationTrust.
        :rtype: int
        """
        return self._clock_skew_seconds

    @clock_skew_seconds.setter
    def clock_skew_seconds(self, clock_skew_seconds):
        """
        Sets the clock_skew_seconds of this IdentityPropagationTrust.
        The clock skew (in secs) that's allowed for the token issue and expiry time.

        **Added In:** 2308181911

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: integer
         - uniqueness: none


        :param clock_skew_seconds: The clock_skew_seconds of this IdentityPropagationTrust.
        :type: int
        """
        self._clock_skew_seconds = clock_skew_seconds

    @property
    def impersonation_service_users(self):
        """
        Gets the impersonation_service_users of this IdentityPropagationTrust.
        The Impersonating Principal.

        **SCIM++ Properties:**
         - idcsCompositeKey: [rule, value]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The impersonation_service_users of this IdentityPropagationTrust.
        :rtype: list[oci.identity_domains.models.IdentityPropagationTrustImpersonationServiceUsers]
        """
        return self._impersonation_service_users

    @impersonation_service_users.setter
    def impersonation_service_users(self, impersonation_service_users):
        """
        Sets the impersonation_service_users of this IdentityPropagationTrust.
        The Impersonating Principal.

        **SCIM++ Properties:**
         - idcsCompositeKey: [rule, value]
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param impersonation_service_users: The impersonation_service_users of this IdentityPropagationTrust.
        :type: list[oci.identity_domains.models.IdentityPropagationTrustImpersonationServiceUsers]
        """
        self._impersonation_service_users = impersonation_service_users

    @property
    def keytab(self):
        """
        Gets the keytab of this IdentityPropagationTrust.

        :return: The keytab of this IdentityPropagationTrust.
        :rtype: oci.identity_domains.models.IdentityPropagationTrustKeytab
        """
        return self._keytab

    @keytab.setter
    def keytab(self, keytab):
        """
        Sets the keytab of this IdentityPropagationTrust.

        :param keytab: The keytab of this IdentityPropagationTrust.
        :type: oci.identity_domains.models.IdentityPropagationTrustKeytab
        """
        self._keytab = keytab

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
