# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .rollback_details import RollbackDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FailedJobsRollbackDetails(RollbackDetails):
    """
    FAILED_JOBS strategy rollback details.
    This strategy would only act-upon targets that had a failed job during patching.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FailedJobsRollbackDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.FailedJobsRollbackDetails.strategy` attribute
        of this class is ``FAILED_JOBS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param strategy:
            The value to assign to the strategy property of this FailedJobsRollbackDetails.
            Allowed values for this property are: "FAILED_JOBS", "LIST_OF_TARGETS"
        :type strategy: str

        """
        self.swagger_types = {
            'strategy': 'str'
        }

        self.attribute_map = {
            'strategy': 'strategy'
        }

        self._strategy = None
        self._strategy = 'FAILED_JOBS'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
