# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201005


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseToolsConnectionOracleDatabaseProxyClientDetails(object):
    """
    The proxy client information.
    """

    #: A constant which can be used with the proxy_authentication_type property of a DatabaseToolsConnectionOracleDatabaseProxyClientDetails.
    #: This constant has a value of "USER_NAME"
    PROXY_AUTHENTICATION_TYPE_USER_NAME = "USER_NAME"

    #: A constant which can be used with the proxy_authentication_type property of a DatabaseToolsConnectionOracleDatabaseProxyClientDetails.
    #: This constant has a value of "NO_PROXY"
    PROXY_AUTHENTICATION_TYPE_NO_PROXY = "NO_PROXY"

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseToolsConnectionOracleDatabaseProxyClientDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_tools.models.DatabaseToolsConnectionOracleDatabaseProxyClientUserNameDetails`
        * :class:`~oci.database_tools.models.DatabaseToolsConnectionOracleDatabaseProxyClientNoProxyDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param proxy_authentication_type:
            The value to assign to the proxy_authentication_type property of this DatabaseToolsConnectionOracleDatabaseProxyClientDetails.
            Allowed values for this property are: "USER_NAME", "NO_PROXY"
        :type proxy_authentication_type: str

        """
        self.swagger_types = {
            'proxy_authentication_type': 'str'
        }

        self.attribute_map = {
            'proxy_authentication_type': 'proxyAuthenticationType'
        }

        self._proxy_authentication_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['proxyAuthenticationType']

        if type == 'USER_NAME':
            return 'DatabaseToolsConnectionOracleDatabaseProxyClientUserNameDetails'

        if type == 'NO_PROXY':
            return 'DatabaseToolsConnectionOracleDatabaseProxyClientNoProxyDetails'
        else:
            return 'DatabaseToolsConnectionOracleDatabaseProxyClientDetails'

    @property
    def proxy_authentication_type(self):
        """
        **[Required]** Gets the proxy_authentication_type of this DatabaseToolsConnectionOracleDatabaseProxyClientDetails.
        The proxy authentication type.

        Allowed values for this property are: "USER_NAME", "NO_PROXY"


        :return: The proxy_authentication_type of this DatabaseToolsConnectionOracleDatabaseProxyClientDetails.
        :rtype: str
        """
        return self._proxy_authentication_type

    @proxy_authentication_type.setter
    def proxy_authentication_type(self, proxy_authentication_type):
        """
        Sets the proxy_authentication_type of this DatabaseToolsConnectionOracleDatabaseProxyClientDetails.
        The proxy authentication type.


        :param proxy_authentication_type: The proxy_authentication_type of this DatabaseToolsConnectionOracleDatabaseProxyClientDetails.
        :type: str
        """
        allowed_values = ["USER_NAME", "NO_PROXY"]
        if not value_allowed_none_or_none_sentinel(proxy_authentication_type, allowed_values):
            raise ValueError(
                f"Invalid value for `proxy_authentication_type`, must be None or one of {allowed_values}"
            )
        self._proxy_authentication_type = proxy_authentication_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
