# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SqlFirewallViolationAggregationDimensions(object):
    """
    The details of the aggregation dimensions used for summarizing SQL violations.
    """

    #: A constant which can be used with the sql_level property of a SqlFirewallViolationAggregationDimensions.
    #: This constant has a value of "USER_ISSUED_SQL"
    SQL_LEVEL_USER_ISSUED_SQL = "USER_ISSUED_SQL"

    #: A constant which can be used with the sql_level property of a SqlFirewallViolationAggregationDimensions.
    #: This constant has a value of "ALL_SQL"
    SQL_LEVEL_ALL_SQL = "ALL_SQL"

    def __init__(self, **kwargs):
        """
        Initializes a new SqlFirewallViolationAggregationDimensions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operation_time:
            The value to assign to the operation_time property of this SqlFirewallViolationAggregationDimensions.
        :type operation_time: list[datetime]

        :param db_user_name:
            The value to assign to the db_user_name property of this SqlFirewallViolationAggregationDimensions.
        :type db_user_name: list[str]

        :param target_id:
            The value to assign to the target_id property of this SqlFirewallViolationAggregationDimensions.
        :type target_id: list[str]

        :param target_name:
            The value to assign to the target_name property of this SqlFirewallViolationAggregationDimensions.
        :type target_name: list[str]

        :param client_program:
            The value to assign to the client_program property of this SqlFirewallViolationAggregationDimensions.
        :type client_program: list[str]

        :param operation:
            The value to assign to the operation property of this SqlFirewallViolationAggregationDimensions.
        :type operation: list[str]

        :param client_os_user_name:
            The value to assign to the client_os_user_name property of this SqlFirewallViolationAggregationDimensions.
        :type client_os_user_name: list[str]

        :param violation_cause:
            The value to assign to the violation_cause property of this SqlFirewallViolationAggregationDimensions.
        :type violation_cause: list[str]

        :param client_ip:
            The value to assign to the client_ip property of this SqlFirewallViolationAggregationDimensions.
        :type client_ip: list[str]

        :param violation_action:
            The value to assign to the violation_action property of this SqlFirewallViolationAggregationDimensions.
        :type violation_action: list[str]

        :param sql_level:
            The value to assign to the sql_level property of this SqlFirewallViolationAggregationDimensions.
            Allowed values for items in this list are: "USER_ISSUED_SQL", "ALL_SQL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type sql_level: list[str]

        """
        self.swagger_types = {
            'operation_time': 'list[datetime]',
            'db_user_name': 'list[str]',
            'target_id': 'list[str]',
            'target_name': 'list[str]',
            'client_program': 'list[str]',
            'operation': 'list[str]',
            'client_os_user_name': 'list[str]',
            'violation_cause': 'list[str]',
            'client_ip': 'list[str]',
            'violation_action': 'list[str]',
            'sql_level': 'list[str]'
        }

        self.attribute_map = {
            'operation_time': 'operationTime',
            'db_user_name': 'dbUserName',
            'target_id': 'targetId',
            'target_name': 'targetName',
            'client_program': 'clientProgram',
            'operation': 'operation',
            'client_os_user_name': 'clientOsUserName',
            'violation_cause': 'violationCause',
            'client_ip': 'clientIp',
            'violation_action': 'violationAction',
            'sql_level': 'sqlLevel'
        }

        self._operation_time = None
        self._db_user_name = None
        self._target_id = None
        self._target_name = None
        self._client_program = None
        self._operation = None
        self._client_os_user_name = None
        self._violation_cause = None
        self._client_ip = None
        self._violation_action = None
        self._sql_level = None

    @property
    def operation_time(self):
        """
        Gets the operation_time of this SqlFirewallViolationAggregationDimensions.
        The time of the SQL violation occurrence in the target database.


        :return: The operation_time of this SqlFirewallViolationAggregationDimensions.
        :rtype: list[datetime]
        """
        return self._operation_time

    @operation_time.setter
    def operation_time(self, operation_time):
        """
        Sets the operation_time of this SqlFirewallViolationAggregationDimensions.
        The time of the SQL violation occurrence in the target database.


        :param operation_time: The operation_time of this SqlFirewallViolationAggregationDimensions.
        :type: list[datetime]
        """
        self._operation_time = operation_time

    @property
    def db_user_name(self):
        """
        Gets the db_user_name of this SqlFirewallViolationAggregationDimensions.
        The name of the database user.


        :return: The db_user_name of this SqlFirewallViolationAggregationDimensions.
        :rtype: list[str]
        """
        return self._db_user_name

    @db_user_name.setter
    def db_user_name(self, db_user_name):
        """
        Sets the db_user_name of this SqlFirewallViolationAggregationDimensions.
        The name of the database user.


        :param db_user_name: The db_user_name of this SqlFirewallViolationAggregationDimensions.
        :type: list[str]
        """
        self._db_user_name = db_user_name

    @property
    def target_id(self):
        """
        Gets the target_id of this SqlFirewallViolationAggregationDimensions.
        The OCID of the target database.


        :return: The target_id of this SqlFirewallViolationAggregationDimensions.
        :rtype: list[str]
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this SqlFirewallViolationAggregationDimensions.
        The OCID of the target database.


        :param target_id: The target_id of this SqlFirewallViolationAggregationDimensions.
        :type: list[str]
        """
        self._target_id = target_id

    @property
    def target_name(self):
        """
        Gets the target_name of this SqlFirewallViolationAggregationDimensions.
        The name of the target database.


        :return: The target_name of this SqlFirewallViolationAggregationDimensions.
        :rtype: list[str]
        """
        return self._target_name

    @target_name.setter
    def target_name(self, target_name):
        """
        Sets the target_name of this SqlFirewallViolationAggregationDimensions.
        The name of the target database.


        :param target_name: The target_name of this SqlFirewallViolationAggregationDimensions.
        :type: list[str]
        """
        self._target_name = target_name

    @property
    def client_program(self):
        """
        Gets the client_program of this SqlFirewallViolationAggregationDimensions.
        The application from which the SQL violation was generated. Examples SQL Plus or SQL Developer.


        :return: The client_program of this SqlFirewallViolationAggregationDimensions.
        :rtype: list[str]
        """
        return self._client_program

    @client_program.setter
    def client_program(self, client_program):
        """
        Sets the client_program of this SqlFirewallViolationAggregationDimensions.
        The application from which the SQL violation was generated. Examples SQL Plus or SQL Developer.


        :param client_program: The client_program of this SqlFirewallViolationAggregationDimensions.
        :type: list[str]
        """
        self._client_program = client_program

    @property
    def operation(self):
        """
        Gets the operation of this SqlFirewallViolationAggregationDimensions.
        The name of the action executed by the user on the target database, for example, ALTER, CREATE, DROP.


        :return: The operation of this SqlFirewallViolationAggregationDimensions.
        :rtype: list[str]
        """
        return self._operation

    @operation.setter
    def operation(self, operation):
        """
        Sets the operation of this SqlFirewallViolationAggregationDimensions.
        The name of the action executed by the user on the target database, for example, ALTER, CREATE, DROP.


        :param operation: The operation of this SqlFirewallViolationAggregationDimensions.
        :type: list[str]
        """
        self._operation = operation

    @property
    def client_os_user_name(self):
        """
        Gets the client_os_user_name of this SqlFirewallViolationAggregationDimensions.
        The name of the operating system user for the database session.


        :return: The client_os_user_name of this SqlFirewallViolationAggregationDimensions.
        :rtype: list[str]
        """
        return self._client_os_user_name

    @client_os_user_name.setter
    def client_os_user_name(self, client_os_user_name):
        """
        Sets the client_os_user_name of this SqlFirewallViolationAggregationDimensions.
        The name of the operating system user for the database session.


        :param client_os_user_name: The client_os_user_name of this SqlFirewallViolationAggregationDimensions.
        :type: list[str]
        """
        self._client_os_user_name = client_os_user_name

    @property
    def violation_cause(self):
        """
        Gets the violation_cause of this SqlFirewallViolationAggregationDimensions.
        Indicates whether SQL or context violation.


        :return: The violation_cause of this SqlFirewallViolationAggregationDimensions.
        :rtype: list[str]
        """
        return self._violation_cause

    @violation_cause.setter
    def violation_cause(self, violation_cause):
        """
        Sets the violation_cause of this SqlFirewallViolationAggregationDimensions.
        Indicates whether SQL or context violation.


        :param violation_cause: The violation_cause of this SqlFirewallViolationAggregationDimensions.
        :type: list[str]
        """
        self._violation_cause = violation_cause

    @property
    def client_ip(self):
        """
        Gets the client_ip of this SqlFirewallViolationAggregationDimensions.
        The IP address of the host from which the session was spawned.


        :return: The client_ip of this SqlFirewallViolationAggregationDimensions.
        :rtype: list[str]
        """
        return self._client_ip

    @client_ip.setter
    def client_ip(self, client_ip):
        """
        Sets the client_ip of this SqlFirewallViolationAggregationDimensions.
        The IP address of the host from which the session was spawned.


        :param client_ip: The client_ip of this SqlFirewallViolationAggregationDimensions.
        :type: list[str]
        """
        self._client_ip = client_ip

    @property
    def violation_action(self):
        """
        Gets the violation_action of this SqlFirewallViolationAggregationDimensions.
        The action taken for this SQL violation.


        :return: The violation_action of this SqlFirewallViolationAggregationDimensions.
        :rtype: list[str]
        """
        return self._violation_action

    @violation_action.setter
    def violation_action(self, violation_action):
        """
        Sets the violation_action of this SqlFirewallViolationAggregationDimensions.
        The action taken for this SQL violation.


        :param violation_action: The violation_action of this SqlFirewallViolationAggregationDimensions.
        :type: list[str]
        """
        self._violation_action = violation_action

    @property
    def sql_level(self):
        """
        Gets the sql_level of this SqlFirewallViolationAggregationDimensions.
        Specifies the level of SQL included for this SQL Firewall policy.
        USER_ISSUED_SQL - User issued SQL statements only.
        ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.

        Allowed values for items in this list are: "USER_ISSUED_SQL", "ALL_SQL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The sql_level of this SqlFirewallViolationAggregationDimensions.
        :rtype: list[str]
        """
        return self._sql_level

    @sql_level.setter
    def sql_level(self, sql_level):
        """
        Sets the sql_level of this SqlFirewallViolationAggregationDimensions.
        Specifies the level of SQL included for this SQL Firewall policy.
        USER_ISSUED_SQL - User issued SQL statements only.
        ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.


        :param sql_level: The sql_level of this SqlFirewallViolationAggregationDimensions.
        :type: list[str]
        """
        allowed_values = ["USER_ISSUED_SQL", "ALL_SQL"]
        if sql_level:
            sql_level[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in sql_level]
        self._sql_level = sql_level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
