# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201

from .entry_details import EntryDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FirewallPolicyEntryDetails(EntryDetails):
    """
    SQL Firewall policy details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FirewallPolicyEntryDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_safe.models.FirewallPolicyEntryDetails.entry_type` attribute
        of this class is ``FIREWALL_POLICY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param entry_type:
            The value to assign to the entry_type property of this FirewallPolicyEntryDetails.
            Allowed values for this property are: "FIREWALL_POLICY"
        :type entry_type: str

        :param time_generated:
            The value to assign to the time_generated property of this FirewallPolicyEntryDetails.
        :type time_generated: datetime

        :param time_status_updated:
            The value to assign to the time_status_updated property of this FirewallPolicyEntryDetails.
        :type time_status_updated: datetime

        """
        self.swagger_types = {
            'entry_type': 'str',
            'time_generated': 'datetime',
            'time_status_updated': 'datetime'
        }

        self.attribute_map = {
            'entry_type': 'entryType',
            'time_generated': 'timeGenerated',
            'time_status_updated': 'timeStatusUpdated'
        }

        self._entry_type = None
        self._time_generated = None
        self._time_status_updated = None
        self._entry_type = 'FIREWALL_POLICY'

    @property
    def time_generated(self):
        """
        **[Required]** Gets the time_generated of this FirewallPolicyEntryDetails.
        The time the the SQL Firewall policy was generated on the target database, in the format defined by RFC3339.


        :return: The time_generated of this FirewallPolicyEntryDetails.
        :rtype: datetime
        """
        return self._time_generated

    @time_generated.setter
    def time_generated(self, time_generated):
        """
        Sets the time_generated of this FirewallPolicyEntryDetails.
        The time the the SQL Firewall policy was generated on the target database, in the format defined by RFC3339.


        :param time_generated: The time_generated of this FirewallPolicyEntryDetails.
        :type: datetime
        """
        self._time_generated = time_generated

    @property
    def time_status_updated(self):
        """
        Gets the time_status_updated of this FirewallPolicyEntryDetails.
        The last date and time the status of the SQL Firewall policy was updated on the target database, in the format defined by RFC3339.


        :return: The time_status_updated of this FirewallPolicyEntryDetails.
        :rtype: datetime
        """
        return self._time_status_updated

    @time_status_updated.setter
    def time_status_updated(self, time_status_updated):
        """
        Sets the time_status_updated of this FirewallPolicyEntryDetails.
        The last date and time the status of the SQL Firewall policy was updated on the target database, in the format defined by RFC3339.


        :param time_status_updated: The time_status_updated of this FirewallPolicyEntryDetails.
        :type: datetime
        """
        self._time_status_updated = time_status_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
