# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OsPatchPackageSummary(object):
    """
    Summary of a package contained in a os patch.
    """

    #: A constant which can be used with the update_type property of a OsPatchPackageSummary.
    #: This constant has a value of "INSTALL"
    UPDATE_TYPE_INSTALL = "INSTALL"

    #: A constant which can be used with the update_type property of a OsPatchPackageSummary.
    #: This constant has a value of "REMOVE"
    UPDATE_TYPE_REMOVE = "REMOVE"

    #: A constant which can be used with the update_type property of a OsPatchPackageSummary.
    #: This constant has a value of "UPDATE"
    UPDATE_TYPE_UPDATE = "UPDATE"

    def __init__(self, **kwargs):
        """
        Initializes a new OsPatchPackageSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param package_name:
            The value to assign to the package_name property of this OsPatchPackageSummary.
        :type package_name: str

        :param target_version:
            The value to assign to the target_version property of this OsPatchPackageSummary.
        :type target_version: str

        :param update_type:
            The value to assign to the update_type property of this OsPatchPackageSummary.
            Allowed values for this property are: "INSTALL", "REMOVE", "UPDATE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type update_type: str

        :param related_cv_es:
            The value to assign to the related_cv_es property of this OsPatchPackageSummary.
        :type related_cv_es: list[str]

        """
        self.swagger_types = {
            'package_name': 'str',
            'target_version': 'str',
            'update_type': 'str',
            'related_cv_es': 'list[str]'
        }

        self.attribute_map = {
            'package_name': 'packageName',
            'target_version': 'targetVersion',
            'update_type': 'updateType',
            'related_cv_es': 'relatedCVEs'
        }

        self._package_name = None
        self._target_version = None
        self._update_type = None
        self._related_cv_es = None

    @property
    def package_name(self):
        """
        **[Required]** Gets the package_name of this OsPatchPackageSummary.
        The package's name.


        :return: The package_name of this OsPatchPackageSummary.
        :rtype: str
        """
        return self._package_name

    @package_name.setter
    def package_name(self, package_name):
        """
        Sets the package_name of this OsPatchPackageSummary.
        The package's name.


        :param package_name: The package_name of this OsPatchPackageSummary.
        :type: str
        """
        self._package_name = package_name

    @property
    def target_version(self):
        """
        Gets the target_version of this OsPatchPackageSummary.
        The target version of the package.


        :return: The target_version of this OsPatchPackageSummary.
        :rtype: str
        """
        return self._target_version

    @target_version.setter
    def target_version(self, target_version):
        """
        Sets the target_version of this OsPatchPackageSummary.
        The target version of the package.


        :param target_version: The target_version of this OsPatchPackageSummary.
        :type: str
        """
        self._target_version = target_version

    @property
    def update_type(self):
        """
        **[Required]** Gets the update_type of this OsPatchPackageSummary.
        The action that current package will be executed on the cluster.

        Allowed values for this property are: "INSTALL", "REMOVE", "UPDATE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The update_type of this OsPatchPackageSummary.
        :rtype: str
        """
        return self._update_type

    @update_type.setter
    def update_type(self, update_type):
        """
        Sets the update_type of this OsPatchPackageSummary.
        The action that current package will be executed on the cluster.


        :param update_type: The update_type of this OsPatchPackageSummary.
        :type: str
        """
        allowed_values = ["INSTALL", "REMOVE", "UPDATE"]
        if not value_allowed_none_or_none_sentinel(update_type, allowed_values):
            update_type = 'UNKNOWN_ENUM_VALUE'
        self._update_type = update_type

    @property
    def related_cv_es(self):
        """
        **[Required]** Gets the related_cv_es of this OsPatchPackageSummary.
        Related CVEs of the package update.


        :return: The related_cv_es of this OsPatchPackageSummary.
        :rtype: list[str]
        """
        return self._related_cv_es

    @related_cv_es.setter
    def related_cv_es(self, related_cv_es):
        """
        Sets the related_cv_es of this OsPatchPackageSummary.
        Related CVEs of the package update.


        :param related_cv_es: The related_cv_es of this OsPatchPackageSummary.
        :type: list[str]
        """
        self._related_cv_es = related_cv_es

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
