# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210331

from .target_resource_details import TargetResourceDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagedSshSessionTargetResourceDetails(TargetResourceDetails):
    """
    Details about a managed SSH session for a target resource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManagedSshSessionTargetResourceDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.bastion.models.ManagedSshSessionTargetResourceDetails.session_type` attribute
        of this class is ``MANAGED_SSH`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param session_type:
            The value to assign to the session_type property of this ManagedSshSessionTargetResourceDetails.
            Allowed values for this property are: "MANAGED_SSH", "PORT_FORWARDING", "DYNAMIC_PORT_FORWARDING"
        :type session_type: str

        :param target_resource_operating_system_user_name:
            The value to assign to the target_resource_operating_system_user_name property of this ManagedSshSessionTargetResourceDetails.
        :type target_resource_operating_system_user_name: str

        :param target_resource_id:
            The value to assign to the target_resource_id property of this ManagedSshSessionTargetResourceDetails.
        :type target_resource_id: str

        :param target_resource_private_ip_address:
            The value to assign to the target_resource_private_ip_address property of this ManagedSshSessionTargetResourceDetails.
        :type target_resource_private_ip_address: str

        :param target_resource_display_name:
            The value to assign to the target_resource_display_name property of this ManagedSshSessionTargetResourceDetails.
        :type target_resource_display_name: str

        :param target_resource_port:
            The value to assign to the target_resource_port property of this ManagedSshSessionTargetResourceDetails.
        :type target_resource_port: int

        """
        self.swagger_types = {
            'session_type': 'str',
            'target_resource_operating_system_user_name': 'str',
            'target_resource_id': 'str',
            'target_resource_private_ip_address': 'str',
            'target_resource_display_name': 'str',
            'target_resource_port': 'int'
        }

        self.attribute_map = {
            'session_type': 'sessionType',
            'target_resource_operating_system_user_name': 'targetResourceOperatingSystemUserName',
            'target_resource_id': 'targetResourceId',
            'target_resource_private_ip_address': 'targetResourcePrivateIpAddress',
            'target_resource_display_name': 'targetResourceDisplayName',
            'target_resource_port': 'targetResourcePort'
        }

        self._session_type = None
        self._target_resource_operating_system_user_name = None
        self._target_resource_id = None
        self._target_resource_private_ip_address = None
        self._target_resource_display_name = None
        self._target_resource_port = None
        self._session_type = 'MANAGED_SSH'

    @property
    def target_resource_operating_system_user_name(self):
        """
        **[Required]** Gets the target_resource_operating_system_user_name of this ManagedSshSessionTargetResourceDetails.
        The name of the user on the target resource operating system that the session uses for the connection.


        :return: The target_resource_operating_system_user_name of this ManagedSshSessionTargetResourceDetails.
        :rtype: str
        """
        return self._target_resource_operating_system_user_name

    @target_resource_operating_system_user_name.setter
    def target_resource_operating_system_user_name(self, target_resource_operating_system_user_name):
        """
        Sets the target_resource_operating_system_user_name of this ManagedSshSessionTargetResourceDetails.
        The name of the user on the target resource operating system that the session uses for the connection.


        :param target_resource_operating_system_user_name: The target_resource_operating_system_user_name of this ManagedSshSessionTargetResourceDetails.
        :type: str
        """
        self._target_resource_operating_system_user_name = target_resource_operating_system_user_name

    @property
    def target_resource_id(self):
        """
        **[Required]** Gets the target_resource_id of this ManagedSshSessionTargetResourceDetails.
        The unique identifier (OCID) of the target resource (a Compute instance, for example) that the session connects to.


        :return: The target_resource_id of this ManagedSshSessionTargetResourceDetails.
        :rtype: str
        """
        return self._target_resource_id

    @target_resource_id.setter
    def target_resource_id(self, target_resource_id):
        """
        Sets the target_resource_id of this ManagedSshSessionTargetResourceDetails.
        The unique identifier (OCID) of the target resource (a Compute instance, for example) that the session connects to.


        :param target_resource_id: The target_resource_id of this ManagedSshSessionTargetResourceDetails.
        :type: str
        """
        self._target_resource_id = target_resource_id

    @property
    def target_resource_private_ip_address(self):
        """
        Gets the target_resource_private_ip_address of this ManagedSshSessionTargetResourceDetails.
        The private IP address of the target resource that the session connects to.


        :return: The target_resource_private_ip_address of this ManagedSshSessionTargetResourceDetails.
        :rtype: str
        """
        return self._target_resource_private_ip_address

    @target_resource_private_ip_address.setter
    def target_resource_private_ip_address(self, target_resource_private_ip_address):
        """
        Sets the target_resource_private_ip_address of this ManagedSshSessionTargetResourceDetails.
        The private IP address of the target resource that the session connects to.


        :param target_resource_private_ip_address: The target_resource_private_ip_address of this ManagedSshSessionTargetResourceDetails.
        :type: str
        """
        self._target_resource_private_ip_address = target_resource_private_ip_address

    @property
    def target_resource_display_name(self):
        """
        **[Required]** Gets the target_resource_display_name of this ManagedSshSessionTargetResourceDetails.
        The display name of the target Compute instance that the session connects to.


        :return: The target_resource_display_name of this ManagedSshSessionTargetResourceDetails.
        :rtype: str
        """
        return self._target_resource_display_name

    @target_resource_display_name.setter
    def target_resource_display_name(self, target_resource_display_name):
        """
        Sets the target_resource_display_name of this ManagedSshSessionTargetResourceDetails.
        The display name of the target Compute instance that the session connects to.


        :param target_resource_display_name: The target_resource_display_name of this ManagedSshSessionTargetResourceDetails.
        :type: str
        """
        self._target_resource_display_name = target_resource_display_name

    @property
    def target_resource_port(self):
        """
        Gets the target_resource_port of this ManagedSshSessionTargetResourceDetails.
        The port number to connect to on the target resource.


        :return: The target_resource_port of this ManagedSshSessionTargetResourceDetails.
        :rtype: int
        """
        return self._target_resource_port

    @target_resource_port.setter
    def target_resource_port(self, target_resource_port):
        """
        Sets the target_resource_port of this ManagedSshSessionTargetResourceDetails.
        The port number to connect to on the target resource.


        :param target_resource_port: The target_resource_port of this ManagedSshSessionTargetResourceDetails.
        :type: int
        """
        self._target_resource_port = target_resource_port

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
