# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421

from .remediation_run_stage import RemediationRunStage
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DetectStage(RemediationRunStage):
    """
    A detect stage performs a Vulnerability Audit and determines if the remediation run should proceed to remediation stage.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DetectStage object with values from keyword arguments. The default value of the :py:attr:`~oci.adm.models.DetectStage.type` attribute
        of this class is ``DETECT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param status:
            The value to assign to the status property of this DetectStage.
            Allowed values for this property are: "CREATED", "IN_PROGRESS", "SUCCEEDED", "FAILED", "CANCELING", "CANCELED"
        :type status: str

        :param time_created:
            The value to assign to the time_created property of this DetectStage.
        :type time_created: datetime

        :param time_started:
            The value to assign to the time_started property of this DetectStage.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this DetectStage.
        :type time_finished: datetime

        :param type:
            The value to assign to the type property of this DetectStage.
            Allowed values for this property are: "DETECT", "RECOMMEND", "VERIFY", "APPLY"
        :type type: str

        :param summary:
            The value to assign to the summary property of this DetectStage.
        :type summary: str

        :param remediation_run_id:
            The value to assign to the remediation_run_id property of this DetectStage.
        :type remediation_run_id: str

        :param previous_stage_type:
            The value to assign to the previous_stage_type property of this DetectStage.
            Allowed values for this property are: "DETECT", "RECOMMEND", "VERIFY", "APPLY"
        :type previous_stage_type: str

        :param next_stage_type:
            The value to assign to the next_stage_type property of this DetectStage.
            Allowed values for this property are: "DETECT", "RECOMMEND", "VERIFY", "APPLY"
        :type next_stage_type: str

        :param audit_id:
            The value to assign to the audit_id property of this DetectStage.
        :type audit_id: str

        """
        self.swagger_types = {
            'status': 'str',
            'time_created': 'datetime',
            'time_started': 'datetime',
            'time_finished': 'datetime',
            'type': 'str',
            'summary': 'str',
            'remediation_run_id': 'str',
            'previous_stage_type': 'str',
            'next_stage_type': 'str',
            'audit_id': 'str'
        }

        self.attribute_map = {
            'status': 'status',
            'time_created': 'timeCreated',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished',
            'type': 'type',
            'summary': 'summary',
            'remediation_run_id': 'remediationRunId',
            'previous_stage_type': 'previousStageType',
            'next_stage_type': 'nextStageType',
            'audit_id': 'auditId'
        }

        self._status = None
        self._time_created = None
        self._time_started = None
        self._time_finished = None
        self._type = None
        self._summary = None
        self._remediation_run_id = None
        self._previous_stage_type = None
        self._next_stage_type = None
        self._audit_id = None
        self._type = 'DETECT'

    @property
    def audit_id(self):
        """
        Gets the audit_id of this DetectStage.
        The Oracle Cloud identifier (`OCID`__) of the vulnerability audit.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The audit_id of this DetectStage.
        :rtype: str
        """
        return self._audit_id

    @audit_id.setter
    def audit_id(self, audit_id):
        """
        Sets the audit_id of this DetectStage.
        The Oracle Cloud identifier (`OCID`__) of the vulnerability audit.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param audit_id: The audit_id of this DetectStage.
        :type: str
        """
        self._audit_id = audit_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
