# -*- coding: utf-8 -*-
'''
Run me to update the release notes in the documentation.

I will pull the content from ../CHANGE_LOG and insert that into
./source/releases.rst
'''
from __future__ import print_function, division, absolute_import


title_template = '''

.. DO NOT EDIT THIS FILE.
   This file is automatically generated by %(this_script)s.
    

======================
Release Notes
======================

'''

def main():
    from os.path import dirname, join, isfile
    curdir = dirname(__file__)
    changelog_path = join(curdir, '..', 'CHANGE_LOG')
    assert isfile(changelog_path), ("%s does not exist" % changelog_path)
    doc_releases = join(curdir, 'source', 'releases.rst')
    with open(changelog_path) as fin:
        content = fin.read()
    with open(doc_releases, 'w') as fout:
        fout.write(title_template % dict(this_script=__file__))
        fout.write(content)

if __name__ == '__main__':
    main()

