/*
 * Decompiled with CFR 0.152.
 */
package nicknack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KeyValueTextInputFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestTextInputFormat
extends KeyValueTextInputFormat {
    private static final Log log = LogFactory.getLog(ManifestTextInputFormat.class);

    protected FileStatus[] listStatus(JobConf job) throws IOException {
        FileStatus[] manifests = super.listStatus(job);
        ArrayList<FileStatus> allFileStatuses = new ArrayList<FileStatus>();
        ArrayList<Path> allPaths = new ArrayList<Path>();
        for (FileStatus manifest : manifests) {
            allPaths.addAll(this.manifestPaths(manifest.getPath(), job));
        }
        for (Path path : allPaths) {
            allFileStatuses.addAll(this.expandPath(path, job));
        }
        log.info((Object)("Total input paths from manifest : " + allFileStatuses.size()));
        return allFileStatuses.toArray(new FileStatus[0]);
    }

    private ArrayList<Path> manifestPaths(Path manifest, JobConf job) throws IOException {
        FileSystem fs = manifest.getFileSystem((Configuration)job);
        FSDataInputStream stream = fs.open(manifest);
        BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)stream));
        ArrayList<Path> paths = new ArrayList<Path>();
        String line = buf.readLine();
        while (line != null) {
            Path p = new Path(line);
            paths.add(p);
            line = buf.readLine();
        }
        return paths;
    }

    private ArrayList<FileStatus> expandPath(Path path, JobConf job) throws IOException {
        FileSystem fs = path.getFileSystem((Configuration)job);
        FileStatus[] matches = fs.globStatus(path);
        if (matches == null) {
            return new ArrayList<FileStatus>();
        }
        ArrayList<FileStatus> expanded = new ArrayList<FileStatus>();
        for (FileStatus match : matches) {
            if (match.isDir()) {
                expanded.addAll(Arrays.asList(fs.listStatus(match.getPath())));
                continue;
            }
            expanded.add(match);
        }
        return expanded;
    }
}

