# Copyright 2011-2012 Yelp
# Copyright 2015 Yelp
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Module for loading all tests, so we can run them from setup.py"""
import sys
from os.path import dirname

# this module has to stand alone, so we can't use tests.py2
if sys.version_info < (2, 7):
    import unittest2 as unittest
else:
    import unittest


def load_tests():
    return unittest.defaultTestLoader.discover(dirname(__file__))
