__version__   = "$Revision: 1.2 $"[11:-2]
__copyright__ = """Copyright (c) 2003 Not Another Corporation Incorporated
                   www.notanothercorporation.com"""
__license__ = """Licensed under the FSF GPL

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__doc__ = """
* $Id: test_sessioninfo.py,v 1.2 2003/09/24 17:03:31 philiplindsay Exp $ *

    ** %s **  Ver %s
 
%s

%s

Test units for the C{SessionInfo} object.

TODO: Shift some of these tests into a suite for C{SafeReadOnlyMixin}?

""" % (__name__, __version__, __copyright__, __license__)

import os
import string

import unittest

import mongoose



STRING_UNKNOWN = "unknown"

class SessionInfoUnitTests(unittest.TestCase):
    """
    Test units for the read-only C{SessionInfo} object.
    """
    
    def testCreateEmptyInfo(self):
        """
        Create an empty C{SessionInfo} object. (Note: This object
        forever has no information stored in it.)
        """
        info = mongoose.SessionInfo({})

        
    def testCreateInitialisedStringInfo(self):
        """
        Create C{SessionInfo} object with a pre existing dictionary, containing
        only string values.
        """
        USERNAME = "Sally Vincent"
        TECH = "Frank Sheeznag"
        
        testValues = {}
        testValues['username'] = USERNAME
        testValues['localTechSupport'] = TECH

        info = mongoose.SessionInfo(testValues)

        self.assertEqual(info.username, USERNAME)
        self.assertEqual(info.localTechSupport, TECH)
        

    NUMBER = 12321
    DICT = dict()
    STRING = "Some string..."
    OBJECT = object()
    EMPTY_EXCEPTION = Exception()
    CLASS = Exception().__class__
    
    def getSampleDictionary(self):
        """
        Returns a dictionary containing a mixture of string and
        non-string values.
        """
        testValues = {}

        testValues['number'] = self.NUMBER
        testValues['dictionary'] = self.DICT
        testValues['string'] = self.STRING
        testValues['object'] = self.OBJECT
        testValues['empty_exception'] = self.EMPTY_EXCEPTION
        testValues['klass'] = self.CLASS

        return testValues


    def testCreateInitialisedNonStringInfo(self):
        """
        Create C{SessionInfo} object with a pre existing dictionary, containing
        a mixture of string and non-string values.
        """
        
        testValues = self.getSampleDictionary()
                
        info = mongoose.SessionInfo(testValues)
        
        self.assertEqual(info.number, str(self.NUMBER))
        self.assertEqual(info.dictionary, str(self.DICT))
        self.assertEqual(info.string, self.STRING)
        self.assertEqual(info.object, str(self.OBJECT))
        self.assertEqual(info.empty_exception, str(self.EMPTY_EXCEPTION))
        self.assertEqual(info.klass, str(self.CLASS))


    def testGetBogusAttributeReturnsUnknown(self):
        """
        If an attribute is requested that has no value the string C{"unknown"}
        should be returned.
        """
        info = mongoose.SessionInfo({})

        self.assertEqual(info.foo, STRING_UNKNOWN)


    def testSetAttributeSilentlyFails(self):
        """
        Once object is instantiated attempts to setting attributes
        should silently fail, but not change the object.
        """

        FOO_VALUE = 0xDEADBEEF
        
        info = mongoose.SessionInfo({})

        info.foo = FOO_VALUE # Should not cause exception...

        self.assertNotEqual(info.foo, FOO_VALUE) # But obj should be unchanged.
        self.assertEqual(info.foo, STRING_UNKNOWN)


    def testStringRepresentation(self):
        """
        Tests that the string representation of the object is as expected.
        """
        
        MATCH = "dictionary: {}\nempty_exception: \n" \
                "klass: exceptions.Exception\nnumber: 12321\n" \
                "object: %s\n" \
                "string: Some string..." % self.OBJECT

        testValues = self.getSampleDictionary()
                
        info = mongoose.SessionInfo(testValues)

        self.assertEqual(str(info), MATCH)
