__version__   = "$Revision: 1.2 $"[11:-2]
__copyright__ = """Copyright (c) 2003 Not Another Corporation Incorporated
                   www.notanothercorporation.com"""
__license__ = """Licensed under the FSF GPL

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__doc__ = """* $Id: test_reporters.py,v 1.2 2003/09/24 17:03:31 philiplindsay Exp $ *

    ** %s **  Ver %s
 
%s

%s

Test units for the C{mongoose.reporters} module.

TODO: Write unit tests for all the different reporters.

""" % (__name__, __version__, __copyright__, __license__)

import unittest
import mongoose


class ReporterUnloadUnitTest(unittest.TestCase):
    """
    Test that C{unload} is called as a result of calling
    C{processAndUnload}.
    """

    EXCEPTION_UNLOAD_CALLED = "Unload called."

    class TestUnloadReporter(mongoose.Reporter):
        """
        Used to test that C{unload()} is automatically called by a call to
        C{processAndUnload()}.
        """
        def unload(self):
            """
            Raises a custom exception to show that this method has been called.
            """
            raise Exception(ReporterUnloadUnitTest.EXCEPTION_UNLOAD_CALLED)


    def testUnloadCalledByProcessAndUnload(self):
        """
        Test that C{unload} is called as a result of calling
        C{processAndUnload}.

        If this passes then it should mean it will always work
        I{unless} someone overrides the base C{processAndUnload()}.
        
        """
        reporter = self.TestUnloadReporter()

        e = ""

        try:
            reporter.processAndUnload(None, None)
        except Exception, e:
            pass

        self.assertEqual(self.EXCEPTION_UNLOAD_CALLED, str(e))


# TODO: Write ConsoleReporter etc tests
