#!/usr/bin/python
from distutils.core import setup

import mongoose

setup(name="mongoose",
    version=mongoose.__version__,
    description="Mongoose",
    long_description="""
Mongoose - catches runaway Pythons
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

This package provides functionality to catch and report otherwise
unhandled Python exceptions in a helpful and extensible manner. It is
intended for use in deployed production or beta software to provide a
graceful exit and report should an uncaught exception occur.

When an uncaught exception occurs one or more "reporters" can act
on the event. Supplied sample reporters log the event to a file,
email the developer or support staff, display output on a console
and display a wxWindows dialog to the user.

Includes "Mongoose Incident Identifier(TM)" technology to provide
developers with a convenient way to track the same exceptional incident
(i.e. "bug") on multiple computers. A Mongoose Incident Identifier is
an automatically generated unique identifier that will be the same on
any computer which encounters the problem. (Similar to Full Circle
Software's TalkBack ID and Bugtoaster's Crash Signature.)
""",
    author="Philip Lindsay (NAC Inc.)",
    author_email="opensource@notanothercorporation.com",
    url="http://www.notanothercorporation.com/source/mongoose.html",
    platforms="All. But, only tested under Win98 and Linux",
    license=mongoose.__license__,
    packages=['mongoose', ],
    )
    