#!/usr/bin/python
#
# * $Id: runall.py,v 1.2 2003/09/24 16:37:00 philiplindsay Exp $ *
#
# Wrapper to run Unit Test cases.
#
# NOTE: This only works for packages if it's run from the package root.
#
# History:
#   0.1.8 -- Merge to include modifications to make this work with the
#            Python 2.3 version of unittest. The new version of unittest
#            implements TestCases as new style classes. Without this change
#            none of the test cases are found!
#            The changed code was taken from CVS version 1.20 of the Python
#            'unittest.py' file.
#
__version__ = "0.1.8"
__copyright__ = \
              "Copyright (c) 2002-2003 Not Another Corporation Incorporated "\
              "www.notanothercorporation.com"
__license__ = """See individual files for license information."""

import unittest
import glob
import os.path

import sys

import getopt

import types


ARGV_OPTIONS = "d:hv:"
MODULE_GLOB_MATCH = "*.py"


options = []
moduleNames = []

testDirectory = "test"
verbosity = 1


def showUsage():
    """
    Displays a standard usage message.
    """
    print "Usage:\n  runall [-v <verbosity>] [([-d <test directory name>] | " \
          "[<file1.py> ... ])]"


def getModuleFilenames(sourceDirectory):
    """
    Returns a list of module filenames that are found in the requested
    directory.

    A module file is a file whose filename matches a 'MODULE_GLOB_MATCH'
    wildcard string (currently '*.py').
    """
    return glob.glob(os.path.join(sourceDirectory, MODULE_GLOB_MATCH))


def getExpandedGlobs(globbedFileList):
    """
    Handle globbed file arguments.

    As Windows does not automatically expand globbed (e.g. '*.py') command
    line file arguments we need to handle them ourselves.
    """
    
    files = []
    
    for currFile in globbedFileList:
        # Establish if it's a wildcard filespec.
        if (('*' in currFile) or ('?' in currFile) or ('[' in currFile)) :
            currFile = glob.glob(currFile)

        if (isinstance(currFile, type([]))):
            # The result was a list of files.
            files.extend(currFile)
        else:
            # The result was a single file.
            files.append(currFile)

    return files


class ExtendedTestLoader(unittest.TestLoader):
    """
    """
    def loadTestsFromModule(self, module):
        """Return a suite of all tests cases contained in the given module"""
        # NOTE: This is copied straight from 'unittest.Testloader' in the
        #       Python distribution. Changes are marked with '+pjl'.
        tests = []
        testSuites = []
        for name in dir(module):
            obj = getattr(module, name)
            if isinstance(obj, (type, types.ClassType)) and \
                   issubclass(obj, unittest.TestCase):
                tests.append(self.loadTestsFromTestCase(obj))
            elif isinstance(obj, (type, types.ClassType)) and \
                     issubclass(obj, unittest.TestSuite): # +pjl
                testSuites.append(obj()) # +pjl
        testSuites.append(self.suiteClass(tests)) # +pjl
        return self.suiteClass(testSuites) # +pjl



if (__name__ == "__main__"):
    # Process the command line options...
    options, files = getopt.getopt(sys.argv[1:], ARGV_OPTIONS)

    for o, a in options:
        # Help...
        if (o == "-h"):
            showUsage()
            sys.exit()

        # Verbosity level..
        if (o == "-v"):
            verbosity = int(a)

        # Name of test directory...
        if (o == "-d"):
            if (a == "."):
                a = ""

            if (("." in a)):
                print "Error : Test directory name cannot contain '.'"
                sys.exit(1)

            testDirectory = a

    # If no file names have been supplied on the command line we retrieve
    # a list of module file names from the requested test directory.
    if (not files):
        files = getModuleFilenames(testDirectory)
        
        # Add path to files to 'sys.path' so the modules are found.
        sys.path.insert(1,testDirectory)
    else:
        files = getExpandedGlobs(files) # Handles globbed file args under Win.

        # Add paths to files to 'sys.path' so the modules are found.
        for filename in files:
            newPath = os.path.split(filename)[0]
            if (newPath not in sys.path):
                sys.path.insert(1, newPath)

    # Turn module filenames into module names.
    moduleNames = [os.path.split(os.path.splitext(filename)[0])[1] \
                   for filename in files]

    # This ensures we first look in the current working directory for packages
    # etc, & never the execution directory of 'runally.py' itself.
    sys.path[0] = os.getcwd()

    # Prepare a test suite and run the tests...
    # Based on Usenet post:
    #   http://groups.google.com/groups?selm=u8z45yodt.fsf%40online.no
    #suite = unittest.defaultTestLoader.loadTestsFromNames(moduleNames)
    suite = ExtendedTestLoader().loadTestsFromNames(moduleNames)
    
    runner = unittest.TextTestRunner(verbosity=verbosity)
    runner.run(suite)
