# User Guide Index

## `classifier`
- [Adaline](user_guide/classifier/Adaline.md)
- [EnsembleVoteClassifier](user_guide/classifier/EnsembleVoteClassifier.md)
- [LogisticRegression](user_guide/classifier/LogisticRegression.md)
- [MultiLayerPerceptron](user_guide/classifier/MultiLayerPerceptron.md)
- [OneRClassifier](user_guide/classifier/OneRClassifier.md)
- [Perceptron](user_guide/classifier/Perceptron.md)
- [SoftmaxRegression](user_guide/classifier/SoftmaxRegression.md)
- [StackingClassifier](user_guide/classifier/StackingClassifier.md)
- [StackingCVClassifier](user_guide/classifier/StackingCVClassifier.md)

## `cluster`
- [Kmeans](user_guide/cluster/Kmeans.md)

## `data`
- [autompg_data](user_guide/data/autompg_data.md)
- [boston_housing_data](user_guide/data/boston_housing_data.md)
- [iris_data](user_guide/data/iris_data.md)
- [loadlocal_mnist](user_guide/data/loadlocal_mnist.md)
- [make_multiplexer_dataset](user_guide/data/make_multiplexer_dataset.md)
- [mnist_data](user_guide/data/mnist_data.md)
- [three_blobs_data](user_guide/data/three_blobs_data.md)
- [wine_data](user_guide/data/wine_data.md)

## `evaluate`
- [accuracy_score](user_guide/evaluate/accuracy_score.md)
- [bias_variance_decomp](user_guide/evaluate/bias_variance_decomp.md)
- [bootstrap](user_guide/evaluate/bootstrap.md)
- [bootstrap_point632_score](user_guide/evaluate/bootstrap_point632_score.md)
- [BootstrapOutOfBag](user_guide/evaluate/BootstrapOutOfBag.md)
- [cochrans_q](user_guide/evaluate/cochrans_q.md)
- [combined_ftest_5x2cv](user_guide/evaluate/combined_ftest_5x2cv.md)
- [confusion_matrix](user_guide/evaluate/confusion_matrix.md)
- [create_counterfactual](user_guide/evaluate/create_counterfactual.md)
- [feature_importance_permutation](user_guide/evaluate/feature_importance_permutation.md)
- [ftest](user_guide/evaluate/ftest.md)
- [lift_score](user_guide/evaluate/lift_score.md)
- [mcnemar_table](user_guide/evaluate/mcnemar_table.md)
- [mcnemar_tables](user_guide/evaluate/mcnemar_tables.md)
- [mcnemar](user_guide/evaluate/mcnemar.md)
- [paired_ttest_5x2cv](user_guide/evaluate/paired_ttest_5x2cv.md)
- [paired_ttest_kfold_cv](user_guide/evaluate/paired_ttest_kfold_cv.md)
- [paired_ttest_resampled](user_guide/evaluate/paired_ttest_resampled.md)
- [permutation_test](user_guide/evaluate/permutation_test.md)
- [PredefinedHoldoutSplit](user_guide/evaluate/PredefinedHoldoutSplit.md)
- [proportion_difference](user_guide/evaluate/proportion_difference.md)
- [RandomHoldoutSplit](user_guide/evaluate/RandomHoldoutSplit.md)
- [scoring](user_guide/evaluate/scoring.md)

## `feature_extraction`
- [LinearDiscriminantAnalysis](user_guide/feature_extraction/LinearDiscriminantAnalysis.md)
- [PrincipalComponentAnalysis](user_guide/feature_extraction/PrincipalComponentAnalysis.md)
- [RBFKernelPCA](user_guide/feature_extraction/RBFKernelPCA.md)

## `feature_selection`
- [ColumnSelector](user_guide/feature_selection/ColumnSelector.md)
- [ExhaustiveFeatureSelector](user_guide/feature_selection/ExhaustiveFeatureSelector.md)
- [SequentialFeatureSelector](user_guide/feature_selection/SequentialFeatureSelector.md)

## `file_io`
- [find_filegroups](user_guide/file_io/find_filegroups.md)
- [find_files](user_guide/file_io/find_files.md)

## `frequent_patterns`
- [apriori](user_guide/frequent_patterns/apriori.md)
- [association_rules](user_guide/frequent_patterns/association_rules.md)
- [fpgrowth](user_guide/frequent_patterns/fpgrowth.md)
- [fpmax](user_guide/frequent_patterns/fpmax.md)

## `general concepts`
- [activation-functions](user_guide/general_concepts/activation-functions.md)
- [gradient-optimization](user_guide/general_concepts/gradient-optimization.md)
- [linear-gradient-derivative](user_guide/general_concepts/linear-gradient-derivative.md)
- [regularization-linear](user_guide/general_concepts/regularization-linear.md)

## `image`
- [extract_face_landmarks](user_guide/image/extract_face_landmarks.md)

## `math`
- [num_combinations](user_guide/math/num_combinations.md)
- [num_permutations](user_guide/math/num_permutations.md)

## `plotting`
- [category_scatter](user_guide/plotting/category_scatter.md)
- [checkerboard_plot](user_guide/plotting/checkerboard_plot.md)
- [ecdf](user_guide/plotting/ecdf.md)
- [enrichment_plot](user_guide/plotting/enrichment_plot.md)
- [heatmap](user_guide/plotting/heatmap.md)
- [plot_confusion_matrix](user_guide/plotting/plot_confusion_matrix.md)
- [plot_pca_correlation_graph](user_guide/plotting/plot_pca_correlation_graph.md)
- [plot_decision_regions](user_guide/plotting/plot_decision_regions.md)
- [plot_learning_curves](user_guide/plotting/plot_learning_curves.md)
- [plot_linear_regression](user_guide/plotting/plot_linear_regression.md)
- [plot_sequential_feature_selection](user_guide/plotting/plot_sequential_feature_selection.md)
- [scatterplotmatrix](user_guide/plotting/scatterplotmatrix.md)
- [stacked_barplot](user_guide/plotting/stacked_barplot.md)

## `preprocessing`
- [CopyTransformer](user_guide/preprocessing/CopyTransformer.md)
- [DenseTransformer](user_guide/preprocessing/DenseTransformer.md)
- [MeanCenterer](user_guide/preprocessing/MeanCenterer.md)
- [minmax_scaling](user_guide/preprocessing/minmax_scaling.md)
- [one-hot_encoding](user_guide/preprocessing/one-hot_encoding.md)
- [shuffle_arrays_unison](user_guide/preprocessing/shuffle_arrays_unison.md)
- [standardize](user_guide/preprocessing/standardize.md)
- [TransactionEncoder](user_guide/preprocessing/TransactionEncoder.md)

## `regressor`
- [LinearRegression](user_guide/regressor/LinearRegression.md)
- [StackingCVRegressor](user_guide/regressor/StackingCVRegressor.md)
- [StackingRegressor](user_guide/regressor/StackingRegressor.md)

## `text`
- [generalize_names](user_guide/text/generalize_names.md)
- [generalize_names_duplcheck](user_guide/text/generalize_names_duplcheck.md)
- [tokenizer](user_guide/text/tokenizer.md)

## `utils`
- [Counter](user_guide/utils/Counter.md)