title: Attribute Lists Extension

# Attribute Lists

## Summary

The Attribute Lists extension adds a syntax to define attributes on the various
HTML elements in markdown's output.

This extension is included in the standard Markdown library.

## Syntax

The basic syntax was inspired by [Maruku][]'s Attribute Lists feature.

[Maruku]: http://maruku.rubyforge.org/proposal.html#attribute_lists

### The List

An example attribute list might look like this:

```text
{: #someid .someclass somekey='some value' }
```

A word which starts with a hash (`#`) will set the id of an element.

A word which starts with a dot (`.`) will be added to the list of classes
assigned to an element.

A key/value pair (`somekey='some value'`) will assign that pair to the element.

Be aware that while the dot syntax will add to a class, using key/value pairs
will always override the previously defined attribute. Consider the following:

```text
{: #id1 .class1 id=id2 class="class2 class3" .class4 }
```

The above example would result in the following attributes being defined:

```text
id="id2" class="class2 class3 class4"
```

### Block Level

To define attributes for a block level element, the attribute list should
be defined on the last line of the block by itself.

```text
This is a paragraph.
{: #an_id .a_class }
```

The above results in the following output:

```html
<p id="an_id" class="a_class">This is a paragraph.</p>
```

The one exception is headers, as they are only ever allowed on one line.

```text
A setext style header {: #setext}
=================================

### A hash style header ### {: #hash }
```

The above results in the following output:

```html
<h1 id="setext">A setext style header</h1>
<h3 id="hash">A hash style header</h3>
```

### Inline

To define attributes on inline elements, the attribute list should be defined
immediately after the inline element with no white space.

```text
[link](http://example.com){: class="foo bar" title="Some title!" }
```

The above results in the following output:

```html
<p><a href="http://example.com" class="foo bar" title="Some title!">link</a></p>
```

## Usage

See [Extensions](index.md) for general extension usage. Use `attr_list` as the
name of the extension.

This extension does not accept any special configuration options.

A trivial example:

```python
markdown.markdown(some_text, extensions=['attr_list'])
```
