# v0.3.0 migration guide

Version 0.3.0 of magicgui introduced some changes to the events and callbacks API.
See https://github.com/napari/magicgui/pull/253 for details

## Callbacks now receive the value directly, instead of an `Event` object

magicgui 0.3.0 is now using [psygnal](https://github.com/tlambert03/psygnal)
as its event/callback handler.

Callbacks connected to `widget.changed` (and other event emitters) may now receive the
value(s) directly, instead of an event object:

````{admonition} **Old Method**
:class: danger

```python
@widget.changed.connect
def my_callback(event):
    # event was an `Event` object with a `value` attribute
    new_value = event.value
```
````

Existing code using callbacks with a single positional
argument will continue to receive a single Event object (and a
warning will be shown, until v0.4.0 where it will become an error).

To silence the warning and opt in to the new pattern of receiving
value directly, you can do one of two things:

1. type hint your single positional argument as *anything* other than `magicgui.events.Event`
2. provide a callback that takes no arguments

````{admonition} **New Method**
:class: tip

```python
@widget.changed.connect
def my_callback(new_value: int):
    ...  # use new_value directly

# or, if you don't need to use new_value
@widget.changed.connect
def my_callback():
    # something that didn't need the value
    ...
```
````

## Event emitters take no keyword arguments

For the few packages who were manually emitting change events,
you should no longer provide the `value=` keyword when emitting.

````{admonition} **Old Method 👎**
:class: danger

```python
widget.changed(value='whatever')
```
````

````{admonition} **New Method 👍**
:class: tip

```python
widget.changed.emit('whatever')
# OR (if you prefer the direct __call__ syntax)
widget.changed('whatever')
```
````
