# vi:et:ts=4 sw=4 sts=4
#
# local-pipelines : run Bitbucket pipelines locally
# Copyright (C) 2016  Gary Kramlich <grim@reaperworld.com>
# Copyright (C) 2016  Sean Farley <sean@farley.io>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA

from __future__ import print_function

from pipelines.step import Step


class TestStep(object):
    def _test(self, step, image, script):
        assert step.image == image

        real_script = ["#!/bin/bash", "set -ex"]
        if script is not None:
            real_script.extend(script)

        assert step.script == real_script
        assert str(step) == "\n".join(real_script)

    def test_manual(self):
        tests = {
            None: None,
            "none": None,
            "empty": [],
            "single": ["one"],
            "double": ["one", "two"],
        }

        for image, script in tests.items():
            self._test(Step(image, script), image, script)

    def test_from_dict(self):
        tests = [
            {
                "image": None,
                "script": None,
            }, {
                "image": "none",
                "script": None,
            }, {
                "image": "empty",
                "script": [],
            }, {
                "image": "single",
                "script": ["one"],
            }, {
                "image": "double",
                "script": ["one", "two"],
            },
        ]

        for test in tests:
            step = Step.from_dict(test)

            self._test(step, test["image"], test["script"])
