
/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 **       Produced by conv_template.py                                      **
 *****************************************************************************
 */

#line 1
/*
 * Taken from numpy/core/src/npymath/npy_math.c.src
 * date: 9/11/2012
 * git hash: 75b8119f8145ab08a436ecfd7de868c6c6ba8f6d
 */

/*
 * vim:syntax=c
 * A small module to implement missing C99 math capabilities required by numpy
 *
 * Please keep this independant of python ! Only basic types (npy_longdouble)
 * can be used, otherwise, pure C, without any use of Python facilities
 *
 * How to add a function to this section
 * -------------------------------------
 *
 * Say you want to add `foo`, these are the steps and the reasons for them.
 *
 * 1) Add foo to the appropriate list in the configuration system. The
 *    lists can be found in numpy/core/setup.py lines 63-105. Read the
 *    comments that come with them, they are very helpful.
 *
 * 2) The configuration system will define a macro HAVE_FOO if your function
 *    can be linked from the math library. The result can depend on the
 *    optimization flags as well as the compiler, so can't be known ahead of
 *    time. If the function can't be linked, then either it is absent, defined
 *    as a macro, or is an intrinsic (hardware) function.
 *
 *    i) Undefine any possible macros:
 *
 *    #ifdef foo
 *    #undef foo
 *    #endif
 *
 *    ii) Avoid as much as possible to declare any function here. Declaring
 *    functions is not portable: some platforms define some function inline
 *    with a non standard identifier, for example, or may put another
 *    idendifier which changes the calling convention of the function. If you
 *    really have to, ALWAYS declare it for the one platform you are dealing
 *    with:
 *
 *    Not ok:
 *        double exp(double a);
 *
 *    Ok:
 *        #ifdef SYMBOL_DEFINED_WEIRD_PLATFORM
 *        double exp(double);
 *        #endif
 *
 * Some of the code is taken from msun library in FreeBSD, with the following
 * notice:
 *
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */
#include "export.h"
#include "npy_math_private.h"

/*
 *****************************************************************************
 **                     BASIC MATH FUNCTIONS                                **
 *****************************************************************************
 */

/* Original code by Konrad Hinsen.  */
#if !HAVE_EXPM1
DL_EXPORT(double) npy_expm1(double x)
{
    const double u = npy_exp(x);

    if (u == 1.0) {
        return x;
    } else if (u - 1.0 == -1.0) {
        return -1;
    } else {
        return (u - 1.0) * x/npy_log(u);
    }
}
#endif

#if !HAVE_LOG1P
DL_EXPORT(double) npy_log1p(double x)
{
    const double u = 1. + x;
    const double d = u - 1.;

    if (d == 0) {
        return x;
    } else {
        return npy_log(u) * x / d;
    }
}
#endif

/* Taken from FreeBSD mlib, adapted for numpy
 *
 * XXX: we could be a bit faster by reusing high/low words for inf/nan
 * classification instead of calling npy_isinf/npy_isnan: we should have some
 * macros for this, though, instead of doing it manually
 */
#if !HAVE_ATAN2
/* XXX: we should have this in npy_math.h */
#define NPY_DBL_EPSILON 1.2246467991473531772E-16
DL_EXPORT(double) npy_atan2(double y, double x)
{
    npy_int32 k, m, iy, ix, hx, hy;
    npy_uint32 lx,ly;
    double z;

    EXTRACT_WORDS(hx, lx, x);
    ix = hx & 0x7fffffff;
    EXTRACT_WORDS(hy, ly, y);
    iy = hy & 0x7fffffff;

    /* if x or y is nan, return nan */
    if (npy_isnan(x * y)) {
        return x + y;
    }

    if (x == 1.0) {
        return npy_atan(y);
    }

    m = 2 * npy_signbit(x) + npy_signbit(y);
    if (y == 0.0) {
        switch(m) {
        case 0:
        case 1: return  y;  /* atan(+-0,+anything)=+-0 */
        case 2: return  NPY_PI;/* atan(+0,-anything) = pi */
        case 3: return -NPY_PI;/* atan(-0,-anything) =-pi */
        }
    }

    if (x == 0.0) {
        return y > 0 ? NPY_PI_2 : -NPY_PI_2;
    }

    if (npy_isinf(x)) {
        if (npy_isinf(y)) {
            switch(m) {
                case 0: return  NPY_PI_4;/* atan(+INF,+INF) */
                case 1: return -NPY_PI_4;/* atan(-INF,+INF) */
                case 2: return  3.0*NPY_PI_4;/*atan(+INF,-INF)*/
                case 3: return -3.0*NPY_PI_4;/*atan(-INF,-INF)*/
            }
        } else {
            switch(m) {
                case 0: return  NPY_PZERO;  /* atan(+...,+INF) */
                case 1: return  NPY_NZERO;  /* atan(-...,+INF) */
                case 2: return  NPY_PI;  /* atan(+...,-INF) */
                case 3: return -NPY_PI;  /* atan(-...,-INF) */
            }
        }
    }

    if (npy_isinf(y)) {
        return y > 0 ? NPY_PI_2 : -NPY_PI_2;
    }

    /* compute y/x */
    k = (iy - ix) >> 20;
    if (k > 60) {            /* |y/x| >  2**60 */
        z = NPY_PI_2 + 0.5 * NPY_DBL_EPSILON;
        m &= 1;
    } else if (hx < 0 && k < -60) {
        z = 0.0;    /* 0 > |y|/x > -2**-60 */
    } else {
        z = npy_atan(npy_fabs(y/x));        /* safe to do y/x */
    }

    switch (m) {
        case 0: return  z  ;    /* atan(+,+) */
        case 1: return -z  ;    /* atan(-,+) */
        case 2: return  NPY_PI - (z - NPY_DBL_EPSILON);/* atan(+,-) */
        default: /* case 3 */
            return  (z - NPY_DBL_EPSILON) - NPY_PI;/* atan(-,-) */
    }
}

#endif

#if !HAVE_HYPOT
DL_EXPORT(double) npy_hypot(double x, double y)
{
    double yx;

    /* Handle the case where x or y is a NaN */
    if (npy_isnan(x * y)) {
        if (npy_isinf(x) || npy_isinf(y)) {
            return NPY_INFINITY;
        } else {
            return NPY_NAN;
        }
    }

    x = npy_fabs(x);
    y = npy_fabs(y);
    if (x < y) {
        double temp = x;
        x = y;
        y = temp;
    }
    if (x == 0.) {
        return 0.;
    }
    else {
        yx = y/x;
        return x*npy_sqrt(1.+yx*yx);
    }
}
#endif

#if !HAVE_ACOSH
DL_EXPORT(double) npy_acosh(double x)
{
    return 2*npy_log(npy_sqrt((x + 1.0)/2) + npy_sqrt((x - 1.0)/2));
}
#endif

#if !HAVE_ASINH
DL_EXPORT(double) npy_asinh(double xx)
{
    double x, d;
    int sign;
    if (xx < 0.0) {
        sign = -1;
        x = -xx;
    }
    else {
        sign = 1;
        x = xx;
    }
    if (x > 1e8) {
        d = x;
    } else {
        d = npy_sqrt(x*x + 1);
    }
    return sign*npy_log1p(x*(1.0 + x/(d+1)));
}
#endif

#if !HAVE_ATANH
DL_EXPORT(double) npy_atanh(double x)
{
    if (x > 0) {
        return -0.5*npy_log1p(-2.0*x/(1.0 + x));
    }
    else {
        return 0.5*npy_log1p(2.0*x/(1.0 - x));
    }
}
#endif

#if !HAVE_RINT
DL_EXPORT(double) npy_rint(double x)
{
    double y, r;

    y = npy_floor(x);
    r = x - y;

    if (r > 0.5) {
        y += 1.0;
    }

    /* Round to nearest even */
    if (r == 0.5) {
        r = y - 2.0*npy_floor(0.5*y);
        if (r == 1.0) {
            y += 1.0;
        }
    }
    return y;
}
#endif

#if !HAVE_TRUNC
DL_EXPORT(double) npy_trunc(double x)
{
    return x < 0 ? npy_ceil(x) : npy_floor(x);
}
#endif

#if !HAVE_EXP2
DL_EXPORT(double) npy_exp2(double x)
{
    return npy_exp(NPY_LOGE2*x);
}
#endif

#if !HAVE_LOG2
DL_EXPORT(double) npy_log2(double x)
{
    return NPY_LOG2E*npy_log(x);
}
#endif

/*
 * if C99 extensions not available then define dummy functions that use the
 * double versions for
 *
 * sin, cos, tan
 * sinh, cosh, tanh,
 * fabs, floor, ceil, rint, trunc
 * sqrt, log10, log, exp, expm1
 * asin, acos, atan,
 * asinh, acosh, atanh
 *
 * hypot, atan2, pow, fmod, modf
 *
 * We assume the above are always available in their double versions.
 *
 * NOTE: some facilities may be available as macro only  instead of functions.
 * For simplicity, we define our own functions and undef the macros. We could
 * instead test for the macro, but I am lazy to do that for now.
 */

#line 330

#line 337

#ifdef sinl
#undef sinl
#endif
#if !HAVE_SINL
DL_EXPORT(npy_longdouble) npy_sinl(npy_longdouble x)
{
    return (npy_longdouble) npy_sin((double)x);
}
#endif


#line 337

#ifdef cosl
#undef cosl
#endif
#if !HAVE_COSL
DL_EXPORT(npy_longdouble) npy_cosl(npy_longdouble x)
{
    return (npy_longdouble) npy_cos((double)x);
}
#endif


#line 337

#ifdef tanl
#undef tanl
#endif
#if !HAVE_TANL
DL_EXPORT(npy_longdouble) npy_tanl(npy_longdouble x)
{
    return (npy_longdouble) npy_tan((double)x);
}
#endif


#line 337

#ifdef sinhl
#undef sinhl
#endif
#if !HAVE_SINHL
DL_EXPORT(npy_longdouble) npy_sinhl(npy_longdouble x)
{
    return (npy_longdouble) npy_sinh((double)x);
}
#endif


#line 337

#ifdef coshl
#undef coshl
#endif
#if !HAVE_COSHL
DL_EXPORT(npy_longdouble) npy_coshl(npy_longdouble x)
{
    return (npy_longdouble) npy_cosh((double)x);
}
#endif


#line 337

#ifdef tanhl
#undef tanhl
#endif
#if !HAVE_TANHL
DL_EXPORT(npy_longdouble) npy_tanhl(npy_longdouble x)
{
    return (npy_longdouble) npy_tanh((double)x);
}
#endif


#line 337

#ifdef fabsl
#undef fabsl
#endif
#if !HAVE_FABSL
DL_EXPORT(npy_longdouble) npy_fabsl(npy_longdouble x)
{
    return (npy_longdouble) npy_fabs((double)x);
}
#endif


#line 337

#ifdef floorl
#undef floorl
#endif
#if !HAVE_FLOORL
DL_EXPORT(npy_longdouble) npy_floorl(npy_longdouble x)
{
    return (npy_longdouble) npy_floor((double)x);
}
#endif


#line 337

#ifdef ceill
#undef ceill
#endif
#if !HAVE_CEILL
DL_EXPORT(npy_longdouble) npy_ceill(npy_longdouble x)
{
    return (npy_longdouble) npy_ceil((double)x);
}
#endif


#line 337

#ifdef rintl
#undef rintl
#endif
#if !HAVE_RINTL
DL_EXPORT(npy_longdouble) npy_rintl(npy_longdouble x)
{
    return (npy_longdouble) npy_rint((double)x);
}
#endif


#line 337

#ifdef truncl
#undef truncl
#endif
#if !HAVE_TRUNCL
DL_EXPORT(npy_longdouble) npy_truncl(npy_longdouble x)
{
    return (npy_longdouble) npy_trunc((double)x);
}
#endif


#line 337

#ifdef sqrtl
#undef sqrtl
#endif
#if !HAVE_SQRTL
DL_EXPORT(npy_longdouble) npy_sqrtl(npy_longdouble x)
{
    return (npy_longdouble) npy_sqrt((double)x);
}
#endif


#line 337

#ifdef log10l
#undef log10l
#endif
#if !HAVE_LOG10L
DL_EXPORT(npy_longdouble) npy_log10l(npy_longdouble x)
{
    return (npy_longdouble) npy_log10((double)x);
}
#endif


#line 337

#ifdef logl
#undef logl
#endif
#if !HAVE_LOGL
DL_EXPORT(npy_longdouble) npy_logl(npy_longdouble x)
{
    return (npy_longdouble) npy_log((double)x);
}
#endif


#line 337

#ifdef expl
#undef expl
#endif
#if !HAVE_EXPL
DL_EXPORT(npy_longdouble) npy_expl(npy_longdouble x)
{
    return (npy_longdouble) npy_exp((double)x);
}
#endif


#line 337

#ifdef expm1l
#undef expm1l
#endif
#if !HAVE_EXPM1L
DL_EXPORT(npy_longdouble) npy_expm1l(npy_longdouble x)
{
    return (npy_longdouble) npy_expm1((double)x);
}
#endif


#line 337

#ifdef asinl
#undef asinl
#endif
#if !HAVE_ASINL
DL_EXPORT(npy_longdouble) npy_asinl(npy_longdouble x)
{
    return (npy_longdouble) npy_asin((double)x);
}
#endif


#line 337

#ifdef acosl
#undef acosl
#endif
#if !HAVE_ACOSL
DL_EXPORT(npy_longdouble) npy_acosl(npy_longdouble x)
{
    return (npy_longdouble) npy_acos((double)x);
}
#endif


#line 337

#ifdef atanl
#undef atanl
#endif
#if !HAVE_ATANL
DL_EXPORT(npy_longdouble) npy_atanl(npy_longdouble x)
{
    return (npy_longdouble) npy_atan((double)x);
}
#endif


#line 337

#ifdef asinhl
#undef asinhl
#endif
#if !HAVE_ASINHL
DL_EXPORT(npy_longdouble) npy_asinhl(npy_longdouble x)
{
    return (npy_longdouble) npy_asinh((double)x);
}
#endif


#line 337

#ifdef acoshl
#undef acoshl
#endif
#if !HAVE_ACOSHL
DL_EXPORT(npy_longdouble) npy_acoshl(npy_longdouble x)
{
    return (npy_longdouble) npy_acosh((double)x);
}
#endif


#line 337

#ifdef atanhl
#undef atanhl
#endif
#if !HAVE_ATANHL
DL_EXPORT(npy_longdouble) npy_atanhl(npy_longdouble x)
{
    return (npy_longdouble) npy_atanh((double)x);
}
#endif


#line 337

#ifdef log1pl
#undef log1pl
#endif
#if !HAVE_LOG1PL
DL_EXPORT(npy_longdouble) npy_log1pl(npy_longdouble x)
{
    return (npy_longdouble) npy_log1p((double)x);
}
#endif


#line 337

#ifdef exp2l
#undef exp2l
#endif
#if !HAVE_EXP2L
DL_EXPORT(npy_longdouble) npy_exp2l(npy_longdouble x)
{
    return (npy_longdouble) npy_exp2((double)x);
}
#endif


#line 337

#ifdef log2l
#undef log2l
#endif
#if !HAVE_LOG2L
DL_EXPORT(npy_longdouble) npy_log2l(npy_longdouble x)
{
    return (npy_longdouble) npy_log2((double)x);
}
#endif



#line 354
#ifdef atan2l
#undef atan2l
#endif
#if !HAVE_ATAN2L
DL_EXPORT(npy_longdouble) npy_atan2l(npy_longdouble x, npy_longdouble y)
{
    return (npy_longdouble) npy_atan2((double)x, (double) y);
}
#endif

#line 354
#ifdef hypotl
#undef hypotl
#endif
#if !HAVE_HYPOTL
DL_EXPORT(npy_longdouble) npy_hypotl(npy_longdouble x, npy_longdouble y)
{
    return (npy_longdouble) npy_hypot((double)x, (double) y);
}
#endif

#line 354
#ifdef powl
#undef powl
#endif
#if !HAVE_POWL
DL_EXPORT(npy_longdouble) npy_powl(npy_longdouble x, npy_longdouble y)
{
    return (npy_longdouble) npy_pow((double)x, (double) y);
}
#endif

#line 354
#ifdef fmodl
#undef fmodl
#endif
#if !HAVE_FMODL
DL_EXPORT(npy_longdouble) npy_fmodl(npy_longdouble x, npy_longdouble y)
{
    return (npy_longdouble) npy_fmod((double)x, (double) y);
}
#endif

#line 354
#ifdef copysignl
#undef copysignl
#endif
#if !HAVE_COPYSIGNL
DL_EXPORT(npy_longdouble) npy_copysignl(npy_longdouble x, npy_longdouble y)
{
    return (npy_longdouble) npy_copysign((double)x, (double) y);
}
#endif


#ifdef modfl
#undef modfl
#endif
#if !HAVE_MODFL
DL_EXPORT(npy_longdouble) npy_modfl(npy_longdouble x, npy_longdouble *iptr)
{
    double niptr;
    double y = npy_modf((double)x, &niptr);
    *iptr = (npy_longdouble) niptr;
    return (npy_longdouble) y;
}
#endif


#line 330

#line 337

#ifdef sinf
#undef sinf
#endif
#if !HAVE_SINF
DL_EXPORT(npy_float) npy_sinf(npy_float x)
{
    return (npy_float) npy_sin((double)x);
}
#endif


#line 337

#ifdef cosf
#undef cosf
#endif
#if !HAVE_COSF
DL_EXPORT(npy_float) npy_cosf(npy_float x)
{
    return (npy_float) npy_cos((double)x);
}
#endif


#line 337

#ifdef tanf
#undef tanf
#endif
#if !HAVE_TANF
DL_EXPORT(npy_float) npy_tanf(npy_float x)
{
    return (npy_float) npy_tan((double)x);
}
#endif


#line 337

#ifdef sinhf
#undef sinhf
#endif
#if !HAVE_SINHF
DL_EXPORT(npy_float) npy_sinhf(npy_float x)
{
    return (npy_float) npy_sinh((double)x);
}
#endif


#line 337

#ifdef coshf
#undef coshf
#endif
#if !HAVE_COSHF
DL_EXPORT(npy_float) npy_coshf(npy_float x)
{
    return (npy_float) npy_cosh((double)x);
}
#endif


#line 337

#ifdef tanhf
#undef tanhf
#endif
#if !HAVE_TANHF
DL_EXPORT(npy_float) npy_tanhf(npy_float x)
{
    return (npy_float) npy_tanh((double)x);
}
#endif


#line 337

#ifdef fabsf
#undef fabsf
#endif
#if !HAVE_FABSF
DL_EXPORT(npy_float) npy_fabsf(npy_float x)
{
    return (npy_float) npy_fabs((double)x);
}
#endif


#line 337

#ifdef floorf
#undef floorf
#endif
#if !HAVE_FLOORF
DL_EXPORT(npy_float) npy_floorf(npy_float x)
{
    return (npy_float) npy_floor((double)x);
}
#endif


#line 337

#ifdef ceilf
#undef ceilf
#endif
#if !HAVE_CEILF
DL_EXPORT(npy_float) npy_ceilf(npy_float x)
{
    return (npy_float) npy_ceil((double)x);
}
#endif


#line 337

#ifdef rintf
#undef rintf
#endif
#if !HAVE_RINTF
DL_EXPORT(npy_float) npy_rintf(npy_float x)
{
    return (npy_float) npy_rint((double)x);
}
#endif


#line 337

#ifdef truncf
#undef truncf
#endif
#if !HAVE_TRUNCF
DL_EXPORT(npy_float) npy_truncf(npy_float x)
{
    return (npy_float) npy_trunc((double)x);
}
#endif


#line 337

#ifdef sqrtf
#undef sqrtf
#endif
#if !HAVE_SQRTF
DL_EXPORT(npy_float) npy_sqrtf(npy_float x)
{
    return (npy_float) npy_sqrt((double)x);
}
#endif


#line 337

#ifdef log10f
#undef log10f
#endif
#if !HAVE_LOG10F
DL_EXPORT(npy_float) npy_log10f(npy_float x)
{
    return (npy_float) npy_log10((double)x);
}
#endif


#line 337

#ifdef logf
#undef logf
#endif
#if !HAVE_LOGF
DL_EXPORT(npy_float) npy_logf(npy_float x)
{
    return (npy_float) npy_log((double)x);
}
#endif


#line 337

#ifdef expf
#undef expf
#endif
#if !HAVE_EXPF
DL_EXPORT(npy_float) npy_expf(npy_float x)
{
    return (npy_float) npy_exp((double)x);
}
#endif


#line 337

#ifdef expm1f
#undef expm1f
#endif
#if !HAVE_EXPM1F
DL_EXPORT(npy_float) npy_expm1f(npy_float x)
{
    return (npy_float) npy_expm1((double)x);
}
#endif


#line 337

#ifdef asinf
#undef asinf
#endif
#if !HAVE_ASINF
DL_EXPORT(npy_float) npy_asinf(npy_float x)
{
    return (npy_float) npy_asin((double)x);
}
#endif


#line 337

#ifdef acosf
#undef acosf
#endif
#if !HAVE_ACOSF
DL_EXPORT(npy_float) npy_acosf(npy_float x)
{
    return (npy_float) npy_acos((double)x);
}
#endif


#line 337

#ifdef atanf
#undef atanf
#endif
#if !HAVE_ATANF
DL_EXPORT(npy_float) npy_atanf(npy_float x)
{
    return (npy_float) npy_atan((double)x);
}
#endif


#line 337

#ifdef asinhf
#undef asinhf
#endif
#if !HAVE_ASINHF
DL_EXPORT(npy_float) npy_asinhf(npy_float x)
{
    return (npy_float) npy_asinh((double)x);
}
#endif


#line 337

#ifdef acoshf
#undef acoshf
#endif
#if !HAVE_ACOSHF
DL_EXPORT(npy_float) npy_acoshf(npy_float x)
{
    return (npy_float) npy_acosh((double)x);
}
#endif


#line 337

#ifdef atanhf
#undef atanhf
#endif
#if !HAVE_ATANHF
DL_EXPORT(npy_float) npy_atanhf(npy_float x)
{
    return (npy_float) npy_atanh((double)x);
}
#endif


#line 337

#ifdef log1pf
#undef log1pf
#endif
#if !HAVE_LOG1PF
DL_EXPORT(npy_float) npy_log1pf(npy_float x)
{
    return (npy_float) npy_log1p((double)x);
}
#endif


#line 337

#ifdef exp2f
#undef exp2f
#endif
#if !HAVE_EXP2F
DL_EXPORT(npy_float) npy_exp2f(npy_float x)
{
    return (npy_float) npy_exp2((double)x);
}
#endif


#line 337

#ifdef log2f
#undef log2f
#endif
#if !HAVE_LOG2F
DL_EXPORT(npy_float) npy_log2f(npy_float x)
{
    return (npy_float) npy_log2((double)x);
}
#endif



#line 354
#ifdef atan2f
#undef atan2f
#endif
#if !HAVE_ATAN2F
DL_EXPORT(npy_float) npy_atan2f(npy_float x, npy_float y)
{
    return (npy_float) npy_atan2((double)x, (double) y);
}
#endif

#line 354
#ifdef hypotf
#undef hypotf
#endif
#if !HAVE_HYPOTF
DL_EXPORT(npy_float) npy_hypotf(npy_float x, npy_float y)
{
    return (npy_float) npy_hypot((double)x, (double) y);
}
#endif

#line 354
#ifdef powf
#undef powf
#endif
#if !HAVE_POWF
DL_EXPORT(npy_float) npy_powf(npy_float x, npy_float y)
{
    return (npy_float) npy_pow((double)x, (double) y);
}
#endif

#line 354
#ifdef fmodf
#undef fmodf
#endif
#if !HAVE_FMODF
DL_EXPORT(npy_float) npy_fmodf(npy_float x, npy_float y)
{
    return (npy_float) npy_fmod((double)x, (double) y);
}
#endif

#line 354
#ifdef copysignf
#undef copysignf
#endif
#if !HAVE_COPYSIGNF
DL_EXPORT(npy_float) npy_copysignf(npy_float x, npy_float y)
{
    return (npy_float) npy_copysign((double)x, (double) y);
}
#endif


#ifdef modff
#undef modff
#endif
#if !HAVE_MODFF
DL_EXPORT(npy_float) npy_modff(npy_float x, npy_float *iptr)
{
    double niptr;
    double y = npy_modf((double)x, &niptr);
    *iptr = (npy_float) niptr;
    return (npy_float) y;
}
#endif




/*
 * Decorate all the math functions which are available on the current platform
 */

#line 390
#line 396
#if HAVE_SINL
DL_EXPORT(npy_longdouble) npy_sinl(npy_longdouble x)
{
    return sinl(x);
}
#endif


#line 396
#if HAVE_COSL
DL_EXPORT(npy_longdouble) npy_cosl(npy_longdouble x)
{
    return cosl(x);
}
#endif


#line 396
#if HAVE_TANL
DL_EXPORT(npy_longdouble) npy_tanl(npy_longdouble x)
{
    return tanl(x);
}
#endif


#line 396
#if HAVE_SINHL
DL_EXPORT(npy_longdouble) npy_sinhl(npy_longdouble x)
{
    return sinhl(x);
}
#endif


#line 396
#if HAVE_COSHL
DL_EXPORT(npy_longdouble) npy_coshl(npy_longdouble x)
{
    return coshl(x);
}
#endif


#line 396
#if HAVE_TANHL
DL_EXPORT(npy_longdouble) npy_tanhl(npy_longdouble x)
{
    return tanhl(x);
}
#endif


#line 396
#if HAVE_FABSL
DL_EXPORT(npy_longdouble) npy_fabsl(npy_longdouble x)
{
    return fabsl(x);
}
#endif


#line 396
#if HAVE_FLOORL
DL_EXPORT(npy_longdouble) npy_floorl(npy_longdouble x)
{
    return floorl(x);
}
#endif


#line 396
#if HAVE_CEILL
DL_EXPORT(npy_longdouble) npy_ceill(npy_longdouble x)
{
    return ceill(x);
}
#endif


#line 396
#if HAVE_RINTL
DL_EXPORT(npy_longdouble) npy_rintl(npy_longdouble x)
{
    return rintl(x);
}
#endif


#line 396
#if HAVE_TRUNCL
DL_EXPORT(npy_longdouble) npy_truncl(npy_longdouble x)
{
    return truncl(x);
}
#endif


#line 396
#if HAVE_SQRTL
DL_EXPORT(npy_longdouble) npy_sqrtl(npy_longdouble x)
{
    return sqrtl(x);
}
#endif


#line 396
#if HAVE_LOG10L
DL_EXPORT(npy_longdouble) npy_log10l(npy_longdouble x)
{
    return log10l(x);
}
#endif


#line 396
#if HAVE_LOGL
DL_EXPORT(npy_longdouble) npy_logl(npy_longdouble x)
{
    return logl(x);
}
#endif


#line 396
#if HAVE_EXPL
DL_EXPORT(npy_longdouble) npy_expl(npy_longdouble x)
{
    return expl(x);
}
#endif


#line 396
#if HAVE_EXPM1L
DL_EXPORT(npy_longdouble) npy_expm1l(npy_longdouble x)
{
    return expm1l(x);
}
#endif


#line 396
#if HAVE_ASINL
DL_EXPORT(npy_longdouble) npy_asinl(npy_longdouble x)
{
    return asinl(x);
}
#endif


#line 396
#if HAVE_ACOSL
DL_EXPORT(npy_longdouble) npy_acosl(npy_longdouble x)
{
    return acosl(x);
}
#endif


#line 396
#if HAVE_ATANL
DL_EXPORT(npy_longdouble) npy_atanl(npy_longdouble x)
{
    return atanl(x);
}
#endif


#line 396
#if HAVE_ASINHL
DL_EXPORT(npy_longdouble) npy_asinhl(npy_longdouble x)
{
    return asinhl(x);
}
#endif


#line 396
#if HAVE_ACOSHL
DL_EXPORT(npy_longdouble) npy_acoshl(npy_longdouble x)
{
    return acoshl(x);
}
#endif


#line 396
#if HAVE_ATANHL
DL_EXPORT(npy_longdouble) npy_atanhl(npy_longdouble x)
{
    return atanhl(x);
}
#endif


#line 396
#if HAVE_LOG1PL
DL_EXPORT(npy_longdouble) npy_log1pl(npy_longdouble x)
{
    return log1pl(x);
}
#endif


#line 396
#if HAVE_EXP2L
DL_EXPORT(npy_longdouble) npy_exp2l(npy_longdouble x)
{
    return exp2l(x);
}
#endif


#line 396
#if HAVE_LOG2L
DL_EXPORT(npy_longdouble) npy_log2l(npy_longdouble x)
{
    return log2l(x);
}
#endif



#line 409
#if HAVE_ATAN2L
DL_EXPORT(npy_longdouble) npy_atan2l(npy_longdouble x, npy_longdouble y)
{
    return atan2l(x, y);
}
#endif

#line 409
#if HAVE_HYPOTL
DL_EXPORT(npy_longdouble) npy_hypotl(npy_longdouble x, npy_longdouble y)
{
    return hypotl(x, y);
}
#endif

#line 409
#if HAVE_POWL
DL_EXPORT(npy_longdouble) npy_powl(npy_longdouble x, npy_longdouble y)
{
    return powl(x, y);
}
#endif

#line 409
#if HAVE_FMODL
DL_EXPORT(npy_longdouble) npy_fmodl(npy_longdouble x, npy_longdouble y)
{
    return fmodl(x, y);
}
#endif

#line 409
#if HAVE_COPYSIGNL
DL_EXPORT(npy_longdouble) npy_copysignl(npy_longdouble x, npy_longdouble y)
{
    return copysignl(x, y);
}
#endif


#if HAVE_MODFL
DL_EXPORT(npy_longdouble) npy_modfl(npy_longdouble x, npy_longdouble *iptr)
{
    return modfl(x, iptr);
}
#endif


#line 390
#line 396
#if HAVE_SIN
DL_EXPORT(npy_double) npy_sin(npy_double x)
{
    return sin(x);
}
#endif


#line 396
#if HAVE_COS
DL_EXPORT(npy_double) npy_cos(npy_double x)
{
    return cos(x);
}
#endif


#line 396
#if HAVE_TAN
DL_EXPORT(npy_double) npy_tan(npy_double x)
{
    return tan(x);
}
#endif


#line 396
#if HAVE_SINH
DL_EXPORT(npy_double) npy_sinh(npy_double x)
{
    return sinh(x);
}
#endif


#line 396
#if HAVE_COSH
DL_EXPORT(npy_double) npy_cosh(npy_double x)
{
    return cosh(x);
}
#endif


#line 396
#if HAVE_TANH
DL_EXPORT(npy_double) npy_tanh(npy_double x)
{
    return tanh(x);
}
#endif


#line 396
#if HAVE_FABS
DL_EXPORT(npy_double) npy_fabs(npy_double x)
{
    return fabs(x);
}
#endif


#line 396
#if HAVE_FLOOR
DL_EXPORT(npy_double) npy_floor(npy_double x)
{
    return floor(x);
}
#endif


#line 396
#if HAVE_CEIL
DL_EXPORT(npy_double) npy_ceil(npy_double x)
{
    return ceil(x);
}
#endif


#line 396
#if HAVE_RINT
DL_EXPORT(npy_double) npy_rint(npy_double x)
{
    return rint(x);
}
#endif


#line 396
#if HAVE_TRUNC
DL_EXPORT(npy_double) npy_trunc(npy_double x)
{
    return trunc(x);
}
#endif


#line 396
#if HAVE_SQRT
DL_EXPORT(npy_double) npy_sqrt(npy_double x)
{
    return sqrt(x);
}
#endif


#line 396
#if HAVE_LOG10
DL_EXPORT(npy_double) npy_log10(npy_double x)
{
    return log10(x);
}
#endif


#line 396
#if HAVE_LOG
DL_EXPORT(npy_double) npy_log(npy_double x)
{
    return log(x);
}
#endif


#line 396
#if HAVE_EXP
DL_EXPORT(npy_double) npy_exp(npy_double x)
{
    return exp(x);
}
#endif


#line 396
#if HAVE_EXPM1
DL_EXPORT(npy_double) npy_expm1(npy_double x)
{
    return expm1(x);
}
#endif


#line 396
#if HAVE_ASIN
DL_EXPORT(npy_double) npy_asin(npy_double x)
{
    return asin(x);
}
#endif


#line 396
#if HAVE_ACOS
DL_EXPORT(npy_double) npy_acos(npy_double x)
{
    return acos(x);
}
#endif


#line 396
#if HAVE_ATAN
DL_EXPORT(npy_double) npy_atan(npy_double x)
{
    return atan(x);
}
#endif


#line 396
#if HAVE_ASINH
DL_EXPORT(npy_double) npy_asinh(npy_double x)
{
    return asinh(x);
}
#endif


#line 396
#if HAVE_ACOSH
DL_EXPORT(npy_double) npy_acosh(npy_double x)
{
    return acosh(x);
}
#endif


#line 396
#if HAVE_ATANH
DL_EXPORT(npy_double) npy_atanh(npy_double x)
{
    return atanh(x);
}
#endif


#line 396
#if HAVE_LOG1P
DL_EXPORT(npy_double) npy_log1p(npy_double x)
{
    return log1p(x);
}
#endif


#line 396
#if HAVE_EXP2
DL_EXPORT(npy_double) npy_exp2(npy_double x)
{
    return exp2(x);
}
#endif


#line 396
#if HAVE_LOG2
DL_EXPORT(npy_double) npy_log2(npy_double x)
{
    return log2(x);
}
#endif



#line 409
#if HAVE_ATAN2
DL_EXPORT(npy_double) npy_atan2(npy_double x, npy_double y)
{
    return atan2(x, y);
}
#endif

#line 409
#if HAVE_HYPOT
DL_EXPORT(npy_double) npy_hypot(npy_double x, npy_double y)
{
    return hypot(x, y);
}
#endif

#line 409
#if HAVE_POW
DL_EXPORT(npy_double) npy_pow(npy_double x, npy_double y)
{
    return pow(x, y);
}
#endif

#line 409
#if HAVE_FMOD
DL_EXPORT(npy_double) npy_fmod(npy_double x, npy_double y)
{
    return fmod(x, y);
}
#endif

#line 409
#if HAVE_COPYSIGN
DL_EXPORT(npy_double) npy_copysign(npy_double x, npy_double y)
{
    return copysign(x, y);
}
#endif


#if HAVE_MODF
DL_EXPORT(npy_double) npy_modf(npy_double x, npy_double *iptr)
{
    return modf(x, iptr);
}
#endif


#line 390
#line 396
#if HAVE_SINF
DL_EXPORT(npy_float) npy_sinf(npy_float x)
{
    return sinf(x);
}
#endif


#line 396
#if HAVE_COSF
DL_EXPORT(npy_float) npy_cosf(npy_float x)
{
    return cosf(x);
}
#endif


#line 396
#if HAVE_TANF
DL_EXPORT(npy_float) npy_tanf(npy_float x)
{
    return tanf(x);
}
#endif


#line 396
#if HAVE_SINHF
DL_EXPORT(npy_float) npy_sinhf(npy_float x)
{
    return sinhf(x);
}
#endif


#line 396
#if HAVE_COSHF
DL_EXPORT(npy_float) npy_coshf(npy_float x)
{
    return coshf(x);
}
#endif


#line 396
#if HAVE_TANHF
DL_EXPORT(npy_float) npy_tanhf(npy_float x)
{
    return tanhf(x);
}
#endif


#line 396
#if HAVE_FABSF
DL_EXPORT(npy_float) npy_fabsf(npy_float x)
{
    return fabsf(x);
}
#endif


#line 396
#if HAVE_FLOORF
DL_EXPORT(npy_float) npy_floorf(npy_float x)
{
    return floorf(x);
}
#endif


#line 396
#if HAVE_CEILF
DL_EXPORT(npy_float) npy_ceilf(npy_float x)
{
    return ceilf(x);
}
#endif


#line 396
#if HAVE_RINTF
DL_EXPORT(npy_float) npy_rintf(npy_float x)
{
    return rintf(x);
}
#endif


#line 396
#if HAVE_TRUNCF
DL_EXPORT(npy_float) npy_truncf(npy_float x)
{
    return truncf(x);
}
#endif


#line 396
#if HAVE_SQRTF
DL_EXPORT(npy_float) npy_sqrtf(npy_float x)
{
    return sqrtf(x);
}
#endif


#line 396
#if HAVE_LOG10F
DL_EXPORT(npy_float) npy_log10f(npy_float x)
{
    return log10f(x);
}
#endif


#line 396
#if HAVE_LOGF
DL_EXPORT(npy_float) npy_logf(npy_float x)
{
    return logf(x);
}
#endif


#line 396
#if HAVE_EXPF
DL_EXPORT(npy_float) npy_expf(npy_float x)
{
    return expf(x);
}
#endif


#line 396
#if HAVE_EXPM1F
DL_EXPORT(npy_float) npy_expm1f(npy_float x)
{
    return expm1f(x);
}
#endif


#line 396
#if HAVE_ASINF
DL_EXPORT(npy_float) npy_asinf(npy_float x)
{
    return asinf(x);
}
#endif


#line 396
#if HAVE_ACOSF
DL_EXPORT(npy_float) npy_acosf(npy_float x)
{
    return acosf(x);
}
#endif


#line 396
#if HAVE_ATANF
DL_EXPORT(npy_float) npy_atanf(npy_float x)
{
    return atanf(x);
}
#endif


#line 396
#if HAVE_ASINHF
DL_EXPORT(npy_float) npy_asinhf(npy_float x)
{
    return asinhf(x);
}
#endif


#line 396
#if HAVE_ACOSHF
DL_EXPORT(npy_float) npy_acoshf(npy_float x)
{
    return acoshf(x);
}
#endif


#line 396
#if HAVE_ATANHF
DL_EXPORT(npy_float) npy_atanhf(npy_float x)
{
    return atanhf(x);
}
#endif


#line 396
#if HAVE_LOG1PF
DL_EXPORT(npy_float) npy_log1pf(npy_float x)
{
    return log1pf(x);
}
#endif


#line 396
#if HAVE_EXP2F
DL_EXPORT(npy_float) npy_exp2f(npy_float x)
{
    return exp2f(x);
}
#endif


#line 396
#if HAVE_LOG2F
DL_EXPORT(npy_float) npy_log2f(npy_float x)
{
    return log2f(x);
}
#endif



#line 409
#if HAVE_ATAN2F
DL_EXPORT(npy_float) npy_atan2f(npy_float x, npy_float y)
{
    return atan2f(x, y);
}
#endif

#line 409
#if HAVE_HYPOTF
DL_EXPORT(npy_float) npy_hypotf(npy_float x, npy_float y)
{
    return hypotf(x, y);
}
#endif

#line 409
#if HAVE_POWF
DL_EXPORT(npy_float) npy_powf(npy_float x, npy_float y)
{
    return powf(x, y);
}
#endif

#line 409
#if HAVE_FMODF
DL_EXPORT(npy_float) npy_fmodf(npy_float x, npy_float y)
{
    return fmodf(x, y);
}
#endif

#line 409
#if HAVE_COPYSIGNF
DL_EXPORT(npy_float) npy_copysignf(npy_float x, npy_float y)
{
    return copysignf(x, y);
}
#endif


#if HAVE_MODFF
DL_EXPORT(npy_float) npy_modff(npy_float x, npy_float *iptr)
{
    return modff(x, iptr);
}
#endif




/*
 * Non standard functions
 */

#line 436

#define LOGE2    NPY_LOGE2f
#define LOG2E    NPY_LOG2Ef
#define RAD2DEG  (180.0f/NPY_PIf)
#define DEG2RAD  (NPY_PIf/180.0f)

DL_EXPORT(npy_float) npy_rad2degf(npy_float x)
{
    return x*RAD2DEG;
}

DL_EXPORT(npy_float) npy_deg2radf(npy_float x)
{
    return x*DEG2RAD;
}

DL_EXPORT(npy_float) npy_log2_1pf(npy_float x)
{
    return LOG2E*npy_log1pf(x);
}

DL_EXPORT(npy_float) npy_exp2_m1f(npy_float x)
{
    return npy_expm1f(LOGE2*x);
}

DL_EXPORT(npy_float) npy_logaddexpf(npy_float x, npy_float y)
{
    const npy_float tmp = x - y;
    if (tmp > 0) {
        return x + npy_log1pf(npy_expf(-tmp));
    }
    else if (tmp <= 0) {
        return y + npy_log1pf(npy_expf(tmp));
    }
    else {
        /* NaNs, or infinities of the same sign involved */
        return x + y;
    }
}

DL_EXPORT(npy_float) npy_logaddexp2f(npy_float x, npy_float y)
{
    const npy_float tmp = x - y;
    if (tmp > 0) {
        return x + npy_log2_1pf(npy_exp2f(-tmp));
    }
    else if (tmp <= 0) {
        return y + npy_log2_1pf(npy_exp2f(tmp));
    }
    else {
        /* NaNs, or infinities of the same sign involved */
        return x + y;
    }
}

#undef LOGE2
#undef LOG2E
#undef RAD2DEG
#undef DEG2RAD


#line 436

#define LOGE2    NPY_LOGE2
#define LOG2E    NPY_LOG2E
#define RAD2DEG  (180.0/NPY_PI)
#define DEG2RAD  (NPY_PI/180.0)

DL_EXPORT(npy_double) npy_rad2deg(npy_double x)
{
    return x*RAD2DEG;
}

DL_EXPORT(npy_double) npy_deg2rad(npy_double x)
{
    return x*DEG2RAD;
}

DL_EXPORT(npy_double) npy_log2_1p(npy_double x)
{
    return LOG2E*npy_log1p(x);
}

DL_EXPORT(npy_double) npy_exp2_m1(npy_double x)
{
    return npy_expm1(LOGE2*x);
}

DL_EXPORT(npy_double) npy_logaddexp(npy_double x, npy_double y)
{
    const npy_double tmp = x - y;
    if (tmp > 0) {
        return x + npy_log1p(npy_exp(-tmp));
    }
    else if (tmp <= 0) {
        return y + npy_log1p(npy_exp(tmp));
    }
    else {
        /* NaNs, or infinities of the same sign involved */
        return x + y;
    }
}

DL_EXPORT(npy_double) npy_logaddexp2(npy_double x, npy_double y)
{
    const npy_double tmp = x - y;
    if (tmp > 0) {
        return x + npy_log2_1p(npy_exp2(-tmp));
    }
    else if (tmp <= 0) {
        return y + npy_log2_1p(npy_exp2(tmp));
    }
    else {
        /* NaNs, or infinities of the same sign involved */
        return x + y;
    }
}

#undef LOGE2
#undef LOG2E
#undef RAD2DEG
#undef DEG2RAD


#line 436

#define LOGE2    NPY_LOGE2l
#define LOG2E    NPY_LOG2El
#define RAD2DEG  (180.0l/NPY_PIl)
#define DEG2RAD  (NPY_PIl/180.0l)

DL_EXPORT(npy_longdouble) npy_rad2degl(npy_longdouble x)
{
    return x*RAD2DEG;
}

DL_EXPORT(npy_longdouble) npy_deg2radl(npy_longdouble x)
{
    return x*DEG2RAD;
}

DL_EXPORT(npy_longdouble) npy_log2_1pl(npy_longdouble x)
{
    return LOG2E*npy_log1pl(x);
}

DL_EXPORT(npy_longdouble) npy_exp2_m1l(npy_longdouble x)
{
    return npy_expm1l(LOGE2*x);
}

DL_EXPORT(npy_longdouble) npy_logaddexpl(npy_longdouble x, npy_longdouble y)
{
    const npy_longdouble tmp = x - y;
    if (tmp > 0) {
        return x + npy_log1pl(npy_expl(-tmp));
    }
    else if (tmp <= 0) {
        return y + npy_log1pl(npy_expl(tmp));
    }
    else {
        /* NaNs, or infinities of the same sign involved */
        return x + y;
    }
}

DL_EXPORT(npy_longdouble) npy_logaddexp2l(npy_longdouble x, npy_longdouble y)
{
    const npy_longdouble tmp = x - y;
    if (tmp > 0) {
        return x + npy_log2_1pl(npy_exp2l(-tmp));
    }
    else if (tmp <= 0) {
        return y + npy_log2_1pl(npy_exp2l(tmp));
    }
    else {
        /* NaNs, or infinities of the same sign involved */
        return x + y;
    }
}

#undef LOGE2
#undef LOG2E
#undef RAD2DEG
#undef DEG2RAD



