/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.util;

import org.keyczar.exceptions.Base64DecodingException;
import org.keyczar.i18n.Messages;

public class Base64Coder {
    private static final char[] ALPHABET;
    private static final byte[] DECODE;
    private static final char[] WHITESPACE;

    private Base64Coder() {
    }

    public static byte[] decode(String source) throws Base64DecodingException {
        int inLen;
        char[] input = source.toCharArray();
        if (input[(inLen = input.length) - 1] == '=') {
            --inLen;
        }
        if (input[inLen - 1] == '=') {
            --inLen;
        }
        int whiteSpaceChars = 0;
        for (char c : input) {
            if (!Base64Coder.isWhiteSpace(c)) continue;
            ++whiteSpaceChars;
        }
        int inputBlocks = (inLen -= whiteSpaceChars) / 4;
        int remainder = inLen % 4;
        int outputLen = inputBlocks * 3;
        switch (remainder) {
            case 1: {
                throw new Base64DecodingException(Messages.getString("Base64Coder.IllegalLength", inLen));
            }
            case 2: {
                ++outputLen;
                break;
            }
            case 3: {
                outputLen += 2;
            }
        }
        byte[] out = new byte[outputLen];
        int buffer = 0;
        int buffCount = 0;
        int outPos = 0;
        for (int i = 0; i < inLen + whiteSpaceChars; ++i) {
            if (!Base64Coder.isWhiteSpace(input[i])) {
                buffer = buffer << 6 | Base64Coder.getByte(input[i]);
                ++buffCount;
            }
            if (buffCount != 4) continue;
            out[outPos++] = (byte)(buffer >> 16);
            out[outPos++] = (byte)(buffer >> 8);
            out[outPos++] = (byte)buffer;
            buffer = 0;
            buffCount = 0;
        }
        switch (buffCount) {
            case 2: {
                out[outPos++] = (byte)(buffer >> 4);
                break;
            }
            case 3: {
                out[outPos++] = (byte)(buffer >> 10);
                out[outPos++] = (byte)(buffer >> 2);
            }
        }
        return out;
    }

    public static String encode(byte[] input) {
        int inputBlocks = input.length / 3;
        int remainder = input.length % 3;
        int outputLen = inputBlocks * 4;
        switch (remainder) {
            case 1: {
                outputLen += 2;
                break;
            }
            case 2: {
                outputLen += 3;
            }
        }
        char[] out = new char[outputLen];
        int outPos = 0;
        int inPos = 0;
        for (int i = 0; i < inputBlocks; ++i) {
            int buffer = (0xFF & input[inPos++]) << 16 | (0xFF & input[inPos++]) << 8 | 0xFF & input[inPos++];
            out[outPos++] = ALPHABET[buffer >> 18 & 0x3F];
            out[outPos++] = ALPHABET[buffer >> 12 & 0x3F];
            out[outPos++] = ALPHABET[buffer >> 6 & 0x3F];
            out[outPos++] = ALPHABET[buffer & 0x3F];
        }
        if (remainder > 0) {
            int buffer = (0xFF & input[inPos++]) << 16;
            if (remainder == 2) {
                buffer |= (0xFF & input[inPos++]) << 8;
            }
            out[outPos++] = ALPHABET[buffer >> 18 & 0x3F];
            out[outPos++] = ALPHABET[buffer >> 12 & 0x3F];
            if (remainder == 2) {
                out[outPos++] = ALPHABET[buffer >> 6 & 0x3F];
            }
        }
        return new String(out);
    }

    private static byte getByte(int i) throws Base64DecodingException {
        if (i < 0 || i > 127 || DECODE[i] == -1) {
            throw new Base64DecodingException(Messages.getString("Base64Coder.IllegalCharacter", i));
        }
        return DECODE[i];
    }

    private static boolean isWhiteSpace(int i) {
        return DECODE[i] == -2;
    }

    static {
        int i;
        ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        DECODE = new byte[128];
        WHITESPACE = new char[]{'\t', '\n', '\r', ' ', '\f'};
        for (i = 0; i < DECODE.length; ++i) {
            Base64Coder.DECODE[i] = -1;
        }
        for (i = 0; i < WHITESPACE.length; ++i) {
            Base64Coder.DECODE[Base64Coder.WHITESPACE[i]] = -2;
        }
        for (i = 0; i < ALPHABET.length; ++i) {
            Base64Coder.DECODE[Base64Coder.ALPHABET[i]] = (byte)i;
        }
    }
}

