/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.keyczar.Keyczar;
import org.keyczar.KeyczarKey;
import org.keyczar.StreamCache;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;

public class UnversionedVerifier
extends Keyczar {
    private static final Logger VERIFIER_LOGGER = Logger.getLogger(UnversionedVerifier.class);
    private static final StreamCache<VerifyingStream> VERIFY_CACHE = new StreamCache();

    public UnversionedVerifier(KeyczarReader reader) throws KeyczarException {
        super(reader);
    }

    public UnversionedVerifier(String fileLocation) throws KeyczarException {
        super(fileLocation);
    }

    public boolean verify(byte[] data, byte[] signature) throws KeyczarException {
        return this.verify(ByteBuffer.wrap(data), ByteBuffer.wrap(signature));
    }

    public boolean verify(ByteBuffer data, ByteBuffer signature) throws KeyczarException {
        VERIFIER_LOGGER.info((Object)Messages.getString("UnversionedVerifier.Verifying", data.remaining()));
        Iterator iter = this.versionMap.entrySet().iterator();
        while (iter.hasNext()) {
            KeyczarKey key = (KeyczarKey)iter.next().getValue();
            ByteBuffer dataCopy = data.duplicate();
            ByteBuffer signatureCopy = signature.duplicate();
            VerifyingStream stream = VERIFY_CACHE.get(key);
            if (stream == null) {
                stream = (VerifyingStream)key.getStream();
            }
            stream.initVerify();
            stream.updateVerify(dataCopy);
            boolean result = stream.verify(signatureCopy);
            VERIFY_CACHE.put(key, stream);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public boolean verify(String data, String signature) throws KeyczarException {
        return this.verify(data.getBytes(), Base64Coder.decode(signature));
    }

    boolean isAcceptablePurpose(KeyPurpose purpose) {
        return purpose == KeyPurpose.VERIFY || purpose == KeyPurpose.SIGN_AND_VERIFY;
    }
}

