/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.enums.KeyType;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.exceptions.UnsupportedTypeException;
import org.keyczar.interfaces.EncryptingStream;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

class RsaPublicKey
extends KeyczarPublicKey {
    private static final String CRYPT_ALGORITHM = "RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING";
    private static final String KEY_GEN_ALGORITHM = "RSA";
    private static final String SIG_ALGORITHM = "SHA1withRSA";
    private RSAPublicKey jcePublicKey;
    @Expose
    String modulus;
    @Expose
    String publicExponent;
    private byte[] hash = new byte[4];

    RsaPublicKey() {
    }

    public byte[] hash() {
        return this.hash;
    }

    Stream getStream() throws KeyczarException {
        return new RsaStream();
    }

    KeyType getType() {
        return KeyType.RSA_PUB;
    }

    void set(BigInteger mod, BigInteger pubExp) throws KeyczarException {
        this.modulus = Base64Coder.encode(mod.toByteArray());
        this.publicExponent = Base64Coder.encode(pubExp.toByteArray());
        this.init();
    }

    void init() throws KeyczarException {
        byte[] modBytes = Base64Coder.decode(this.modulus);
        byte[] pubExpBytes = Base64Coder.decode(this.publicExponent);
        BigInteger mod = new BigInteger(modBytes);
        BigInteger pubExp = new BigInteger(pubExpBytes);
        try {
            KeyFactory kf = KeyFactory.getInstance(KEY_GEN_ALGORITHM);
            RSAPublicKeySpec spec = new RSAPublicKeySpec(mod, pubExp);
            this.jcePublicKey = (RSAPublicKey)kf.generatePublic(spec);
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
        byte[] fullHash = Util.prefixHash(Util.stripLeadingZeros(modBytes), Util.stripLeadingZeros(pubExpBytes));
        System.arraycopy(fullHash, 0, this.hash, 0, this.hash.length);
    }

    static RsaPublicKey read(String input) throws KeyczarException {
        RsaPublicKey key = (RsaPublicKey)Util.gson().fromJson(input, RsaPublicKey.class);
        if (key.getType() != KeyType.RSA_PUB) {
            throw new UnsupportedTypeException(key.getType());
        }
        key.init();
        return key;
    }

    private class RsaStream
    implements VerifyingStream,
    EncryptingStream {
        private Cipher cipher;
        private Signature signature;

        public RsaStream() throws KeyczarException {
            try {
                this.signature = Signature.getInstance(RsaPublicKey.SIG_ALGORITHM);
                this.cipher = Cipher.getInstance(RsaPublicKey.CRYPT_ALGORITHM);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public int digestSize() {
            return RsaPublicKey.this.getType().getOutputSize();
        }

        public int doFinalEncrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            try {
                return this.cipher.doFinal(input, output);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public SigningStream getSigningStream() {
            return new SigningStream(){

                public int digestSize() {
                    return 0;
                }

                public void initSign() {
                }

                public void sign(ByteBuffer output) {
                }

                public void updateSign(ByteBuffer input) {
                }
            };
        }

        public int initEncrypt(ByteBuffer output) throws KeyczarException {
            try {
                this.cipher.init(1, RsaPublicKey.this.jcePublicKey);
            }
            catch (InvalidKeyException e) {
                throw new KeyczarException(e);
            }
            return 0;
        }

        public void initVerify() throws KeyczarException {
            try {
                this.signature.initVerify(RsaPublicKey.this.jcePublicKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public int maxOutputSize(int inputLen) {
            return RsaPublicKey.this.getType().getOutputSize();
        }

        public int updateEncrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            try {
                return this.cipher.update(input, output);
            }
            catch (ShortBufferException e) {
                throw new KeyczarException(e);
            }
        }

        public void updateVerify(ByteBuffer input) throws KeyczarException {
            try {
                this.signature.update(input);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        public boolean verify(ByteBuffer sig) throws KeyczarException {
            try {
                return this.signature.verify(sig.array(), sig.position(), sig.limit() - sig.position());
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }
    }
}

