/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.keyczar.KeyczarKey;
import org.keyczar.enums.KeyType;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

class HmacKey
extends KeyczarKey {
    private static final String MAC_ALGORITHM = "HMACSHA1";
    @Expose
    private String hmacKeyString;
    private Key hmacKey;
    private byte[] hash = new byte[4];

    HmacKey() {
    }

    static HmacKey generate() throws KeyczarException {
        return HmacKey.generate(KeyType.HMAC_SHA1.defaultSize());
    }

    static HmacKey generate(int keySize) throws KeyczarException {
        HmacKey key = new HmacKey();
        key.size = keySize;
        byte[] keyBytes = Util.rand(key.size() / 8);
        key.hmacKeyString = Base64Coder.encode(keyBytes);
        key.init();
        return key;
    }

    void init() throws KeyczarException {
        byte[] keyBytes = Base64Coder.decode(this.hmacKeyString);
        byte[] fullHash = Util.hash(new byte[][]{keyBytes});
        System.arraycopy(fullHash, 0, this.hash, 0, this.hash.length);
        this.hmacKey = new SecretKeySpec(keyBytes, MAC_ALGORITHM);
    }

    byte[] keyBytes() {
        return this.hmacKey.getEncoded();
    }

    Stream getStream() throws KeyczarException {
        return new HmacStream();
    }

    KeyType getType() {
        return KeyType.HMAC_SHA1;
    }

    byte[] hash() {
        return this.hash;
    }

    static HmacKey read(String input) throws KeyczarException {
        HmacKey key = (HmacKey)Util.gson().fromJson(input, HmacKey.class);
        key.init();
        return key;
    }

    private class HmacStream
    implements VerifyingStream,
    SigningStream {
        private Mac hmac;

        public HmacStream() throws KeyczarException {
            try {
                this.hmac = Mac.getInstance(HmacKey.MAC_ALGORITHM);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public int digestSize() {
            return HmacKey.this.getType().getOutputSize();
        }

        public void initSign() throws KeyczarException {
            try {
                this.hmac.init(HmacKey.this.hmacKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public void initVerify() throws KeyczarException {
            this.initSign();
        }

        public void sign(ByteBuffer output) {
            output.put(this.hmac.doFinal());
        }

        public void updateSign(ByteBuffer input) {
            this.hmac.update(input);
        }

        public void updateVerify(ByteBuffer input) {
            this.updateSign(input);
        }

        public boolean verify(ByteBuffer signature) {
            byte[] sigBytes = new byte[signature.remaining()];
            signature.get(sigBytes);
            return Arrays.equals(this.hmac.doFinal(), sigBytes);
        }
    }
}

