/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONException;
import org.json.JSONObject;
import org.keyczar.exceptions.Base64DecodingException;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.util.Base64Coder;

public class Util {
    private static final ConcurrentLinkedQueue<MessageDigest> DIGEST_QUEUE = new ConcurrentLinkedQueue();
    private static final ConcurrentLinkedQueue<SecureRandom> RAND_QUEUE = new ConcurrentLinkedQueue();
    private static final int READ_BUF_SIZE = 8192;

    private Util() {
    }

    public static byte[] stripLeadingZeros(byte[] input) {
        int zeros;
        for (zeros = 0; zeros < input.length && input[zeros] == 0; ++zeros) {
        }
        if (zeros == 0) {
            return input;
        }
        byte[] output = new byte[input.length - zeros];
        System.arraycopy(input, zeros, output, 0, output.length);
        return output;
    }

    public static byte[] fromInt(int input) {
        byte[] output = new byte[4];
        Util.writeInt(input, output, 0);
        return output;
    }

    public static byte[] fromLong(long input) {
        byte[] output = new byte[8];
        Util.writeLong(input, output, 0);
        return output;
    }

    public static byte[] prefixHash(byte[] ... inputs) throws KeyczarException {
        MessageDigest md = DIGEST_QUEUE.poll();
        if (md == null) {
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyczarException(e);
            }
        }
        for (byte[] array : inputs) {
            md.update(Util.fromInt(array.length));
            md.update(array);
        }
        byte[] digest = md.digest();
        DIGEST_QUEUE.add(md);
        return digest;
    }

    public static byte[] lenPrefix(byte[] data) {
        if (data == null || data.length == 0) {
            return Util.fromInt(0);
        }
        return ByteBuffer.allocate(4 + data.length).putInt(data.length).put(data).array();
    }

    public static byte[] lenPrefixPack(byte[] ... inputArrays) {
        int outputSize = (1 + inputArrays.length) * 4;
        for (byte[] array : inputArrays) {
            outputSize += array.length;
        }
        byte[] output = new byte[outputSize];
        ByteBuffer outputBuffer = ByteBuffer.wrap(output);
        outputBuffer.putInt(inputArrays.length);
        for (byte[] array : inputArrays) {
            outputBuffer.putInt(array.length);
            outputBuffer.put(array);
        }
        return output;
    }

    public static byte[][] lenPrefixUnpack(byte[] packedInput, int maxArrays) {
        ByteBuffer input = ByteBuffer.wrap(packedInput);
        int numArrays = input.getInt();
        if (numArrays < 0 || numArrays > maxArrays) {
            return null;
        }
        byte[][] output = new byte[numArrays][];
        for (int i = 0; i < numArrays; ++i) {
            if (input.remaining() < 4) {
                return null;
            }
            int len = input.getInt();
            if (len < 0 || len > input.remaining()) {
                return null;
            }
            byte[] array = new byte[len];
            input.get(array);
            output[i] = array;
        }
        return output;
    }

    public static byte[] hash(byte[] ... inputs) throws KeyczarException {
        MessageDigest md = DIGEST_QUEUE.poll();
        if (md == null) {
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyczarException(e);
            }
        }
        for (byte[] array : inputs) {
            md.update(array);
        }
        byte[] digest = md.digest();
        DIGEST_QUEUE.add(md);
        return digest;
    }

    public static void rand(byte[] dest) {
        SecureRandom random = RAND_QUEUE.poll();
        if (random == null) {
            random = new SecureRandom();
        }
        random.nextBytes(dest);
        RAND_QUEUE.add(random);
    }

    public static byte[] rand(int len) {
        byte[] output = new byte[len];
        Util.rand(output);
        return output;
    }

    static int readInt(byte[] src, int offset) {
        int output = 0;
        output |= (src[offset++] & 0xFF) << 24;
        output |= (src[offset++] & 0xFF) << 16;
        output |= (src[offset++] & 0xFF) << 8;
        return output |= src[offset++] & 0xFF;
    }

    static long readLong(byte[] src, int offset) {
        long output = 0L;
        output |= ((long)src[offset++] & 0xFFL) << 56;
        output |= ((long)src[offset++] & 0xFFL) << 48;
        output |= ((long)src[offset++] & 0xFFL) << 40;
        output |= ((long)src[offset++] & 0xFFL) << 32;
        output |= ((long)src[offset++] & 0xFFL) << 24;
        output |= ((long)src[offset++] & 0xFFL) << 16;
        output |= ((long)src[offset++] & 0xFFL) << 8;
        return output |= (long)src[offset++] & 0xFFL;
    }

    public static int toInt(byte[] src) {
        return Util.readInt(src, 0);
    }

    public static long toLong(byte[] src) {
        return Util.readLong(src, 0);
    }

    static void writeInt(int input, byte[] dest, int offset) {
        dest[offset++] = (byte)(input >> 24);
        dest[offset++] = (byte)(input >> 16);
        dest[offset++] = (byte)(input >> 8);
        dest[offset++] = (byte)input;
    }

    static void writeLong(long input, byte[] dest, int offset) {
        dest[offset++] = (byte)(input >> 56);
        dest[offset++] = (byte)(input >> 48);
        dest[offset++] = (byte)(input >> 40);
        dest[offset++] = (byte)(input >> 32);
        dest[offset++] = (byte)(input >> 24);
        dest[offset++] = (byte)(input >> 16);
        dest[offset++] = (byte)(input >> 8);
        dest[offset++] = (byte)input;
    }

    public static boolean safeArrayEquals(byte[] a1, byte[] a2) {
        if (a1 == null || a2 == null) {
            return a1 == a2;
        }
        if (a1.length != a2.length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < a1.length; ++i) {
            result = (byte)(result | a1[i] ^ a2[i]);
        }
        return result == 0;
    }

    public static byte[] cat(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] result = new byte[length];
        int pos = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, pos, array.length);
            pos += array.length;
        }
        return result;
    }

    public static List<String> split(String s, int chunkSize) {
        ArrayList<String> chunks = new ArrayList<String>();
        int length = s.length();
        for (int i = 0; i < length; i += chunkSize) {
            chunks.add(s.substring(i, Math.min(length, i + chunkSize)));
        }
        return chunks;
    }

    public static byte[] readStreamFully(InputStream inStream) throws IOException {
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        int bytesRead = 0;
        while ((bytesRead = inStream.read(buf)) != -1) {
            tempStream.write(buf, 0, bytesRead);
        }
        return tempStream.toByteArray();
    }

    public static String encodeBigInteger(BigInteger value) {
        return Base64Coder.encodeWebSafe(value.toByteArray());
    }

    public static BigInteger decodeBigInteger(String value) throws Base64DecodingException {
        return new BigInteger(Base64Coder.decodeWebSafe(value));
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) throws KeyczarException {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(algorithm);
            kpg.initialize(keySize);
            KeyPair pair = kpg.generateKeyPair();
            return pair;
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
    }

    public static <T extends Enum<T>> T deserializeEnum(Class<T> enumType, String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return Enum.valueOf(enumType, name);
    }

    public static Map<String, String> deserializeMap(JSONObject jsonObject) throws JSONException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (jsonObject != null) {
            Iterator iter = jsonObject.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = jsonObject.getString(key);
                map.put(key, value);
            }
        }
        return map;
    }
}

