/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.interop.operations;

import java.util.Map;
import org.keyczar.UnversionedSigner;
import org.keyczar.UnversionedVerifier;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interop.operations.Operation;

public class UnversionedSignOperation
extends Operation {
    public UnversionedSignOperation(String keyPath, String testData) {
        super(keyPath, testData);
    }

    @Override
    public byte[] generate(String algorithm, Map<String, String> generateParams) throws KeyczarException {
        UnversionedSigner signer = new UnversionedSigner(this.getReader(algorithm, generateParams.get("cryptedKeySet"), ""));
        if (generateParams.get("encoding").equals("encoded")) {
            String signature = signer.sign(this.testData);
            return signature.getBytes();
        }
        if (generateParams.get("encoding").equals("unencoded")) {
            byte[] signature = signer.sign(this.testData.getBytes());
            return signature;
        }
        throw new KeyczarException("Expects encoded or unencoded in parameters");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void test(Map<String, String> output, String algorithm, Map<String, String> generateParams, Map<String, String> testParams) throws KeyczarException {
        if (testParams.get("class").equals("signer")) {
            UnversionedSigner verifier = new UnversionedSigner(this.getReader(algorithm, generateParams.get("cryptedKeySet"), testParams.get("pubKey")));
            if (generateParams.get("encoding").equals("encoded")) {
                assert (verifier.verify(this.testData, new String(this.readOutput(output))));
                return;
            }
            if (!generateParams.get("encoding").equals("unencoded")) throw new KeyczarException("Expects encoded or unencoded in parameters");
            assert (verifier.verify(this.testData.getBytes(), this.readOutput(output)));
            return;
        }
        if (!testParams.get("class").equals("verifier")) throw new KeyczarException("Expects signer or verifier in parameters");
        UnversionedVerifier verifier = new UnversionedVerifier(this.getReader(algorithm, generateParams.get("cryptedKeySet"), testParams.get("pubKey")));
        if (generateParams.get("encoding").equals("encoded")) {
            assert (verifier.verify(this.testData, new String(this.readOutput(output))));
            return;
        }
        if (!generateParams.get("encoding").equals("unencoded")) throw new KeyczarException("Expects encoded or unencoded in parameters");
        assert (verifier.verify(this.testData.getBytes(), this.readOutput(output)));
        return;
    }
}

