/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.interop.operations;

import java.util.Map;
import org.keyczar.Crypter;
import org.keyczar.Encrypter;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interop.operations.Operation;

public class EncryptOperation
extends Operation {
    public EncryptOperation(String keyPath, String testData) {
        super(keyPath, testData);
    }

    @Override
    public byte[] generate(String algorithm, Map<String, String> generateParams) throws KeyczarException {
        if (generateParams.get("class").equals("crypter")) {
            Crypter crypter = new Crypter(this.getReader(algorithm, generateParams.get("cryptedKeySet"), generateParams.get("pubKey")));
            if (generateParams.get("encoding").equals("encoded")) {
                String ciphertext = crypter.encrypt(this.testData);
                return ciphertext.getBytes();
            }
            if (generateParams.get("encoding").equals("unencoded")) {
                byte[] ciphertext = crypter.encrypt(this.testData.getBytes());
                return ciphertext;
            }
            throw new KeyczarException("Expects encoded or unencoded in parameters");
        }
        if (generateParams.get("class").equals("encrypter")) {
            Encrypter crypter = new Encrypter(this.getReader(algorithm, generateParams.get("cryptedKeySet"), generateParams.get("pubKey")));
            if (generateParams.get("encoding").equals("encoded")) {
                String ciphertext = crypter.encrypt(this.testData);
                return ciphertext.getBytes();
            }
            if (generateParams.get("encoding").equals("unencoded")) {
                byte[] ciphertext = crypter.encrypt(this.testData.getBytes());
                return ciphertext;
            }
            throw new KeyczarException("Expects encoded or unencoded in parameters");
        }
        throw new KeyczarException("Expects crypter or encrypter in parameters");
    }

    @Override
    public void test(Map<String, String> output, String algorithm, Map<String, String> generateParams, Map<String, String> testParams) throws KeyczarException {
        Crypter crypter = new Crypter(this.getReader(algorithm, generateParams.get("cryptedKeySet"), ""));
        if (generateParams.get("encoding").equals("encoded")) {
            String plaintext = crypter.decrypt(new String(this.readOutput(output)));
            assert (plaintext.equals(this.testData));
        } else if (generateParams.get("encoding").equals("unencoded")) {
            byte[] plaintext = crypter.decrypt(this.readOutput(output));
            assert (new String(plaintext).equals(this.testData));
        } else {
            throw new KeyczarException("Expects encoded or unencoded in parameters");
        }
    }
}

